/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.std;

import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.effect.std.SecureRandom;
import java.io.Serializable;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public interface SecureRandomCompanionPlatform {
    private java.security.SecureRandom getInstance() {
        return java.security.SecureRandom.getInstance("NativePRNGNonBlocking");
    }

    private <F> SecureRandom<F> javaUtilRandom(java.security.SecureRandom random, Sync<F> evidence$1) {
        return new SecureRandom<F>(evidence$1, random){};
    }

    private <F> SecureRandom<F> javaUtilRandomBlocking(java.security.SecureRandom random, Sync<F> evidence$1) {
        return new SecureRandom<F>(evidence$1, random){};
    }

    public static Object javaSecuritySecureRandom$(SecureRandomCompanionPlatform $this, Sync evidence$1) {
        return $this.javaSecuritySecureRandom(evidence$1);
    }

    default public <F> Object javaSecuritySecureRandom(Sync<F> evidence$1) {
        return Sync$.MODULE$.apply(evidence$1).delay(() -> this.javaSecuritySecureRandom$$anonfun$1(evidence$1));
    }

    public static SecureRandom unsafeJavaSecuritySecureRandom$(SecureRandomCompanionPlatform $this, Sync evidence$1) {
        return $this.unsafeJavaSecuritySecureRandom(evidence$1);
    }

    default public <F> SecureRandom<F> unsafeJavaSecuritySecureRandom(Sync<F> evidence$1) {
        int major;
        Option<Object> option = this.javaMajorVersion();
        if (option instanceof Some && (major = BoxesRunTime.unboxToInt((Object)((Some)option).value())) > 8) {
            SecureRandom<F> secureRandom;
            try {
                secureRandom = this.javaUtilRandom(this.happyRandom$1(), evidence$1);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable ex = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(ex)) {
                    java.security.SecureRandom secureRandom2 = SecureRandomCompanionPlatform.fallback$1();
                    java.security.SecureRandom rnd = secureRandom2;
                    secureRandom = SecureRandomCompanionPlatform.isThreadsafe$1(rnd) ? this.javaUtilRandomBlocking(rnd, evidence$1) : this.fallbackPool$1(evidence$1);
                }
                throw throwable;
            }
            return secureRandom;
        }
        if (option instanceof Some || None$.MODULE$.equals(option)) {
            return this.fallbackPool$1(evidence$1);
        }
        throw new MatchError(option);
    }

    private <F> SecureRandom<F> pool(int n, Sync<F> evidence$1) {
        AtomicInteger index = new AtomicInteger(0);
        scala.util.Random[] array = (scala.util.Random[])Array$.MODULE$.fill(n, SecureRandomCompanionPlatform::$anonfun$1, ClassTag$.MODULE$.apply(scala.util.Random.class));
        return new SecureRandom<F>(evidence$1, index, n, array, this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super(SecureRandomCompanionPlatform.cats$effect$std$SecureRandomCompanionPlatform$$_$selectRandom$1(evidence$1$6, index$3, n$4, array$3), evidence$1$6);
            }
        };
    }

    private Option<Object> javaMajorVersion() {
        return Option$.MODULE$.apply((Object)System.getProperty("java.version")).flatMap((Function1 & Serializable)javaVersion -> this.parseJavaMajorVersion((String)javaVersion));
    }

    private Option<Object> parseJavaMajorVersion(String javaVersion) {
        if (javaVersion.startsWith("1.")) {
            return Try$.MODULE$.apply(() -> SecureRandomCompanionPlatform.parseJavaMajorVersion$$anonfun$1(javaVersion)).toOption();
        }
        return Try$.MODULE$.apply(() -> SecureRandomCompanionPlatform.parseJavaMajorVersion$$anonfun$2(javaVersion)).toOption();
    }

    private SecureRandom javaSecuritySecureRandom$$anonfun$1(Sync evidence$1$3) {
        return this.unsafeJavaSecuritySecureRandom(evidence$1$3);
    }

    private java.security.SecureRandom happyRandom$1() {
        return this.getInstance();
    }

    private static java.security.SecureRandom fallback$1() {
        return new java.security.SecureRandom();
    }

    private static boolean isThreadsafe$1(java.security.SecureRandom rnd) {
        return StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(rnd.getProvider().getProperty(new StringBuilder(24).append("SecureRandom.").append(rnd.getAlgorithm()).append(" ThreadSafe").toString(), "false")));
    }

    private SecureRandom fallbackPool$1(Sync evidence$1$4) {
        int processors = Runtime.getRuntime().availableProcessors();
        return this.pool(processors, evidence$1$4);
    }

    private static scala.util.Random $anonfun$1() {
        return new scala.util.Random((Random)new java.security.SecureRandom());
    }

    private static scala.util.Random selectRandom$1$$anonfun$1(AtomicInteger index$2, int n$2, scala.util.Random[] array$2) {
        int currentIndex = index$2.getAndUpdate(i -> (i + 1) % n$2);
        return array$2[currentIndex];
    }

    public static Object cats$effect$std$SecureRandomCompanionPlatform$$_$selectRandom$1(Sync evidence$1$5, AtomicInteger index$1, int n$1, scala.util.Random[] array$1) {
        return Sync$.MODULE$.apply(evidence$1$5).delay(() -> SecureRandomCompanionPlatform.selectRandom$1$$anonfun$1(index$1, n$1, array$1));
    }

    private static int parseJavaMajorVersion$$anonfun$1(String javaVersion$1) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(javaVersion$1.split("\\.")[1]));
    }

    private static int parseJavaMajorVersion$$anonfun$2(String javaVersion$2) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(javaVersion$2.split("\\.")[0]));
    }
}

