/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.std;

import cats.Applicative;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.Invariant;
import cats.Monad;
import cats.arrow.FunctionK;
import cats.effect.kernel.Async;
import cats.effect.kernel.Cont;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Poll;
import cats.effect.kernel.Ref;
import cats.effect.kernel.syntax.MonadCancelOps_$;
import cats.effect.kernel.syntax.package;
import cats.effect.std.FailureSignal$;
import cats.effect.std.Queue$;
import cats.effect.std.Queue$State$;
import cats.effect.std.Queue$SyncState$;
import cats.effect.std.QueueSink;
import cats.effect.std.QueueSource;
import cats.effect.std.QueueSource$;
import cats.effect.std.UnsafeUnbounded;
import cats.effect.std.unsafe.UnboundedQueue;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.ApplyOps$;
import cats.syntax.FlattenOps$;
import cats.syntax.IfMOps$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;

public abstract class Queue<F, A>
implements QueueSource<F, A>,
QueueSink<F, A> {
    public static <F, A> Object bounded(int n, GenConcurrent<F, ?> genConcurrent) {
        return Queue$.MODULE$.bounded(n, genConcurrent);
    }

    public static <F, A> Object boundedForAsync(int n, Async<F> async) {
        return Queue$.MODULE$.boundedForAsync(n, async);
    }

    public static <F, A> Object boundedForConcurrent(int n, GenConcurrent<F, ?> genConcurrent) {
        return Queue$.MODULE$.boundedForConcurrent(n, genConcurrent);
    }

    public static <F> Invariant<?> catsInvariantForQueue(Functor<F> functor) {
        return Queue$.MODULE$.catsInvariantForQueue(functor);
    }

    public static <F, A> Object circularBuffer(int n, GenConcurrent<F, ?> genConcurrent) {
        return Queue$.MODULE$.circularBuffer(n, genConcurrent);
    }

    public static <F, A> Object dropping(int n, GenConcurrent<F, ?> genConcurrent) {
        return Queue$.MODULE$.dropping(n, genConcurrent);
    }

    public static <F, A> Object droppingForAsync(int n, Async<F> async) {
        return Queue$.MODULE$.droppingForAsync(n, async);
    }

    public static <F, A> Object droppingForConcurrent(int n, GenConcurrent<F, ?> genConcurrent) {
        return Queue$.MODULE$.droppingForConcurrent(n, genConcurrent);
    }

    public static <F, A> Object synchronous(GenConcurrent<F, ?> genConcurrent) {
        return Queue$.MODULE$.synchronous(genConcurrent);
    }

    public static <F, A> Object unbounded(GenConcurrent<F, ?> genConcurrent) {
        return Queue$.MODULE$.unbounded(genConcurrent);
    }

    public static <F, A> Object unboundedForAsync(Async<F> async) {
        return Queue$.MODULE$.unboundedForAsync(async);
    }

    public static <F, A> Object unboundedForConcurrent(GenConcurrent<F, ?> genConcurrent) {
        return Queue$.MODULE$.unboundedForConcurrent(genConcurrent);
    }

    public static <F, A> Object unsafeBounded(int n, Async<F> async) {
        return Queue$.MODULE$.unsafeBounded(n, async);
    }

    public static <F, A> Object unsafeUnbounded(Async<F> async) {
        return Queue$.MODULE$.unsafeUnbounded(async);
    }

    public <G> Queue<G, A> mapK(FunctionK<F, G> f) {
        return new Queue<G, A>(f, this){
            private final FunctionK f$2;
            private final Object take;
            private final Object tryTake;
            private final /* synthetic */ Queue $outer;
            {
                this.f$2 = f$1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.take = f$1.apply($outer.take());
                this.tryTake = f$1.apply($outer.tryTake());
            }

            public Object offer(Object a) {
                return this.f$2.apply(this.$outer.offer(a));
            }

            public Object tryOffer(Object a) {
                return this.f$2.apply(this.$outer.tryOffer(a));
            }

            public Object size() {
                return this.f$2.apply(this.$outer.size());
            }

            public Object take() {
                return this.take;
            }

            public Object tryTake() {
                return this.tryTake;
            }
        };
    }

    public static abstract class AbstractQueue<F, A>
    extends Queue<F, A> {
        private final int capacity;
        private final Ref<F, State<F, A>> state;
        private final GenConcurrent<F, ?> F;
        private final Object take;
        private final Object tryTake;
        private final Object size;
        private final F notifyNextTaker;

        public AbstractQueue(int capacity, Ref<F, State<F, A>> state, GenConcurrent<F, ?> F) {
            this.capacity = capacity;
            this.state = state;
            this.F = F;
            this.take = F.uncancelable((Function1 & Serializable)poll -> package.all$.MODULE$.toFlatMapOps(F.deferred(), (FlatMap)F).flatMap((Function1 & Serializable)taker -> {
                Object modificationF = state.modify((Function1 & Serializable)x$1 -> {
                    State state = x$1;
                    if (state != null) {
                        Tuple2 tuple2;
                        State state2 = Queue$State$.MODULE$.unapply(state);
                        scala.collection.immutable.Queue queue = state2._1();
                        int n = state2._2();
                        scala.collection.immutable.Queue queue2 = state2._3();
                        scala.collection.immutable.Queue queue3 = state2._4();
                        scala.collection.immutable.Queue queue4 = queue;
                        int size = n;
                        scala.collection.immutable.Queue takers = queue2;
                        scala.collection.immutable.Queue offerers = queue3;
                        if (queue4.nonEmpty() && offerers.isEmpty()) {
                            Tuple2 tuple22 = queue4.dequeue();
                            if (tuple22 == null) {
                                throw new MatchError((Object)tuple22);
                            }
                            Object a = tuple22._1();
                            scala.collection.immutable.Queue rest = (scala.collection.immutable.Queue)tuple22._2();
                            Tuple2 tuple23 = Tuple2$.MODULE$.apply(a, (Object)rest);
                            Object a2 = tuple23._1();
                            scala.collection.immutable.Queue rest2 = (scala.collection.immutable.Queue)tuple23._2();
                            State state3 = (State)Predef$.MODULE$.ArrowAssoc(Queue$State$.MODULE$.apply(rest2, size - 1, takers, offerers));
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state3, F.pure(a2));
                        }
                        scala.collection.immutable.Queue queue5 = queue;
                        int size2 = n;
                        scala.collection.immutable.Queue takers2 = queue2;
                        scala.collection.immutable.Queue offerers2 = queue3;
                        if (queue5.nonEmpty()) {
                            Tuple2 tuple24 = queue5.dequeue();
                            if (tuple24 == null) {
                                throw new MatchError((Object)tuple24);
                            }
                            Object a = tuple24._1();
                            scala.collection.immutable.Queue rest = (scala.collection.immutable.Queue)tuple24._2();
                            Tuple2 tuple25 = Tuple2$.MODULE$.apply(a, (Object)rest);
                            Object a3 = tuple25._1();
                            scala.collection.immutable.Queue rest3 = (scala.collection.immutable.Queue)tuple25._2();
                            if (size2 - 1 < capacity) {
                                Tuple2 tuple26 = offerers2.dequeue();
                                if (tuple26 == null) {
                                    throw new MatchError((Object)tuple26);
                                }
                                Deferred release = (Deferred)tuple26._1();
                                scala.collection.immutable.Queue tail = (scala.collection.immutable.Queue)tuple26._2();
                                Tuple2 tuple27 = Tuple2$.MODULE$.apply((Object)release, (Object)tail);
                                Deferred release2 = (Deferred)tuple27._1();
                                scala.collection.immutable.Queue tail2 = (scala.collection.immutable.Queue)tuple27._2();
                                State state4 = (State)Predef$.MODULE$.ArrowAssoc(Queue$State$.MODULE$.apply(rest3, size2 - 1, takers2, tail2));
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state4, package.all$.MODULE$.toFunctorOps(release2.complete((Object)BoxedUnit.UNIT), (Functor)F).as(a3));
                            }
                            State state5 = (State)Predef$.MODULE$.ArrowAssoc(Queue$State$.MODULE$.apply(rest3, size2 - 1, takers2, offerers2));
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state5, F.pure(a3));
                        }
                        scala.collection.immutable.Queue queue6 = queue;
                        int size3 = n;
                        scala.collection.immutable.Queue takers3 = queue2;
                        scala.collection.immutable.Queue offerers3 = queue3;
                        Object cleanup = state.modify((Function1 & Serializable)s -> {
                            scala.collection.immutable.Queue takers2 = (scala.collection.immutable.Queue)s.takers().filter((Function1 & Serializable)_$26 -> _$26 != taker);
                            if (takers2.isEmpty()) {
                                State state = (State)Predef$.MODULE$.ArrowAssoc(s.copy(s.copy$default$1(), s.copy$default$2(), takers2, s.copy$default$4()));
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state, F.unit());
                            }
                            Tuple2 tuple2 = takers2.dequeue();
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Deferred taker = (Deferred)tuple2._1();
                            scala.collection.immutable.Queue rest = (scala.collection.immutable.Queue)tuple2._2();
                            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)taker, (Object)rest);
                            Deferred taker2 = (Deferred)tuple22._1();
                            scala.collection.immutable.Queue rest2 = (scala.collection.immutable.Queue)tuple22._2();
                            State state = (State)Predef$.MODULE$.ArrowAssoc(s.copy(s.copy$default$1(), s.copy$default$2(), rest2, s.copy$default$4()));
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state, package.all$.MODULE$.toFunctorOps(taker2.complete((Object)BoxedUnit.UNIT), (Functor)F).void());
                        });
                        Object object = package.all$.MODULE$.monadCancelOps_(poll.apply(taker.get()));
                        Object object2 = package.all$.MODULE$.catsSyntaxFlatten(cleanup, (FlatMap)F);
                        Object object3 = package.all$.MODULE$.catsSyntaxApplyOps(MonadCancelOps_$.MODULE$.onCancel$extension(object, FlattenOps$.MODULE$.flatten$extension(object2, (FlatMap)F), (MonadCancel)F));
                        Object object4 = package.all$.MODULE$.monadCancelOps_(poll.apply(this.take()));
                        Object object5 = package.all$.MODULE$.catsSyntaxFlatten(this.notifyNextTaker, (FlatMap)F);
                        Object await = ApplyOps$.MODULE$.$times$greater$extension(object3, MonadCancelOps_$.MODULE$.onCancel$extension(object4, FlattenOps$.MODULE$.flatten$extension(object5, (FlatMap)F), (MonadCancel)F), (Apply)F);
                        if (offerers3.isEmpty()) {
                            tuple2 = Tuple2$.MODULE$.apply(await, offerers3);
                        } else {
                            Tuple2 tuple28 = offerers3.dequeue();
                            if (tuple28 == null) {
                                throw new MatchError((Object)tuple28);
                            }
                            Deferred release = (Deferred)tuple28._1();
                            scala.collection.immutable.Queue rest = (scala.collection.immutable.Queue)tuple28._2();
                            Tuple2 tuple29 = Tuple2$.MODULE$.apply((Object)release, (Object)rest);
                            Deferred release3 = (Deferred)tuple29._1();
                            scala.collection.immutable.Queue rest4 = (scala.collection.immutable.Queue)tuple29._2();
                            Object object6 = package.all$.MODULE$.catsSyntaxApplyOps(release3.complete((Object)BoxedUnit.UNIT));
                            tuple2 = Tuple2$.MODULE$.apply(ApplyOps$.MODULE$.$times$greater$extension(object6, await, (Apply)F), (Object)rest4);
                        }
                        Tuple2 tuple210 = tuple2;
                        Object fulfill = tuple210._1();
                        scala.collection.immutable.Queue offerers22 = (scala.collection.immutable.Queue)tuple210._2();
                        State state6 = (State)Predef$.MODULE$.ArrowAssoc(Queue$State$.MODULE$.apply(queue6, size3, takers3.enqueue(taker), offerers22));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state6, fulfill);
                    }
                    throw new MatchError((Object)state);
                });
                Object object = package.all$.MODULE$.catsSyntaxFlatten(modificationF, (FlatMap)F);
                return FlattenOps$.MODULE$.flatten$extension(object, (FlatMap)F);
            }));
            this.tryTake = state.flatModify((Function1 & Serializable)x$1 -> {
                State state = x$1;
                if (state != null) {
                    State state2 = Queue$State$.MODULE$.unapply(state);
                    scala.collection.immutable.Queue queue = state2._1();
                    int n = state2._2();
                    scala.collection.immutable.Queue queue2 = state2._3();
                    scala.collection.immutable.Queue queue3 = state2._4();
                    scala.collection.immutable.Queue queue4 = queue;
                    int size = n;
                    scala.collection.immutable.Queue takers = queue2;
                    scala.collection.immutable.Queue offerers = queue3;
                    if (queue4.nonEmpty() && offerers.isEmpty()) {
                        Tuple2 tuple2 = queue4.dequeue();
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object a = tuple2._1();
                        scala.collection.immutable.Queue rest = (scala.collection.immutable.Queue)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply(a, (Object)rest);
                        Object a2 = tuple22._1();
                        scala.collection.immutable.Queue rest2 = (scala.collection.immutable.Queue)tuple22._2();
                        State state3 = (State)Predef$.MODULE$.ArrowAssoc(Queue$State$.MODULE$.apply(rest2, size - 1, takers, offerers));
                        Object object = package.all$.MODULE$.catsSyntaxOptionId(a2);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state3, F.pure((Object)OptionIdOps$.MODULE$.some$extension(object)));
                    }
                    scala.collection.immutable.Queue queue5 = queue;
                    int size2 = n;
                    scala.collection.immutable.Queue takers2 = queue2;
                    scala.collection.immutable.Queue offerers2 = queue3;
                    if (queue5.nonEmpty()) {
                        Tuple2 tuple2 = queue5.dequeue();
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Object a = tuple2._1();
                        scala.collection.immutable.Queue rest = (scala.collection.immutable.Queue)tuple2._2();
                        Tuple2 tuple23 = Tuple2$.MODULE$.apply(a, (Object)rest);
                        Object a3 = tuple23._1();
                        scala.collection.immutable.Queue rest3 = (scala.collection.immutable.Queue)tuple23._2();
                        Tuple2 tuple24 = offerers2.dequeue();
                        if (tuple24 == null) {
                            throw new MatchError((Object)tuple24);
                        }
                        Deferred release = (Deferred)tuple24._1();
                        scala.collection.immutable.Queue tail = (scala.collection.immutable.Queue)tuple24._2();
                        Tuple2 tuple25 = Tuple2$.MODULE$.apply((Object)release, (Object)tail);
                        Deferred release2 = (Deferred)tuple25._1();
                        scala.collection.immutable.Queue tail2 = (scala.collection.immutable.Queue)tuple25._2();
                        State state4 = (State)Predef$.MODULE$.ArrowAssoc(Queue$State$.MODULE$.apply(rest3, size2 - 1, takers2, tail2));
                        Object object = package.all$.MODULE$.catsSyntaxOptionId(a3);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state4, package.all$.MODULE$.toFunctorOps(release2.complete((Object)BoxedUnit.UNIT), (Functor)F).as((Object)OptionIdOps$.MODULE$.some$extension(object)));
                    }
                }
                State s = state;
                State state5 = (State)Predef$.MODULE$.ArrowAssoc((Object)s);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state5, F.pure((Object)package.all$.MODULE$.none()));
            }, F);
            this.size = package.all$.MODULE$.toFunctorOps(state.get(), F).map((Function1 & Serializable)_$27 -> _$27.size());
            this.notifyNextTaker = state.modify((Function1 & Serializable)s -> {
                if (s.takers().isEmpty()) {
                    State state = (State)Predef$.MODULE$.ArrowAssoc(s);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state, F.unit());
                }
                Tuple2 tuple2 = s.takers().dequeue();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Deferred taker = (Deferred)tuple2._1();
                scala.collection.immutable.Queue rest = (scala.collection.immutable.Queue)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)taker, (Object)rest);
                Deferred taker2 = (Deferred)tuple22._1();
                scala.collection.immutable.Queue rest2 = (scala.collection.immutable.Queue)tuple22._2();
                State state = (State)Predef$.MODULE$.ArrowAssoc(s.copy(s.copy$default$1(), s.copy$default$2(), rest2, s.copy$default$4()));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state, package.all$.MODULE$.toFunctorOps(taker2.complete((Object)BoxedUnit.UNIT), (Functor)F).void());
            });
        }

        public abstract Tuple2<State<F, A>, F> onOfferNoCapacity(State<F, A> var1, A var2, Deferred<F, BoxedUnit> var3, Poll<F> var4, Function0<F> var5);

        public abstract Tuple2<State<F, A>, F> onTryOfferNoCapacity(State<F, A> var1, A var2);

        @Override
        public F offer(A a) {
            return (F)this.F.uncancelable((Function1 & Serializable)poll -> package.all$.MODULE$.toFlatMapOps(this.F.deferred(), this.F).flatMap((Function1 & Serializable)offerer -> {
                Object modificationF = this.state.modify((Function1 & Serializable)x$1 -> {
                    State state = x$1;
                    if (state != null) {
                        State state2 = Queue$State$.MODULE$.unapply(state);
                        scala.collection.immutable.Queue queue = state2._1();
                        int n = state2._2();
                        scala.collection.immutable.Queue queue2 = state2._3();
                        scala.collection.immutable.Queue queue3 = state2._4();
                        scala.collection.immutable.Queue queue4 = queue;
                        int size = n;
                        scala.collection.immutable.Queue takers = queue2;
                        scala.collection.immutable.Queue offerers = queue3;
                        if (takers.nonEmpty()) {
                            Tuple2 tuple2 = takers.dequeue();
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Deferred taker = (Deferred)tuple2._1();
                            scala.collection.immutable.Queue rest = (scala.collection.immutable.Queue)tuple2._2();
                            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)taker, (Object)rest);
                            Deferred taker2 = (Deferred)tuple22._1();
                            scala.collection.immutable.Queue rest2 = (scala.collection.immutable.Queue)tuple22._2();
                            State state3 = (State)Predef$.MODULE$.ArrowAssoc(Queue$State$.MODULE$.apply(queue4.enqueue(a), size + 1, rest2, offerers));
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state3, package.all$.MODULE$.toFunctorOps(taker2.complete((Object)BoxedUnit.UNIT), this.F).void());
                        }
                        scala.collection.immutable.Queue queue5 = queue;
                        int size2 = n;
                        scala.collection.immutable.Queue takers2 = queue2;
                        scala.collection.immutable.Queue offerers2 = queue3;
                        if (size2 < this.capacity) {
                            State state4 = (State)Predef$.MODULE$.ArrowAssoc(Queue$State$.MODULE$.apply(queue5.enqueue(a), size2 + 1, takers2, offerers2));
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state4, this.F.unit());
                        }
                    }
                    State s = state;
                    return this.onOfferNoCapacity(s, a, (Deferred<F, BoxedUnit>)offerer, (Poll<F>)poll, () -> this.$anonfun$15$$anonfun$1(a));
                });
                Object object = package.all$.MODULE$.catsSyntaxFlatten(modificationF, this.F);
                return FlattenOps$.MODULE$.flatten$extension(object, this.F);
            }));
        }

        @Override
        public F tryOffer(A a) {
            return (F)this.state.flatModify((Function1 & Serializable)x$1 -> {
                State state = x$1;
                if (state != null) {
                    State state2 = Queue$State$.MODULE$.unapply(state);
                    scala.collection.immutable.Queue queue = state2._1();
                    int n = state2._2();
                    scala.collection.immutable.Queue queue2 = state2._3();
                    scala.collection.immutable.Queue queue3 = state2._4();
                    scala.collection.immutable.Queue queue4 = queue;
                    int size = n;
                    scala.collection.immutable.Queue takers = queue2;
                    scala.collection.immutable.Queue offerers = queue3;
                    if (takers.nonEmpty()) {
                        Tuple2 tuple2 = takers.dequeue();
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Deferred taker = (Deferred)tuple2._1();
                        scala.collection.immutable.Queue rest = (scala.collection.immutable.Queue)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)taker, (Object)rest);
                        Deferred taker2 = (Deferred)tuple22._1();
                        scala.collection.immutable.Queue rest2 = (scala.collection.immutable.Queue)tuple22._2();
                        State state3 = (State)Predef$.MODULE$.ArrowAssoc(Queue$State$.MODULE$.apply(queue4.enqueue(a), size + 1, rest2, offerers));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state3, package.all$.MODULE$.toFunctorOps(taker2.complete((Object)BoxedUnit.UNIT), this.F).as((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                    }
                    scala.collection.immutable.Queue queue5 = queue;
                    int size2 = n;
                    scala.collection.immutable.Queue takers2 = queue2;
                    scala.collection.immutable.Queue offerers2 = queue3;
                    if (size2 < this.capacity) {
                        State state4 = (State)Predef$.MODULE$.ArrowAssoc(Queue$State$.MODULE$.apply(queue5.enqueue(a), size2 + 1, takers2, offerers2));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state4, this.F.pure((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                    }
                }
                State s = state;
                return this.onTryOfferNoCapacity(s, a);
            }, this.F);
        }

        @Override
        public F take() {
            return (F)this.take;
        }

        @Override
        public F tryTake() {
            return (F)this.tryTake;
        }

        @Override
        public F size() {
            return (F)this.size;
        }

        private final Object $anonfun$15$$anonfun$1(Object a$11) {
            return this.offer(a$11);
        }
    }

    public static abstract class BaseBoundedAsyncQueue<F, A>
    extends Queue<F, A> {
        public final Async<F> cats$effect$std$Queue$BaseBoundedAsyncQueue$$F;
        private final UnsafeBounded buffer;
        private final UnsafeUnbounded takers;
        private final UnsafeUnbounded offerers;
        private final FailureSignal$ FailureSignal;
        private final Object size;
        private final Object take;
        private final Object tryTake;

        public BaseBoundedAsyncQueue(int capacity, Async<F> F) {
            this.cats$effect$std$Queue$BaseBoundedAsyncQueue$$F = F;
            Predef$.MODULE$.require(capacity > 1, this::$init$$$anonfun$8);
            this.buffer = new UnsafeBounded(capacity);
            this.takers = new UnsafeUnbounded();
            this.offerers = new UnsafeUnbounded();
            this.FailureSignal = FailureSignal$.MODULE$;
            this.size = F.delay(this::$init$$$anonfun$9);
            this.take = F.uncancelable((Function1 & Serializable)poll -> F.defer(() -> this.$init$$$anonfun$10$$anonfun$1(F, poll)));
            this.tryTake = F.delay(this::$init$$$anonfun$11);
        }

        public UnsafeBounded<A> buffer() {
            return this.buffer;
        }

        public UnsafeUnbounded<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>> takers() {
            return this.takers;
        }

        public UnsafeUnbounded<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>> offerers() {
            return this.offerers;
        }

        public FailureSignal$ FailureSignal() {
            return this.FailureSignal;
        }

        @Override
        public F size() {
            return (F)this.size;
        }

        @Override
        public F take() {
            return (F)this.take;
        }

        @Override
        public F tryTake() {
            return (F)this.tryTake;
        }

        @Override
        public F tryTakeN(Option<Object> limit, Monad<F> F0) {
            QueueSource$.MODULE$.assertMaxNPositive(limit);
            return (F)this.cats$effect$std$Queue$BaseBoundedAsyncQueue$$F.delay(() -> this.tryTakeN$$anonfun$1(F0, limit));
        }

        public void debug() {
            Predef$.MODULE$.println((Object)new StringBuilder(8).append("buffer: ").append(this.buffer().debug()).toString());
        }

        public final void notifyOne(UnsafeUnbounded<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>> waiters) {
            boolean retry;
            do {
                boolean bl;
                try {
                    Function1<Either<Throwable, BoxedUnit>, BoxedUnit> f = waiters.take();
                    if (f == null) {
                        bl = true;
                    } else {
                        f.apply(Queue$.cats$effect$std$Queue$$$EitherUnit);
                        bl = false;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    FailureSignal$ failureSignal$ = this.FailureSignal();
                    Throwable throwable3 = throwable2;
                    if (!(failureSignal$ != null ? !failureSignal$.equals(throwable3) : throwable3 != null)) {
                        bl = false;
                    }
                    throw throwable;
                }
                retry = bl;
            } while (retry);
        }

        private final Object $init$$$anonfun$8() {
            return "capacity must be > 1";
        }

        private final int $init$$$anonfun$9() {
            return this.buffer().size();
        }

        private final void $anonfun$19() {
            this.notifyOne(this.takers());
        }

        private final Object $init$$$anonfun$10$$anonfun$1$$anonfun$1(BooleanRef received$2, Async F$26, ObjectRef result$2, Poll poll$9) {
            if (received$2.elem) {
                return F$26.pure(result$2.elem);
            }
            return poll$9.apply(this.take());
        }

        private final Object $init$$$anonfun$10$$anonfun$1(Async F$25, Poll poll$7) {
            Object object;
            try {
                A result = this.buffer().take();
                this.notifyOne(this.offerers());
                object = F$25.pure(result);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                FailureSignal$ failureSignal$ = this.FailureSignal();
                Throwable throwable3 = throwable2;
                if (!(failureSignal$ != null ? !failureSignal$.equals(throwable3) : throwable3 != null)) {
                    BooleanRef received = BooleanRef.create((boolean)false);
                    ObjectRef result = ObjectRef.create(null);
                    Object wait = F$25.cont(new Cont<F, BoxedUnit, BoxedUnit>(result, received, this){
                        private final ObjectRef result$1;
                        private final BooleanRef received$1;
                        private final /* synthetic */ BaseBoundedAsyncQueue $outer;
                        {
                            this.result$1 = result$6;
                            this.received$1 = received$6;
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public Function3 apply(MonadCancel G) {
                            return (Function3 & Serializable)(k, get, lift) -> G.uncancelable((Function1 & Serializable)poll -> {
                                Object lifted = lift.apply(this.$outer.cats$effect$std$Queue$BaseBoundedAsyncQueue$$F.delay(() -> this.$anonfun$18(k, G, poll, get, lift)));
                                Object object = package.all$.MODULE$.catsSyntaxFlatten(lifted, (FlatMap)G);
                                return FlattenOps$.MODULE$.flatten$extension(object, (FlatMap)G);
                            });
                        }

                        private final Object $anonfun$18(Function1 k$2, MonadCancel G$3, Poll poll$8, Object get$2, FunctionK lift$2) {
                            Object object;
                            Function0<BoxedUnit> clear = this.$outer.takers().put((Function1<Either<Throwable, BoxedUnit>, BoxedUnit>)k$2);
                            try {
                                this.result$1.elem = this.$outer.buffer().take();
                                clear.apply$mcV$sp();
                                this.received$1.elem = true;
                                this.$outer.notifyOne(this.$outer.takers());
                                this.$outer.notifyOne(this.$outer.offerers());
                                object = G$3.unit();
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                FailureSignal$ failureSignal$ = this.$outer.FailureSignal();
                                Throwable throwable3 = throwable2;
                                if (!(failureSignal$ != null ? !failureSignal$.equals(throwable3) : throwable3 != null)) {
                                    Object object2 = package.all$.MODULE$.monadCancelOps_(poll$8.apply(get$2));
                                    object = MonadCancelOps_$.MODULE$.onCancel$extension(object2, lift$2.apply(this.$outer.cats$effect$std$Queue$BaseBoundedAsyncQueue$$F.delay(clear)), G$3);
                                }
                                throw throwable;
                            }
                            return object;
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{apply$$anonfun$1(cats.effect.kernel.MonadCancel scala.Function1 java.lang.Object cats.arrow.FunctionK ), $anonfun$18(scala.Function1 cats.effect.kernel.MonadCancel cats.effect.kernel.Poll java.lang.Object cats.arrow.FunctionK ), apply$$anonfun$1$$anonfun$1(cats.arrow.FunctionK scala.Function1 cats.effect.kernel.MonadCancel java.lang.Object cats.effect.kernel.Poll )}, serializedLambda);
                        }
                    });
                    Object notifyAnyway = F$25.delay((Function0 & Serializable)() -> {
                        this.$anonfun$19();
                        return BoxedUnit.UNIT;
                    });
                    Object object2 = package.all$.MODULE$.catsSyntaxApplyOps(poll$7.apply(wait));
                    Object object3 = package.all$.MODULE$.monadCancelOps_(ApplyOps$.MODULE$.$times$greater$extension(object2, F$25.defer(() -> this.$init$$$anonfun$10$$anonfun$1$$anonfun$1(received, F$25, result, poll$7)), (Apply)F$25));
                    object = MonadCancelOps_$.MODULE$.onCancel$extension(object3, notifyAnyway, (MonadCancel)F$25);
                }
                throw throwable;
            }
            return object;
        }

        private final Option $init$$$anonfun$11() {
            Some some;
            try {
                A back = this.buffer().take();
                this.notifyOne(this.offerers());
                some = Some$.MODULE$.apply(back);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                FailureSignal$ failureSignal$ = this.FailureSignal();
                Throwable throwable3 = throwable2;
                if (!(failureSignal$ != null ? !failureSignal$.equals(throwable3) : throwable3 != null)) {
                    some = None$.MODULE$;
                }
                throw throwable;
            }
            return some;
        }

        private final void loop$1(int i) {
            while (i >= 0) {
                Function1<Either<Throwable, BoxedUnit>, BoxedUnit> f;
                Function1<Either<Throwable, BoxedUnit>, BoxedUnit> function1;
                boolean took = false;
                try {
                    Function1<Either<Throwable, BoxedUnit>, BoxedUnit> back = this.offerers().take();
                    took = true;
                    function1 = back;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    FailureSignal$ failureSignal$ = this.FailureSignal();
                    Throwable throwable3 = throwable2;
                    if (failureSignal$ != null ? !failureSignal$.equals(throwable3) : throwable3 != null) {
                        throw throwable;
                    }
                    function1 = f = null;
                }
                if (took) {
                    if (f == null) continue;
                    f.apply(Queue$.cats$effect$std$Queue$$$EitherUnit);
                    --i;
                    continue;
                }
                return;
            }
        }

        private final List tryTakeN$$anonfun$1(Monad F0$1, Option limit$1) {
            Monad monad = F0$1;
            List<A> back = this.buffer().drain(BoxesRunTime.unboxToInt((Object)limit$1.getOrElse(Queue$::cats$effect$std$Queue$BaseBoundedAsyncQueue$$_$_$$anonfun$20)));
            this.loop$1(back.length());
            return back;
        }
    }

    public static final class BoundedAsyncQueue<F, A>
    extends BaseBoundedAsyncQueue<F, A>
    implements cats.effect.std.unsafe.BoundedQueue<F, A> {
        private final Async<F> F;

        public BoundedAsyncQueue(int capacity, Async<F> F) {
            this.F = F;
            super(capacity, F);
        }

        @Override
        public F offer(A a) {
            return (F)this.F.uncancelable((Function1 & Serializable)poll -> this.F.defer(() -> this.offer$$anonfun$3$$anonfun$1(a, poll)));
        }

        @Override
        public boolean unsafeTryOffer(A a) {
            boolean bl;
            try {
                this.buffer().put(a);
                this.notifyOne(this.takers());
                bl = true;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                FailureSignal$ failureSignal$ = this.FailureSignal();
                Throwable throwable3 = throwable2;
                if (!(failureSignal$ != null ? !failureSignal$.equals(throwable3) : throwable3 != null)) {
                    bl = false;
                }
                throw throwable;
            }
            return bl;
        }

        @Override
        public F tryOffer(A a) {
            return (F)this.F.delay(() -> this.tryOffer$$anonfun$3(a));
        }

        private final Option $anonfun$21$$anonfun$1(Function1 k$3, Object a$15, BooleanRef succeeded$1) {
            Some some;
            Function0<BoxedUnit> clear = this.offerers().put((Function1<Either<Throwable, BoxedUnit>, BoxedUnit>)k$3);
            try {
                this.buffer().put(a$15);
                clear.apply$mcV$sp();
                succeeded$1.elem = true;
                k$3.apply(Queue$.cats$effect$std$Queue$$$EitherUnit);
                this.notifyOne(this.offerers());
                this.notifyOne(this.takers());
                some = None$.MODULE$;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                FailureSignal$ failureSignal$ = this.FailureSignal();
                Throwable throwable3 = throwable2;
                if (!(failureSignal$ != null ? !failureSignal$.equals(throwable3) : throwable3 != null)) {
                    some = Some$.MODULE$.apply(this.F.delay(clear));
                }
                throw throwable;
            }
            return some;
        }

        private final void $anonfun$22() {
            this.notifyOne(this.offerers());
        }

        private final Object offer$$anonfun$3$$anonfun$1$$anonfun$1(BooleanRef succeeded$3, Poll poll$11, Object a$17) {
            if (succeeded$3.elem) {
                return this.F.unit();
            }
            return poll$11.apply(this.offer(a$17));
        }

        private final Object offer$$anonfun$3$$anonfun$1(Object a$14, Poll poll$10) {
            Object object;
            try {
                this.buffer().put(a$14);
                this.notifyOne(this.takers());
                object = this.F.unit();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                FailureSignal$ failureSignal$ = this.FailureSignal();
                Throwable throwable3 = throwable2;
                if (!(failureSignal$ != null ? !failureSignal$.equals(throwable3) : throwable3 != null)) {
                    BooleanRef succeeded = BooleanRef.create((boolean)false);
                    Object wait = this.F.async((Function1 & Serializable)k -> this.F.delay(() -> this.$anonfun$21$$anonfun$1(k, a$14, succeeded)));
                    Object notifyAnyway = this.F.delay((Function0 & Serializable)() -> {
                        this.$anonfun$22();
                        return BoxedUnit.UNIT;
                    });
                    Object object2 = package.all$.MODULE$.catsSyntaxApplyOps(poll$10.apply(wait));
                    Object object3 = package.all$.MODULE$.monadCancelOps_(ApplyOps$.MODULE$.$times$greater$extension(object2, this.F.defer(() -> this.offer$$anonfun$3$$anonfun$1$$anonfun$1(succeeded, poll$10, a$14)), this.F));
                    object = MonadCancelOps_$.MODULE$.onCancel$extension(object3, notifyAnyway, this.F);
                }
                throw throwable;
            }
            return object;
        }

        private final boolean tryOffer$$anonfun$3(Object a$18) {
            return this.unsafeTryOffer(a$18);
        }
    }

    public static final class BoundedQueue<F, A>
    extends AbstractQueue<F, A> {
        private final Ref<F, State<F, A>> state;
        private final GenConcurrent<F, ?> F;

        public BoundedQueue(int capacity, Ref<F, State<F, A>> state, GenConcurrent<F, ?> F) {
            this.state = state;
            this.F = F;
            super(capacity, state, F);
            Predef$.MODULE$.require(capacity > 0, this::$init$$$anonfun$7);
        }

        @Override
        public Tuple2<State<F, A>, F> onOfferNoCapacity(State<F, A> s2, A a, Deferred<F, BoxedUnit> offerer, Poll<F> poll, Function0<F> recurse) {
            State<F, A> state = s2;
            if (state == null) {
                throw new MatchError(state);
            }
            State<F, A> state2 = Queue$State$.MODULE$.unapply(state);
            scala.collection.immutable.Queue<A> queue = state2._1();
            int n = state2._2();
            scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> queue2 = state2._3();
            scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> queue3 = state2._4();
            scala.collection.immutable.Queue<A> queue4 = queue;
            int size = n;
            scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> takers = queue2;
            scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> offerers = queue3;
            Tuple4 tuple4 = Tuple4$.MODULE$.apply(queue4, (Object)BoxesRunTime.boxToInteger((int)size), takers, offerers);
            scala.collection.immutable.Queue queue5 = (scala.collection.immutable.Queue)tuple4._1();
            int size2 = BoxesRunTime.unboxToInt((Object)tuple4._2());
            scala.collection.immutable.Queue takers2 = (scala.collection.immutable.Queue)tuple4._3();
            scala.collection.immutable.Queue offerers2 = (scala.collection.immutable.Queue)tuple4._4();
            Object cleanup = this.state.modify((Function1 & Serializable)s -> {
                scala.collection.immutable.Queue offerers2 = (scala.collection.immutable.Queue)s.offerers().filter(arg_0 -> Queue$.cats$effect$std$Queue$BoundedQueue$$_$_$$anonfun$17(offerer, arg_0));
                if (offerers2.isEmpty()) {
                    State state = (State)Predef$.MODULE$.ArrowAssoc(s.copy(s.copy$default$1(), s.copy$default$2(), s.copy$default$3(), offerers2));
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state, this.F.unit());
                }
                Tuple2 tuple2 = offerers2.dequeue();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Deferred offerer = (Deferred)tuple2._1();
                scala.collection.immutable.Queue rest = (scala.collection.immutable.Queue)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)offerer, (Object)rest);
                Deferred offerer2 = (Deferred)tuple22._1();
                scala.collection.immutable.Queue rest2 = (scala.collection.immutable.Queue)tuple22._2();
                State state = (State)Predef$.MODULE$.ArrowAssoc(s.copy(s.copy$default$1(), s.copy$default$2(), s.copy$default$3(), rest2));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state, package.all$.MODULE$.toFunctorOps(offerer2.complete((Object)BoxedUnit.UNIT), this.F).void());
            });
            State state3 = (State)Predef$.MODULE$.ArrowAssoc(Queue$State$.MODULE$.apply(queue5, size2, takers2, offerers2.enqueue(offerer)));
            Object object = package.all$.MODULE$.catsSyntaxApplyOps(poll.apply(offerer.get()));
            Object object2 = package.all$.MODULE$.monadCancelOps_(ApplyOps$.MODULE$.$times$greater$extension(object, poll.apply(recurse.apply()), this.F));
            Object object3 = package.all$.MODULE$.catsSyntaxFlatten(cleanup, this.F);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state3, MonadCancelOps_$.MODULE$.onCancel$extension(object2, FlattenOps$.MODULE$.flatten$extension(object3, this.F), this.F));
        }

        @Override
        public Tuple2<State<F, A>, F> onTryOfferNoCapacity(State<F, A> s, A a) {
            State state = (State)Predef$.MODULE$.ArrowAssoc(s);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state, this.F.pure((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        }

        private final Object $init$$$anonfun$7() {
            return "capacity must be > 0";
        }
    }

    public static final class CircularBufferQueue<F, A>
    extends AbstractQueue<F, A> {
        private final GenConcurrent<F, ?> F;

        public CircularBufferQueue(int capacity, Ref<F, State<F, A>> state, GenConcurrent<F, ?> F) {
            this.F = F;
            super(capacity, state, F);
        }

        @Override
        public Tuple2<State<F, A>, F> onOfferNoCapacity(State<F, A> s, A a, Deferred<F, BoxedUnit> offerer, Poll<F> poll, Function0<F> recurse) {
            Tuple2<State<F, A>, F> tuple2 = this.onTryOfferNoCapacity(s, a);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            State ns = (State)tuple2._1();
            Object fb = tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)ns, fb);
            State ns2 = (State)tuple22._1();
            Object fb2 = tuple22._2();
            return Tuple2$.MODULE$.apply((Object)ns2, package.all$.MODULE$.toFunctorOps(fb2, this.F).void());
        }

        @Override
        public Tuple2<State<F, A>, F> onTryOfferNoCapacity(State<F, A> s, A a) {
            State<F, A> state = s;
            if (state == null) {
                throw new MatchError(state);
            }
            State<F, A> state2 = Queue$State$.MODULE$.unapply(state);
            scala.collection.immutable.Queue<A> queue = state2._1();
            int n = state2._2();
            scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> queue2 = state2._3();
            scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> queue3 = state2._4();
            scala.collection.immutable.Queue<A> queue4 = queue;
            int size = n;
            scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> takers = queue2;
            scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> offerers = queue3;
            Tuple4 tuple4 = Tuple4$.MODULE$.apply(queue4, (Object)BoxesRunTime.boxToInteger((int)size), takers, offerers);
            scala.collection.immutable.Queue queue5 = (scala.collection.immutable.Queue)tuple4._1();
            int size2 = BoxesRunTime.unboxToInt((Object)tuple4._2());
            scala.collection.immutable.Queue takers2 = (scala.collection.immutable.Queue)tuple4._3();
            scala.collection.immutable.Queue offerers2 = (scala.collection.immutable.Queue)tuple4._4();
            Tuple2 tuple2 = queue5.dequeue();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Queue rest = (scala.collection.immutable.Queue)tuple2._2();
            scala.collection.immutable.Queue rest2 = rest;
            State state3 = (State)Predef$.MODULE$.ArrowAssoc(Queue$State$.MODULE$.apply(rest2.enqueue(a), size2, takers2, offerers2));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state3, this.F.pure((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        }
    }

    public static final class DroppingAsyncQueue<F, A>
    extends BaseBoundedAsyncQueue<F, A> {
        private final Async<F> F;

        public DroppingAsyncQueue(int capacity, Async<F> F) {
            this.F = F;
            super(capacity, F);
        }

        @Override
        public F offer(A a) {
            return (F)this.F.delay((Function0 & Serializable)() -> {
                this.offer$$anonfun$5(a);
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public F tryOffer(A a) {
            return (F)this.F.delay(() -> this.tryOffer$$anonfun$5(a));
        }

        private boolean tryOfferUnsafe(A a) {
            boolean bl;
            try {
                this.buffer().put(a);
                this.notifyOne(this.takers());
                bl = true;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                FailureSignal$ failureSignal$ = this.FailureSignal();
                Throwable throwable3 = throwable2;
                if (!(failureSignal$ != null ? !failureSignal$.equals(throwable3) : throwable3 != null)) {
                    bl = false;
                }
                throw throwable;
            }
            return bl;
        }

        private final void offer$$anonfun$5(Object a$21) {
            this.tryOfferUnsafe(a$21);
        }

        private final boolean tryOffer$$anonfun$5(Object a$22) {
            return this.tryOfferUnsafe(a$22);
        }
    }

    public static final class DroppingQueue<F, A>
    extends AbstractQueue<F, A> {
        private final GenConcurrent<F, ?> F;

        public DroppingQueue(int capacity, Ref<F, State<F, A>> state, GenConcurrent<F, ?> F) {
            this.F = F;
            super(capacity, state, F);
        }

        @Override
        public Tuple2<State<F, A>, F> onOfferNoCapacity(State<F, A> s, A a, Deferred<F, BoxedUnit> offerer, Poll<F> poll, Function0<F> recurse) {
            State state = (State)Predef$.MODULE$.ArrowAssoc(s);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state, this.F.unit());
        }

        @Override
        public Tuple2<State<F, A>, F> onTryOfferNoCapacity(State<F, A> s, A a) {
            State state = (State)Predef$.MODULE$.ArrowAssoc(s);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)state, this.F.pure((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        }
    }

    public static final class State<F, A>
    implements Product,
    Serializable {
        private final scala.collection.immutable.Queue queue;
        private final int size;
        private final scala.collection.immutable.Queue takers;
        private final scala.collection.immutable.Queue offerers;

        public static <F, A> State<F, A> apply(scala.collection.immutable.Queue<A> queue, int n, scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> queue2, scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> queue3) {
            return Queue$State$.MODULE$.apply(queue, n, queue2, queue3);
        }

        public static <F, A> State<F, A> empty() {
            return Queue$State$.MODULE$.empty();
        }

        public static State<?, ?> fromProduct(Product product) {
            return Queue$State$.MODULE$.fromProduct(product);
        }

        public static <F, A> State<F, A> unapply(State<F, A> state) {
            return Queue$State$.MODULE$.unapply(state);
        }

        public State(scala.collection.immutable.Queue<A> queue, int size, scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> takers, scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> offerers) {
            this.queue = queue;
            this.size = size;
            this.takers = takers;
            this.offerers = offerers;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.queue()));
            n = Statics.mix((int)n, (int)this.size());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.takers()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.offerers()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.size() != state.size()) return false;
            scala.collection.immutable.Queue<A> queue = this.queue();
            scala.collection.immutable.Queue<A> queue2 = state.queue();
            if (queue == null) {
                if (queue2 != null) {
                    return false;
                }
            } else if (!queue.equals(queue2)) return false;
            scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> queue3 = this.takers();
            scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> queue4 = state.takers();
            if (queue3 == null) {
                if (queue4 != null) {
                    return false;
                }
            } else if (!queue3.equals(queue4)) return false;
            scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> queue5 = this.offerers();
            scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> queue6 = state.offerers();
            if (queue5 == null) {
                if (queue6 == null) return true;
                return false;
            } else {
                if (!queue5.equals(queue6)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "queue";
                }
                case 1: {
                    return "size";
                }
                case 2: {
                    return "takers";
                }
                case 3: {
                    return "offerers";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public scala.collection.immutable.Queue<A> queue() {
            return this.queue;
        }

        public int size() {
            return this.size;
        }

        public scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> takers() {
            return this.takers;
        }

        public scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> offerers() {
            return this.offerers;
        }

        public <F, A> State<F, A> copy(scala.collection.immutable.Queue<A> queue, int size, scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> takers, scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> offerers) {
            return new State<F, A>(queue, size, takers, offerers);
        }

        public <F, A> scala.collection.immutable.Queue<A> copy$default$1() {
            return this.queue();
        }

        public int copy$default$2() {
            return this.size();
        }

        public <F, A> scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> copy$default$3() {
            return this.takers();
        }

        public <F, A> scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> copy$default$4() {
            return this.offerers();
        }

        public scala.collection.immutable.Queue<A> _1() {
            return this.queue();
        }

        public int _2() {
            return this.size();
        }

        public scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> _3() {
            return this.takers();
        }

        public scala.collection.immutable.Queue<Deferred<F, BoxedUnit>> _4() {
            return this.offerers();
        }
    }

    public static final class SyncState<F, A>
    implements Product,
    Serializable {
        private final scala.collection.immutable.Queue offerers;
        private final scala.collection.immutable.Queue takers;

        public static <F, A> SyncState<F, A> apply(scala.collection.immutable.Queue<Tuple2<A, Deferred<F, Object>>> queue, scala.collection.immutable.Queue<Deferred<F, Tuple2<A, Deferred<F, Object>>>> queue2) {
            return Queue$SyncState$.MODULE$.apply(queue, queue2);
        }

        public static <F, A> SyncState<F, A> empty() {
            return Queue$SyncState$.MODULE$.empty();
        }

        public static SyncState<?, ?> fromProduct(Product product) {
            return Queue$SyncState$.MODULE$.fromProduct(product);
        }

        public static <F, A> SyncState<F, A> unapply(SyncState<F, A> syncState) {
            return Queue$SyncState$.MODULE$.unapply(syncState);
        }

        public SyncState(scala.collection.immutable.Queue<Tuple2<A, Deferred<F, Object>>> offerers, scala.collection.immutable.Queue<Deferred<F, Tuple2<A, Deferred<F, Object>>>> takers) {
            this.offerers = offerers;
            this.takers = takers;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SyncState)) return false;
            SyncState syncState = (SyncState)object;
            scala.collection.immutable.Queue<Tuple2<A, Deferred<F, Object>>> queue = this.offerers();
            scala.collection.immutable.Queue<Tuple2<A, Deferred<F, Object>>> queue2 = syncState.offerers();
            if (queue == null) {
                if (queue2 != null) {
                    return false;
                }
            } else if (!queue.equals(queue2)) return false;
            scala.collection.immutable.Queue<Deferred<F, Tuple2<A, Deferred<F, Object>>>> queue3 = this.takers();
            scala.collection.immutable.Queue<Deferred<F, Tuple2<A, Deferred<F, Object>>>> queue4 = syncState.takers();
            if (queue3 == null) {
                if (queue4 == null) return true;
                return false;
            } else {
                if (!queue3.equals(queue4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SyncState;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SyncState";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "offerers";
            }
            if (1 == n2) {
                return "takers";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public scala.collection.immutable.Queue<Tuple2<A, Deferred<F, Object>>> offerers() {
            return this.offerers;
        }

        public scala.collection.immutable.Queue<Deferred<F, Tuple2<A, Deferred<F, Object>>>> takers() {
            return this.takers;
        }

        public <F, A> SyncState<F, A> copy(scala.collection.immutable.Queue<Tuple2<A, Deferred<F, Object>>> offerers, scala.collection.immutable.Queue<Deferred<F, Tuple2<A, Deferred<F, Object>>>> takers) {
            return new SyncState<F, A>(offerers, takers);
        }

        public <F, A> scala.collection.immutable.Queue<Tuple2<A, Deferred<F, Object>>> copy$default$1() {
            return this.offerers();
        }

        public <F, A> scala.collection.immutable.Queue<Deferred<F, Tuple2<A, Deferred<F, Object>>>> copy$default$2() {
            return this.takers();
        }

        public scala.collection.immutable.Queue<Tuple2<A, Deferred<F, Object>>> _1() {
            return this.offerers();
        }

        public scala.collection.immutable.Queue<Deferred<F, Tuple2<A, Deferred<F, Object>>>> _2() {
            return this.takers();
        }
    }

    public static final class Synchronous<F, A>
    extends Queue<F, A> {
        private final Ref<F, SyncState<F, A>> stateR;
        private final GenConcurrent<F, ?> F;
        private final Object take;
        private final Object tryTake;
        private final Object size;

        public Synchronous(Ref<F, SyncState<F, A>> stateR, GenConcurrent<F, ?> F) {
            this.stateR = stateR;
            this.F = F;
            this.take = package.all$.MODULE$.toFlatMapOps(F.deferred(), F).flatMap((Function1 & Serializable)latch -> F.uncancelable((Function1 & Serializable)poll -> {
                Object modificationF = stateR.modify((Function1 & Serializable)x$12 -> {
                    SyncState syncState = x$12;
                    if (syncState != null) {
                        SyncState syncState2 = Queue$SyncState$.MODULE$.unapply(syncState);
                        scala.collection.immutable.Queue queue = syncState2._1();
                        scala.collection.immutable.Queue queue2 = syncState2._2();
                        scala.collection.immutable.Queue offerers = queue;
                        scala.collection.immutable.Queue takers = queue2;
                        if (offerers.nonEmpty()) {
                            Tuple2 tuple2;
                            Tuple2 tuple22 = offerers.dequeue();
                            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
                                throw new MatchError((Object)tuple22);
                            }
                            Object value = tuple2._1();
                            Deferred offerer = (Deferred)tuple2._2();
                            scala.collection.immutable.Queue tail = (scala.collection.immutable.Queue)tuple22._2();
                            Tuple3 tuple3 = Tuple3$.MODULE$.apply(value, (Object)offerer, (Object)tail);
                            Object value2 = tuple3._1();
                            Deferred offerer2 = (Deferred)tuple3._2();
                            scala.collection.immutable.Queue tail2 = (scala.collection.immutable.Queue)tuple3._3();
                            SyncState syncState3 = (SyncState)Predef$.MODULE$.ArrowAssoc(Queue$SyncState$.MODULE$.apply(tail2, takers));
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)syncState3, package.all$.MODULE$.toFunctorOps(offerer2.complete((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Functor)F).as(value2));
                        }
                        scala.collection.immutable.Queue offerers2 = queue;
                        scala.collection.immutable.Queue takers2 = queue2;
                        Object removeListener = stateR.modify((Function1 & Serializable)x$1 -> {
                            SyncState syncState = x$1;
                            if (syncState != null) {
                                SyncState syncState2 = Queue$SyncState$.MODULE$.unapply(syncState);
                                scala.collection.immutable.Queue queue = syncState2._1();
                                scala.collection.immutable.Queue queue2 = syncState2._2();
                                scala.collection.immutable.Queue offerers = queue;
                                scala.collection.immutable.Queue takers = queue2;
                                Tuple2 tuple2 = this.filterFound$1((Deferred)latch, takers, scala.collection.immutable.Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])));
                                if (tuple2 == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                boolean found = BoxesRunTime.unboxToBoolean((Object)tuple2._1());
                                scala.collection.immutable.Queue takers2 = (scala.collection.immutable.Queue)tuple2._2();
                                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)found), (Object)takers2);
                                boolean found2 = BoxesRunTime.unboxToBoolean((Object)tuple22._1());
                                scala.collection.immutable.Queue takers22 = (scala.collection.immutable.Queue)tuple22._2();
                                SyncState syncState3 = (SyncState)Predef$.MODULE$.ArrowAssoc(Queue$SyncState$.MODULE$.apply(offerers, takers22));
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)syncState3, (Object)BoxesRunTime.boxToBoolean((boolean)found2));
                            }
                            throw new MatchError((Object)syncState);
                        });
                        Object failCommit = package.all$.MODULE$.toFlatMapOps(latch.get(), (FlatMap)F).flatMap((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                Deferred commitLatch = (Deferred)tuple2._2();
                                return package.all$.MODULE$.toFunctorOps(commitLatch.complete((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Functor)F).void();
                            }
                            throw new MatchError((Object)tuple2);
                        });
                        Object object = package.all$.MODULE$.catsSyntaxIfM(removeListener, (FlatMap)F);
                        Object cleanupF = IfMOps$.MODULE$.ifM$extension(object, () -> this.$anonfun$4(F), () -> this.$anonfun$5(failCommit), (FlatMap)F);
                        Object object2 = package.all$.MODULE$.monadCancelOps_(poll.apply(latch.get()));
                        Object awaitF = package.all$.MODULE$.toFlatMapOps(MonadCancelOps_$.MODULE$.onCancel$extension(object2, cleanupF, (MonadCancel)F), (FlatMap)F).flatMap((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                Object a = tuple2._1();
                                Deferred latch = (Deferred)tuple2._2();
                                return package.all$.MODULE$.toFunctorOps(latch.complete((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Functor)F).as(a);
                            }
                            throw new MatchError((Object)tuple2);
                        });
                        SyncState syncState4 = (SyncState)Predef$.MODULE$.ArrowAssoc(Queue$SyncState$.MODULE$.apply(offerers2, takers2.enqueue(latch)));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)syncState4, awaitF);
                    }
                    throw new MatchError((Object)syncState);
                });
                Object object = package.all$.MODULE$.catsSyntaxFlatten(modificationF, (FlatMap)F);
                return FlattenOps$.MODULE$.flatten$extension(object, (FlatMap)F);
            }));
            this.tryTake = F.uncancelable((Function1 & Serializable)_$22 -> stateR.flatModify((Function1 & Serializable)x$1 -> {
                SyncState syncState = x$1;
                if (syncState != null) {
                    SyncState syncState2 = Queue$SyncState$.MODULE$.unapply(syncState);
                    scala.collection.immutable.Queue queue = syncState2._1();
                    scala.collection.immutable.Queue queue2 = syncState2._2();
                    scala.collection.immutable.Queue offerers = queue;
                    scala.collection.immutable.Queue takers = queue2;
                    if (offerers.nonEmpty()) {
                        Tuple2 tuple2;
                        Tuple2 tuple22 = offerers.dequeue();
                        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
                            throw new MatchError((Object)tuple22);
                        }
                        Object value = tuple2._1();
                        Deferred offerer = (Deferred)tuple2._2();
                        scala.collection.immutable.Queue tail = (scala.collection.immutable.Queue)tuple22._2();
                        Tuple3 tuple3 = Tuple3$.MODULE$.apply(value, (Object)offerer, (Object)tail);
                        Object value2 = tuple3._1();
                        Deferred offerer2 = (Deferred)tuple3._2();
                        scala.collection.immutable.Queue tail2 = (scala.collection.immutable.Queue)tuple3._3();
                        SyncState syncState3 = (SyncState)Predef$.MODULE$.ArrowAssoc(Queue$SyncState$.MODULE$.apply(tail2, takers));
                        Object object = package.all$.MODULE$.catsSyntaxOptionId(value2);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)syncState3, package.all$.MODULE$.toFunctorOps(offerer2.complete((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Functor)F).as((Object)OptionIdOps$.MODULE$.some$extension(object)));
                    }
                }
                SyncState st = syncState;
                SyncState syncState4 = (SyncState)Predef$.MODULE$.ArrowAssoc((Object)st);
                Option option = (Option)package.all$.MODULE$.catsSyntaxApplicativeId((Object)package.all$.MODULE$.none());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)syncState4, ApplicativeIdOps$.MODULE$.pure$extension((Object)option, (Applicative)F));
            }, (MonadCancel)F));
            this.size = F.pure((Object)BoxesRunTime.boxToInteger((int)0));
        }

        @Override
        public F offer(A a) {
            return (F)package.all$.MODULE$.toFlatMapOps(this.F.deferred(), this.F).flatMap((Function1 & Serializable)latch -> this.F.uncancelable((Function1 & Serializable)poll -> {
                Object object = package.all$.MODULE$.catsSyntaxIfM(poll.apply(latch.get()), this.F);
                Object checkCommit = IfMOps$.MODULE$.ifM$extension(object, this::$anonfun$7, () -> this.$anonfun$8(poll, a), this.F);
                Object modificationF = this.stateR.modify((Function1 & Serializable)x$1 -> {
                    SyncState syncState = x$1;
                    if (syncState != null) {
                        SyncState syncState2 = Queue$SyncState$.MODULE$.unapply(syncState);
                        scala.collection.immutable.Queue queue = syncState2._1();
                        scala.collection.immutable.Queue queue2 = syncState2._2();
                        scala.collection.immutable.Queue offerers = queue;
                        scala.collection.immutable.Queue takers = queue2;
                        if (takers.nonEmpty()) {
                            Tuple2 tuple2 = takers.dequeue();
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Deferred taker = (Deferred)tuple2._1();
                            scala.collection.immutable.Queue tail = (scala.collection.immutable.Queue)tuple2._2();
                            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)taker, (Object)tail);
                            Deferred taker2 = (Deferred)tuple22._1();
                            scala.collection.immutable.Queue tail2 = (scala.collection.immutable.Queue)tuple22._2();
                            Object object = package.all$.MODULE$.catsSyntaxApplyOps(taker2.complete((Object)Tuple2$.MODULE$.apply(a, latch)));
                            Object finish = ApplyOps$.MODULE$.$times$greater$extension(object, checkCommit, this.F);
                            SyncState syncState3 = (SyncState)Predef$.MODULE$.ArrowAssoc(Queue$SyncState$.MODULE$.apply(offerers, tail2));
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)syncState3, finish);
                        }
                        scala.collection.immutable.Queue offerers2 = queue;
                        scala.collection.immutable.Queue takers2 = queue2;
                        Object cleanupF = this.stateR.update(arg_0 -> Queue$.cats$effect$std$Queue$Synchronous$$_$_$$anonfun$10(latch, arg_0));
                        SyncState syncState4 = (SyncState)Predef$.MODULE$.ArrowAssoc(Queue$SyncState$.MODULE$.apply(offerers2.enqueue((Object)Tuple2$.MODULE$.apply(a, latch)), takers2));
                        Object object = package.all$.MODULE$.monadCancelOps_(checkCommit);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)syncState4, MonadCancelOps_$.MODULE$.onCancel$extension(object, cleanupF, this.F));
                    }
                    throw new MatchError((Object)syncState);
                });
                Object object2 = package.all$.MODULE$.catsSyntaxFlatten(modificationF, this.F);
                return FlattenOps$.MODULE$.flatten$extension(object2, this.F);
            }));
        }

        @Override
        public F tryOffer(A a) {
            return (F)this.stateR.flatModify((Function1 & Serializable)x$1 -> {
                SyncState syncState = x$1;
                if (syncState != null) {
                    SyncState syncState2 = Queue$SyncState$.MODULE$.unapply(syncState);
                    scala.collection.immutable.Queue queue = syncState2._1();
                    scala.collection.immutable.Queue queue2 = syncState2._2();
                    scala.collection.immutable.Queue offerers = queue;
                    scala.collection.immutable.Queue takers = queue2;
                    if (takers.nonEmpty()) {
                        Tuple2 tuple2 = takers.dequeue();
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Deferred taker = (Deferred)tuple2._1();
                        scala.collection.immutable.Queue tail = (scala.collection.immutable.Queue)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)taker, (Object)tail);
                        Deferred taker2 = (Deferred)tuple22._1();
                        scala.collection.immutable.Queue tail2 = (scala.collection.immutable.Queue)tuple22._2();
                        Object commitF = package.all$.MODULE$.toFlatMapOps(this.F.deferred(), this.F).flatMap((Function1 & Serializable)latch -> this.F.uncancelable((Function1 & Serializable)poll -> {
                            Object object = package.all$.MODULE$.catsSyntaxApplyOps(taker2.complete((Object)Tuple2$.MODULE$.apply(a, latch)));
                            return ApplyOps$.MODULE$.$times$greater$extension(object, poll.apply(latch.get()), this.F);
                        }));
                        SyncState syncState3 = (SyncState)Predef$.MODULE$.ArrowAssoc(Queue$SyncState$.MODULE$.apply(offerers, tail2));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)syncState3, commitF);
                    }
                }
                SyncState st = syncState;
                SyncState syncState4 = (SyncState)Predef$.MODULE$.ArrowAssoc((Object)st);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)syncState4, this.F.pure((Object)BoxesRunTime.boxToBoolean((boolean)false)));
            }, this.F);
        }

        @Override
        public F take() {
            return (F)this.take;
        }

        @Override
        public F tryTake() {
            return (F)this.tryTake;
        }

        @Override
        public F size() {
            return (F)this.size;
        }

        private final Tuple2 filterFound$1(Deferred latch$4, scala.collection.immutable.Queue in, scala.collection.immutable.Queue out) {
            while (!in.isEmpty()) {
                Tuple2 tuple2 = in.dequeue();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object head = tuple2._1();
                scala.collection.immutable.Queue tail = (scala.collection.immutable.Queue)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply(head, (Object)tail);
                Object head2 = tuple22._1();
                scala.collection.immutable.Queue tail2 = (scala.collection.immutable.Queue)tuple22._2();
                if (head2 == latch$4) {
                    return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), out.$plus$plus((IterableOnce)tail2));
                }
                scala.collection.immutable.Queue queue = tail2;
                scala.collection.immutable.Queue queue2 = out.enqueue(head2);
                in = queue;
                out = queue2;
            }
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)out);
        }

        private final Object $anonfun$4(GenConcurrent F$14) {
            return F$14.unit();
        }

        private final Object $anonfun$5(Object failCommit$1) {
            return failCommit$1;
        }

        private final Object $anonfun$7() {
            return this.F.unit();
        }

        private final Object $anonfun$8(Poll poll$2, Object a$2) {
            return poll$2.apply(this.offer(a$2));
        }
    }

    public static final class UnboundedAsyncQueue<F, A>
    extends Queue<F, A>
    implements UnboundedQueue<F, A> {
        private final Async<F> F;
        private final UnsafeUnbounded<A> buffer;
        private final UnsafeUnbounded<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>> takers;
        private final FailureSignal$ FailureSignal;
        private final Object size;
        private final Object take;
        private final Object tryTake;

        public UnboundedAsyncQueue(Async<F> F) {
            this.F = F;
            this.buffer = new UnsafeUnbounded();
            this.takers = new UnsafeUnbounded();
            this.FailureSignal = FailureSignal$.MODULE$;
            this.size = F.delay(this::$init$$$anonfun$12);
            this.take = F.uncancelable((Function1 & Serializable)poll -> F.defer(() -> this.$init$$$anonfun$13$$anonfun$1(F, poll)));
            this.tryTake = F.delay(this::$init$$$anonfun$14);
        }

        @Override
        public void unsafeOffer(A a) {
            this.buffer.put(a);
            this.notifyOne();
        }

        @Override
        public F offer(A a) {
            return (F)this.F.delay((Function0 & Serializable)() -> {
                this.offer$$anonfun$4(a);
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public F tryOffer(A a) {
            return (F)this.F.delay(() -> this.tryOffer$$anonfun$4(a));
        }

        @Override
        public F size() {
            return (F)this.size;
        }

        @Override
        public F take() {
            return (F)this.take;
        }

        @Override
        public F tryTake() {
            return (F)this.tryTake;
        }

        private void notifyOne() {
            boolean retry;
            do {
                boolean bl;
                try {
                    Function1<Either<Throwable, BoxedUnit>, BoxedUnit> f = this.takers.take();
                    if (f == null) {
                        bl = true;
                    } else {
                        f.apply(Queue$.cats$effect$std$Queue$$$EitherUnit);
                        bl = false;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    FailureSignal$ failureSignal$ = this.FailureSignal;
                    Throwable throwable3 = throwable2;
                    if (!(failureSignal$ != null ? !failureSignal$.equals(throwable3) : throwable3 != null)) {
                        bl = false;
                    }
                    throw throwable;
                }
                retry = bl;
            } while (retry);
        }

        private final int $init$$$anonfun$12() {
            return this.buffer.size();
        }

        private final Either $anonfun$23$$anonfun$1(Function1 k$4, ObjectRef result$4, BooleanRef received$4, Async F$30) {
            Left left;
            Function0<BoxedUnit> clear = this.takers.put((Function1<Either<Throwable, BoxedUnit>, BoxedUnit>)k$4);
            try {
                result$4.elem = this.buffer.take();
                clear.apply$mcV$sp();
                received$4.elem = true;
                this.notifyOne();
                left = Queue$.cats$effect$std$Queue$$$EitherUnit;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                FailureSignal$ failureSignal$ = this.FailureSignal;
                Throwable throwable3 = throwable2;
                if (!(failureSignal$ != null ? !failureSignal$.equals(throwable3) : throwable3 != null)) {
                    left = package$.MODULE$.Left().apply((Object)Some$.MODULE$.apply(F$30.delay(clear)));
                }
                throw throwable;
            }
            return left;
        }

        private final void $anonfun$24() {
            this.notifyOne();
        }

        private final Object $init$$$anonfun$13$$anonfun$1$$anonfun$1(BooleanRef received$5, Async F$31, ObjectRef result$5, Poll poll$13) {
            if (received$5.elem) {
                return F$31.pure(result$5.elem);
            }
            return poll$13.apply(this.take());
        }

        private final Object $init$$$anonfun$13$$anonfun$1(Async F$28, Poll poll$12) {
            Object object;
            try {
                object = F$28.pure(this.buffer.take());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                FailureSignal$ failureSignal$ = this.FailureSignal;
                Throwable throwable3 = throwable2;
                if (!(failureSignal$ != null ? !failureSignal$.equals(throwable3) : throwable3 != null)) {
                    BooleanRef received = BooleanRef.create((boolean)false);
                    ObjectRef result = ObjectRef.create(null);
                    Object wait = F$28.asyncCheckAttempt((Function1 & Serializable)k -> F$28.delay(() -> this.$anonfun$23$$anonfun$1(k, result, received, F$28)));
                    Object notifyAnyway = F$28.delay((Function0 & Serializable)() -> {
                        this.$anonfun$24();
                        return BoxedUnit.UNIT;
                    });
                    Object object2 = package.all$.MODULE$.catsSyntaxApplyOps(poll$12.apply(wait));
                    Object object3 = package.all$.MODULE$.monadCancelOps_(ApplyOps$.MODULE$.$times$greater$extension(object2, F$28.defer(() -> this.$init$$$anonfun$13$$anonfun$1$$anonfun$1(received, F$28, result, poll$12)), (Apply)F$28));
                    object = MonadCancelOps_$.MODULE$.onCancel$extension(object3, notifyAnyway, (MonadCancel)F$28);
                }
                throw throwable;
            }
            return object;
        }

        private final Option $init$$$anonfun$14() {
            Some some;
            try {
                some = Some$.MODULE$.apply(this.buffer.take());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                FailureSignal$ failureSignal$ = this.FailureSignal;
                Throwable throwable3 = throwable2;
                if (!(failureSignal$ != null ? !failureSignal$.equals(throwable3) : throwable3 != null)) {
                    some = None$.MODULE$;
                }
                throw throwable;
            }
            return some;
        }

        private final void offer$$anonfun$4(Object a$19) {
            this.unsafeOffer(a$19);
        }

        private final boolean tryOffer$$anonfun$4(Object a$20) {
            this.buffer.put(a$20);
            this.notifyOne();
            return true;
        }
    }

    public static final class UnsafeBounded<A> {
        private final int bound;
        private final Object[] buffer;
        private final AtomicLongArray sequenceBuffer;
        private final AtomicLong head;
        private final AtomicLong tail;
        private final int LookAheadStep;
        private final FailureSignal$ FailureSignal;

        public UnsafeBounded(int bound) {
            this.bound = bound;
            Predef$.MODULE$.require(bound > 1, this::$init$$$anonfun$15);
            this.buffer = new Object[bound];
            this.sequenceBuffer = new AtomicLongArray(bound);
            this.head = new AtomicLong(0L);
            this.tail = new AtomicLong(0L);
            this.LookAheadStep = Math.max(2, Math.min(bound / 4, 4096));
            this.FailureSignal = FailureSignal$.MODULE$;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), bound).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.sequenceBuffer.set(i, i));
        }

        public String debug() {
            return Predef$.MODULE$.wrapRefArray(this.buffer).mkString("[", ", ", "]");
        }

        public int size() {
            long currentTail;
            long after;
            long before;
            do {
                before = this.head.get();
                currentTail = this.tail.get();
            } while (before != (after = this.head.get()));
            long size = currentTail - after;
            if (size < 0L) {
                return 0;
            }
            return (int)size;
        }

        public void put(A data) {
            long currentTail = this.loop$2(Long.MIN_VALUE);
            this.buffer[this.project((long)currentTail)] = data;
            this.sequenceBuffer.incrementAndGet(this.project(currentTail));
        }

        public A take() {
            long currentHead = this.loop$3(-1L);
            Object back = this.buffer[this.project(currentHead)];
            this.buffer[this.project((long)currentHead)] = null;
            this.sequenceBuffer.set(this.project(currentHead), currentHead + (long)this.bound);
            return (A)back;
        }

        public List<A> drain(int limit) {
            ListBuffer back = new ListBuffer();
            int maxLookAheadStep = Math.min(this.LookAheadStep, limit);
            this.loopMany$1(limit, maxLookAheadStep, back, 0);
            return back.toList();
        }

        private int project(long idx) {
            return (int)((idx & Integer.MAX_VALUE) % (long)this.bound);
        }

        private final Object $init$$$anonfun$15() {
            return "bound must be > 1";
        }

        private final long loop$2(long currentHead) {
            long currentTail;
            while (true) {
                long seq;
                if ((seq = this.sequenceBuffer.get(this.project(currentTail = this.tail.get()))) < currentTail) {
                    if (currentTail - (long)this.bound < currentHead) continue;
                    long currentHead2 = this.head.get();
                    if (currentTail - (long)this.bound >= currentHead2) {
                        throw this.FailureSignal;
                    }
                    currentHead = currentHead2;
                    continue;
                }
                if (seq == currentTail && this.tail.compareAndSet(currentTail, currentTail + 1L)) break;
            }
            return currentTail;
        }

        private final long loop$3(long currentTail) {
            long currentHead;
            while (true) {
                long seq;
                if ((seq = this.sequenceBuffer.get(this.project(currentHead = this.head.get()))) < currentHead + 1L) {
                    if (currentHead < currentTail) continue;
                    long currentTail2 = this.tail.get();
                    if (currentHead == currentTail2) {
                        throw this.FailureSignal;
                    }
                    currentTail = currentTail2;
                    continue;
                }
                if (seq == currentHead + 1L && this.head.compareAndSet(currentHead, currentHead + 1L)) break;
            }
            return currentHead;
        }

        private final void loopOne$1(int limit$2, ListBuffer back$1, int consumed) {
            while (consumed < limit$2) {
                boolean bl;
                try {
                    back$1.$plus$eq(this.take());
                    bl = true;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    FailureSignal$ failureSignal$ = this.FailureSignal;
                    Throwable throwable3 = throwable2;
                    if (!(failureSignal$ != null ? !failureSignal$.equals(throwable3) : throwable3 != null)) {
                        bl = false;
                    }
                    throw throwable;
                }
                boolean next = bl;
                if (next) {
                    ++consumed;
                    continue;
                }
                return;
            }
        }

        private final void loopMany$1(int limit$3, int maxLookAheadStep$1, ListBuffer back$2, int consumed) {
            while (consumed < limit$3) {
                long expectedLookAheadSeq;
                int remaining = limit$3 - consumed;
                int step = Math.min(remaining, maxLookAheadStep$1);
                long currentHead = this.head.get();
                long lookAheadIndex = currentHead + (long)step - 1L;
                int lookAheadOffset = this.project(lookAheadIndex);
                long lookAheadSeq = this.sequenceBuffer.get(lookAheadOffset);
                if (lookAheadSeq == (expectedLookAheadSeq = lookAheadIndex + 1L) && this.head.compareAndSet(currentHead, expectedLookAheadSeq)) {
                    for (int i = 0; i < step; ++i) {
                        long index = currentHead + (long)i;
                        int offset = this.project(index);
                        long expectedSeq = index + 1L;
                        while (this.sequenceBuffer.get(offset) != expectedSeq) {
                        }
                        Object value = this.buffer[offset];
                        this.buffer[offset] = null;
                        this.sequenceBuffer.set(offset, index + (long)this.bound);
                        back$2.$plus$eq(value);
                    }
                    consumed += step;
                    continue;
                }
                if (lookAheadSeq < expectedLookAheadSeq) {
                    if (this.sequenceBuffer.get(this.project(currentHead)) >= currentHead + 1L) {
                        this.loopOne$1(limit$3, back$2, consumed);
                        return;
                    }
                    return;
                }
                this.loopOne$1(limit$3, back$2, consumed);
                return;
            }
        }
    }
}

