/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.std;

import cats.Applicative;
import cats.Functor;
import cats.Show;
import cats.Show$;
import cats.arrow.FunctionK;
import cats.data.EitherT$;
import cats.data.IorT$;
import cats.data.Kleisli$;
import cats.data.OptionT$;
import cats.data.WriterT$;
import cats.data.package;
import cats.effect.kernel.Sync;
import cats.effect.std.Console;
import cats.effect.std.Console$;
import cats.kernel.Monoid;
import cats.syntax.package;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxedUnit;

public abstract class ConsoleCompanionCrossPlatform {
    public <F> Console apply(Console<F> C) {
        return C;
    }

    public <F, L> Console<?> catsEitherTConsole(Console<F> evidence$1, Functor<F> evidence$2) {
        return Console$.MODULE$.apply(evidence$1).mapK(EitherT$.MODULE$.liftK(evidence$2));
    }

    public <F, R> Console<?> catsKleisliConsole(Console<F> evidence$1) {
        return Console$.MODULE$.apply(evidence$1).mapK(Kleisli$.MODULE$.liftK());
    }

    public <F> Console<?> catsOptionTConsole(Console<F> evidence$1, Functor<F> evidence$2) {
        return Console$.MODULE$.apply(evidence$1).mapK(OptionT$.MODULE$.liftK(evidence$2));
    }

    public <F, S> Console<?> catsStateTConsole(Console<F> evidence$1, Applicative<F> evidence$2) {
        return Console$.MODULE$.apply(evidence$1).mapK(package.StateT$.MODULE$.liftK(evidence$2));
    }

    public <F, L> Console<?> catsWriterTConsole(Console<F> evidence$1, Applicative<F> evidence$2, Monoid<L> evidence$3) {
        return Console$.MODULE$.apply(evidence$1).mapK(WriterT$.MODULE$.liftK(evidence$3, evidence$2));
    }

    public <F, L> Console<?> catsIorTConsole(Console<F> evidence$1, Functor<F> evidence$2) {
        return Console$.MODULE$.apply(evidence$1).mapK(IorT$.MODULE$.liftK(evidence$2));
    }

    public <F, E, L, S> Console<?> catsReaderWriterStateTConsole(Console<F> evidence$1, Applicative<F> evidence$2, Monoid<L> evidence$3) {
        return Console$.MODULE$.apply(evidence$1).mapK(package.ReaderWriterStateT$.MODULE$.liftK(evidence$2, evidence$3));
    }

    public String readLineWithCharsetImpl(Charset charset) {
        InputStream in = System.in;
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPLACE);
        ByteBuffer bytes = ByteBuffer.allocate(64);
        StringBuilder builder = new StringBuilder();
        return ConsoleCompanionCrossPlatform.loop$1(builder, bytes, in, decoder);
    }

    public <F> Object printStackTrace(Console<F> c, Throwable t) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        t.printStackTrace(ps);
        return c.error(baos.toString(), Show$.MODULE$.catsShowForString());
    }

    public <F, G> Console<G> mapK(Console<F> self, FunctionK<F, G> f) {
        return new Console.MapKConsole<F, G>((Console)self, (FunctionK)f){
            private final FunctionK f$2;
            private final Console self$2;
            {
                this.f$2 = f$1;
                this.self$2 = self$1;
                super(self$1, f$1);
            }

            public Object print(Object a, Show S) {
                return this.f$2.apply(this.self$2.print(a, S));
            }

            public Object println(Object a, Show S) {
                return this.f$2.apply(this.self$2.println(a, S));
            }

            public Object error(Object a, Show S) {
                return this.f$2.apply(this.self$2.error(a, S));
            }

            public Object errorln(Object a, Show S) {
                return this.f$2.apply(this.self$2.errorln(a, S));
            }

            public Object printStackTrace(Throwable t) {
                return this.f$2.apply(this.self$2.printStackTrace(t));
            }
        };
    }

    private static final void print$$anonfun$1(String text$1) {
        System.out.print(text$1);
        System.out.flush();
    }

    public static /* bridge */ /* synthetic */ Object cats$effect$std$ConsoleCompanionCrossPlatform$SyncConsole$$_$print$$anonfun$adapted$1(String text$5) {
        ConsoleCompanionCrossPlatform.print$$anonfun$1(text$5);
        return BoxedUnit.UNIT;
    }

    private static final void println$$anonfun$1(String text$2) {
        System.out.println(text$2);
        System.out.flush();
    }

    public static /* bridge */ /* synthetic */ Object cats$effect$std$ConsoleCompanionCrossPlatform$SyncConsole$$_$println$$anonfun$adapted$1(String text$6) {
        ConsoleCompanionCrossPlatform.println$$anonfun$1(text$6);
        return BoxedUnit.UNIT;
    }

    private static final void error$$anonfun$1(String text$3) {
        System.err.print(text$3);
    }

    public static /* bridge */ /* synthetic */ Object cats$effect$std$ConsoleCompanionCrossPlatform$SyncConsole$$_$error$$anonfun$adapted$1(String text$7) {
        ConsoleCompanionCrossPlatform.error$$anonfun$1(text$7);
        return BoxedUnit.UNIT;
    }

    private static final void errorln$$anonfun$1(String text$4) {
        System.err.println(text$4);
    }

    public static /* bridge */ /* synthetic */ Object cats$effect$std$ConsoleCompanionCrossPlatform$SyncConsole$$_$errorln$$anonfun$adapted$1(String text$8) {
        ConsoleCompanionCrossPlatform.errorln$$anonfun$1(text$8);
        return BoxedUnit.UNIT;
    }

    private static final void printStackTrace$$anonfun$1(Throwable t$1) {
        t$1.printStackTrace();
    }

    public static /* bridge */ /* synthetic */ Object cats$effect$std$ConsoleCompanionCrossPlatform$SyncConsole$$_$printStackTrace$$anonfun$adapted$1(Throwable t$2) {
        ConsoleCompanionCrossPlatform.printStackTrace$$anonfun$1(t$2);
        return BoxedUnit.UNIT;
    }

    private static final CharBuffer decodeNext$1(ByteBuffer bytes$1, InputStream in$1, CharsetDecoder decoder$1) {
        bytes$1.clear();
        return ConsoleCompanionCrossPlatform.decodeNextLoop$1(in$1, bytes$1, decoder$1);
    }

    private static final CharBuffer decodeNextLoop$1(InputStream in$2, ByteBuffer bytes$2, CharsetDecoder decoder$2) {
        CharBuffer result;
        do {
            Object object;
            int b;
            if ((b = in$2.read()) == -1) {
                return null;
            }
            bytes$2.put((byte)b);
            int limit = bytes$2.limit();
            int position = bytes$2.position();
            result = null;
            try {
                bytes$2.flip();
                result = decoder$2.decode(bytes$2);
                object = BoxedUnit.UNIT;
            }
            catch (MalformedInputException malformedInputException) {
                bytes$2.limit(limit);
                object = bytes$2.position(position);
            }
        } while (result == null);
        return result;
    }

    private static final String loop$1(StringBuilder builder$1, ByteBuffer bytes$3, InputStream in$3, CharsetDecoder decoder$3) {
        while (true) {
            String decoded;
            CharBuffer buffer;
            if ((buffer = ConsoleCompanionCrossPlatform.decodeNext$1(bytes$3, in$3, decoder$3)) == null) {
                String result = builder$1.toString();
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(result))) {
                    return result;
                }
                throw new EOFException();
            }
            String string = decoded = buffer.toString();
            String string2 = "\n";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                int len = builder$1.length();
                if (len > 0 && builder$1.charAt(len - 1) == '\r') {
                    builder$1.deleteCharAt(len - 1);
                }
                return builder$1.toString();
            }
            builder$1.append(decoded);
        }
    }

    public class SyncConsole<F>
    implements Console<F> {
        private final Sync<F> F;
        private final /* synthetic */ ConsoleCompanionCrossPlatform $outer;

        public SyncConsole(ConsoleCompanionCrossPlatform $outer, Sync<F> F) {
            this.F = F;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public F readLineWithCharset(Charset charset) {
            return (F)this.F.blocking(() -> this.readLineWithCharset$$anonfun$1(charset));
        }

        @Override
        public <A> F print(A a, Show<A> S) {
            String text = package.show$.MODULE$.toShow(a, S).show();
            return (F)this.F.blocking(() -> ConsoleCompanionCrossPlatform.cats$effect$std$ConsoleCompanionCrossPlatform$SyncConsole$$_$print$$anonfun$adapted$1(text));
        }

        @Override
        public <A> Show<A> print$default$2(A a) {
            return Show$.MODULE$.fromToString();
        }

        @Override
        public <A> F println(A a, Show<A> S) {
            String text = package.show$.MODULE$.toShow(a, S).show();
            return (F)this.F.blocking(() -> ConsoleCompanionCrossPlatform.cats$effect$std$ConsoleCompanionCrossPlatform$SyncConsole$$_$println$$anonfun$adapted$1(text));
        }

        @Override
        public <A> Show<A> println$default$2(A a) {
            return Show$.MODULE$.fromToString();
        }

        @Override
        public <A> F error(A a, Show<A> S) {
            String text = package.show$.MODULE$.toShow(a, S).show();
            return (F)this.F.blocking(() -> ConsoleCompanionCrossPlatform.cats$effect$std$ConsoleCompanionCrossPlatform$SyncConsole$$_$error$$anonfun$adapted$1(text));
        }

        @Override
        public <A> Show<A> error$default$2(A a) {
            return Show$.MODULE$.fromToString();
        }

        @Override
        public <A> F errorln(A a, Show<A> S) {
            String text = package.show$.MODULE$.toShow(a, S).show();
            return (F)this.F.blocking(() -> ConsoleCompanionCrossPlatform.cats$effect$std$ConsoleCompanionCrossPlatform$SyncConsole$$_$errorln$$anonfun$adapted$1(text));
        }

        @Override
        public <A> Show<A> errorln$default$2(A a) {
            return Show$.MODULE$.fromToString();
        }

        @Override
        public F printStackTrace(Throwable t) {
            return (F)this.F.blocking(() -> ConsoleCompanionCrossPlatform.cats$effect$std$ConsoleCompanionCrossPlatform$SyncConsole$$_$printStackTrace$$anonfun$adapted$1(t));
        }

        public final /* synthetic */ ConsoleCompanionCrossPlatform cats$effect$std$ConsoleCompanionCrossPlatform$SyncConsole$$$outer() {
            return this.$outer;
        }

        private final String readLineWithCharset$$anonfun$1(Charset charset$1) {
            return this.$outer.readLineWithCharsetImpl(charset$1);
        }
    }
}

