/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.std;

import cats.effect.kernel.Async;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Ref;
import cats.effect.std.AtomicCell$;
import cats.effect.std.AtomicCell$ApplyPartiallyApplied$;
import cats.effect.std.Mutex;
import cats.kernel.Monoid;
import cats.syntax.package;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxedUnit;

public abstract class AtomicCell<F, A> {
    public static <F> boolean apply() {
        return AtomicCell$.MODULE$.apply();
    }

    public static <F, A> Object async(A a, Async<F> async) {
        return AtomicCell$.MODULE$.async(a, async);
    }

    public static <F, A> Object concurrent(A a, GenConcurrent<F, Throwable> genConcurrent) {
        return AtomicCell$.MODULE$.concurrent(a, genConcurrent);
    }

    public abstract F get();

    public abstract F set(A var1);

    public abstract <B> F modify(Function1<A, Tuple2<A, B>> var1);

    public abstract <B> F evalModify(Function1<A, F> var1);

    public F update(Function1<A, A> f) {
        return this.modify((Function1 & Serializable)a -> Tuple2$.MODULE$.apply(f.apply(a), (Object)BoxedUnit.UNIT));
    }

    public abstract F evalUpdate(Function1<A, F> var1);

    public F getAndUpdate(Function1<A, A> f) {
        return this.modify((Function1 & Serializable)a -> Tuple2$.MODULE$.apply(f.apply(a), a));
    }

    public abstract F evalGetAndUpdate(Function1<A, F> var1);

    public F updateAndGet(Function1<A, A> f) {
        return this.modify((Function1 & Serializable)a -> {
            Object aa = f.apply(a);
            return Tuple2$.MODULE$.apply(aa, aa);
        });
    }

    public abstract F evalUpdateAndGet(Function1<A, F> var1);

    public F getAndSet(A a) {
        return this.getAndUpdate((Function1 & Serializable)_$2 -> a);
    }

    public static final class ApplyPartiallyApplied<F> {
        private final boolean dummy;

        public static <A, F> Object empty$extension(boolean bl, Monoid<A> monoid, Async<F> async) {
            return AtomicCell$ApplyPartiallyApplied$.MODULE$.empty$extension(bl, monoid, async);
        }

        public static <A, F> Object empty$extension(boolean bl, Monoid<A> monoid, GenConcurrent<F, Throwable> genConcurrent) {
            return AtomicCell$ApplyPartiallyApplied$.MODULE$.empty$extension(bl, monoid, genConcurrent);
        }

        public static <F> boolean equals$extension(boolean bl, Object object) {
            return AtomicCell$ApplyPartiallyApplied$.MODULE$.equals$extension(bl, object);
        }

        public static <F> int hashCode$extension(boolean bl) {
            return AtomicCell$ApplyPartiallyApplied$.MODULE$.hashCode$extension(bl);
        }

        public static <A, F> Object of$extension(boolean bl, A a, Async<F> async) {
            return AtomicCell$ApplyPartiallyApplied$.MODULE$.of$extension(bl, a, async);
        }

        public static <A, F> Object of$extension(boolean bl, A a, GenConcurrent<F, Throwable> genConcurrent) {
            return AtomicCell$ApplyPartiallyApplied$.MODULE$.of$extension(bl, a, genConcurrent);
        }

        public ApplyPartiallyApplied(boolean dummy) {
            this.dummy = dummy;
        }

        public int hashCode() {
            return AtomicCell$ApplyPartiallyApplied$.MODULE$.hashCode$extension(this.cats$effect$std$AtomicCell$ApplyPartiallyApplied$$dummy());
        }

        public boolean equals(Object x$0) {
            return AtomicCell$ApplyPartiallyApplied$.MODULE$.equals$extension(this.cats$effect$std$AtomicCell$ApplyPartiallyApplied$$dummy(), x$0);
        }

        public boolean cats$effect$std$AtomicCell$ApplyPartiallyApplied$$dummy() {
            return this.dummy;
        }

        public <A> F of(A init, GenConcurrent<F, Throwable> F) {
            return (F)AtomicCell$ApplyPartiallyApplied$.MODULE$.of$extension(this.cats$effect$std$AtomicCell$ApplyPartiallyApplied$$dummy(), init, F);
        }

        public <A> F of(A init, Async<F> F) {
            return (F)AtomicCell$ApplyPartiallyApplied$.MODULE$.of$extension(this.cats$effect$std$AtomicCell$ApplyPartiallyApplied$$dummy(), init, F);
        }

        public <A> F empty(Monoid<A> M, GenConcurrent<F, Throwable> F) {
            return (F)AtomicCell$ApplyPartiallyApplied$.MODULE$.empty$extension(this.cats$effect$std$AtomicCell$ApplyPartiallyApplied$$dummy(), M, F);
        }

        public <A> F empty(Monoid<A> M, Async<F> F) {
            return (F)AtomicCell$ApplyPartiallyApplied$.MODULE$.empty$extension(this.cats$effect$std$AtomicCell$ApplyPartiallyApplied$$dummy(), M, F);
        }
    }

    public static final class AsyncImpl<F, A>
    extends AtomicCell<F, A> {
        private final Mutex<F> mutex;
        private final Async<F> F;
        private volatile A cell;

        public AsyncImpl(A init, Mutex<F> mutex, Async<F> F) {
            this.mutex = mutex;
            this.F = F;
            this.cell = init;
        }

        @Override
        public F get() {
            return (F)this.F.delay(this::get$$anonfun$1);
        }

        @Override
        public F set(A a) {
            return (F)this.mutex.lock().surround(this.F.delay((Function0 & Serializable)() -> {
                this.set$$anonfun$1(a);
                return BoxedUnit.UNIT;
            }), this.F);
        }

        @Override
        public <B> F modify(Function1<A, Tuple2<A, B>> f) {
            return this.evalModify((Function1 & Serializable)a -> this.F.pure(f.apply(a)));
        }

        @Override
        public <B> F evalModify(Function1<A, F> f) {
            return (F)this.mutex.lock().surround(package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.F.delay(this::evalModify$$anonfun$2), this.F).flatMap(f), this.F).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Object a = tuple2._1();
                    Object b = tuple2._2();
                    return this.F.delay(() -> this.evalModify$$anonfun$3$$anonfun$1(a, b));
                }
                throw new MatchError((Object)tuple2);
            }), this.F);
        }

        @Override
        public F evalUpdate(Function1<A, F> f) {
            return this.evalModify((Function1 & Serializable)a -> package.all$.MODULE$.toFunctorOps(f.apply(a), this.F).map(AtomicCell$::cats$effect$std$AtomicCell$AsyncImpl$$_$evalUpdate$$anonfun$2$$anonfun$1));
        }

        @Override
        public F evalGetAndUpdate(Function1<A, F> f) {
            return this.evalModify((Function1 & Serializable)a -> package.all$.MODULE$.toFunctorOps(f.apply(a), this.F).map(arg_0 -> AtomicCell$.cats$effect$std$AtomicCell$AsyncImpl$$_$evalGetAndUpdate$$anonfun$2$$anonfun$1(a, arg_0)));
        }

        @Override
        public F evalUpdateAndGet(Function1<A, F> f) {
            return this.evalModify((Function1 & Serializable)a -> package.all$.MODULE$.toFunctorOps(f.apply(a), this.F).map(AtomicCell$::cats$effect$std$AtomicCell$AsyncImpl$$_$evalUpdateAndGet$$anonfun$2$$anonfun$1));
        }

        private final Object get$$anonfun$1() {
            return this.cell;
        }

        private final void set$$anonfun$1(Object a$3) {
            this.cell = a$3;
        }

        private final Object evalModify$$anonfun$2() {
            return this.cell;
        }

        private final Object evalModify$$anonfun$3$$anonfun$1(Object a$4, Object b$1) {
            this.cell = a$4;
            return b$1;
        }
    }

    public static final class ConcurrentImpl<F, A>
    extends AtomicCell<F, A> {
        private final Ref<F, A> ref;
        private final Mutex<F> mutex;
        private final GenConcurrent<F, Throwable> F;

        public ConcurrentImpl(Ref<F, A> ref, Mutex<F> mutex, GenConcurrent<F, Throwable> F) {
            this.ref = ref;
            this.mutex = mutex;
            this.F = F;
        }

        @Override
        public F get() {
            return (F)this.ref.get();
        }

        @Override
        public F set(A a) {
            return (F)this.mutex.lock().surround(this.ref.set(a), this.F);
        }

        @Override
        public <B> F modify(Function1<A, Tuple2<A, B>> f) {
            return this.evalModify((Function1 & Serializable)a -> this.F.pure(f.apply(a)));
        }

        @Override
        public <B> F evalModify(Function1<A, F> f) {
            return (F)this.mutex.lock().surround(package.all$.MODULE$.toFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.ref.get(), this.F).flatMap(f), this.F).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Object a = tuple2._1();
                    Object b = tuple2._2();
                    return package.all$.MODULE$.toFunctorOps(this.ref.set(a), this.F).as(b);
                }
                throw new MatchError((Object)tuple2);
            }), this.F);
        }

        @Override
        public F evalUpdate(Function1<A, F> f) {
            return this.evalModify((Function1 & Serializable)a -> package.all$.MODULE$.toFunctorOps(f.apply(a), this.F).map(AtomicCell$::cats$effect$std$AtomicCell$ConcurrentImpl$$_$evalUpdate$$anonfun$1$$anonfun$1));
        }

        @Override
        public F evalGetAndUpdate(Function1<A, F> f) {
            return this.evalModify((Function1 & Serializable)a -> package.all$.MODULE$.toFunctorOps(f.apply(a), this.F).map(arg_0 -> AtomicCell$.cats$effect$std$AtomicCell$ConcurrentImpl$$_$evalGetAndUpdate$$anonfun$1$$anonfun$1(a, arg_0)));
        }

        @Override
        public F evalUpdateAndGet(Function1<A, F> f) {
            return this.evalModify((Function1 & Serializable)a -> package.all$.MODULE$.toFunctorOps(f.apply(a), this.F).map(AtomicCell$::cats$effect$std$AtomicCell$ConcurrentImpl$$_$evalUpdateAndGet$$anonfun$1$$anonfun$1));
        }
    }
}

