/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001\u0002\r\u001a\r\u0001Ba!\u0010\u0001\u0005\u0002\u0005-\u0003b\u0002,\u0001A\u0003%\u0011q\n\u0005\t\u0003'\u0002\u0001\u0015!\u0003\u0002V!9\u00111\f\u0001!B\u0013Y\bbBA/\u0001\u0011\u0005\u0011q\f\u0005\b\u0003G\u0002A\u0011AA3\u0011!\t\t\b\u0001Q\u0005\n\u0005M\u0004\u0002CA;\u0001\u0001&I!a\u001e\t\u000f\u0005\u001d\u0002\u0001\"\u0011\u0002*\u001d)\u0011'\u0007E\u0005e\u0019)\u0001$\u0007E\u0005g!)Qh\u0003C\u0001}\u0019)qh\u0003\u0002\f\u0001\"AQ+\u0004B\u0001B\u0003%!\n\u0003\u0005W\u001b\t\u0005\t\u0015!\u0003X\u0011\u0015iT\u0002\"\u0001k\u0011%yW\u00021A\u0001B\u0003&1\u000eC\u0003q\u001b\u0011\u0005\u0011\u000fC\u0003s\u001b\u0011\u00051\u000fC\u0003z\u001b\u0011\u0005!\u0010C\u0004\u0002\u001a5!I!a\u0007\t\u000f\u0005\u001dR\u0002\"\u0011\u0002*!I\u00111H\u0006\u0002\u0002\u0013%\u0011Q\b\u0002\t/\u0016\f7\u000eT5ti*\u0011!dG\u0001\u0007k:\u001c\u0018MZ3\u000b\u0005qi\u0012AB3gM\u0016\u001cGOC\u0001\u001f\u0003\u0011\u0019\u0017\r^:\u0004\u0001U\u0019\u0011%!\u0013\u0014\u0005\u0001\u0011\u0003cA\u0012-]5\tAE\u0003\u0002&M\u00051\u0011\r^8nS\u000eT!a\n\u0015\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002*U\u0005!Q\u000f^5m\u0015\u0005Y\u0013\u0001\u00026bm\u0006L!!\f\u0013\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004BaL\u0007\u0002H9\u0011\u0001GC\u0007\u00023\u0005Aq+Z1l\u0019&\u001cH\u000f\u0005\u00021\u0017M\u00191\u0002\u000e\u001e\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\r\u0005s\u0017PU3g!\t)4(\u0003\u0002=m\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012A\r\u0002\u0005\u001d>$W-\u0006\u0002B\u0019N\u0011QB\u0011\t\u0004\u0007\"SU\"\u0001#\u000b\u0005\u00153\u0015a\u0001:fM*\u0011qIK\u0001\u0005Y\u0006tw-\u0003\u0002J\t\niq+Z1l%\u00164WM]3oG\u0016\u0004\"a\u0013'\r\u0001\u0011)Q*\u0004b\u0001\u001d\n\t\u0011)\u0005\u0002P%B\u0011Q\u0007U\u0005\u0003#Z\u0012qAT8uQ&tw\r\u0005\u00026'&\u0011AK\u000e\u0002\u0004\u0003:L\u0018!A1\u0002\u000bE,X-^3\u0011\u0007a;'J\u0004\u0002ZI:\u0011!l\u0019\b\u00037\nt!\u0001X1\u000f\u0005u\u0003W\"\u00010\u000b\u0005}{\u0012A\u0002\u001fs_>$h(C\u0001\u001f\u0013\taR$\u0003\u0002\u001b7%\u0011Q)G\u0005\u0003K\u001a\fq\u0001]1dW\u0006<WM\u0003\u0002F3%\u0011\u0001.\u001b\u0002\u000f%\u00164WM]3oG\u0016\fV/Z;f\u0015\t)g\rF\u0002l[:\u00042\u0001\\\u0007K\u001b\u0005Y\u0001\"B+\u0011\u0001\u0004Q\u0005\"\u0002,\u0011\u0001\u00049\u0016!B0oKb$\u0018aB4fi:+\u0007\u0010\u001e\u000b\u0002W\u000691/\u001a;OKb$HC\u0001;x!\t)T/\u0003\u0002wm\t!QK\\5u\u0011\u0015A8\u00031\u0001l\u0003\u0011qW\r\u001f;\u0002\u0011A\f7m\u001b%fC\u0012$ba\u001f@\u0002\u0002\u0005\u0015\u0001CA\u001b}\u0013\tihGA\u0002J]RDQa \u000bA\u0002m\fQAY8v]\u0012Da!a\u0001\u0015\u0001\u0004Y\u0018a\u0002:f[>4X\r\u001a\u0005\b\u0003\u000f!\u0002\u0019AA\u0005\u0003\u0011\u0011xn\u001c;\u0011\u0007A\u0002!\nK\u0002\u0015\u0003\u001b\u0001B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'1\u0014AC1o]>$\u0018\r^5p]&!\u0011qCA\t\u0005\u001d!\u0018-\u001b7sK\u000e\f\u0001\u0002]1dWR\u000b\u0017\u000e\u001c\u000b\bw\u0006u\u0011qDA\u0011\u0011\u0015yX\u00031\u0001|\u0011\u0019\t\u0019!\u0006a\u0001w\"1\u00111E\u000bA\u0002-\fA\u0001\u001d:fm\"\u001aQ#!\u0004\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u000b\u0011\t\u00055\u0012Q\u0007\b\u0005\u0003_\t\t\u0004\u0005\u0002^m%\u0019\u00111\u0007\u001c\u0002\rA\u0013X\rZ3g\u0013\u0011\t9$!\u000f\u0003\rM#(/\u001b8h\u0015\r\t\u0019DN\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002@A!\u0011\u0011IA\"\u001b\u00051\u0015bAA#\r\n1qJ\u00196fGR\u00042aSA%\t\u0015i\u0005A1\u0001O)\t\ti\u0005\u0005\u00031\u0001\u0005\u001d\u0003#B\"\u0002R\u0005\u001d\u0013B\u00015E\u00035\tG\u000e\\8xK\u0012$v\u000eU1dWB\u00191%a\u0016\n\u0007\u0005eCEA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\\\u0001\bO\u000e\u001cu.\u001e8u\u0003\u001d\u0001(/\u001a9f]\u0012$2\u0001^A1\u0011\u0019)V\u00011\u0001\u0002H\u00059am\u001c:fC\u000eDGc\u0001;\u0002h!9\u0011\u0011\u000e\u0004A\u0002\u0005-\u0014!\u00014\u0011\rU\ni'a\u0012u\u0013\r\tyG\u000e\u0002\n\rVt7\r^5p]F\nA\u0002]1dW&3g*Z3eK\u0012$\u0012\u0001^\u0001\u0005a\u0006\u001c7\u000eF\u0002|\u0003sBQa \u0005A\u0002m\u0004")
public final class WeakList<A>
extends AtomicReference<Node<A>> {
    private final ReferenceQueue<A> queue = new ReferenceQueue();
    private final AtomicBoolean allowedToPack = new AtomicBoolean(true);
    private int gcCount = 0;

    public void prepend(A a) {
        this.packIfNeeded();
        Node<A> newHead = new Node<A>(a, this.queue);
        this.loop$1(newHead);
    }

    public void foreach(Function1<A, BoxedUnit> f) {
        for (Node currentNode = (Node)this.get(); currentNode != null; currentNode = currentNode.getNext()) {
            Object a = currentNode.get();
            Object object = a != null ? f.apply(a) : BoxedUnit.UNIT;
        }
    }

    private void packIfNeeded() {
        if (this.allowedToPack.compareAndSet(true, false)) {
            try {
                int gcCount = this.gcCount;
                boolean shouldPack = false;
                while (this.queue.poll() != null) {
                    if (++gcCount <= 0 || (gcCount & gcCount - 1) != 0) continue;
                    shouldPack = true;
                }
                if (shouldPack) {
                    gcCount -= this.pack(gcCount);
                }
                this.gcCount = gcCount;
            }
            finally {
                this.allowedToPack.set(true);
            }
            return;
        }
    }

    private int pack(int bound) {
        Node got = (Node)this.get();
        if (got != null) {
            return got.packHead(bound, 0, this);
        }
        return 0;
    }

    @Override
    public String toString() {
        return new StringBuilder(10).append("WeakList(").append(this.get()).append(")").toString();
    }

    private final void loop$1(Node newHead$1) {
        Node currentHead;
        do {
            currentHead = (Node)this.get();
            newHead$1.setNext(currentHead);
        } while (!this.compareAndSet(currentHead, newHead$1));
    }

    public static final class Node<A>
    extends WeakReference<A> {
        private Node<A> _next;

        public Node<A> getNext() {
            return this._next;
        }

        public void setNext(Node<A> next) {
            this._next = next;
        }

        public int packHead(int bound, int removed, WeakList<A> root) {
            Node<A> next;
            block6: {
                while (true) {
                    next = this_._next;
                    if (this_.get() != null) break block6;
                    if (!root.compareAndSet(this_, next)) break;
                    if (next == null) {
                        return removed + 1;
                    }
                    ++removed;
                    --bound;
                    Node<A> this_ = next;
                }
                Node prev = (Node)root.get();
                if (prev != null && prev.getNext() == this_) {
                    return super.packTail(bound, removed, prev);
                }
                if (next != null) {
                    return super.packTail(bound - 1, removed, this_);
                }
                return removed;
            }
            if (next == null) {
                return removed;
            }
            if (bound > 0) {
                return super.packTail(bound - 1, removed, this_);
            }
            return removed;
        }

        private int packTail(int bound, int removed, Node<A> prev) {
            while (true) {
                Node<A> this_;
                Node<A> next = this_._next;
                if (this_.get() == null) {
                    prev.setNext(next);
                    if (next == null) {
                        return removed + 1;
                    }
                    ++removed;
                    --bound;
                    this_ = next;
                    continue;
                }
                if (next == null) {
                    return removed;
                }
                if (bound <= 0) break;
                prev = this_;
                --bound;
                this_ = next;
            }
            return removed;
        }

        public String toString() {
            return new StringBuilder(8).append("Node(").append(this.get()).append(", ").append(this._next).append(")").toString();
        }

        public Node(A a, ReferenceQueue<A> queue) {
            super(a, queue);
        }
    }
}

