/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.unsafe.StripedHashtable$;
import cats.effect.unsafe.ThreadSafeHashtable$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4Q!\u0006\f\u00031qA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006S\u0001!\tA\u000b\u0005\u0007m\u0001\u0001\u000b\u0015B\u001c\t\ri\u0002\u0001\u0015)\u0003'\u0011\u0019Y\u0004\u0001)Q\u0005M!1A\b\u0001Q!\n\u0019Ba!\u0010\u0001!\u0002\u00131\u0003B\u0002 \u0001A\u0003%a\u0004C\u0003@\u0001\u0011\u0005\u0001\t\u0003\u0004I\u0001\u0001&I!\u0013\u0005\u0006\u001f\u0002!\t\u0001\u0015\u0005\u0006'\u0002!\t\u0001\u0016\u0005\u0007+\u0002!\tA\u0006,\t\ri\u0003A\u0011\u0001\f\\\u0011\u0019a\u0006\u0001\"\u0001\u00177\u001e)QL\u0006E\u0005=\u001a)QC\u0006E\u0005?\")\u0011&\u0005C\u0001A\"Aa(\u0005b\u0001\n\u000b\t\u0012\r\u0003\u0004c#\u0001\u0006iA\b\u0002\u0014)\"\u0014X-\u00193TC\u001a,\u0007*Y:ii\u0006\u0014G.\u001a\u0006\u0003/a\ta!\u001e8tC\u001a,'BA\r\u001b\u0003\u0019)gMZ3di*\t1$\u0001\u0003dCR\u001cXCA\u000f0'\t\u0001a\u0004\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VMZ\u0001\u0010S:LG/[1m\u0007\u0006\u0004\u0018mY5us\u000e\u0001\u0001CA\u0010(\u0013\tA\u0003EA\u0002J]R\fa\u0001P5oSRtDCA\u00166!\ra\u0003!L\u0007\u0002-A\u0011af\f\u0007\u0001\t\u0015\u0001\u0004A1\u00012\u0005\u0005\t\u0015C\u0001\u001a\u001f!\ty2'\u0003\u00025A\t9aj\u001c;iS:<\u0007\"\u0002\u0013\u0003\u0001\u00041\u0013!\u00035bg\"$\u0018M\u00197f!\ry\u0002HH\u0005\u0003s\u0001\u0012Q!\u0011:sCf\fAa]5{K\u0006!Q.Y:l\u0003!\u0019\u0017\r]1dSRL\u0018!\u00047pOJrU/\u001c+bE2,7/A\u0005U_6\u00147\u000f^8oK\u0006\u0019\u0001/\u001e;\u0015\u0007\u0005#e\t\u0005\u0002 \u0005&\u00111\t\t\u0002\u0005+:LG\u000fC\u0003F\u0013\u0001\u0007Q&A\u0001b\u0011\u00159\u0015\u00021\u0001'\u0003\u0011A\u0017m\u001d5\u0002\r%t7/\u001a:u)\u0015\t%\nT'O\u0011\u0015Y%\u00021\u00018\u0003\u0015!\u0018M\u00197f\u0011\u0015Y$\u00021\u0001'\u0011\u0015)%\u00021\u0001\u001f\u0011\u00159%\u00021\u0001'\u0003\u0019\u0011X-\\8wKR\u0019\u0011)\u0015*\t\u000b\u0015[\u0001\u0019A\u0017\t\u000b\u001d[\u0001\u0019\u0001\u0014\u0002\u001fUt7/\u00194f\u0011\u0006\u001c\b\u000e^1cY\u0016$\u0012aN\u0001\bSN,U\u000e\u001d;z+\u00059\u0006CA\u0010Y\u0013\tI\u0006EA\u0004C_>dW-\u00198\u0002\u001dUt7/\u00194f\u0007\u0006\u0004\u0018mY5usR\ta%A\u000bv]N\fg-Z%oSRL\u0017\r\\\"ba\u0006\u001c\u0017\u000e^=\u0002'QC'/Z1e'\u00064W\rS1tQR\f'\r\\3\u0011\u00051\n2CA\t\u001f)\u0005qV#\u0001\u0010\u0002\u0015Q{WNY:u_:,\u0007\u0005")
public final class ThreadSafeHashtable<A> {
    private final int initialCapacity;
    private Object[] hashtable;
    private int size;
    private int mask;
    private int capacity;
    private final int log2NumTables;
    private final Object Tombstone;

    public synchronized void put(A a, int hash) {
        int sz = this.size;
        int cap = this.capacity;
        if (sz << 1 >= cap) {
            int newCap = cap << 1;
            int newMask = newCap - 1;
            Object[] newHashtable = new Object[newCap];
            Object[] table = this.hashtable;
            for (int i = 0; i < cap; ++i) {
                Object cur = table[i];
                if (cur == null || cur == this.Tombstone) continue;
                this.insert(newHashtable, newMask, cur, System.identityHashCode(cur) >> this.log2NumTables);
            }
            this.hashtable = newHashtable;
            this.mask = newMask;
            this.capacity = newCap;
        }
        this.insert(this.hashtable, this.mask, a, hash);
        this.size = sz + 1;
    }

    private void insert(Object[] table, int mask, Object a, int hash) {
        int idx = hash & mask;
        for (int remaining = mask; remaining >= 0; --remaining) {
            Object cur = table[idx];
            if (cur == null || cur == this.Tombstone) {
                table[idx] = a;
                return;
            }
            idx = idx + 1 & mask;
        }
    }

    public synchronized void remove(A a, int hash) {
        int init;
        int msk = this.mask;
        int idx = init = hash & msk;
        Object[] table = this.hashtable;
        for (int remaining = msk; remaining >= 0; --remaining) {
            Object cur = table[idx];
            if (a == cur) {
                table[idx] = this.Tombstone;
                --this.size;
                int sz = this.size;
                int cap = this.capacity;
                if (cap > this.initialCapacity && sz << 2 < cap) {
                    int newCap = cap >>> 1;
                    int newMask = newCap - 1;
                    Object[] newHashtable = new Object[newCap];
                    Object[] table2 = this.hashtable;
                    for (int i = 0; i < cap; ++i) {
                        Object cur2 = table2[i];
                        if (cur2 == null || cur2 == this.Tombstone) continue;
                        this.insert(newHashtable, newMask, cur2, System.identityHashCode(cur2) >> this.log2NumTables);
                    }
                    this.hashtable = newHashtable;
                    this.mask = newMask;
                    this.capacity = newCap;
                }
                return;
            }
            if (cur == null) {
                return;
            }
            idx = idx + 1 & msk;
        }
    }

    public Object[] unsafeHashtable() {
        return this.hashtable;
    }

    public boolean isEmpty() {
        return this.size == 0 && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(this.hashtable)).forall((Function1 & java.io.Serializable & Serializable)cb -> BoxesRunTime.boxToBoolean((boolean)ThreadSafeHashtable.$anonfun$isEmpty$1(this, cb)));
    }

    public int unsafeCapacity() {
        return this.capacity;
    }

    public int unsafeInitialCapacity() {
        return this.initialCapacity;
    }

    public static final /* synthetic */ boolean $anonfun$isEmpty$1(ThreadSafeHashtable $this, Object cb) {
        return cb == null || cb == $this.Tombstone;
    }

    public ThreadSafeHashtable(int initialCapacity) {
        this.initialCapacity = initialCapacity;
        this.hashtable = new Object[initialCapacity];
        this.size = 0;
        this.mask = initialCapacity - 1;
        this.capacity = initialCapacity;
        this.log2NumTables = StripedHashtable$.MODULE$.log2NumTables();
        this.Tombstone = ThreadSafeHashtable$.MODULE$.Tombstone();
    }
}

