/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.tracing;

import cats.effect.tracing.RingBuffer$;
import cats.effect.tracing.TracingEvent;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E3Qa\u0004\t\u0003%YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006E\u0001!Ia\t\u0005\u0007O\u0001\u0001\u000b\u0011B\u0010\t\r!\u0002\u0001\u0015!\u0003 \u0011\u0019I\u0003\u0001)Q\u0005U!1\u0001\u0007\u0001Q!\n}AQ!\r\u0001\u0005\u0002IBQ\u0001\u000f\u0001\u0005\u0002eBQA\u000f\u0001\u0005\u0002mBQ\u0001\u0013\u0001\u0005\u0002%;aA\u0013\t\t\u0002IYeAB\b\u0011\u0011\u0003\u0011B\nC\u0003#\u0019\u0011\u0005Q\nC\u0003O\u0019\u0011\u0005qJ\u0001\u0006SS:<')\u001e4gKJT!!\u0005\n\u0002\u000fQ\u0014\u0018mY5oO*\u00111\u0003F\u0001\u0007K\u001a4Wm\u0019;\u000b\u0003U\tAaY1ugN\u0011\u0001a\u0006\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u000f1|wmU5{K\u000e\u0001\u0001C\u0001\r!\u0013\t\t\u0013DA\u0002J]R\fa\u0001P5oSRtDC\u0001\u0013'!\t)\u0003!D\u0001\u0011\u0011\u0015i\"\u00011\u0001 \u0003\u0019aWM\\4uQ\u0006!Q.Y:l\u0003\u0019\u0011WO\u001a4feB\u0019\u0001dK\u0017\n\u00051J\"!B!se\u0006L\bCA\u0013/\u0013\ty\u0003C\u0001\u0007Ue\u0006\u001c\u0017N\\4Fm\u0016tG/A\u0003j]\u0012,\u00070\u0001\u0003qkNDGCA\u001a7!\tAB'\u0003\u000263\t!QK\\5u\u0011\u00159t\u00011\u0001.\u0003\t!X-\u0001\u0003qK\u0016\\W#A\u0017\u0002\rQ|G*[:u)\u0005a\u0004cA\u001fF[9\u0011ah\u0011\b\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003z\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005\u0011K\u0012a\u00029bG.\fw-Z\u0005\u0003\r\u001e\u0013A\u0001T5ti*\u0011A)G\u0001\u000bS:4\u0018\r\\5eCR,G#A\u001a\u0002\u0015IKgn\u001a\"vM\u001a,'\u000f\u0005\u0002&\u0019M\u0011Ab\u0006\u000b\u0002\u0017\u0006)Q-\u001c9usR\u0011A\u0005\u0015\u0005\u0006;9\u0001\ra\b")
public final class RingBuffer {
    private final int length;
    private final int mask;
    private TracingEvent[] buffer;
    private int index;

    public static RingBuffer empty(int n) {
        return RingBuffer$.MODULE$.empty(n);
    }

    public void push(TracingEvent te) {
        int idx = this.index & this.mask;
        this.buffer[idx] = te;
        ++this.index;
    }

    public TracingEvent peek() {
        return this.buffer[this.index - 1 & this.mask];
    }

    public List<TracingEvent> toList() {
        List result = List$.MODULE$.empty();
        TracingEvent[] buf = this.buffer;
        if (buf != null) {
            int msk = this.mask;
            int idx = this.index;
            int start = package$.MODULE$.max(idx - this.length, 0);
            int end = idx;
            for (int i = start; i < end; ++i) {
                result = result.$colon$colon((Object)buf[i & msk]);
            }
        }
        return result;
    }

    public void invalidate() {
        this.index = 0;
        this.buffer = null;
    }

    public RingBuffer(int logSize) {
        this.length = 1 << logSize;
        this.mask = this.length - 1;
        this.buffer = new TracingEvent[this.length];
        this.index = 0;
    }
}

