/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.adapter.IStackFrameManager;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StackFrameManager
implements IStackFrameManager {
    private Map<Long, StackFrame[]> threadStackFrameMap = Collections.synchronizedMap(new HashMap());

    @Override
    public StackFrame getStackFrame(StackFrameReference ref) {
        ThreadReference thread = ref.getThread();
        int depth = ref.getDepth();
        StackFrame[] frames = this.threadStackFrameMap.get(thread.uniqueID());
        return frames == null || frames.length < depth ? null : frames[depth];
    }

    @Override
    public StackFrame[] reloadStackFrames(ThreadReference thread) {
        return this.threadStackFrameMap.compute(thread.uniqueID(), (key, old) -> {
            try {
                return thread.frames().toArray(new StackFrame[0]);
            }
            catch (IncompatibleThreadStateException e) {
                return new StackFrame[0];
            }
        });
    }
}

