/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.adapter.IProvider;
import com.microsoft.java.debug.core.adapter.IProviderContext;
import java.util.HashMap;
import java.util.Map;

public class ProviderContext
implements IProviderContext {
    private Map<Class<? extends IProvider>, IProvider> providerMap = new HashMap<Class<? extends IProvider>, IProvider>();

    @Override
    public <T extends IProvider> T getProvider(Class<T> clazz) {
        if (!this.providerMap.containsKey(clazz)) {
            throw new IllegalArgumentException(String.format("%s has not been registered.", clazz.getName()));
        }
        return (T)this.providerMap.get(clazz);
    }

    @Override
    public void registerProvider(Class<? extends IProvider> clazz, IProvider provider) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null provider class is illegal.");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Null provider is illegal.");
        }
        if (this.providerMap.containsKey(clazz)) {
            throw new IllegalArgumentException(String.format("%s has already been registered.", clazz.getName()));
        }
        if (!clazz.isInstance(provider)) {
            throw new IllegalArgumentException(String.format("The provider doesn't implement interface %s.", clazz.getName()));
        }
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("The provider class should be an interface");
        }
        this.providerMap.put(clazz, provider);
    }
}

