/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = -7068164191168103891L;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private int cacheSize;

    public LRUCache(int cacheSize) {
        super((int)Math.ceil((float)cacheSize / 0.75f) + 1, 0.75f, true);
        if (cacheSize < 0) {
            throw new IllegalArgumentException("cacheSize is negative.");
        }
        this.cacheSize = cacheSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.cacheSize;
    }
}

