/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.DebugEvent;
import com.microsoft.java.debug.core.IEventHub;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import java.util.logging.Logger;

public class EventHub
implements IEventHub {
    private static final Logger logger = Logger.getLogger("java-debug");
    private PublishSubject<DebugEvent> subject = PublishSubject.create();
    private Thread workingThread = null;
    private boolean isClosed = false;

    @Override
    public Observable<DebugEvent> events() {
        return this.subject;
    }

    @Override
    public void start(VirtualMachine vm) {
        if (this.isClosed) {
            throw new IllegalStateException("This event hub is already closed.");
        }
        this.workingThread = new Thread(() -> {
            EventQueue queue = vm.eventQueue();
            try {
                while (true) {
                    if (Thread.interrupted()) {
                        this.subject.onComplete();
                        return;
                    }
                    EventSet set = queue.remove();
                    boolean shouldResume = true;
                    for (Event event : set) {
                        try {
                            logger.fine("\nJDI Event: " + event + "\n");
                        }
                        catch (VMDisconnectedException vMDisconnectedException) {
                            // empty catch block
                        }
                        DebugEvent dbgEvent = new DebugEvent();
                        dbgEvent.event = event;
                        dbgEvent.eventSet = set;
                        this.subject.onNext((Object)dbgEvent);
                        shouldResume &= dbgEvent.shouldResume;
                    }
                    if (!shouldResume) continue;
                    set.resume();
                }
            }
            catch (InterruptedException e) {
                this.isClosed = true;
                this.subject.onComplete();
                return;
            }
            catch (VMDisconnectedException e) {
                this.isClosed = true;
                this.subject.onError((Throwable)e);
                return;
            }
        }, "Event Hub");
        this.workingThread.start();
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.workingThread.interrupt();
        this.workingThread = null;
        this.isClosed = true;
    }

    @Override
    public Observable<DebugEvent> breakpointEvents() {
        return this.events().filter(debugEvent -> debugEvent.event instanceof BreakpointEvent);
    }

    @Override
    public Observable<DebugEvent> threadEvents() {
        return this.events().filter(debugEvent -> debugEvent.event instanceof ThreadStartEvent || debugEvent.event instanceof ThreadDeathEvent);
    }

    @Override
    public Observable<DebugEvent> exceptionEvents() {
        return this.events().filter(debugEvent -> debugEvent.event instanceof ExceptionEvent);
    }

    @Override
    public Observable<DebugEvent> stepEvents() {
        return this.events().filter(debugEvent -> debugEvent.event instanceof StepEvent);
    }

    @Override
    public Observable<DebugEvent> vmEvents() {
        return this.events().filter(debugEvent -> debugEvent.event instanceof VMStartEvent || debugEvent.event instanceof VMDisconnectEvent || debugEvent.event instanceof VMDeathEvent);
    }
}

