/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.UsageDataSession;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.DebugAdapter;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapter;
import com.microsoft.java.debug.core.adapter.IProviderContext;
import com.microsoft.java.debug.core.protocol.AbstractProtocolServer;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.sun.jdi.VMDisconnectedException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProtocolServer
extends AbstractProtocolServer {
    private static final Logger logger = Logger.getLogger("java-debug");
    private IDebugAdapter debugAdapter;
    private UsageDataSession usageDataSession = new UsageDataSession();
    private Object lock = new Object();
    private boolean isDispatchingRequest = false;
    private ConcurrentLinkedQueue<Events.DebugEvent> eventQueue = new ConcurrentLinkedQueue();

    public ProtocolServer(InputStream input, OutputStream output, IProviderContext context) {
        super(input, output);
        this.debugAdapter = new DebugAdapter(this, context);
    }

    @Override
    public void run() {
        this.usageDataSession.reportStart();
        super.run();
        this.usageDataSession.reportStop();
        this.usageDataSession.submitUsageData();
    }

    @Override
    public void sendResponse(Messages.Response response) {
        this.usageDataSession.recordResponse(response);
        super.sendResponse(response);
    }

    @Override
    public CompletableFuture<Messages.Response> sendRequest(Messages.Request request) {
        this.usageDataSession.recordRequest(request);
        return super.sendRequest(request);
    }

    @Override
    public CompletableFuture<Messages.Response> sendRequest(Messages.Request request, long timeout) {
        this.usageDataSession.recordRequest(request);
        return super.sendRequest(request, timeout);
    }

    @Override
    public void sendEvent(Events.DebugEvent event) {
        if (event instanceof Events.StoppedEvent) {
            this.sendEventLater(event);
        } else {
            super.sendEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEventLater(Events.DebugEvent event) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isDispatchingRequest) {
                this.eventQueue.offer(event);
            } else {
                super.sendEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispatchRequest(Messages.Request request) {
        Object object;
        this.usageDataSession.recordRequest(request);
        try {
            object = this.lock;
            synchronized (object) {
                this.isDispatchingRequest = true;
            }
            ((CompletableFuture)((CompletableFuture)this.debugAdapter.dispatchRequest(request).thenCompose(response -> {
                CompletableFuture future = new CompletableFuture();
                if (response != null) {
                    this.sendResponse((Messages.Response)response);
                    future.complete(null);
                } else {
                    future.completeExceptionally(new DebugException("The request dispatcher should not return null response.", ErrorCode.UNKNOWN_FAILURE.getId()));
                }
                return future;
            })).exceptionally(ex -> {
                Messages.Response response = new Messages.Response(request.seq, request.command);
                if (ex instanceof CompletionException && ex.getCause() != null) {
                    ex = ex.getCause();
                }
                if (ex instanceof VMDisconnectedException) {
                    response.success = true;
                    this.sendResponse(response);
                } else {
                    boolean isUserError;
                    String exceptionMessage = ex.getMessage() != null ? ex.getMessage() : ex.toString();
                    ErrorCode errorCode = ex instanceof DebugException ? ErrorCode.parse(((DebugException)ex).getErrorCode()) : ErrorCode.UNKNOWN_FAILURE;
                    boolean bl = isUserError = ex instanceof DebugException && ((DebugException)ex).isUserError();
                    if (isUserError) {
                        this.usageDataSession.recordUserError(errorCode);
                    } else {
                        logger.log(Level.SEVERE, String.format("[error response][%s]: %s", request.command, exceptionMessage), (Throwable)ex);
                    }
                    this.sendResponse(AdapterUtils.setErrorResponse(response, errorCode, exceptionMessage));
                }
                return null;
            })).join();
        }
        finally {
            object = this.lock;
            synchronized (object) {
                this.isDispatchingRequest = false;
            }
            while (this.eventQueue.peek() != null) {
                super.sendEvent(this.eventQueue.poll());
            }
        }
    }
}

