/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.debugger.dap;

import cats.Applicative;
import cats.FlatMap;
import cats.Functor;
import cats.Invariant;
import cats.Invariant$;
import cats.Semigroupal;
import cats.Show;
import cats.UnorderedFoldable$;
import cats.data.NonEmptyList;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.std.Dispatcher;
import cats.syntax.ApplicativeByNameOps$;
import cats.syntax.package;
import com.google.gson.JsonObject;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Types;
import fs2.Stream;
import fs2.Stream$;
import fs2.concurrent.Channel;
import fs2.concurrent.Signal;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.api.debugger.Debugger;
import org.apache.daffodil.debugger.dap.DAPodil;
import org.apache.daffodil.debugger.dap.DAPodil$Data$;
import org.apache.daffodil.debugger.dap.DAPodil$Debugee$State$Running$;
import org.apache.daffodil.debugger.dap.DAPodil$Debugee$State$Stopped$;
import org.apache.daffodil.debugger.dap.DAPodil$Debugee$State$Stopped$Reason$BreakpointHit$;
import org.apache.daffodil.debugger.dap.DAPodil$Debugee$State$Stopped$Reason$Entry$;
import org.apache.daffodil.debugger.dap.DAPodil$Debugee$State$Stopped$Reason$Pause$;
import org.apache.daffodil.debugger.dap.DAPodil$Debugee$State$Stopped$Reason$StepIn$;
import org.apache.daffodil.debugger.dap.DAPodil$Debugee$State$Stopped$Reason$StepOut$;
import org.apache.daffodil.debugger.dap.DAPodil$Debugee$State$Stopped$Reason$StepOver$;
import org.apache.daffodil.debugger.dap.DAPodil$Frame$;
import org.apache.daffodil.debugger.dap.DAPodil$Frame$Scope$;
import org.apache.daffodil.debugger.dap.DAPodil$Line$;
import org.apache.daffodil.debugger.dap.DAPodil$Location$;
import org.apache.daffodil.debugger.dap.Next;
import org.apache.daffodil.debugger.dap.Parse;
import org.apache.daffodil.debugger.dap.Parse$;
import org.apache.daffodil.debugger.dap.Parse$Breakpoints$;
import org.apache.daffodil.debugger.dap.Parse$ConfigEvent$;
import org.apache.daffodil.debugger.dap.Parse$ConfigEvent$BuildInfo$;
import org.apache.daffodil.debugger.dap.Parse$ConfigEvent$LaunchArgs$;
import org.apache.daffodil.debugger.dap.Parse$Control$;
import org.apache.daffodil.debugger.dap.Parse$DaffodilDebugger$;
import org.apache.daffodil.debugger.dap.Parse$DataEvent$;
import org.apache.daffodil.debugger.dap.Parse$DataLeftOverEvent$;
import org.apache.daffodil.debugger.dap.Parse$Debugee$;
import org.apache.daffodil.debugger.dap.Parse$Debugee$LaunchArgs$;
import org.apache.daffodil.debugger.dap.Parse$Delimiter$;
import org.apache.daffodil.debugger.dap.Parse$Delivery$;
import org.apache.daffodil.debugger.dap.Parse$Delivery$State$;
import org.apache.daffodil.debugger.dap.Parse$ElementName$;
import org.apache.daffodil.debugger.dap.Parse$Event$;
import org.apache.daffodil.debugger.dap.Parse$Event$Control$;
import org.apache.daffodil.debugger.dap.Parse$Event$EndElement$;
import org.apache.daffodil.debugger.dap.Parse$Event$Fini$;
import org.apache.daffodil.debugger.dap.Parse$Event$Init$;
import org.apache.daffodil.debugger.dap.Parse$Exception$;
import org.apache.daffodil.debugger.dap.Parse$InfosetEvent$;
import org.apache.daffodil.debugger.dap.Parse$PointOfUncertainty$;
import org.apache.daffodil.lib.exceptions.SchemaFileLocation;
import org.apache.daffodil.lib.xml.NS;
import org.apache.daffodil.runtime1.events.EventHandler;
import org.apache.daffodil.runtime1.infoset.DIDocument;
import org.apache.daffodil.runtime1.infoset.DIElement;
import org.apache.daffodil.runtime1.processors.StateForDebugger;
import org.apache.daffodil.runtime1.processors.dfa.DFADelimiter;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.Parser;
import org.typelevel.log4cats.Logger;
import org.typelevel.log4cats.Logger$;
import org.typelevel.log4cats.slf4j.Slf4jLogger$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple4$;
import scala.Tuple5$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public interface Parse {
    public static IO<Parse> apply(Path path, InputStream inputStream, Path path2, Debugger debugger, String string, Option<String> option, Option<String> option2, Map<String, String> map, Map<String, String> map2, Channel<IO, Events.DebugEvent> channel) {
        return Parse$.MODULE$.apply(path, inputStream, path2, debugger, string, option, option2, map, map2, channel);
    }

    public static DAPodil.Source dataDumpSource() {
        return Parse$.MODULE$.dataDumpSource();
    }

    public static Resource<IO, DAPodil.Debugee> debugee(Debugee.LaunchArgs.Manual manual) {
        return Parse$.MODULE$.debugee(manual);
    }

    public static Either<NonEmptyList<String>, Resource<IO, DAPodil.Debugee>> debugee(Messages.Request request) {
        return Parse$.MODULE$.debugee(request);
    }

    public static DAPodil.Source infosetSource() {
        return Parse$.MODULE$.infosetSource();
    }

    public static Logger<IO> logger() {
        return Parse$.MODULE$.logger();
    }

    public Stream<IO, Object> run();

    public IO<BoxedUnit> close();

    public static interface Breakpoints {
        public static IO<Breakpoints> apply() {
            return Parse$Breakpoints$.MODULE$.apply();
        }

        public IO<BoxedUnit> setBreakpoints(URI var1, List<DAPodil.Line> var2);

        public IO<Object> shouldBreak(DAPodil.Location var1);
    }

    public static class ConfigEvent
    extends Events.DebugEvent
    implements Product,
    Serializable {
        private final LaunchArgs launchArgs;
        private final BuildInfo buildInfo;

        public static ConfigEvent apply(LaunchArgs launchArgs, BuildInfo buildInfo) {
            return Parse$ConfigEvent$.MODULE$.apply(launchArgs, buildInfo);
        }

        public static ConfigEvent apply(Debugee.LaunchArgs launchArgs) {
            return Parse$ConfigEvent$.MODULE$.apply(launchArgs);
        }

        public static ConfigEvent fromProduct(Product product) {
            return Parse$ConfigEvent$.MODULE$.fromProduct(product);
        }

        public static ConfigEvent unapply(ConfigEvent configEvent) {
            return Parse$ConfigEvent$.MODULE$.unapply(configEvent);
        }

        public ConfigEvent(LaunchArgs launchArgs, BuildInfo buildInfo) {
            this.launchArgs = launchArgs;
            this.buildInfo = buildInfo;
            super("daffodil.config");
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ConfigEvent)) return false;
            ConfigEvent configEvent = (ConfigEvent)object;
            LaunchArgs launchArgs = this.launchArgs();
            LaunchArgs launchArgs2 = configEvent.launchArgs();
            if (launchArgs == null) {
                if (launchArgs2 != null) {
                    return false;
                }
            } else if (!launchArgs.equals(launchArgs2)) return false;
            BuildInfo buildInfo = this.buildInfo();
            BuildInfo buildInfo2 = configEvent.buildInfo();
            if (buildInfo == null) {
                if (buildInfo2 != null) {
                    return false;
                }
            } else if (!((Object)buildInfo).equals(buildInfo2)) return false;
            if (!configEvent.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ConfigEvent;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ConfigEvent";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "launchArgs";
            }
            if (1 == n2) {
                return "buildInfo";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public LaunchArgs launchArgs() {
            return this.launchArgs;
        }

        public BuildInfo buildInfo() {
            return this.buildInfo;
        }

        public ConfigEvent copy(LaunchArgs launchArgs, BuildInfo buildInfo) {
            return new ConfigEvent(launchArgs, buildInfo);
        }

        public LaunchArgs copy$default$1() {
            return this.launchArgs();
        }

        public BuildInfo copy$default$2() {
            return this.buildInfo();
        }

        public LaunchArgs _1() {
            return this.launchArgs();
        }

        public BuildInfo _2() {
            return this.buildInfo();
        }

        public static class BuildInfo
        implements Product,
        Serializable {
            private final String version;
            private final String scalaVersion;

            public static BuildInfo apply(String string, String string2) {
                return Parse$ConfigEvent$BuildInfo$.MODULE$.apply(string, string2);
            }

            public static BuildInfo fromProduct(Product product) {
                return Parse$ConfigEvent$BuildInfo$.MODULE$.fromProduct(product);
            }

            public static BuildInfo unapply(BuildInfo buildInfo) {
                return Parse$ConfigEvent$BuildInfo$.MODULE$.unapply(buildInfo);
            }

            public BuildInfo(String version, String scalaVersion) {
                this.version = version;
                this.scalaVersion = scalaVersion;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof BuildInfo)) return false;
                BuildInfo buildInfo = (BuildInfo)object;
                String string = this.version();
                String string2 = buildInfo.version();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                String string3 = this.scalaVersion();
                String string4 = buildInfo.scalaVersion();
                if (string3 == null) {
                    if (string4 != null) {
                        return false;
                    }
                } else if (!string3.equals(string4)) return false;
                if (!buildInfo.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof BuildInfo;
            }

            public int productArity() {
                return 2;
            }

            public String productPrefix() {
                return "BuildInfo";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                if (1 == n2) {
                    return this._2();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "version";
                }
                if (1 == n2) {
                    return "scalaVersion";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String version() {
                return this.version;
            }

            public String scalaVersion() {
                return this.scalaVersion;
            }

            public BuildInfo copy(String version, String scalaVersion) {
                return new BuildInfo(version, scalaVersion);
            }

            public String copy$default$1() {
                return this.version();
            }

            public String copy$default$2() {
                return this.scalaVersion();
            }

            public String _1() {
                return this.version();
            }

            public String _2() {
                return this.scalaVersion();
            }
        }

        public static interface LaunchArgs {
            public static int ordinal(LaunchArgs launchArgs) {
                return Parse$ConfigEvent$LaunchArgs$.MODULE$.ordinal(launchArgs);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static interface Control {
        public static Logger<IO> logger() {
            return Parse$Control$.MODULE$.logger();
        }

        public static IO<Control> stopped() {
            return Parse$Control$.MODULE$.stopped();
        }

        public IO<Object> await();

        public IO<BoxedUnit> continue();

        public IO<BoxedUnit> stepOver();

        public IO<BoxedUnit> stepIn();

        public IO<BoxedUnit> stepOut();

        public IO<BoxedUnit> pause();
    }

    public static class DaffodilDebugger
    implements EventHandler,
    Debugger {
        private final Dispatcher<IO> dispatcher;
        private final Breakpoints breakpoints;
        private final Control control;
        private final Channel<IO, Event> events;
        private final String infosetFormat;
        private final Logger logger;

        public static Resource<IO, Debugger> resource(Channel<IO, Event> channel, Breakpoints breakpoints, Control control, String string) {
            return Parse$DaffodilDebugger$.MODULE$.resource(channel, breakpoints, control, string);
        }

        public DaffodilDebugger(Dispatcher<IO> dispatcher, Breakpoints breakpoints, Control control, Channel<IO, Event> events, String infosetFormat) {
            this.dispatcher = dispatcher;
            this.breakpoints = breakpoints;
            this.control = control;
            this.events = events;
            this.infosetFormat = infosetFormat;
            this.logger = Slf4jLogger$.MODULE$.getLogger((Sync)IO$.MODULE$.asyncForIO(), "org.apache.daffodil.debugger.dap.Parse.DaffodilDebugger");
        }

        public Logger<IO> logger() {
            return this.logger;
        }

        public void init(PState pstate, Parser processor) {
            this.dispatcher.unsafeRunSync((Object)((IO)this.events.send((Object)Parse$Event$Init$.MODULE$.apply((StateForDebugger)pstate.copyStateForDebugger()))).void());
        }

        public void fini(Parser processor) {
            this.dispatcher.unsafeRunSync((Object)((IO)this.events.send((Object)Parse$Event$Fini$.MODULE$)).$times$greater((IO)this.events.close()).$times$greater((IO)Logger$.MODULE$.apply(this.logger()).debug(Parse$::org$apache$daffodil$debugger$dap$Parse$DaffodilDebugger$$_$fini$$anonfun$1)));
        }

        public void startElement(PState pstate, Parser processor) {
            LazyRef lazyRef = new LazyRef();
            this.dispatcher.unsafeRunSync((Object)((IO)this.logger().debug(Parse$::org$apache$daffodil$debugger$dap$Parse$DaffodilDebugger$$_$startElement$$anonfun$1)).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.control.await().flatMap((Function1 & Serializable)isStepping -> this.startElement$$anonfun$2$$anonfun$1(pstate, lazyRef, BoxesRunTime.unboxToBoolean((Object)isStepping)));
            }));
        }

        public IO<BoxedUnit> onBreakpointHit(DAPodil.Location location) {
            return this.control.pause().$times$greater(((IO)this.events.send((Object)Parse$Event$Control$.MODULE$.apply(DAPodil$Debugee$State$Stopped$.MODULE$.breakpointHit(location)))).void());
        }

        public DAPodil.Location createLocation(SchemaFileLocation loc) {
            return DAPodil$Location$.MODULE$.apply(URI.create(loc.diagnosticFile().toURI().toString()).normalize(), DAPodil$Line$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)loc.lineNumber().map(Parse$::org$apache$daffodil$debugger$dap$Parse$DaffodilDebugger$$_$createLocation$$anonfun$1).getOrElse(Parse$::org$apache$daffodil$debugger$dap$Parse$DaffodilDebugger$$_$createLocation$$anonfun$2))));
        }

        public void endElement(PState pstate, Parser processor) {
            this.dispatcher.unsafeRunSync((Object)this.control.await().$times$greater(((IO)this.events.send((Object)Parse$Event$EndElement$.MODULE$.apply((StateForDebugger)pstate.copyStateForDebugger()))).void()));
        }

        private final Option infoset$lzyINIT1$1(LazyRef infoset$lzy1$1, PState pstate$2) {
            Option option;
            LazyRef lazyRef = infoset$lzy1$1;
            synchronized (lazyRef) {
                Object object;
                if (infoset$lzy1$1.initialized()) {
                    object = infoset$lzy1$1.value();
                } else {
                    DIDocument d;
                    DIElement node = pstate$2.infoset();
                    while (node.diParent() != null) {
                        node = node.diParent();
                    }
                    DIElement dIElement = node;
                    object = infoset$lzy1$1.initialize(dIElement instanceof DIDocument && (d = (DIDocument)dIElement).numChildren() == 0 ? None$.MODULE$ : Some$.MODULE$.apply((Object)Parse$InfosetEvent$.MODULE$.apply(this.infosetFormat, node)));
                }
                option = (Option)object;
            }
            return option;
        }

        private final Option infoset$1(LazyRef infoset$lzy1$2, PState pstate$3) {
            return (Option)(infoset$lzy1$2.initialized() ? infoset$lzy1$2.value() : this.infoset$lzyINIT1$1(infoset$lzy1$2, pstate$3));
        }

        private final /* synthetic */ Tuple2 startElement$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$1(boolean isStepping$2, PState pstate$8, LazyRef infoset$lzy1$6, boolean shouldBreak) {
            Event.StartElement startElement = isStepping$2 || shouldBreak ? new Event.StartElement(pstate$8, (Option<InfosetEvent>)this.infoset$1(infoset$lzy1$6, pstate$8)) : new Event.StartElement(pstate$8, (Option<InfosetEvent>)None$.MODULE$);
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)shouldBreak), (Object)startElement);
        }

        private final IO startElement$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$1(DAPodil.Location location$4) {
            return this.onBreakpointHit(location$4);
        }

        private final /* synthetic */ IO startElement$$anonfun$2$$anonfun$1(PState pstate$5, LazyRef infoset$lzy1$4, boolean isStepping) {
            return ((IO)this.logger().debug(Parse$::org$apache$daffodil$debugger$dap$Parse$DaffodilDebugger$$_$startElement$$anonfun$2$$anonfun$1$$anonfun$1)).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit;
                BoxedUnit $4$ = boxedUnit = BoxedUnit.UNIT;
                DAPodil.Location location = this.createLocation(pstate$5.schemaFileLocation());
                return Tuple2$.MODULE$.apply((Object)$4$, (Object)location);
            }).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    DAPodil.Location location = (DAPodil.Location)tuple2._2();
                    return this.breakpoints.shouldBreak(location).map((Function1 & Serializable)shouldBreak -> this.startElement$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$1(isStepping, pstate$5, infoset$lzy1$4, BoxesRunTime.unboxToBoolean((Object)shouldBreak))).flatMap((Function1 & Serializable)x$12 -> {
                        Tuple2 tuple2 = x$12;
                        if (tuple2 != null) {
                            boolean shouldBreak = BoxesRunTime.unboxToBoolean((Object)tuple2._1());
                            Event.StartElement startElement = (Event.StartElement)tuple2._2();
                            return ((IO)this.events.send((Object)startElement)).flatMap((Function1 & Serializable)x$1 -> {
                                Either either = x$1;
                                Function0 function0 = package.all$.MODULE$.catsSyntaxApplicativeByName(() -> this.startElement$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$1(location));
                                return ((IO)ApplicativeByNameOps$.MODULE$.whenA$extension(function0, shouldBreak, (Applicative)IO$.MODULE$.asyncForIO())).map((Function1)((JProcedure1 & Serializable)Parse$::org$apache$daffodil$debugger$dap$Parse$DaffodilDebugger$$_$startElement$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$2));
                            });
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
                throw new MatchError((Object)tuple2);
            });
        }
    }

    public static class DataEvent
    extends Events.DebugEvent
    implements Product,
    Serializable {
        private final long bytePos1b;

        public static DataEvent apply(long l) {
            return Parse$DataEvent$.MODULE$.apply(l);
        }

        public static DataEvent fromProduct(Product product) {
            return Parse$DataEvent$.MODULE$.fromProduct(product);
        }

        public static DataEvent unapply(DataEvent dataEvent) {
            return Parse$DataEvent$.MODULE$.unapply(dataEvent);
        }

        public DataEvent(long bytePos1b) {
            this.bytePos1b = bytePos1b;
            super("daffodil.data");
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.bytePos1b()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DataEvent)) return false;
            DataEvent dataEvent = (DataEvent)object;
            if (this.bytePos1b() != dataEvent.bytePos1b()) return false;
            if (!dataEvent.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DataEvent;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DataEvent";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "bytePos1b";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long bytePos1b() {
            return this.bytePos1b;
        }

        public DataEvent copy(long bytePos1b) {
            return new DataEvent(bytePos1b);
        }

        public long copy$default$1() {
            return this.bytePos1b();
        }

        public long _1() {
            return this.bytePos1b();
        }
    }

    public static class DataLeftOverEvent
    extends Events.DebugEvent
    implements Product,
    Serializable {
        private final long bitPos1b;
        private final long bytePos1b;
        private final long leftOverBits;
        private final String message;

        public static DataLeftOverEvent apply(long l, long l2, long l3, String string) {
            return Parse$DataLeftOverEvent$.MODULE$.apply(l, l2, l3, string);
        }

        public static DataLeftOverEvent fromProduct(Product product) {
            return Parse$DataLeftOverEvent$.MODULE$.fromProduct(product);
        }

        public static DataLeftOverEvent unapply(DataLeftOverEvent dataLeftOverEvent) {
            return Parse$DataLeftOverEvent$.MODULE$.unapply(dataLeftOverEvent);
        }

        public DataLeftOverEvent(long bitPos1b, long bytePos1b, long leftOverBits, String message) {
            this.bitPos1b = bitPos1b;
            this.bytePos1b = bytePos1b;
            this.leftOverBits = leftOverBits;
            this.message = message;
            super("daffodil.dataLeftOver");
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.bitPos1b()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.bytePos1b()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.leftOverBits()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.message()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DataLeftOverEvent)) return false;
            DataLeftOverEvent dataLeftOverEvent = (DataLeftOverEvent)object;
            if (this.bitPos1b() != dataLeftOverEvent.bitPos1b()) return false;
            if (this.bytePos1b() != dataLeftOverEvent.bytePos1b()) return false;
            if (this.leftOverBits() != dataLeftOverEvent.leftOverBits()) return false;
            String string = this.message();
            String string2 = dataLeftOverEvent.message();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!dataLeftOverEvent.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DataLeftOverEvent;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "DataLeftOverEvent";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToLong((long)this._3());
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "bitPos1b";
                }
                case 1: {
                    return "bytePos1b";
                }
                case 2: {
                    return "leftOverBits";
                }
                case 3: {
                    return "message";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long bitPos1b() {
            return this.bitPos1b;
        }

        public long bytePos1b() {
            return this.bytePos1b;
        }

        public long leftOverBits() {
            return this.leftOverBits;
        }

        public String message() {
            return this.message;
        }

        public DataLeftOverEvent copy(long bitPos1b, long bytePos1b, long leftOverBits, String message) {
            return new DataLeftOverEvent(bitPos1b, bytePos1b, leftOverBits, message);
        }

        public long copy$default$1() {
            return this.bitPos1b();
        }

        public long copy$default$2() {
            return this.bytePos1b();
        }

        public long copy$default$3() {
            return this.leftOverBits();
        }

        public String copy$default$4() {
            return this.message();
        }

        public long _1() {
            return this.bitPos1b();
        }

        public long _2() {
            return this.bytePos1b();
        }

        public long _3() {
            return this.leftOverBits();
        }

        public String _4() {
            return this.message();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Debugee
    implements DAPodil.Debugee {
        private final DAPodil.Source schema;
        private final DAPodil.Source dataIn;
        private final Signal<IO, DAPodil.Data> outputData;
        private final Stream<IO, Events.DebugEvent> eventsIn;
        private final Breakpoints breakpoints;
        private final Control control;
        private final Channel<IO, Event> parseEvents;

        public static Either<NonEmptyList<String>, Path> parseData(JsonObject jsonObject) {
            return Parse$Debugee$.MODULE$.parseData(jsonObject);
        }

        public static Either<NonEmptyList<String>, String> parseInfosetFormat(JsonObject jsonObject) {
            return Parse$Debugee$.MODULE$.parseInfosetFormat(jsonObject);
        }

        public static Either<NonEmptyList<String>, Serializable> parseInfosetOutput(JsonObject jsonObject, boolean bl) {
            return Parse$Debugee$.MODULE$.parseInfosetOutput(jsonObject, bl);
        }

        public static Either<NonEmptyList<Nothing$>, Option<String>> parseRootName(JsonObject jsonObject) {
            return Parse$Debugee$.MODULE$.parseRootName(jsonObject);
        }

        public static Either<NonEmptyList<Nothing$>, Option<String>> parseRootNamespace(JsonObject jsonObject) {
            return Parse$Debugee$.MODULE$.parseRootNamespace(jsonObject);
        }

        public static Either<NonEmptyList<String>, Path> parseSchema(JsonObject jsonObject) {
            return Parse$Debugee$.MODULE$.parseSchema(jsonObject);
        }

        public static Either<NonEmptyList<String>, Object> parseStopOnEntry(JsonObject jsonObject) {
            return Parse$Debugee$.MODULE$.parseStopOnEntry(jsonObject);
        }

        public static Either<NonEmptyList<String>, LaunchArgs> parseTDML(JsonObject jsonObject, JsonObject jsonObject2) {
            return Parse$Debugee$.MODULE$.parseTDML(jsonObject, jsonObject2);
        }

        public static Either<NonEmptyList<String>, String> parseTDMLName(JsonObject jsonObject) {
            return Parse$Debugee$.MODULE$.parseTDMLName(jsonObject);
        }

        public static Either<NonEmptyList<String>, String> parseTDMLPath(JsonObject jsonObject) {
            return Parse$Debugee$.MODULE$.parseTDMLPath(jsonObject);
        }

        public static Either<NonEmptyList<String>, Map<String, String>> parseTunables(JsonObject jsonObject) {
            return Parse$Debugee$.MODULE$.parseTunables(jsonObject);
        }

        public static Either<NonEmptyList<String>, Map<String, String>> parseVariables(JsonObject jsonObject) {
            return Parse$Debugee$.MODULE$.parseVariables(jsonObject);
        }

        public static boolean parseInfosetOutput$default$2() {
            return Parse$Debugee$.MODULE$.parseInfosetOutput$default$2();
        }

        public Debugee(DAPodil.Source schema, DAPodil.Source dataIn, Signal<IO, DAPodil.Data> outputData, Stream<IO, Events.DebugEvent> eventsIn, Breakpoints breakpoints, Control control, Channel<IO, Event> parseEvents) {
            this.schema = schema;
            this.dataIn = dataIn;
            this.outputData = outputData;
            this.eventsIn = eventsIn;
            this.breakpoints = breakpoints;
            this.control = control;
            this.parseEvents = parseEvents;
        }

        @Override
        public Signal<IO, DAPodil.Data> data() {
            return this.outputData;
        }

        @Override
        public Stream<IO, Events.DebugEvent> events() {
            return this.eventsIn;
        }

        @Override
        public IO<List<DAPodil.Source>> sources() {
            return IO$.MODULE$.pure((Object)new .colon.colon((Object)this.schema, (List)new .colon.colon((Object)this.dataIn, (List)Nil$.MODULE$)));
        }

        @Override
        public IO<Option<DAPodil.Source.Content>> sourceContent(int ref) {
            return IO$.MODULE$.pure((Object)None$.MODULE$);
        }

        @Override
        public Stream<IO, DAPodil.Source> sourceChanges() {
            return Stream$.MODULE$.empty();
        }

        @Override
        public IO<BoxedUnit> stepOver() {
            return this.control.stepOver().$times$greater(((IO)this.parseEvents.send((Object)Parse$Event$Control$.MODULE$.apply(DAPodil$Debugee$State$Stopped$.MODULE$.stepOver()))).void());
        }

        @Override
        public IO<BoxedUnit> stepIn() {
            return this.control.stepIn().$times$greater(((IO)this.parseEvents.send((Object)Parse$Event$Control$.MODULE$.apply(DAPodil$Debugee$State$Stopped$.MODULE$.stepIn()))).void());
        }

        @Override
        public IO<BoxedUnit> stepOut() {
            return this.control.stepOut().$times$greater(((IO)this.parseEvents.send((Object)Parse$Event$Control$.MODULE$.apply(DAPodil$Debugee$State$Stopped$.MODULE$.stepOut()))).void());
        }

        @Override
        public IO<BoxedUnit> continue() {
            return this.control.continue().$times$greater(((IO)this.parseEvents.send((Object)Parse$Event$Control$.MODULE$.apply(DAPodil$Debugee$State$Running$.MODULE$))).void());
        }

        @Override
        public IO<BoxedUnit> pause() {
            return this.control.pause().$times$greater(((IO)this.parseEvents.send((Object)Parse$Event$Control$.MODULE$.apply(DAPodil$Debugee$State$Stopped$.MODULE$.pause()))).void());
        }

        @Override
        public IO<BoxedUnit> setBreakpoints(URI uri, List<DAPodil.Line> lines) {
            return this.breakpoints.setBreakpoints(uri, lines);
        }

        @Override
        public IO<Option<Types.Variable>> eval(Requests.EvaluateArguments args) {
            String string;
            String name = string = args.expression;
            return ((IO)this.data().get()).map(arg_0 -> Parse$.org$apache$daffodil$debugger$dap$Parse$Debugee$$_$eval$$anonfun$1(args, name, arg_0));
        }

        public static interface LaunchArgs {
            public static int ordinal(LaunchArgs launchArgs) {
                return Parse$Debugee$LaunchArgs$.MODULE$.ordinal(launchArgs);
            }

            public static Either<NonEmptyList<String>, LaunchArgs> parse(JsonObject jsonObject) {
                return Parse$Debugee$LaunchArgs$.MODULE$.parse(jsonObject);
            }

            public static Either<NonEmptyList<String>, LaunchArgs> parseManual(JsonObject jsonObject) {
                return Parse$Debugee$LaunchArgs$.MODULE$.parseManual(jsonObject);
            }
        }
    }

    public static class Delimiter
    implements Product,
    Serializable {
        private final String kind;
        private final DFADelimiter value;

        public static Delimiter apply(String string, DFADelimiter dFADelimiter) {
            return Parse$Delimiter$.MODULE$.apply(string, dFADelimiter);
        }

        public static Delimiter fromProduct(Product product) {
            return Parse$Delimiter$.MODULE$.fromProduct(product);
        }

        public static Delimiter unapply(Delimiter delimiter) {
            return Parse$Delimiter$.MODULE$.unapply(delimiter);
        }

        public Delimiter(String kind, DFADelimiter value) {
            this.kind = kind;
            this.value = value;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Delimiter)) return false;
            Delimiter delimiter = (Delimiter)object;
            String string = this.kind();
            String string2 = delimiter.kind();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            DFADelimiter dFADelimiter = this.value();
            DFADelimiter dFADelimiter2 = delimiter.value();
            if (dFADelimiter == null) {
                if (dFADelimiter2 != null) {
                    return false;
                }
            } else if (!dFADelimiter.equals(dFADelimiter2)) return false;
            if (!delimiter.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Delimiter;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Delimiter";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "kind";
            }
            if (1 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String kind() {
            return this.kind;
        }

        public DFADelimiter value() {
            return this.value;
        }

        public Delimiter copy(String kind, DFADelimiter value) {
            return new Delimiter(kind, value);
        }

        public String copy$default$1() {
            return this.kind();
        }

        public DFADelimiter copy$default$2() {
            return this.value();
        }

        public String _1() {
            return this.kind();
        }

        public DFADelimiter _2() {
            return this.value();
        }
    }

    public static class Delivery {
        private final Next<DAPodil.Frame.Id> frameIds;
        private final Next<DAPodil.VariablesReference> variableRefs;
        private final Channel<IO, DAPodil.Data> data;
        private final Channel<IO, Events.DebugEvent> dapEvents;

        public static IO<Delivery> to(Channel<IO, DAPodil.Data> channel, Channel<IO, Events.DebugEvent> channel2) {
            return Parse$Delivery$.MODULE$.to(channel, channel2);
        }

        public Delivery(Next<DAPodil.Frame.Id> frameIds, Next<DAPodil.VariablesReference> variableRefs, Channel<IO, DAPodil.Data> data, Channel<IO, Events.DebugEvent> dapEvents) {
            this.frameIds = frameIds;
            this.variableRefs = variableRefs;
            this.data = data;
            this.dapEvents = dapEvents;
        }

        public Stream<IO, Nothing$> deliver(Stream<IO, Event> events) {
            return events.evalScan((Object)Parse$Delivery$State$.MODULE$.empty(), (Function2 & Serializable)(x$12, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$12, x$2);
                if (tuple2 != null) {
                    State state = (State)tuple2._1();
                    Event event = (Event)tuple2._2();
                    State state2 = state;
                    if (event instanceof Event.Init) {
                        Event.Init init = Parse$Event$Init$.MODULE$.unapply((Event.Init)event);
                        StateForDebugger stateForDebugger = init._1();
                        return IO$.MODULE$.pure((Object)state2.copy(DAPodil$Data$.MODULE$.empty(), state2.copy$default$2(), state2.copy$default$3()));
                    }
                    State state3 = state;
                    if (event instanceof Event.StartElement) {
                        Event.StartElement e = (Event.StartElement)event;
                        return this.createFrame(e).map(arg_0 -> Parse$.org$apache$daffodil$debugger$dap$Parse$Delivery$$_$deliver$$anonfun$1$$anonfun$1(state3, e, arg_0)).flatMap((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                DAPodil.Frame frame = (DAPodil.Frame)tuple2._1();
                                State newState = (State)tuple2._2();
                                return ((IO)this.data.send((Object)newState.data())).map(arg_0 -> Parse$.org$apache$daffodil$debugger$dap$Parse$Delivery$$_$deliver$$anonfun$1$$anonfun$2$$anonfun$1(newState, arg_0));
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    }
                    State state4 = state;
                    if (event instanceof Event.EndElement) {
                        Event.EndElement endElement = Parse$Event$EndElement$.MODULE$.unapply((Event.EndElement)event);
                        StateForDebugger stateForDebugger = endElement._1();
                        return IO$.MODULE$.pure((Object)state4.copy(state4.data().pop(), state4.copy$default$2(), state4.copy$default$3()));
                    }
                    State state5 = state;
                    if (event == Parse$Event$Fini$.MODULE$) {
                        return IO$.MODULE$.pure((Object)state5);
                    }
                    State state6 = state;
                    if (event instanceof Event.Control) {
                        Event.Control control = Parse$Event$Control$.MODULE$.unapply((Event.Control)event);
                        DAPodil.Debugee.State state7 = control._1();
                        if (state7 instanceof DAPodil.Debugee.State.Stopped) {
                            Events.StoppedEvent stoppedEvent;
                            DAPodil.Debugee.State.Stopped stopped = DAPodil$Debugee$State$Stopped$.MODULE$.unapply((DAPodil.Debugee.State.Stopped)state7);
                            DAPodil.Debugee.State.Stopped.Reason reason = stopped._1();
                            DAPodil.Debugee.State.Stopped.Reason reason2 = reason;
                            DAPodil.Debugee.State.Stopped.Reason reason3 = reason2;
                            if (DAPodil$Debugee$State$Stopped$Reason$Entry$.MODULE$.equals(reason3)) {
                                stoppedEvent = new Events.StoppedEvent("entry", 1L);
                            } else if (DAPodil$Debugee$State$Stopped$Reason$Pause$.MODULE$.equals(reason3)) {
                                stoppedEvent = new Events.StoppedEvent("pause", 1L);
                            } else if (DAPodil$Debugee$State$Stopped$Reason$StepOver$.MODULE$.equals(reason3)) {
                                stoppedEvent = new Events.StoppedEvent("stepOver", 1L);
                            } else if (DAPodil$Debugee$State$Stopped$Reason$StepIn$.MODULE$.equals(reason3)) {
                                stoppedEvent = new Events.StoppedEvent("stepIn", 1L);
                            } else if (DAPodil$Debugee$State$Stopped$Reason$StepOut$.MODULE$.equals(reason3)) {
                                stoppedEvent = new Events.StoppedEvent("stepOut", 1L);
                            } else if (reason3 instanceof DAPodil.Debugee.State.Stopped.Reason.BreakpointHit) {
                                DAPodil.Location location;
                                DAPodil.Debugee.State.Stopped.Reason.BreakpointHit breakpointHit = DAPodil$Debugee$State$Stopped$Reason$BreakpointHit$.MODULE$.unapply((DAPodil.Debugee.State.Stopped.Reason.BreakpointHit)reason3);
                                DAPodil.Location location2 = location = breakpointHit._1();
                                stoppedEvent = new Events.StoppedEvent("breakpoint", 1L, false, Show.ShowInterpolator$.MODULE$.show$extension(package.all$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Breakpoint hit at ", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)location2, DAPodil$Location$.MODULE$.show()))})), null);
                            } else {
                                throw new MatchError((Object)reason3);
                            }
                            List events = (List)((IterableOps)new .colon.colon((Object)stoppedEvent, (List)new .colon.colon((Object)Parse$DataEvent$.MODULE$.apply(state6.bytePos1b()), (List)Nil$.MODULE$))).$plus$plus((IterableOnce)state6.infoset().toList());
                            return ((IO)package.all$.MODULE$.toTraverseOps((Object)events, UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse((Function1 & Serializable)a -> (IO)this.dapEvents.send(a), (Applicative)IO$.MODULE$.asyncForIO())).as((Object)state6);
                        }
                        State state8 = state;
                        if (DAPodil$Debugee$State$Running$.MODULE$.equals(state7)) {
                            return IO$.MODULE$.pure((Object)state8);
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }).drain();
        }

        public IO<DAPodil.Frame> createFrame(Event.StartElement startElement) {
            return ((IO)package.all$.MODULE$.catsSyntaxTuple4Semigroupal(Tuple4$.MODULE$.apply(this.frameIds.next(), this.variableRefs.next(), this.variableRefs.next(), this.variableRefs.next())).tupled((Invariant)IO$.MODULE$.asyncForIO(), (Semigroupal)IO$.MODULE$.asyncForIO())).map(arg_0 -> Parse$.org$apache$daffodil$debugger$dap$Parse$Delivery$$_$createFrame$$anonfun$1(startElement, arg_0)).flatMap((Function1 & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 != null) {
                    Tuple4 tuple4 = (Tuple4)tuple3._2();
                    Tuple4 ids = (Tuple4)tuple3._1();
                    if (tuple4 != null) {
                        int frameId = tuple4._1() == null ? BoxesRunTime.unboxToInt(null) : ((DAPodil.Frame.Id)tuple4._1()).value();
                        int parseScopeId = tuple4._2() == null ? BoxesRunTime.unboxToInt(null) : ((DAPodil.VariablesReference)tuple4._2()).value();
                        int schemaScopeId = tuple4._3() == null ? BoxesRunTime.unboxToInt(null) : ((DAPodil.VariablesReference)tuple4._3()).value();
                        int dataScopeId = tuple4._4() == null ? BoxesRunTime.unboxToInt(null) : ((DAPodil.VariablesReference)tuple4._4()).value();
                        Types.StackFrame stackFrame = (Types.StackFrame)tuple3._3();
                        return this.schemaScope(schemaScopeId, startElement.state()).flatMap((Function1 & Serializable)schemaScope -> this.parseScope(parseScopeId, startElement).map((Function1 & Serializable)parseScope -> DAPodil$Frame$.MODULE$.apply(frameId, stackFrame, (List<DAPodil.Frame.Scope>)((List)new .colon.colon(parseScope, (List)new .colon.colon(schemaScope, (List)new .colon.colon((Object)this.dataScope(dataScopeId, startElement.state()), (List)Nil$.MODULE$)))))));
                    }
                }
                throw new MatchError((Object)tuple3);
            });
        }

        public IO<DAPodil.Frame.Scope> parseScope(int ref, Event.StartElement event) {
            return (IO)package.all$.MODULE$.catsSyntaxTuple5Semigroupal(Tuple5$.MODULE$.apply(this.variableRefs.next(), this.variableRefs.next(), this.variableRefs.next(), this.variableRefs.next(), this.variableRefs.next())).mapN((arg_0, arg_1, arg_2, arg_3, arg_4) -> Parse$.org$apache$daffodil$debugger$dap$Parse$Delivery$$_$parseScope$$anonfun$adapted$1(event, ref, arg_0, arg_1, arg_2, arg_3, arg_4), (Functor)IO$.MODULE$.asyncForIO(), (Semigroupal)IO$.MODULE$.asyncForIO());
        }

        public IO<DAPodil.Frame.Scope> schemaScope(int scopeRef, StateForDebugger state) {
            return ((IO)package.all$.MODULE$.toTraverseOps((Object)state.variableMapForDebugger().qnames().toList().groupBy(Parse$::org$apache$daffodil$debugger$dap$Parse$Delivery$$_$schemaScope$$anonfun$1).toList(), UnorderedFoldable$.MODULE$.catsTraverseForList()).flatTraverse((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    NS ns = (NS)tuple2._1();
                    List vs = (List)tuple2._2();
                    return this.variableRefs.next().map(arg_0 -> Parse$.org$apache$daffodil$debugger$dap$Parse$Delivery$$_$schemaScope$$anonfun$2$$anonfun$adapted$1(scopeRef, ns, vs, state, arg_0));
                }
                throw new MatchError((Object)tuple2);
            }, (Applicative)IO$.MODULE$.asyncForIO(), (FlatMap)Invariant$.MODULE$.catsInstancesForList())).map(arg_0 -> Parse$.org$apache$daffodil$debugger$dap$Parse$Delivery$$_$schemaScope$$anonfun$3(scopeRef, arg_0));
        }

        public DAPodil.Frame.Scope dataScope(int ref, StateForDebugger state) {
            long bytePos1b = state.currentLocation().bytePos1b();
            List dataVariables = (List)new .colon.colon((Object)new Types.Variable("bytePos1b", BoxesRunTime.boxToLong((long)bytePos1b).toString(), "number", 0, null), (List)Nil$.MODULE$);
            Object[] objectArray = new Tuple2[1];
            DAPodil.VariablesReference variablesReference = (DAPodil.VariablesReference)Predef$.MODULE$.ArrowAssoc((Object)new DAPodil.VariablesReference(ref));
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)variablesReference, (Object)dataVariables);
            return DAPodil$Frame$Scope$.MODULE$.apply("Data", ref, (Map<DAPodil.VariablesReference, List<Types.Variable>>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
        }

        public static class State
        implements Product,
        Serializable {
            private final DAPodil.Data data;
            private final long bytePos1b;
            private final Option infoset;

            public static State apply(DAPodil.Data data, long l, Option<InfosetEvent> option) {
                return Parse$Delivery$State$.MODULE$.apply(data, l, option);
            }

            public static State empty() {
                return Parse$Delivery$State$.MODULE$.empty();
            }

            public static State fromProduct(Product product) {
                return Parse$Delivery$State$.MODULE$.fromProduct(product);
            }

            public static State unapply(State state) {
                return Parse$Delivery$State$.MODULE$.unapply(state);
            }

            public State(DAPodil.Data data, long bytePos1b, Option<InfosetEvent> infoset) {
                this.data = data;
                this.bytePos1b = bytePos1b;
                this.infoset = infoset;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.data()));
                n = Statics.mix((int)n, (int)Statics.longHash((long)this.bytePos1b()));
                n = Statics.mix((int)n, (int)Statics.anyHash(this.infoset()));
                return Statics.finalizeHash((int)n, (int)3);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof State)) return false;
                State state = (State)object;
                if (this.bytePos1b() != state.bytePos1b()) return false;
                DAPodil.Data data = this.data();
                DAPodil.Data data2 = state.data();
                if (data == null) {
                    if (data2 != null) {
                        return false;
                    }
                } else if (!((Object)data).equals(data2)) return false;
                Option<InfosetEvent> option = this.infoset();
                Option<InfosetEvent> option2 = state.infoset();
                if (option == null) {
                    if (option2 != null) {
                        return false;
                    }
                } else if (!option.equals(option2)) return false;
                if (!state.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof State;
            }

            public int productArity() {
                return 3;
            }

            public String productPrefix() {
                return "State";
            }

            public Object productElement(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return this._1();
                    }
                    case 1: {
                        return BoxesRunTime.boxToLong((long)this._2());
                    }
                    case 2: {
                        return this._3();
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return "data";
                    }
                    case 1: {
                        return "bytePos1b";
                    }
                    case 2: {
                        return "infoset";
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public DAPodil.Data data() {
                return this.data;
            }

            public long bytePos1b() {
                return this.bytePos1b;
            }

            public Option<InfosetEvent> infoset() {
                return this.infoset;
            }

            public State copy(DAPodil.Data data, long bytePos1b, Option<InfosetEvent> infoset) {
                return new State(data, bytePos1b, infoset);
            }

            public DAPodil.Data copy$default$1() {
                return this.data();
            }

            public long copy$default$2() {
                return this.bytePos1b();
            }

            public Option<InfosetEvent> copy$default$3() {
                return this.infoset();
            }

            public DAPodil.Data _1() {
                return this.data();
            }

            public long _2() {
                return this.bytePos1b();
            }

            public Option<InfosetEvent> _3() {
                return this.infoset();
            }
        }
    }

    public static final class ElementName
    implements Product,
    Serializable {
        private final String value;

        public static String apply(String string) {
            return Parse$ElementName$.MODULE$.apply(string);
        }

        public static String unapply(String string) {
            return Parse$ElementName$.MODULE$.unapply(string);
        }

        public static String _1$extension(String string) {
            return Parse$ElementName$.MODULE$._1$extension(string);
        }

        public static boolean canEqual$extension(String string, Object object) {
            return Parse$ElementName$.MODULE$.canEqual$extension(string, object);
        }

        public static String copy$extension(String string, String string2) {
            return Parse$ElementName$.MODULE$.copy$extension(string, string2);
        }

        public static boolean equals$extension(String string, Object object) {
            return Parse$ElementName$.MODULE$.equals$extension(string, object);
        }

        public static int hashCode$extension(String string) {
            return Parse$ElementName$.MODULE$.hashCode$extension(string);
        }

        public static int productArity$extension(String string) {
            return Parse$ElementName$.MODULE$.productArity$extension(string);
        }

        public static Object productElement$extension(String string, int n) {
            return Parse$ElementName$.MODULE$.productElement$extension(string, n);
        }

        public static String productElementName$extension(String string, int n) {
            return Parse$ElementName$.MODULE$.productElementName$extension(string, n);
        }

        public static String productPrefix$extension(String string) {
            return Parse$ElementName$.MODULE$.productPrefix$extension(string);
        }

        public static String toString$extension(String string) {
            return Parse$ElementName$.MODULE$.toString$extension(string);
        }

        public static String copy$default$1$extension(String string) {
            return Parse$ElementName$.MODULE$.copy$default$1$extension(string);
        }

        public ElementName(String value) {
            this.value = value;
        }

        public int hashCode() {
            return Parse$ElementName$.MODULE$.hashCode$extension(this.value());
        }

        public boolean equals(Object x$0) {
            return Parse$ElementName$.MODULE$.equals$extension(this.value(), x$0);
        }

        public String toString() {
            return Parse$ElementName$.MODULE$.toString$extension(this.value());
        }

        public boolean canEqual(Object that) {
            return Parse$ElementName$.MODULE$.canEqual$extension(this.value(), that);
        }

        public int productArity() {
            return Parse$ElementName$.MODULE$.productArity$extension(this.value());
        }

        public String productPrefix() {
            return Parse$ElementName$.MODULE$.productPrefix$extension(this.value());
        }

        public Object productElement(int n) {
            return Parse$ElementName$.MODULE$.productElement$extension(this.value(), n);
        }

        public String productElementName(int n) {
            return Parse$ElementName$.MODULE$.productElementName$extension(this.value(), n);
        }

        public String value() {
            return this.value;
        }

        public String copy(String value) {
            return Parse$ElementName$.MODULE$.copy$extension(this.value(), value);
        }

        public String copy$default$1() {
            return Parse$ElementName$.MODULE$.copy$default$1$extension(this.value());
        }

        public String _1() {
            return Parse$ElementName$.MODULE$._1$extension(this.value());
        }
    }

    public static interface Event {
        public static int ordinal(Event event) {
            return Parse$Event$.MODULE$.ordinal(event);
        }

        public static Show<Event> show() {
            return Parse$Event$.MODULE$.show();
        }
    }

    public static class Exception
    extends RuntimeException
    implements Product {
        private final List diagnostics;

        public static Exception apply(List<Diagnostic> list) {
            return Parse$Exception$.MODULE$.apply(list);
        }

        public static Exception fromProduct(Product product) {
            return Parse$Exception$.MODULE$.fromProduct(product);
        }

        public static Exception unapply(Exception exception) {
            return Parse$Exception$.MODULE$.unapply(exception);
        }

        public Exception(List<Diagnostic> diagnostics) {
            this.diagnostics = diagnostics;
            super(Parse$.MODULE$.org$apache$daffodil$debugger$dap$Parse$$$Exception$superArg$1(diagnostics));
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Exception)) return false;
            Exception exception = (Exception)object;
            List<Diagnostic> list = this.diagnostics();
            List<Diagnostic> list2 = exception.diagnostics();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            if (!exception.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Exception;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Exception";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "diagnostics";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<Diagnostic> diagnostics() {
            return this.diagnostics;
        }

        public Exception copy(List<Diagnostic> diagnostics) {
            return new Exception(diagnostics);
        }

        public List<Diagnostic> copy$default$1() {
            return this.diagnostics();
        }

        public List<Diagnostic> _1() {
            return this.diagnostics();
        }
    }

    public static class InfosetEvent
    extends Events.DebugEvent
    implements Product,
    Serializable {
        private final String content;
        private final String mimeType;

        public static InfosetEvent apply(String string, DIElement dIElement) {
            return Parse$InfosetEvent$.MODULE$.apply(string, dIElement);
        }

        public static InfosetEvent apply(String string, String string2) {
            return Parse$InfosetEvent$.MODULE$.apply(string, string2);
        }

        public static InfosetEvent fromProduct(Product product) {
            return Parse$InfosetEvent$.MODULE$.fromProduct(product);
        }

        public static InfosetEvent unapply(InfosetEvent infosetEvent) {
            return Parse$InfosetEvent$.MODULE$.unapply(infosetEvent);
        }

        public InfosetEvent(String content, String mimeType) {
            this.content = content;
            this.mimeType = mimeType;
            super("daffodil.infoset");
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof InfosetEvent)) return false;
            InfosetEvent infosetEvent = (InfosetEvent)object;
            String string = this.content();
            String string2 = infosetEvent.content();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.mimeType();
            String string4 = infosetEvent.mimeType();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!infosetEvent.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof InfosetEvent;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "InfosetEvent";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "content";
            }
            if (1 == n2) {
                return "mimeType";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String content() {
            return this.content;
        }

        public String mimeType() {
            return this.mimeType;
        }

        public InfosetEvent copy(String content, String mimeType) {
            return new InfosetEvent(content, mimeType);
        }

        public String copy$default$1() {
            return this.content();
        }

        public String copy$default$2() {
            return this.mimeType();
        }

        public String _1() {
            return this.content();
        }

        public String _2() {
            return this.mimeType();
        }
    }

    public static class PointOfUncertainty
    implements Product,
    Serializable {
        private final Option bitPosition;
        private final SchemaFileLocation location;
        private final String name;
        private final String context;

        public static PointOfUncertainty apply(Option<Object> option, SchemaFileLocation schemaFileLocation, String string, String string2) {
            return Parse$PointOfUncertainty$.MODULE$.apply(option, schemaFileLocation, string, string2);
        }

        public static PointOfUncertainty fromProduct(Product product) {
            return Parse$PointOfUncertainty$.MODULE$.fromProduct(product);
        }

        public static PointOfUncertainty unapply(PointOfUncertainty pointOfUncertainty) {
            return Parse$PointOfUncertainty$.MODULE$.unapply(pointOfUncertainty);
        }

        public PointOfUncertainty(Option<Object> bitPosition, SchemaFileLocation location, String name, String context) {
            this.bitPosition = bitPosition;
            this.location = location;
            this.name = name;
            this.context = context;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PointOfUncertainty)) return false;
            PointOfUncertainty pointOfUncertainty = (PointOfUncertainty)object;
            Option<Object> option = this.bitPosition();
            Option<Object> option2 = pointOfUncertainty.bitPosition();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            SchemaFileLocation schemaFileLocation = this.location();
            SchemaFileLocation schemaFileLocation2 = pointOfUncertainty.location();
            if (schemaFileLocation == null) {
                if (schemaFileLocation2 != null) {
                    return false;
                }
            } else if (!schemaFileLocation.equals(schemaFileLocation2)) return false;
            String string = this.name();
            String string2 = pointOfUncertainty.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.context();
            String string4 = pointOfUncertainty.context();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!pointOfUncertainty.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PointOfUncertainty;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "PointOfUncertainty";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return new ElementName(this._3());
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "bitPosition";
                }
                case 1: {
                    return "location";
                }
                case 2: {
                    return "name";
                }
                case 3: {
                    return "context";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<Object> bitPosition() {
            return this.bitPosition;
        }

        public SchemaFileLocation location() {
            return this.location;
        }

        public String name() {
            return this.name;
        }

        public String context() {
            return this.context;
        }

        public PointOfUncertainty copy(Option<Object> bitPosition, SchemaFileLocation location, String name, String context) {
            return new PointOfUncertainty(bitPosition, location, name, context);
        }

        public Option<Object> copy$default$1() {
            return this.bitPosition();
        }

        public SchemaFileLocation copy$default$2() {
            return this.location();
        }

        public String copy$default$3() {
            return this.name();
        }

        public String copy$default$4() {
            return this.context();
        }

        public Option<Object> _1() {
            return this.bitPosition();
        }

        public SchemaFileLocation _2() {
            return this.location();
        }

        public String _3() {
            return this.name();
        }

        public String _4() {
            return this.context();
        }
    }
}

