/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.debugger.dap;

import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.apache.daffodil.io.DataDumper;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class DataLeftOverUtils$
implements Serializable {
    public static final DataLeftOverUtils$ MODULE$ = new DataLeftOverUtils$();

    private DataLeftOverUtils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DataLeftOverUtils$.class);
    }

    public String getMessage(Path dataFilePath, long bitPos1b, long bytePos1b, long leftOverBits) {
        Object object;
        String dumpString;
        String leftOverBitsText = "Left over data. Consumed " + (bitPos1b - 1L) + " bit(s), with at least " + leftOverBits + " bit(s) remaining.\n";
        DataDumper Dump = new DataDumper();
        int numBytes = (int)package$.MODULE$.min(8L, leftOverBits / 8L);
        RandomAccessFile f = new RandomAccessFile(dataFilePath.toFile(), "r");
        byte[] bytes = new byte[numBytes];
        f.seek(bytePos1b - 1L);
        f.readFully(bytes);
        f.close();
        if (bytes.length > 0) {
            DataDumper.TextOnly textOnly = Dump.TextOnly().apply((Option)Some$.MODULE$.apply((Object)"utf-8"));
            int n = bytes.length * 8;
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            int n2 = Dump.dump$default$5();
            Option option = Dump.dump$default$7();
            v0 = Dump.dump((DataDumper.Kind)textOnly, 0L, n, byteBuffer, n2, false, option).mkString("\n");
        } else {
            v0 = dumpString = "";
        }
        if (bytes.length > 0) {
            Object object2 = Predef$.MODULE$.byteArrayOps(bytes);
            object = "Left over data (Hex) starting at byte " + bytePos1b + " is: (0x" + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)a -> StringOps$.MODULE$.format$extension("%02x", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)a))})), ClassTag$.MODULE$.apply(String.class))).mkString() + "...)\n";
        } else {
            object = "";
        }
        String dataHex = object;
        String dataText = bytes.length > 0 ? "Left over data (UTF-8) starting at byte " + bytePos1b + " is: (" + dumpString + "...)" : "";
        return leftOverBitsText + dataHex + dataText;
    }
}

