/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.IOUtils;
import org.apache.daffodil.lib.api.DaffodilSchemaSource;
import org.apache.daffodil.lib.api.URISchemaSource;
import org.apache.daffodil.lib.api.URISchemaSource$;
import org.apache.daffodil.lib.calendar.DFDLDate;
import org.apache.daffodil.lib.calendar.DFDLDateConversion$;
import org.apache.daffodil.lib.calendar.DFDLDateTime;
import org.apache.daffodil.lib.calendar.DFDLDateTimeConversion$;
import org.apache.daffodil.lib.calendar.DFDLTime;
import org.apache.daffodil.lib.calendar.DFDLTimeConversion$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.lib.xml.NS;
import org.apache.daffodil.lib.xml.NS$;
import org.apache.daffodil.lib.xml.PrettyPrinter;
import org.apache.daffodil.lib.xml.RemapPUAToXMLIllegalChar;
import org.apache.daffodil.lib.xml.RemapXMLIllegalCharToPUA;
import org.apache.daffodil.lib.xml.XMLUtils;
import org.xml.sax.XMLReader;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;
import scala.xml.Atom;
import scala.xml.Comment;
import scala.xml.Elem;
import scala.xml.Elem$;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PrefixedAttribute;
import scala.xml.PrefixedAttribute$;
import scala.xml.ProcInstr;
import scala.xml.Text;
import scala.xml.Text$;
import scala.xml.TopScope$;
import scala.xml.Unparsed;
import scala.xml.Utility$;

public final class XMLUtils$ {
    public static final XMLUtils$ MODULE$ = new XMLUtils$();
    private static URI schemaForDFDLSchemas;
    private static URI dafextURI;
    private static URI tdmlURI;
    private static final PrefixedAttribute xmlNilAttribute;
    private static final String PositiveInfinityString;
    private static final String NegativeInfinityString;
    private static final String NaNString;
    private static final RemapXMLIllegalCharToPUA remapXMLToPUA;
    private static final RemapPUAToXMLIllegalChar remapPUAToXML;
    private static final NS XSD_NAMESPACE;
    private static final NS XSI_NAMESPACE;
    private static final NS XPATH_FUNCTION_NAMESPACE;
    private static final NS XPATH_MATH_NAMESPACE;
    private static final NS DFDL_NAMESPACE;
    private static final NS DFDLX_NAMESPACE;
    private static final NS TDML_NAMESPACE;
    private static final NS EXAMPLE_NAMESPACE;
    private static final NS XHTML_NAMESPACE;
    private static final String DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA;
    private static final NS DAFFODIL_EXTENSION_NAMESPACE_NCSA;
    private static final String EXT_PREFIX_NCSA;
    private static final NS EXT_NS_NCSA;
    private static final String DAFFODIL_NAMESPACE_ROOT_APACHE;
    private static final NS DAFFODIL_EXTENSION_NAMESPACE_APACHE;
    private static final String EXT_PREFIX_APACHE;
    private static final NS EXT_NS_APACHE;
    private static final NS DAFFODIL_INTERNAL_NAMESPACE;
    private static final String INT_PREFIX;
    private static final NS INT_NS;
    private static final String DAFFODIL_SAX_URN_ROOT;
    private static final String DAFFODIL_SAX_URN_PARSERESULT;
    private static final String DAFFODIL_SAX_URN_BLOBDIRECTORY;
    private static final String DAFFODIL_SAX_URN_BLOBPREFIX;
    private static final String DAFFODIL_SAX_URN_BLOBSUFFIX;
    private static final String SAX_NAMESPACES_FEATURE;
    private static final String SAX_NAMESPACE_PREFIXES_FEATURE;
    private static final String XML_DISALLOW_DOCTYPE_FEATURE;
    private static final String XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE;
    private static final String XML_EXTERNAL_GENERAL_ENTITIES_FEATURE;
    private static final String XML_LOAD_EXTERNAL_DTD_FEATURE;
    private static final String FILE_ATTRIBUTE_NAME;
    private static final String LINE_ATTRIBUTE_NAME;
    private static final String COLUMN_ATTRIBUTE_NAME;
    private static final NS xsdURI;
    private static final NS dfdlURI;
    private static final NS dfdlxURI;
    private static final NS dfdlAppinfoSource;
    private static final NS targetNS;
    private static final NS xsiURI;
    private static final NS fnURI;
    private static final NS mathURI;
    private static final NS dafintURI;
    private static final List<String> DFDL_SIMPLE_BUILT_IN_TYPES;
    private static final RemapXMLIllegalCharToPUA xmlRemapperPreservingCR;
    private static final Regex xmlEntityPattern;
    private static volatile byte bitmap$0;

    static {
        xmlNilAttribute = new PrefixedAttribute("xsi", "nil", "true", (MetaData)Null$.MODULE$);
        PositiveInfinityString = "INF";
        NegativeInfinityString = "-INF";
        NaNString = "NaN";
        remapXMLToPUA = new RemapXMLIllegalCharToPUA(false, true);
        remapPUAToXML = new RemapPUAToXMLIllegalChar();
        XSD_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2001/XMLSchema");
        XSI_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2001/XMLSchema-instance");
        XPATH_FUNCTION_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2005/xpath-functions");
        XPATH_MATH_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2005/xpath-functions/math");
        DFDL_NAMESPACE = NS$.MODULE$.apply("http://www.ogf.org/dfdl/dfdl-1.0/");
        DFDLX_NAMESPACE = NS$.MODULE$.apply("http://www.ogf.org/dfdl/dfdl-1.0/extensions");
        TDML_NAMESPACE = NS$.MODULE$.apply("http://www.ibm.com/xmlns/dfdl/testData");
        EXAMPLE_NAMESPACE = NS$.MODULE$.apply("http://example.com");
        XHTML_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/1999/xhtml");
        DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA = "urn:ogf:dfdl:2013:imp:opensource.ncsa.illinois.edu:2012";
        DAFFODIL_EXTENSION_NAMESPACE_NCSA = NS$.MODULE$.apply(new java.lang.StringBuilder(4).append(MODULE$.DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA()).append(":ext").toString());
        EXT_PREFIX_NCSA = "daf";
        EXT_NS_NCSA = NS$.MODULE$.apply(MODULE$.DAFFODIL_EXTENSION_NAMESPACE_NCSA().uri());
        DAFFODIL_NAMESPACE_ROOT_APACHE = "urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018";
        DAFFODIL_EXTENSION_NAMESPACE_APACHE = NS$.MODULE$.apply(new java.lang.StringBuilder(4).append(MODULE$.DAFFODIL_NAMESPACE_ROOT_APACHE()).append(":ext").toString());
        EXT_PREFIX_APACHE = "daf";
        EXT_NS_APACHE = NS$.MODULE$.apply(MODULE$.DAFFODIL_EXTENSION_NAMESPACE_APACHE().uri());
        DAFFODIL_INTERNAL_NAMESPACE = NS$.MODULE$.apply(new java.lang.StringBuilder(4).append(MODULE$.DAFFODIL_NAMESPACE_ROOT_APACHE()).append(":int").toString());
        INT_PREFIX = "dafint";
        INT_NS = NS$.MODULE$.apply(MODULE$.DAFFODIL_INTERNAL_NAMESPACE().uri());
        DAFFODIL_SAX_URN_ROOT = new java.lang.StringBuilder(4).append(MODULE$.DAFFODIL_NAMESPACE_ROOT_APACHE()).append(":sax").toString();
        DAFFODIL_SAX_URN_PARSERESULT = new java.lang.StringBuilder(12).append(MODULE$.DAFFODIL_SAX_URN_ROOT()).append(":ParseResult").toString();
        DAFFODIL_SAX_URN_BLOBDIRECTORY = new java.lang.StringBuilder(14).append(MODULE$.DAFFODIL_SAX_URN_ROOT()).append(":BlobDirectory").toString();
        DAFFODIL_SAX_URN_BLOBPREFIX = new java.lang.StringBuilder(11).append(MODULE$.DAFFODIL_SAX_URN_ROOT()).append(":BlobPrefix").toString();
        DAFFODIL_SAX_URN_BLOBSUFFIX = new java.lang.StringBuilder(11).append(MODULE$.DAFFODIL_SAX_URN_ROOT()).append(":BlobSuffix").toString();
        SAX_NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
        SAX_NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
        XML_DISALLOW_DOCTYPE_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
        XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE = "http://xml.org/sax/features/external-parameter-entities";
        XML_EXTERNAL_GENERAL_ENTITIES_FEATURE = "http://xml.org/sax/features/external-general-entities";
        XML_LOAD_EXTERNAL_DTD_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
        FILE_ATTRIBUTE_NAME = "file";
        LINE_ATTRIBUTE_NAME = "line";
        COLUMN_ATTRIBUTE_NAME = "col";
        xsdURI = MODULE$.XSD_NAMESPACE();
        dfdlURI = MODULE$.DFDL_NAMESPACE();
        dfdlxURI = MODULE$.DFDLX_NAMESPACE();
        dfdlAppinfoSource = NS$.MODULE$.apply("http://www.ogf.org/dfdl/");
        targetNS = MODULE$.EXAMPLE_NAMESPACE();
        xsiURI = MODULE$.XSI_NAMESPACE();
        fnURI = MODULE$.XPATH_FUNCTION_NAMESPACE();
        mathURI = MODULE$.XPATH_MATH_NAMESPACE();
        dafintURI = MODULE$.DAFFODIL_INTERNAL_NAMESPACE();
        DFDL_SIMPLE_BUILT_IN_TYPES = (List)scala.package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"string", "float", "double", "decimal", "integer", "long", "int", "short", "byte", "unsignedLong", "unsignedInt", "nonNegativeInteger", "unsignedShort", "unsignedByte", "boolean", "date", "time", "dateTime", "hexBinary"}));
        xmlRemapperPreservingCR = new RemapXMLIllegalCharToPUA(false, false);
        xmlEntityPattern = new Regex("&(quot|amp|apos|lt|gt);", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"entity"}));
    }

    private URI schemaForDFDLSchemas$lzycompute() {
        XMLUtils$ xMLUtils$ = this;
        synchronized (xMLUtils$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                schemaForDFDLSchemas = Misc$.MODULE$.getRequiredResource("org/apache/daffodil/xsd/XMLSchema_for_DFDL.xsd");
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return schemaForDFDLSchemas;
    }

    public URI schemaForDFDLSchemas() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.schemaForDFDLSchemas$lzycompute();
        }
        return schemaForDFDLSchemas;
    }

    private URI dafextURI$lzycompute() {
        XMLUtils$ xMLUtils$ = this;
        synchronized (xMLUtils$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                dafextURI = Misc$.MODULE$.getRequiredResource("org/apache/daffodil/xsd/dafext.xsd");
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return dafextURI;
    }

    public URI dafextURI() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.dafextURI$lzycompute();
        }
        return dafextURI;
    }

    private URI tdmlURI$lzycompute() {
        XMLUtils$ xMLUtils$ = this;
        synchronized (xMLUtils$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                tdmlURI = Misc$.MODULE$.getRequiredResource("org/apache/daffodil/xsd/tdml.xsd");
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return tdmlURI;
    }

    public URI tdmlURI() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.tdmlURI$lzycompute();
        }
        return tdmlURI;
    }

    public PrefixedAttribute xmlNilAttribute() {
        return xmlNilAttribute;
    }

    public String PositiveInfinityString() {
        return PositiveInfinityString;
    }

    public String NegativeInfinityString() {
        return NegativeInfinityString;
    }

    public String NaNString() {
        return NaNString;
    }

    public float strToFloat(String s) {
        String string = s;
        String string2 = this.PositiveInfinityString();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return Float.POSITIVE_INFINITY;
        }
        String string4 = this.NegativeInfinityString();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return Float.NEGATIVE_INFINITY;
        }
        String string6 = this.NaNString();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return Float.NaN;
        }
        return StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(s));
    }

    public double strToDouble(String s) {
        String string = s;
        String string2 = this.PositiveInfinityString();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return Double.POSITIVE_INFINITY;
        }
        String string4 = this.NegativeInfinityString();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return Double.NEGATIVE_INFINITY;
        }
        String string6 = this.NaNString();
        String string7 = string;
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return Double.NaN;
        }
        return StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s));
    }

    public int uncodeLength(String s) {
        int res = s.getBytes("UTF-32BE").length / 4;
        return res;
    }

    public <T> scala.collection.immutable.Seq<T> walkUnicodeString(String str, Function3<Object, Object, Object, T> bodyFunc) {
        int len = str.length();
        if (len == 0) {
            return Nil$.MODULE$;
        }
        ListBuffer list = new ListBuffer();
        char prev = '\u0000';
        char curr = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), 0);
        char next = '\u0000';
        for (int pos = 0; pos < len; ++pos) {
            next = pos + 1 < len ? StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), pos + 1) : (char)'\u0000';
            list.$plus$eq(bodyFunc.apply((Object)BoxesRunTime.boxToCharacter((char)prev), (Object)BoxesRunTime.boxToCharacter((char)curr), (Object)BoxesRunTime.boxToCharacter((char)next)));
            prev = curr;
            curr = next;
        }
        return list.toSeq();
    }

    private RemapXMLIllegalCharToPUA remapXMLToPUA() {
        return remapXMLToPUA;
    }

    public String remapXMLIllegalCharactersToPUA(String s) {
        return this.remapXMLToPUA().remap(s);
    }

    private RemapPUAToXMLIllegalChar remapPUAToXML() {
        return remapPUAToXML;
    }

    public String remapPUAToXMLIllegalCharacters(String text) {
        return this.remapPUAToXML().remap(text);
    }

    public Node coalesceAllAdjacentTextNodes(Node node) {
        Option option;
        Node node2 = node;
        if (node2 != null && !(option = Elem$.MODULE$.unapplySeq(node2)).isEmpty()) {
            String prefix = (String)((Tuple5)option.get())._1();
            String label = (String)((Tuple5)option.get())._2();
            MetaData attribs = (MetaData)((Tuple5)option.get())._3();
            NamespaceBinding scope = (NamespaceBinding)((Tuple5)option.get())._4();
            scala.collection.immutable.Seq child = (scala.collection.immutable.Seq)((Tuple5)option.get())._5();
            scala.collection.immutable.Seq coalescedChildren = (scala.collection.immutable.Seq)child.map((Function1 & Serializable)x$1 -> MODULE$.coalesceAllAdjacentTextNodes((Node)x$1));
            scala.collection.immutable.Seq<Node> newChildren = this.coalesceAdjacentTextNodes((scala.collection.immutable.Seq<Node>)coalescedChildren);
            return Elem$.MODULE$.apply(prefix, label, attribs, scope, true, newChildren);
        }
        return node2;
    }

    public scala.collection.immutable.Seq<Node> coalesceAdjacentTextNodes(scala.collection.immutable.Seq<Node> seq) {
        if (seq.length() == 0) {
            return seq;
        }
        if (seq.length() == 1) {
            Node node = (Node)seq.apply(0);
            if (node instanceof Atom) {
                return seq;
            }
        }
        ArrayBuilder ab = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Node.class));
        boolean i = false;
        ObjectRef tn = ObjectRef.create(null);
        ObjectRef sb = ObjectRef.create(null);
        seq.foreach((Function1 & Serializable)current -> {
            if (current instanceof Text || current instanceof Unparsed) {
                if ((Node)tn$1.elem == null) {
                    if ((StringBuilder)sb$1.elem == null || ((StringBuilder)sb$1.elem).length() == 0) {
                        tn$1.elem = current;
                        return BoxedUnit.UNIT;
                    }
                    return ((StringBuilder)sb$1.elem).append(current.text());
                }
                if ((StringBuilder)sb$1.elem == null) {
                    sb$1.elem = new StringBuilder();
                }
                ((StringBuilder)sb$1.elem).append(((Node)tn$1.elem).text());
                ((StringBuilder)sb$1.elem).append(current.text());
                tn$1.elem = null;
                return BoxedUnit.UNIT;
            }
            XMLUtils$.processText$1(tn, sb, ab);
            return ab.$plus$eq(current);
        });
        XMLUtils$.processText$1(tn, sb, ab);
        return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ab.result()));
    }

    public NS XSD_NAMESPACE() {
        return XSD_NAMESPACE;
    }

    public NS XSI_NAMESPACE() {
        return XSI_NAMESPACE;
    }

    public NS XPATH_FUNCTION_NAMESPACE() {
        return XPATH_FUNCTION_NAMESPACE;
    }

    public NS XPATH_MATH_NAMESPACE() {
        return XPATH_MATH_NAMESPACE;
    }

    public NS DFDL_NAMESPACE() {
        return DFDL_NAMESPACE;
    }

    public NS DFDLX_NAMESPACE() {
        return DFDLX_NAMESPACE;
    }

    public NS TDML_NAMESPACE() {
        return TDML_NAMESPACE;
    }

    public NS EXAMPLE_NAMESPACE() {
        return EXAMPLE_NAMESPACE;
    }

    public NS XHTML_NAMESPACE() {
        return XHTML_NAMESPACE;
    }

    public Elem getXSDElement(NamespaceBinding scope) {
        String string;
        boolean isXSDTheDefaultNS;
        String xsdPre = scope.getPrefix(this.XSD_NAMESPACE().toString());
        String string2 = this.XSD_NAMESPACE().toString();
        String string3 = scope.getURI(null);
        boolean bl = !(string2 != null ? !string2.equals(string3) : string3 != null) ? true : (isXSDTheDefaultNS = false);
        if (xsdPre != null) {
            string = xsdPre;
        } else if (isXSDTheDefaultNS) {
            string = null;
        } else {
            throw Assert$.MODULE$.usageError("Scope argument must have a binding for the XSD namespace.");
        }
        String xsdPrefix = string;
        Elem res = Elem$.MODULE$.apply(xsdPrefix, "element", (MetaData)Null$.MODULE$, scope, true, (scala.collection.immutable.Seq)Nil$.MODULE$);
        return res;
    }

    private String DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA() {
        return DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA;
    }

    private NS DAFFODIL_EXTENSION_NAMESPACE_NCSA() {
        return DAFFODIL_EXTENSION_NAMESPACE_NCSA;
    }

    public String EXT_PREFIX_NCSA() {
        return EXT_PREFIX_NCSA;
    }

    public NS EXT_NS_NCSA() {
        return EXT_NS_NCSA;
    }

    private String DAFFODIL_NAMESPACE_ROOT_APACHE() {
        return DAFFODIL_NAMESPACE_ROOT_APACHE;
    }

    private NS DAFFODIL_EXTENSION_NAMESPACE_APACHE() {
        return DAFFODIL_EXTENSION_NAMESPACE_APACHE;
    }

    public String EXT_PREFIX_APACHE() {
        return EXT_PREFIX_APACHE;
    }

    public NS EXT_NS_APACHE() {
        return EXT_NS_APACHE;
    }

    private NS DAFFODIL_INTERNAL_NAMESPACE() {
        return DAFFODIL_INTERNAL_NAMESPACE;
    }

    public String INT_PREFIX() {
        return INT_PREFIX;
    }

    public NS INT_NS() {
        return INT_NS;
    }

    public String DAFFODIL_SAX_URN_ROOT() {
        return DAFFODIL_SAX_URN_ROOT;
    }

    public String DAFFODIL_SAX_URN_PARSERESULT() {
        return DAFFODIL_SAX_URN_PARSERESULT;
    }

    public String DAFFODIL_SAX_URN_BLOBDIRECTORY() {
        return DAFFODIL_SAX_URN_BLOBDIRECTORY;
    }

    public String DAFFODIL_SAX_URN_BLOBPREFIX() {
        return DAFFODIL_SAX_URN_BLOBPREFIX;
    }

    public String DAFFODIL_SAX_URN_BLOBSUFFIX() {
        return DAFFODIL_SAX_URN_BLOBSUFFIX;
    }

    public String SAX_NAMESPACES_FEATURE() {
        return SAX_NAMESPACES_FEATURE;
    }

    public String SAX_NAMESPACE_PREFIXES_FEATURE() {
        return SAX_NAMESPACE_PREFIXES_FEATURE;
    }

    public String XML_DISALLOW_DOCTYPE_FEATURE() {
        return XML_DISALLOW_DOCTYPE_FEATURE;
    }

    public String XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE() {
        return XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE;
    }

    public String XML_EXTERNAL_GENERAL_ENTITIES_FEATURE() {
        return XML_EXTERNAL_GENERAL_ENTITIES_FEATURE;
    }

    public String XML_LOAD_EXTERNAL_DTD_FEATURE() {
        return XML_LOAD_EXTERNAL_DTD_FEATURE;
    }

    public void setSecureDefaults(XMLReader xmlReader) {
        xmlReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        xmlReader.setFeature(this.XML_DISALLOW_DOCTYPE_FEATURE(), true);
        xmlReader.setFeature(this.XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE(), false);
        xmlReader.setFeature(this.XML_EXTERNAL_GENERAL_ENTITIES_FEATURE(), false);
    }

    public String FILE_ATTRIBUTE_NAME() {
        return FILE_ATTRIBUTE_NAME;
    }

    public String LINE_ATTRIBUTE_NAME() {
        return LINE_ATTRIBUTE_NAME;
    }

    public String COLUMN_ATTRIBUTE_NAME() {
        return COLUMN_ATTRIBUTE_NAME;
    }

    public NS xsdURI() {
        return xsdURI;
    }

    public NS dfdlURI() {
        return dfdlURI;
    }

    public NS dfdlxURI() {
        return dfdlxURI;
    }

    public NS dfdlAppinfoSource() {
        return dfdlAppinfoSource;
    }

    public NS targetNS() {
        return targetNS;
    }

    public NS xsiURI() {
        return xsiURI;
    }

    public NS fnURI() {
        return fnURI;
    }

    public NS mathURI() {
        return mathURI;
    }

    public NS dafintURI() {
        return dafintURI;
    }

    public List<String> DFDL_SIMPLE_BUILT_IN_TYPES() {
        return DFDL_SIMPLE_BUILT_IN_TYPES;
    }

    public String slashify(String s) {
        String string = s;
        String string2 = "";
        if (!(string == null ? string2 != null : !string.equals(string2)) || s.endsWith("/")) {
            return s;
        }
        return new java.lang.StringBuilder(1).append(s).append("/").toString();
    }

    public scala.collection.immutable.Seq<NamespaceBinding> namespaceBindings(NamespaceBinding nsBinding) {
        if (nsBinding == null) {
            return Nil$.MODULE$;
        }
        Nil$ thisOne = nsBinding.uri() != null ? new .colon.colon((Object)nsBinding, (List)Nil$.MODULE$) : Nil$.MODULE$;
        scala.collection.immutable.Seq<NamespaceBinding> others = this.namespaceBindings(nsBinding.parent());
        return (scala.collection.immutable.Seq)thisOne.$plus$plus(others);
    }

    public MetaData dfdlAttributes(Node n) {
        return n.attributes().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$dfdlAttributes$1(n, x$2)));
    }

    public MetaData dfdlxAttributes(Node n) {
        return n.attributes().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$dfdlxAttributes$1(n, x$3)));
    }

    public MetaData dafAttributes(Node n) {
        return n.attributes().filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$dafAttributes$1(n, a)));
    }

    public NamespaceBinding combineScopes(NamespaceBinding local, NamespaceBinding outer) {
        String outerURI;
        NamespaceBinding moreBindings;
        String uri;
        String pre;
        while (true) {
            NamespaceBinding namespaceBinding = local;
            TopScope$ topScope$ = TopScope$.MODULE$;
            if (!(namespaceBinding != null ? !namespaceBinding.equals(topScope$) : topScope$ != null)) {
                return outer;
            }
            NamespaceBinding namespaceBinding2 = local;
            if (namespaceBinding2 == null) {
                throw new MatchError((Object)namespaceBinding2);
            }
            String pre2 = namespaceBinding2.prefix();
            String uri2 = namespaceBinding2.uri();
            NamespaceBinding moreBindings2 = namespaceBinding2.parent();
            Tuple3 tuple3 = new Tuple3((Object)pre2, (Object)uri2, (Object)moreBindings2);
            pre = (String)tuple3._1();
            uri = (String)tuple3._2();
            moreBindings = (NamespaceBinding)tuple3._3();
            String string = outerURI = outer.getURI(pre);
            String string2 = uri;
            if (string != null ? !string.equals(string2) : string2 != null) break;
            local = moreBindings;
        }
        if (outerURI == null) {
            return new NamespaceBinding(pre, uri, this.combineScopes(moreBindings, outer));
        }
        NamespaceBinding outerWithoutDuplicate = this.removeBindings(new NamespaceBinding(pre, uri, (NamespaceBinding)TopScope$.MODULE$), outer);
        NamespaceBinding moreBindingsWithoutConflict = this.removeBindings(new NamespaceBinding(pre, uri, (NamespaceBinding)TopScope$.MODULE$), moreBindings);
        return new NamespaceBinding(pre, uri, this.combineScopes(moreBindingsWithoutConflict, outerWithoutDuplicate));
    }

    public NamespaceBinding removeBindings(NamespaceBinding nb, NamespaceBinding scope) {
        NamespaceBinding more;
        while (true) {
            NamespaceBinding namespaceBinding = nb;
            TopScope$ topScope$ = TopScope$.MODULE$;
            if (!(namespaceBinding != null ? !namespaceBinding.equals(topScope$) : topScope$ != null)) {
                return scope;
            }
            NamespaceBinding namespaceBinding2 = scope;
            TopScope$ topScope$2 = TopScope$.MODULE$;
            if (!(namespaceBinding2 != null ? !namespaceBinding2.equals(topScope$2) : topScope$2 != null)) {
                return scope;
            }
            NamespaceBinding namespaceBinding3 = scope;
            if (namespaceBinding3 == null) {
                throw new MatchError((Object)namespaceBinding3);
            }
            String pre = namespaceBinding3.prefix();
            NamespaceBinding more2 = namespaceBinding3.parent();
            Tuple2 tuple2 = new Tuple2((Object)pre, (Object)more2);
            String pre2 = (String)tuple2._1();
            more = (NamespaceBinding)tuple2._2();
            if (nb.getURI(pre2) == null) break;
            scope = more;
        }
        NamespaceBinding x$1 = this.removeBindings(nb, more);
        String x$2 = scope.copy$default$1();
        String x$3 = scope.copy$default$2();
        return scope.copy(x$2, x$3, x$1);
    }

    public NamespaceBinding combineScopes(String prefix, NS ns, NamespaceBinding outer) {
        if (Maybe$.MODULE$.isEmpty$extension(ns.optURI())) {
            return outer;
        }
        String uri = ((URI)Maybe$.MODULE$.get$extension(ns.optURI())).toString();
        NamespaceBinding inner = new NamespaceBinding(prefix, uri, (NamespaceBinding)TopScope$.MODULE$);
        return this.combineScopes(inner, outer);
    }

    public Node collapseScopes(Node x, NamespaceBinding outer) {
        Option option;
        Node node = x;
        if (node != null && !(option = Elem$.MODULE$.unapplySeq(node)).isEmpty()) {
            String pre = (String)((Tuple5)option.get())._1();
            String lab = (String)((Tuple5)option.get())._2();
            MetaData md = (MetaData)((Tuple5)option.get())._3();
            NamespaceBinding scp = (NamespaceBinding)((Tuple5)option.get())._4();
            scala.collection.immutable.Seq child = (scala.collection.immutable.Seq)((Tuple5)option.get())._5();
            NamespaceBinding newScope = this.combineScopes(scp, outer);
            return Elem$.MODULE$.apply(pre, lab, md, newScope, true, (scala.collection.immutable.Seq)child.flatMap((Function1 & Serializable)ch -> MODULE$.collapseScopes((Node)ch, newScope)));
        }
        return x;
    }

    public NamespaceBinding filterScope(NamespaceBinding nsb, scala.collection.immutable.Seq<NS> nss) {
        TopScope$ topScope$;
        NamespaceBinding namespaceBinding = nsb;
        TopScope$ topScope$2 = TopScope$.MODULE$;
        if (!(namespaceBinding != null ? !namespaceBinding.equals(topScope$2) : topScope$2 != null)) {
            topScope$ = TopScope$.MODULE$;
        } else {
            NamespaceBinding parentCopy = this.filterScope(nsb.parent(), nss);
            if (nss.contains((Object)NS$.MODULE$.apply(nsb.uri()))) {
                topScope$ = parentCopy;
            } else {
                NamespaceBinding x$1 = parentCopy;
                String x$2 = nsb.copy$default$1();
                String x$3 = nsb.copy$default$2();
                topScope$ = nsb.copy(x$2, x$3, x$1);
            }
        }
        TopScope$ newHead = topScope$;
        return newHead;
    }

    public boolean prefixInScope(String prefix, NamespaceBinding scope) {
        boolean bl;
        if (scope == null) {
            bl = false;
        } else {
            String string = prefix;
            String string2 = scope.prefix();
            bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : this.prefixInScope(prefix, scope.parent());
        }
        boolean ret = bl;
        return ret;
    }

    public Node removeComments(Node e) {
        Option option;
        Node node = e;
        if (node != null && !(option = Elem$.MODULE$.unapplySeq(node)).isEmpty()) {
            String prefix = (String)((Tuple5)option.get())._1();
            String label = (String)((Tuple5)option.get())._2();
            MetaData attribs = (MetaData)((Tuple5)option.get())._3();
            NamespaceBinding scope = (NamespaceBinding)((Tuple5)option.get())._4();
            scala.collection.immutable.Seq child = (scala.collection.immutable.Seq)((Tuple5)option.get())._5();
            scala.collection.immutable.Seq newChildren = (scala.collection.immutable.Seq)((IterableOps)child.filterNot((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeComments$1(x$6)))).map((Function1 & Serializable)x$7 -> MODULE$.removeComments((Node)x$7));
            return Elem$.MODULE$.apply(prefix, label, attribs, scope, true, newChildren);
        }
        return node;
    }

    public Node removeAttributes(Node n, scala.collection.immutable.Seq<NS> ns, Option<NamespaceBinding> parentScope) {
        Node res1 = (Node)this.removeAttributes1(n, ns, parentScope);
        Node res2 = this.removeMixedWhitespace(res1);
        Node res = res2.apply(0);
        return res;
    }

    public scala.collection.immutable.Seq<NS> removeAttributes$default$2() {
        return (scala.collection.immutable.Seq)Nil$.MODULE$;
    }

    public Option<NamespaceBinding> removeAttributes$default$3() {
        return None$.MODULE$;
    }

    private Node removeMixedWhitespace(Node ns2) {
        Elem elem;
        scala.collection.immutable.Seq noMixedChildren;
        if (!(ns2 instanceof Elem)) {
            return ns2;
        }
        Elem e = (Elem)ns2;
        scala.collection.immutable.Seq children = e.child();
        scala.collection.immutable.Seq seq = noMixedChildren = children.exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeMixedWhitespace$1(x$8))) ? (scala.collection.immutable.Seq)((IterableOps)children.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeMixedWhitespace$2(e, x0$1)))).map((Function1 & Serializable)ns -> MODULE$.removeMixedWhitespace((Node)ns)) : (scala.collection.immutable.Seq)children.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeMixedWhitespace$4(x0$2)));
        if (noMixedChildren == children) {
            elem = e;
        } else {
            scala.collection.immutable.Seq x$1 = noMixedChildren;
            String x$2 = e.copy$default$1();
            String x$3 = e.copy$default$2();
            MetaData x$4 = e.copy$default$3();
            NamespaceBinding x$5 = e.copy$default$4();
            boolean x$6 = e.copy$default$5();
            elem = e.copy(x$2, x$3, x$4, x$5, x$6, (Seq)x$1);
        }
        Elem res = elem;
        return res;
    }

    private Node convertPCDataToText(Node n) {
        Option option;
        Text text;
        Node node = n;
        if (node instanceof Text) {
            Text text2;
            text = text2 = (Text)node;
        } else if (node instanceof Atom) {
            Atom atom = (Atom)node;
            text = Text$.MODULE$.apply(atom.text());
        } else if (node != null && !(option = Elem$.MODULE$.unapplySeq(node)).isEmpty()) {
            String prefix = (String)((Tuple5)option.get())._1();
            String label = (String)((Tuple5)option.get())._2();
            MetaData attributes = (MetaData)((Tuple5)option.get())._3();
            NamespaceBinding scope = (NamespaceBinding)((Tuple5)option.get())._4();
            scala.collection.immutable.Seq children = (scala.collection.immutable.Seq)((Tuple5)option.get())._5();
            scala.collection.immutable.Seq newChildren = (scala.collection.immutable.Seq)children.map((Function1 & Serializable)x$9 -> MODULE$.convertPCDataToText((Node)x$9));
            text = Elem$.MODULE$.apply(prefix, label, attributes, scope, true, newChildren);
        } else {
            text = n;
        }
        Text res = text;
        return res;
    }

    private NodeSeq removeAttributes1(Node n, scala.collection.immutable.Seq<NS> ns, Option<NamespaceBinding> parentScope) {
        Object object;
        Option option;
        Node node = n;
        if (node != null && !(option = Elem$.MODULE$.unapplySeq(node)).isEmpty()) {
            Object object2;
            String prefix = (String)((Tuple5)option.get())._1();
            String label = (String)((Tuple5)option.get())._2();
            MetaData attributes = (MetaData)((Tuple5)option.get())._3();
            NamespaceBinding scope = (NamespaceBinding)((Tuple5)option.get())._4();
            scala.collection.immutable.Seq children = (scala.collection.immutable.Seq)((Tuple5)option.get())._5();
            TopScope$ filteredScope = ns.length() > 0 ? this.filterScope(scope, ns) : TopScope$.MODULE$;
            Option<NamespaceBinding> option2 = parentScope;
            if (option2 instanceof Some) {
                NamespaceBinding ps;
                Some some = (Some)option2;
                NamespaceBinding namespaceBinding = ps = (NamespaceBinding)some.value();
                TopScope$ topScope$ = filteredScope;
                object2 = !(namespaceBinding != null ? !namespaceBinding.equals(topScope$) : topScope$ != null) ? ps : filteredScope;
            } else if (None$.MODULE$.equals(option2)) {
                object2 = filteredScope;
            } else {
                throw new MatchError(option2);
            }
            TopScope$ newScope = object2;
            NodeSeq newChildren = NodeSeq$.MODULE$.seqToNodeSeq((Seq)children.flatMap(arg_0 -> XMLUtils$.$anonfun$removeAttributes1$1(ns, (NamespaceBinding)newScope, arg_0)));
            scala.collection.immutable.Seq<Node> textMergedChildren = this.coalesceAdjacentTextNodes((scala.collection.immutable.Seq<Node>)newChildren);
            String newPrefix = this.prefixInScope(prefix, (NamespaceBinding)newScope) ? prefix : null;
            MetaData newAttributes = attributes.filter((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeAttributes1$2(node, m)));
            object = Elem$.MODULE$.apply(newPrefix, label, newAttributes, (NamespaceBinding)newScope, true, textMergedChildren);
        } else {
            object = node instanceof Comment ? NodeSeq$.MODULE$.Empty() : node;
        }
        NodeSeq res = object;
        return res;
    }

    public Node normalize(Node n) {
        Node noComments = this.removeComments(n);
        Node noPCData = this.convertPCDataToText(noComments);
        Node combinedText = this.coalesceAllAdjacentTextNodes(noPCData);
        Node noMixedWS = this.removeMixedWhitespace(combinedText);
        return noMixedWS;
    }

    public void compareAndReport(Node expected, Node actual, boolean ignoreProcInstr, boolean checkPrefixes, boolean checkNamespaces, Option<Object> maybeFloatEpsilon, Option<Object> maybeDoubleEpsilon) {
        Node actualMinimized;
        Node expectedMinimized = this.normalize(expected);
        scala.collection.immutable.Seq<Tuple3<String, String, String>> diffs = this.computeDiff(expectedMinimized, actualMinimized = this.normalize(actual), ignoreProcInstr, checkPrefixes, checkNamespaces, maybeFloatEpsilon, maybeDoubleEpsilon);
        if (diffs.length() > 0) {
            throw new XMLUtils.XMLDifferenceException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\nComparison failed.\nExpected (attributes %s)\n          %s\nActual (attributes %s for diff)\n          %s\nDifferences were (path, expected, actual):\n%s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{checkPrefixes || checkNamespaces ? "compared for diff" : "stripped", checkPrefixes || checkNamespaces ? expected : this.removeAttributes(expected, this.removeAttributes$default$2(), this.removeAttributes$default$3()).toString(), checkPrefixes || checkNamespaces ? "compared" : "ignored", actual, ((IterableOnceOps)diffs.map((Function1 & Serializable)x$11 -> x$11.toString())).mkString("- ", "\n- ", "\n")})));
        }
    }

    public boolean compareAndReport$default$3() {
        return true;
    }

    public boolean compareAndReport$default$4() {
        return false;
    }

    public boolean compareAndReport$default$5() {
        return false;
    }

    public Option<Object> compareAndReport$default$6() {
        return None$.MODULE$;
    }

    public Option<Object> compareAndReport$default$7() {
        return None$.MODULE$;
    }

    public scala.collection.immutable.Seq<Tuple3<String, String, String>> computeDiff(Node a, Node b, boolean ignoreProcInstr, boolean checkPrefixes, boolean checkNamespaces, Option<Object> maybeFloatEpsilon, Option<Object> maybeDoubleEpsilon) {
        return this.computeDiffOne(a, b, (NamespaceBinding)TopScope$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, (Option<Object>)None$.MODULE$, (scala.collection.immutable.Seq<String>)Nil$.MODULE$, ignoreProcInstr, checkPrefixes, checkNamespaces, (Option<String>)None$.MODULE$, maybeFloatEpsilon, maybeDoubleEpsilon);
    }

    public boolean computeDiff$default$3() {
        return true;
    }

    public boolean computeDiff$default$4() {
        return false;
    }

    public boolean computeDiff$default$5() {
        return false;
    }

    public Option<Object> computeDiff$default$6() {
        return None$.MODULE$;
    }

    public Option<Object> computeDiff$default$7() {
        return None$.MODULE$;
    }

    public scala.collection.immutable.Map<String, Object> childArrayCounters(Elem e) {
        Option option;
        Elem elem = e;
        if (elem == null || (option = Elem$.MODULE$.unapplySeq((Node)elem)).isEmpty()) {
            throw new MatchError((Object)elem);
        }
        scala.collection.immutable.Seq children = (scala.collection.immutable.Seq)((Tuple5)option.get())._5();
        scala.collection.immutable.Seq children2 = children;
        scala.collection.immutable.Seq labels = (scala.collection.immutable.Seq)children2.map((Function1 & Serializable)x$12 -> x$12.label());
        scala.collection.immutable.Map groups = labels.groupBy((Function1 & Serializable)x -> x);
        scala.collection.immutable.Map counts = (scala.collection.immutable.Map)groups.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String label = (String)tuple2._1();
                scala.collection.immutable.Seq labelList = (scala.collection.immutable.Seq)tuple2._2();
                return new Tuple2((Object)label, (Object)BoxesRunTime.boxToInteger((int)labelList.length()));
            }
            throw new MatchError((Object)tuple2);
        });
        scala.collection.immutable.Map arrayCounts = (scala.collection.immutable.Map)counts.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$childArrayCounters$4(x0$2)));
        scala.collection.immutable.Map arrayCounters = (scala.collection.immutable.Map)arrayCounts.map((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                String label = (String)tuple2._1();
                return new Tuple2((Object)label, (Object)BoxesRunTime.boxToLong((long)1L));
            }
            throw new MatchError((Object)tuple2);
        });
        return arrayCounters;
    }

    private Option<String> getXSIType(Elem a) {
        Option res = a.attribute(this.XSI_NAMESPACE().toString(), "type").map((Function1 & Serializable)x$13 -> ((Node)x$13.head()).text());
        return res;
    }

    public scala.collection.immutable.Seq<Tuple3<String, String, String>> computeDiffOne(Node an, Node bn, NamespaceBinding aParentScope, NamespaceBinding bParentScope, Option<Object> maybeIndex, scala.collection.immutable.Seq<String> parentPathSteps, boolean ignoreProcInstr, boolean checkPrefixes, boolean checkNamespaces, Option<String> maybeType, Option<Object> maybeFloatEpsilon, Option<Object> maybeDoubleEpsilon) {
        LazyRef zPath$lzy = new LazyRef();
        Tuple2 tuple2 = new Tuple2((Object)an, (Object)bn);
        if (tuple2 != null) {
            Node a = (Node)tuple2._1();
            Node b = (Node)tuple2._2();
            if (a instanceof Elem) {
                Elem elem = (Elem)a;
                if (b instanceof Elem) {
                    Tuple2 tuple22;
                    Tuple2 tuple23;
                    String pathLabel;
                    Option option;
                    Option option2;
                    Elem elem2 = (Elem)b;
                    Elem elem3 = elem;
                    if (elem3 == null || (option2 = Elem$.MODULE$.unapplySeq((Node)elem3)).isEmpty()) {
                        throw new MatchError((Object)elem3);
                    }
                    String prefixA = (String)((Tuple5)option2.get())._1();
                    String labelA = (String)((Tuple5)option2.get())._2();
                    MetaData attribsA = (MetaData)((Tuple5)option2.get())._3();
                    NamespaceBinding nsbA = (NamespaceBinding)((Tuple5)option2.get())._4();
                    scala.collection.immutable.Seq childrenA = (scala.collection.immutable.Seq)((Tuple5)option2.get())._5();
                    Tuple5 tuple5 = new Tuple5((Object)prefixA, (Object)labelA, (Object)attribsA, (Object)nsbA, (Object)childrenA);
                    String prefixA2 = (String)tuple5._1();
                    String labelA2 = (String)tuple5._2();
                    MetaData attribsA2 = (MetaData)tuple5._3();
                    NamespaceBinding nsbA2 = (NamespaceBinding)tuple5._4();
                    scala.collection.immutable.Seq childrenA2 = (scala.collection.immutable.Seq)tuple5._5();
                    Elem elem4 = elem2;
                    if (elem4 == null || (option = Elem$.MODULE$.unapplySeq((Node)elem4)).isEmpty()) {
                        throw new MatchError((Object)elem4);
                    }
                    String prefixB = (String)((Tuple5)option.get())._1();
                    String labelB = (String)((Tuple5)option.get())._2();
                    MetaData attribsB = (MetaData)((Tuple5)option.get())._3();
                    NamespaceBinding nsbB = (NamespaceBinding)((Tuple5)option.get())._4();
                    scala.collection.immutable.Seq childrenB = (scala.collection.immutable.Seq)((Tuple5)option.get())._5();
                    Tuple5 tuple52 = new Tuple5((Object)prefixB, (Object)labelB, (Object)attribsB, (Object)nsbB, (Object)childrenB);
                    String prefixB2 = (String)tuple52._1();
                    String labelB2 = (String)tuple52._2();
                    MetaData attribsB2 = (MetaData)tuple52._3();
                    NamespaceBinding nsbB2 = (NamespaceBinding)tuple52._4();
                    scala.collection.immutable.Seq childrenB2 = (scala.collection.immutable.Seq)tuple52._5();
                    Option<String> typeA = this.getXSIType(elem);
                    Option<String> typeB = this.getXSIType(elem2);
                    Option maybeType2 = Option$.MODULE$.apply(typeA.getOrElse((Function0 & Serializable)() -> (String)typeB.getOrElse((Function0 & Serializable)() -> null)));
                    Option nilledA = elem.attribute(this.XSI_NAMESPACE().toString(), "nil");
                    Option nilledB = elem2.attribute(this.XSI_NAMESPACE().toString(), "nil");
                    String mappingsA = checkNamespaces ? nsbA2.buildString(aParentScope).trim() : "";
                    String mappingsB = checkNamespaces ? nsbB2.buildString(bParentScope).trim() : "";
                    String string = labelA2;
                    String string2 = labelB2;
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        return new .colon.colon((Object)new Tuple3((Object)XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), (Object)labelA2, (Object)labelB2), (List)Nil$.MODULE$);
                    }
                    if (checkPrefixes) {
                        String string3 = prefixA2;
                        String string4 = prefixB2;
                        if (string3 == null ? string4 != null : !string3.equals(string4)) {
                            return new .colon.colon((Object)new Tuple3((Object)new java.lang.StringBuilder(8).append(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps)).append("/").append(labelA2).append("@prefix").toString(), (Object)prefixA2, (Object)prefixB2), (List)Nil$.MODULE$);
                        }
                    }
                    if (checkNamespaces) {
                        String string5 = mappingsA;
                        String string6 = mappingsB;
                        if (string5 == null ? string6 != null : !string5.equals(string6)) {
                            return new .colon.colon((Object)new Tuple3((Object)new java.lang.StringBuilder(7).append(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps)).append("/").append(labelA2).append("@xmlns").toString(), (Object)mappingsA, (Object)mappingsB), (List)Nil$.MODULE$);
                        }
                    }
                    Option option3 = nilledA;
                    Option option4 = nilledB;
                    if (option3 == null ? option4 != null : !option3.equals(option4)) {
                        return new .colon.colon((Object)new Tuple3((Object)new java.lang.StringBuilder(9).append(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps)).append("/").append(labelA2).append("@xsi:nil").toString(), nilledA.map((Function1 & Serializable)x$16 -> x$16.toString()).getOrElse((Function0 & Serializable)() -> ""), nilledB.map((Function1 & Serializable)x$17 -> x$17.toString()).getOrElse((Function0 & Serializable)() -> "")), (List)Nil$.MODULE$);
                    }
                    Option<String> option5 = typeA;
                    Option<String> option6 = typeB;
                    if ((option5 == null ? option6 != null : !option5.equals(option6)) && typeA.isDefined() && typeB.isDefined()) {
                        return new .colon.colon((Object)new Tuple3((Object)new java.lang.StringBuilder(10).append(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps)).append("/").append(labelA2).append("@xsi:type").toString(), typeA.map((Function1 & Serializable)x$18 -> x$18.toString()).getOrElse((Function0 & Serializable)() -> ""), typeA.map((Function1 & Serializable)x$19 -> x$19.toString()).getOrElse((Function0 & Serializable)() -> "")), (List)Nil$.MODULE$);
                    }
                    String string7 = pathLabel = new java.lang.StringBuilder(0).append(labelA2).append(maybeIndex.map((Function1 & Serializable)x$20 -> XMLUtils$.$anonfun$computeDiffOne$11(BoxesRunTime.unboxToInt((Object)x$20))).getOrElse((Function0 & Serializable)() -> "")).toString();
                    scala.collection.immutable.Seq thisPathStep = (scala.collection.immutable.Seq)parentPathSteps.$plus$colon((Object)string7);
                    if (ignoreProcInstr) {
                        scala.collection.immutable.Seq ca = (scala.collection.immutable.Seq)childrenA2.filterNot((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeDiffOne$13(x$21)));
                        scala.collection.immutable.Seq cb = (scala.collection.immutable.Seq)childrenB2.filterNot((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeDiffOne$14(x$22)));
                        tuple23 = new Tuple2((Object)ca, (Object)cb);
                    } else {
                        tuple23 = tuple22 = new Tuple2((Object)childrenA2, (Object)childrenB2);
                    }
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    scala.collection.immutable.Seq childrenACompare = (scala.collection.immutable.Seq)tuple22._1();
                    scala.collection.immutable.Seq childrenBCompare = (scala.collection.immutable.Seq)tuple22._2();
                    Tuple2 tuple24 = new Tuple2((Object)childrenACompare, (Object)childrenBCompare);
                    scala.collection.immutable.Seq childrenACompare2 = (scala.collection.immutable.Seq)tuple24._1();
                    scala.collection.immutable.Seq childrenBCompare2 = (scala.collection.immutable.Seq)tuple24._2();
                    Iterable repeatingChildrenLabels = ((MapOps)childrenA2.groupBy((Function1 & Serializable)x$24 -> x$24.label()).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeDiffOne$16(x0$1)))).keys();
                    Iterable labelsWithZeroCount = (Iterable)repeatingChildrenLabels.map((Function1 & Serializable)x$25 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$25), (Object)BoxesRunTime.boxToInteger((int)0)));
                    Map countMap = (Map)Map$.MODULE$.apply(labelsWithZeroCount.toSeq());
                    scala.collection.immutable.Seq childrenDiffs = (scala.collection.immutable.Seq)((IterableOps)childrenACompare2.zip((IterableOnce)childrenBCompare2)).flatMap((Function1 & Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            Node ca = (Node)tuple2._1();
                            Node cb = (Node)tuple2._2();
                            Option maybeChildCount = countMap.get((Object)ca.label());
                            Option maybeChildIndex = maybeChildCount.map((Function1)(JFunction1.mcII.sp & Serializable)count -> {
                                String string = ca.label();
                                countMap.update((Object)string, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)countMap.apply((Object)string)) + 1)));
                                return count + 1;
                            });
                            return MODULE$.computeDiffOne(ca, cb, nsbA2, nsbB2, (Option<Object>)maybeChildIndex, (scala.collection.immutable.Seq<String>)thisPathStep, ignoreProcInstr, checkPrefixes, checkNamespaces, (Option<String>)maybeType2, maybeFloatEpsilon, maybeDoubleEpsilon);
                        }
                        throw new MatchError((Object)tuple2);
                    });
                    Nil$ childrenLengthDiff = childrenA2.length() != childrenB2.length() ? new .colon.colon((Object)new Tuple3((Object)new java.lang.StringBuilder(15).append(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps)).append("/").append(labelA2).append("::child@count)").toString(), (Object)Integer.toString(childrenA2.length()), (Object)Integer.toString(childrenB2.length())), (List)Nil$.MODULE$) : Nil$.MODULE$;
                    return (scala.collection.immutable.Seq)childrenDiffs.$plus$plus((IterableOnce)childrenLengthDiff);
                }
            }
        }
        if (tuple2 != null) {
            Node tA = (Node)tuple2._1();
            Node tB = (Node)tuple2._2();
            if (tA instanceof Text) {
                Text text = (Text)tA;
                if (tB instanceof Text) {
                    Text text2 = (Text)tB;
                    scala.collection.immutable.Seq<Tuple3<String, String, String>> thisDiff = this.computeTextDiff(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), text, text2, maybeType, maybeFloatEpsilon, maybeDoubleEpsilon);
                    return thisDiff;
                }
            }
        }
        if (tuple2 != null) {
            Node pA = (Node)tuple2._1();
            Node pB = (Node)tuple2._2();
            if (pA instanceof ProcInstr) {
                ProcInstr procInstr = (ProcInstr)pA;
                if (pB instanceof ProcInstr) {
                    ProcInstr procInstr2 = (ProcInstr)pB;
                    ProcInstr procInstr3 = procInstr;
                    if (procInstr3 == null) {
                        throw new MatchError((Object)procInstr3);
                    }
                    String tA1label = procInstr3.target();
                    String tA1content = procInstr3.proctext();
                    Tuple2 tuple25 = new Tuple2((Object)tA1label, (Object)tA1content);
                    String tA1label2 = (String)tuple25._1();
                    String tA1content2 = (String)tuple25._2();
                    ProcInstr procInstr4 = procInstr2;
                    if (procInstr4 == null) {
                        throw new MatchError((Object)procInstr4);
                    }
                    String tB1label = procInstr4.target();
                    String tB1content = procInstr4.proctext();
                    Tuple2 tuple26 = new Tuple2((Object)tB1label, (Object)tB1content);
                    String tB1label2 = (String)tuple26._1();
                    String tB1content2 = (String)tuple26._2();
                    scala.collection.immutable.Seq<Tuple3<String, String, String>> labelDiff = this.computeTextDiff(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), tA1label2, tB1label2, (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                    scala.collection.immutable.Seq<Tuple3<String, String, String>> contentDiff = this.computeTextDiff(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), tA1content2, tB1content2, maybeType, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                    return (scala.collection.immutable.Seq)labelDiff.$plus$plus(contentDiff);
                }
            }
        }
        return new .colon.colon((Object)new Tuple3((Object)XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), (Object)an.toString(), (Object)bn.toString()), (List)Nil$.MODULE$);
    }

    public scala.collection.immutable.Seq<Tuple3<String, String, String>> computeTextDiff(String zPath, Text tA, Text tB, Option<String> maybeType, Option<Object> maybeFloatEpsilon, Option<Object> maybeDoubleEpsilon) {
        String dataA = tA.toString();
        String dataB = tB.toString();
        return this.computeTextDiff(zPath, dataA, dataB, maybeType, maybeFloatEpsilon, maybeDoubleEpsilon);
    }

    public scala.collection.immutable.Seq<Tuple3<String, String, String>> computeBlobDiff(String zPath, String dataA, String dataB) {
        Option<URI> uriA = Misc$.MODULE$.searchResourceOption(dataA, (Option<URI>)None$.MODULE$);
        Option<URI> uriB = Misc$.MODULE$.searchResourceOption(dataB, (Option<URI>)None$.MODULE$);
        Option pathA = uriA.map((Function1 & Serializable)u -> Paths.get(u));
        Option pathB = uriB.map((Function1 & Serializable)u -> Paths.get(u));
        boolean canReadA = BoxesRunTime.unboxToBoolean((Object)pathA.map((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeBlobDiff$3(p))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        boolean canReadB = BoxesRunTime.unboxToBoolean((Object)pathB.map((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeBlobDiff$5(p))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        if (!canReadA || !canReadB) {
            String path = new java.lang.StringBuilder(8).append(zPath).append(".canRead").toString();
            return new .colon.colon((Object)new Tuple3((Object)path, (Object)Boolean.toString(canReadA), (Object)Boolean.toString(canReadB)), (List)Nil$.MODULE$);
        }
        int CHUNK_SIZE = 1024;
        byte[] arrayA = new byte[CHUNK_SIZE];
        byte[] arrayB = new byte[CHUNK_SIZE];
        InputStream streamA = Files.newInputStream((Path)pathA.get(), StandardOpenOption.READ);
        InputStream streamB = Files.newInputStream((Path)pathB.get(), StandardOpenOption.READ);
        int lenA = 0;
        int lenB = 0;
        int numSameBytes = 0;
        boolean areSame = true;
        while (true) {
            boolean bl = areSame = (lenA = streamA.read(arrayA)) == (lenB = streamB.read(arrayB)) && Predef$.MODULE$.wrapByteArray(arrayA).sameElements((IterableOnce)Predef$.MODULE$.wrapByteArray(arrayB));
            if (!areSame || lenA == -1 || lenB == -1) break;
            numSameBytes += lenA;
        }
        if (!areSame) {
            Tuple2[] zip = ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.byteArrayOps(arrayA), (IterableOnce)Predef$.MODULE$.wrapByteArray(arrayB));
            Object qual$1 = Predef$.MODULE$.refArrayOps((Object[])zip);
            Function1 & Serializable x$1 = (Function1 & Serializable)z -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeBlobDiff$7(z));
            int x$2 = ArrayOps$.MODULE$.indexWhere$default$2$extension(qual$1);
            int firstDiffIndex = ArrayOps$.MODULE$.indexWhere$extension(qual$1, (Function1)x$1, x$2);
            int MAX_CONTEXT = 40;
            byte[] contextA = (byte[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.byteArrayOps(arrayA), lenA)), firstDiffIndex)), MAX_CONTEXT);
            byte[] contextB = (byte[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.byteArrayOps(arrayB), lenB)), firstDiffIndex)), MAX_CONTEXT);
            String hexA = Misc$.MODULE$.bytes2Hex(contextA);
            String hexB = Misc$.MODULE$.bytes2Hex(contextB);
            int absoluteIndex = numSameBytes + firstDiffIndex;
            String path = new java.lang.StringBuilder(10).append(zPath).append(".bytesAt(").append(absoluteIndex + 1).append(")").toString();
            return new .colon.colon((Object)new Tuple3((Object)path, (Object)hexA, (Object)hexB), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    public scala.collection.immutable.Seq<Tuple3<String, String, String>> computeTextDiff(String zPath, String dataA, String dataB, Option<String> maybeType, Option<Object> maybeFloatEpsilon, Option<Object> maybeDoubleEpsilon) {
        if (!maybeType.isDefined()) ** GOTO lbl-1000
        v0 = maybeType.get();
        var8_7 = "xs:anyURI";
        if (!(v0 != null ? v0.equals(var8_7) == false : var8_7 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        hasBlobType = v1;
        dataLooksLikeBlobURI = new .colon.colon((Object)dataA, (List)new .colon.colon((Object)dataB, (List)Nil$.MODULE$)).forall((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$computeTextDiff$1$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)());
        if (hasBlobType || dataLooksLikeBlobURI) {
            return this.computeBlobDiff(zPath, dataA, dataB);
        }
        if (this.textIsSame(dataA, dataB, maybeType, maybeFloatEpsilon, maybeDoubleEpsilon)) {
            return Nil$.MODULE$;
        }
        CHARS_TO_SHOW_AFTER_DIFF = 40;
        lenA = dataA.length();
        lenB = dataB.length();
        for (index = 0; index < lenA && index < lenB && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(dataA), index) == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(dataB), index); ++index) {
        }
        contextA = Misc$.MODULE$.remapStringToVisibleGlyphs(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(dataA), index, index + CHARS_TO_SHOW_AFTER_DIFF));
        contextB = Misc$.MODULE$.remapStringToVisibleGlyphs(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(dataB), index, index + CHARS_TO_SHOW_AFTER_DIFF));
        path = new java.lang.StringBuilder(9).append(zPath).append(".charAt(").append(index + 1).append(")").toString();
        return new .colon.colon((Object)new Tuple3((Object)path, (Object)contextA, (Object)contextB), (List)Nil$.MODULE$);
    }

    public boolean textIsSame(String dataA, String dataB, Option<String> maybeType, Option<Object> maybeFloatEpsilon, Option<Object> maybeDoubleEpsilon) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        maybeFloatEpsilon.foreach((Function1)(JFunction1.mcVF.sp & Serializable)eps -> {
            if (!((double)eps > 0.0)) {
                throw Assert$.MODULE$.usageError("eps.>(0.0)");
            }
        });
        maybeDoubleEpsilon.foreach((Function1)(JFunction1.mcVD.sp & Serializable)eps -> {
            if (!(eps > 0.0)) {
                throw Assert$.MODULE$.usageError("eps.>(0.0)");
            }
        });
        boolean bl = false;
        Some some = null;
        Option<String> option = maybeType;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string6 = (String)some.value();
            if ("xs:hexBinary".equals(string6)) {
                return dataA.equalsIgnoreCase(dataB);
            }
        }
        if (bl && "xs:date".equals(string5 = (String)some.value())) {
            DFDLDate a = DFDLDateConversion$.MODULE$.fromXMLString(dataA);
            DFDLDate b = DFDLDateConversion$.MODULE$.fromXMLString(dataB);
            DFDLDate dFDLDate = a;
            DFDLDate dFDLDate2 = b;
            return !(dFDLDate != null ? !((Object)dFDLDate).equals(dFDLDate2) : dFDLDate2 != null);
        }
        if (bl && "xs:time".equals(string4 = (String)some.value())) {
            DFDLTime a = DFDLTimeConversion$.MODULE$.fromXMLString(dataA);
            DFDLTime b = DFDLTimeConversion$.MODULE$.fromXMLString(dataB);
            DFDLTime dFDLTime = a;
            DFDLTime dFDLTime2 = b;
            return !(dFDLTime != null ? !((Object)dFDLTime).equals(dFDLTime2) : dFDLTime2 != null);
        }
        if (bl && "xs:dateTime".equals(string3 = (String)some.value())) {
            DFDLDateTime a = DFDLDateTimeConversion$.MODULE$.fromXMLString(dataA);
            DFDLDateTime b = DFDLDateTimeConversion$.MODULE$.fromXMLString(dataB);
            DFDLDateTime dFDLDateTime = a;
            DFDLDateTime dFDLDateTime2 = b;
            return !(dFDLDateTime != null ? !((Object)dFDLDateTime).equals(dFDLDateTime2) : dFDLDateTime2 != null);
        }
        if (bl && "xs:double".equals(string2 = (String)some.value())) {
            double a = this.strToDouble(dataA);
            double b = this.strToDouble(dataB);
            if (Double.isNaN(a) && Double.isNaN(b)) {
                return true;
            }
            Option<Object> option2 = maybeDoubleEpsilon;
            if (None$.MODULE$.equals(option2)) {
                return a == b;
            }
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                double epsilon = BoxesRunTime.unboxToDouble((Object)some2.value());
                return package$.MODULE$.abs(a - b) < epsilon;
            }
            throw new MatchError(option2);
        }
        if (bl && "xs:float".equals(string = (String)some.value())) {
            float a = this.strToFloat(dataA);
            float b = this.strToFloat(dataB);
            if (Float.isNaN(a) && Float.isNaN(b)) {
                return true;
            }
            Option<Object> option3 = maybeFloatEpsilon;
            if (None$.MODULE$.equals(option3)) {
                return a == b;
            }
            if (option3 instanceof Some) {
                Some some3 = (Some)option3;
                float epsilon = BoxesRunTime.unboxToFloat((Object)some3.value());
                return package$.MODULE$.abs(a - b) < epsilon;
            }
            throw new MatchError(option3);
        }
        String string7 = dataA;
        String string8 = dataB;
        return !(string7 != null ? !string7.equals(string8) : string8 != null);
    }

    public Option<File> getOptTDMLFileFromNode(Node node) {
        return node.attribute(NS$.MODULE$.implicitNStoString(this.INT_NS()), this.FILE_ATTRIBUTE_NAME()).map((Function1 & Serializable)uriStringNode -> new File(NodeSeq$.MODULE$.seqToNodeSeq(uriStringNode).text()));
    }

    public File convertNodeToTempFile(Node xml, File tmpDir, String nameHint) {
        String prefix = this.prefixFromHint(nameHint);
        File tmpSchemaFile = File.createTempFile(prefix, ".dfdl.xsd", tmpDir);
        tmpSchemaFile.deleteOnExit();
        PrettyPrinter pp = new PrettyPrinter(2);
        String xmlString = pp.format(xml);
        FileOutputStream fos = new FileOutputStream(tmpSchemaFile);
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
        fw.write(xmlString);
        fw.close();
        return tmpSchemaFile;
    }

    public String convertNodeToTempFile$default$3() {
        return "daffodil_tmp_";
    }

    private String prefixFromHint(String nameHint) {
        int n = nameHint.length();
        switch (n) {
            case 0: {
                return "daffodil_tmp_";
            }
            case 1: {
                return new java.lang.StringBuilder(2).append(nameHint).append("__").toString();
            }
            case 2: {
                return new java.lang.StringBuilder(1).append(nameHint).append("_").toString();
            }
        }
        return nameHint;
    }

    public File convertInputStreamToTempFile(InputStream is, File tmpDir, String nameHint, String suffix) {
        String prefix = this.prefixFromHint(nameHint);
        File tmpSchemaFile = File.createTempFile(prefix, suffix, tmpDir);
        tmpSchemaFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tmpSchemaFile);
        IOUtils.copy((InputStream)is, (OutputStream)fos);
        fos.close();
        return tmpSchemaFile;
    }

    public StringBuilder escape(String s, StringBuilder sb) {
        int i = 0;
        String str = this.xmlRemapperPreservingCR().remap(s);
        while (i < str.length()) {
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), i);
            ++i;
            char c2 = c;
            switch (c2) {
                case '\'': {
                    StringBuilder stringBuilder = sb.append("&#x27;");
                    break;
                }
                case '\"': {
                    StringBuilder stringBuilder = sb.append("&quot;");
                    break;
                }
                case '&': {
                    StringBuilder stringBuilder = sb.append("&amp;");
                    break;
                }
                case '<': {
                    StringBuilder stringBuilder = sb.append("&lt;");
                    break;
                }
                case '>': {
                    StringBuilder stringBuilder = sb.append("&gt;");
                    break;
                }
                default: {
                    StringBuilder stringBuilder;
                    if (RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c))) {
                        stringBuilder = sb.append(c);
                        break;
                    }
                    if (RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(c)) || RichChar$.MODULE$.isControl$extension(Predef$.MODULE$.charWrapper(c))) {
                        stringBuilder = this.toNumericCharacterEntity(c, sb);
                        break;
                    }
                    if (c == '\u00a0') {
                        stringBuilder = this.toNumericCharacterEntity(c, sb);
                        break;
                    }
                    if (c < '\u00ff') {
                        stringBuilder = sb.append(c);
                        break;
                    }
                    stringBuilder = this.toNumericCharacterEntity(c, sb);
                    break;
                }
            }
        }
        return sb;
    }

    public StringBuilder escape$default$2() {
        return new StringBuilder();
    }

    private RemapXMLIllegalCharToPUA xmlRemapperPreservingCR() {
        return xmlRemapperPreservingCR;
    }

    public StringBuilder toNumericCharacterEntity(char c, StringBuilder sb) {
        char i = c;
        if (i <= '\u0000') {
            throw Assert$.MODULE$.usageError("i.>(0)");
        }
        String s = Integer.toHexString(i).toUpperCase();
        sb.append("&#x");
        sb.append(s);
        return sb.append(";");
    }

    private Regex xmlEntityPattern() {
        return xmlEntityPattern;
    }

    /*
     * WARNING - void declaration
     */
    public String unescape(String raw) {
        void var3_2;
        String res = this.xmlEntityPattern().replaceAllIn((CharSequence)raw, (Function1 & Serializable)m -> {
            StringBuilder sb = Utility$.MODULE$.unescape(m.group("entity"), new StringBuilder());
            if (sb == null) {
                throw Assert$.MODULE$.abort("Invariant broken: sb.ne(null)");
            }
            return sb.toString();
        });
        void withoutNamedXMLCharEntities = var3_2;
        return withoutNamedXMLCharEntities;
    }

    public Object maybeURI(NamespaceBinding nsb, String prefix) {
        while (nsb != null) {
            String string = nsb.prefix();
            String string2 = prefix;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return Maybe$One$.MODULE$.apply(nsb.uri());
            }
            nsb = nsb.parent();
        }
        return Maybe$.MODULE$.Nope();
    }

    public Object maybePrefix(NamespaceBinding nsb, String uri) {
        while (nsb != null) {
            String string = nsb.uri();
            String string2 = uri;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                if (nsb.prefix() == null) {
                    return Maybe$.MODULE$.Nope();
                }
                return Maybe$One$.MODULE$.apply(nsb.prefix());
            }
            nsb = nsb.parent();
        }
        return Maybe$.MODULE$.Nope();
    }

    public Option<Tuple2<URISchemaSource, Object>> resolveSchemaLocation(String schemaLocation, Option<DaffodilSchemaSource> optContextURI) {
        None$ none$;
        boolean uriIsJustPathComponent;
        URI uRI;
        try {
            uRI = new URI(schemaLocation);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(new java.lang.StringBuilder(35).append("schemaLocation is not a valid URI: ").append(schemaLocation).toString(), e);
        }
        URI uri = uRI;
        boolean bl = uriIsJustPathComponent = uri.getScheme() == null && uri.getAuthority() == null && uri.getQuery() == null && uri.getFragment() == null && uri.getPath() != null;
        if (uri.isAbsolute()) {
            try {
                uri.toURL().openStream().close();
                URISchemaSource uss = URISchemaSource$.MODULE$.apply(Misc$.MODULE$.uriToDiagnosticFile(uri), uri);
                none$ = new Some((Object)new Tuple2((Object)uss, (Object)BoxesRunTime.boxToBoolean((boolean)false)));
            }
            catch (IOException e) {
                none$ = None$.MODULE$;
            }
        } else {
            if (!uriIsJustPathComponent) {
                String msg = new java.lang.StringBuilder(67).append("Non-absolute schemaLocation URI can only contain a path component: ").append(schemaLocation).toString();
                throw new IllegalArgumentException(msg);
            }
            if (uri.getPath().startsWith("/")) {
                Option optResolvedAbsolute = None$.MODULE$.orElse((Function0 & Serializable)() -> {
                    URL resource = MODULE$.getClass().getResource(uri.getPath());
                    if (resource != null) {
                        URISchemaSource uss = URISchemaSource$.MODULE$.apply(new File(uri.getPath()), resource.toURI());
                        return new Some((Object)new Tuple2((Object)uss, (Object)BoxesRunTime.boxToBoolean((boolean)false)));
                    }
                    return None$.MODULE$;
                }).orElse((Function0 & Serializable)() -> {
                    File file = Paths.get(uri.getPath(), new String[0]).toFile();
                    if (file.exists()) {
                        URISchemaSource uss = URISchemaSource$.MODULE$.apply(file, file.toURI());
                        return new Some((Object)new Tuple2((Object)uss, (Object)BoxesRunTime.boxToBoolean((boolean)false)));
                    }
                    return None$.MODULE$;
                });
                none$ = optResolvedAbsolute;
            } else {
                if (!optContextURI.isDefined()) {
                    throw Assert$.MODULE$.usageError("optContextURI.isDefined");
                }
                DaffodilSchemaSource contextURI = (DaffodilSchemaSource)optContextURI.get();
                Option optResolvedRelative = None$.MODULE$.orElse((Function0 & Serializable)() -> {
                    Option relativeURI = Misc$.MODULE$.getResourceRelativeOnlyOption(uri.getPath(), contextURI.uriForLoading()).map((Function1 & Serializable)u -> {
                        File contextURIDiagnosticFile = contextURI.diagnosticFile();
                        File relativeDiagnosticFile = contextURIDiagnosticFile.toPath().resolveSibling(Paths.get(uri.getPath(), new String[0])).normalize().toFile();
                        return new Tuple2((Object)URISchemaSource$.MODULE$.apply(relativeDiagnosticFile, (URI)u), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                    });
                    return relativeURI;
                }).orElse((Function0 & Serializable)() -> {
                    String uriPath = new java.lang.StringBuilder(1).append("/").append(uri.getPath()).toString();
                    Option pair = Option$.MODULE$.apply((Object)MODULE$.getClass().getResource(uriPath)).map((Function1 & Serializable)r -> URISchemaSource$.MODULE$.apply(new File(uriPath), r.toURI())).map((Function1 & Serializable)x$29 -> new Tuple2(x$29, (Object)BoxesRunTime.boxToBoolean((boolean)true)));
                    return pair;
                });
                none$ = optResolvedRelative;
            }
        }
        None$ optResolved = none$;
        return optResolved;
    }

    private static final void processText$1(ObjectRef tn$1, ObjectRef sb$1, ArrayBuilder ab$1) {
        if ((Node)tn$1.elem == null) {
            if ((StringBuilder)sb$1.elem != null && ((StringBuilder)sb$1.elem).length() > 0) {
                ab$1.$plus$eq((Object)new Text(((StringBuilder)sb$1.elem).toString()));
                ((StringBuilder)sb$1.elem).clear();
                return;
            }
            return;
        }
        if ((StringBuilder)sb$1.elem != null && ((StringBuilder)sb$1.elem).length() != 0) {
            throw Assert$.MODULE$.abort("Invariant broken: sb.==(null).||(sb.length().==(0))");
        }
        ab$1.$plus$eq((Object)((Node)tn$1.elem));
        tn$1.elem = null;
    }

    public static final /* synthetic */ boolean $anonfun$dfdlAttributes$1(Node n$1, MetaData x$2) {
        String string = x$2.getNamespace(n$1);
        String string2 = MODULE$.DFDL_NAMESPACE().toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$dfdlxAttributes$1(Node n$2, MetaData x$3) {
        String string = x$3.getNamespace(n$2);
        String string2 = MODULE$.DFDLX_NAMESPACE().toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$dafAttributes$1(Node n$3, MetaData a) {
        String string = a.getNamespace(n$3);
        String string2 = MODULE$.EXT_NS_NCSA().toString();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = a.getNamespace(n$3);
        String string4 = MODULE$.EXT_NS_APACHE().toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$removeComments$1(Node x$6) {
        return x$6 instanceof Comment;
    }

    public static final /* synthetic */ boolean $anonfun$removeMixedWhitespace$1(Node x$8) {
        return x$8 instanceof Elem;
    }

    public static final /* synthetic */ boolean $anonfun$removeMixedWhitespace$2(Elem e$1, Node x0$1) {
        Option option;
        String data;
        Option option2;
        Node node = x0$1;
        if (node != null && !(option2 = Text$.MODULE$.unapply((Object)node)).isEmpty() && (data = (String)option2.get()).matches("\\s*")) {
            return false;
        }
        if (node != null && !(option = Text$.MODULE$.unapply((Object)node)).isEmpty()) {
            String data2 = (String)option.get();
            throw new Exception(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Element %s contains mixed data: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{e$1.label(), data2})));
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$removeMixedWhitespace$4(Node x0$2) {
        String string;
        Option option;
        Node node = x0$2;
        return node == null || (option = Text$.MODULE$.unapply((Object)node)).isEmpty() || !"".equals(string = (String)option.get());
    }

    public static final /* synthetic */ NodeSeq $anonfun$removeAttributes1$1(scala.collection.immutable.Seq ns$1, NamespaceBinding newScope$2, Node x$10) {
        return MODULE$.removeAttributes1(x$10, (scala.collection.immutable.Seq<NS>)ns$1, (Option<NamespaceBinding>)new Some((Object)newScope$2));
    }

    public static final /* synthetic */ boolean $anonfun$removeAttributes1$2(Node x1$1, MetaData m) {
        Some some;
        String string;
        Some some2;
        String pre;
        Some some3;
        Some some4;
        boolean bl = false;
        PrefixedAttribute prefixedAttribute = null;
        MetaData metaData = m;
        if (metaData instanceof PrefixedAttribute) {
            bl = true;
            prefixedAttribute = (PrefixedAttribute)metaData;
            Some some5 = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute);
            if (!some5.isEmpty()) {
                String string2;
                Option option;
                String string3 = (String)((Tuple4)some5.get())._2();
                Seq seq = (Seq)((Tuple4)some5.get())._3();
                if ("nil".equals(string3) && seq != null && !(option = Text$.MODULE$.unapply((Object)seq)).isEmpty() && "true".equals(string2 = (String)option.get())) {
                    NS nS = NS$.MODULE$.apply(prefixedAttribute.getNamespace(x1$1));
                    NS nS2 = MODULE$.XSI_NAMESPACE();
                    if (!(nS != null ? !((Object)nS).equals(nS2) : nS2 != null)) {
                        return true;
                    }
                }
            }
        }
        if (bl && !(some4 = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute)).isEmpty()) {
            String string4;
            Option option;
            String string5 = (String)((Tuple4)some4.get())._1();
            String string6 = (String)((Tuple4)some4.get())._2();
            Seq seq = (Seq)((Tuple4)some4.get())._3();
            if ("xsi".equals(string5) && "nil".equals(string6) && seq != null && !(option = Text$.MODULE$.unapply((Object)seq)).isEmpty() && "true".equals(string4 = (String)option.get()) && prefixedAttribute.getNamespace(x1$1) == null) {
                return true;
            }
        }
        if (bl && !(some3 = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute)).isEmpty() && (pre = (String)((Tuple4)some3.get())._1()) != null) {
            String string7 = prefixedAttribute.getNamespace(x1$1);
            String string8 = MODULE$.DAFFODIL_INTERNAL_NAMESPACE().toString();
            if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                String string9 = pre;
                String string10 = "";
                if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                    throw Assert$.MODULE$.abort("Invariant broken: pre.!=(\"\")");
                }
                return false;
            }
        }
        if (bl && !(some2 = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute)).isEmpty() && "type".equals(string = (String)((Tuple4)some2.get())._2())) {
            NS nS = NS$.MODULE$.apply(prefixedAttribute.getNamespace(x1$1));
            NS nS3 = MODULE$.XSI_NAMESPACE();
            if (!(nS != null ? !((Object)nS).equals(nS3) : nS3 != null)) {
                return true;
            }
        }
        if (bl && !(some = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute)).isEmpty()) {
            String string11 = (String)((Tuple4)some.get())._1();
            String string12 = (String)((Tuple4)some.get())._2();
            if ("xsi".equals(string11) && "type".equals(string12)) {
                return true;
            }
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$childArrayCounters$4(Tuple2 x0$2) {
        int n;
        Tuple2 tuple2 = x0$2;
        return tuple2 == null || 1 != (n = tuple2._2$mcI$sp());
    }

    private static final /* synthetic */ String zPath$lzycompute$1(LazyRef zPath$lzy$1, scala.collection.immutable.Seq parentPathSteps$1) {
        String string;
        LazyRef lazyRef = zPath$lzy$1;
        synchronized (lazyRef) {
            string = zPath$lzy$1.initialized() ? (String)zPath$lzy$1.value() : (String)zPath$lzy$1.initialize((Object)((IterableOnceOps)parentPathSteps$1.reverse()).mkString("/"));
        }
        return string;
    }

    private static final String zPath$1(LazyRef zPath$lzy$1, scala.collection.immutable.Seq parentPathSteps$1) {
        if (zPath$lzy$1.initialized()) {
            return (String)zPath$lzy$1.value();
        }
        return XMLUtils$.zPath$lzycompute$1(zPath$lzy$1, parentPathSteps$1);
    }

    public static final /* synthetic */ String $anonfun$computeDiffOne$11(int x$20) {
        return new java.lang.StringBuilder(2).append("[").append(x$20).append("]").toString();
    }

    public static final /* synthetic */ boolean $anonfun$computeDiffOne$13(Node x$21) {
        return x$21 instanceof ProcInstr;
    }

    public static final /* synthetic */ boolean $anonfun$computeDiffOne$14(Node x$22) {
        return x$22 instanceof ProcInstr;
    }

    public static final /* synthetic */ boolean $anonfun$computeDiffOne$16(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            scala.collection.immutable.Seq v = (scala.collection.immutable.Seq)tuple2._2();
            return v.length() > 1;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$computeBlobDiff$3(Path p) {
        return Files.isReadable(p);
    }

    public static final /* synthetic */ boolean $anonfun$computeBlobDiff$5(Path p) {
        return Files.isReadable(p);
    }

    public static final /* synthetic */ boolean $anonfun$computeBlobDiff$7(Tuple2 z) {
        return BoxesRunTime.unboxToByte((Object)z._1()) != BoxesRunTime.unboxToByte((Object)z._2());
    }

    private XMLUtils$() {
    }

    public static final /* synthetic */ Object $anonfun$computeTextDiff$1$adapted(String x$28) {
        return BoxesRunTime.boxToBoolean((boolean)x$28.startsWith("file://"));
    }
}

