/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextZonedSignStyle;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextZonedSignStyle$AsciiCARealiaModified$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextZonedSignStyle$AsciiStandard$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextZonedSignStyle$AsciiTandemModified$;
import org.apache.daffodil.lib.schema.annotation.props.gen.TextZonedSignStyle$AsciiTranslatedEBCDIC$;
import org.apache.daffodil.lib.util.DecimalUtils$OverpunchLocation$;
import org.apache.daffodil.lib.util.PackedSignCodes;
import scala.Enumeration;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class DecimalUtils$ {
    public static final DecimalUtils$ MODULE$ = new DecimalUtils$();
    private static final String B0_to_B9_chars = "^\u00a3\u00a5\u00b7\u00a9\u00a7\u00b6\u00bc\u00bd\u00be";

    public BigInteger packedToBigInteger(byte[] num, PackedSignCodes signCodes) {
        int numDigits = ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(num)) * 2;
        char[] outputData = new char[numDigits - 1];
        int outputPos = 0;
        int offset = 0;
        int signNibble = num[offset + ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(num)) - 1] & 0xF;
        boolean negative = signCodes.negative().contains((Object)BoxesRunTime.boxToInteger((int)signNibble));
        if (!(negative || signCodes.positive().contains((Object)BoxesRunTime.boxToInteger((int)signNibble)) || signCodes.unsigned().contains((Object)BoxesRunTime.boxToInteger((int)signNibble)) || signCodes.zero_sign().contains((Object)BoxesRunTime.boxToInteger((int)signNibble)))) {
            throw new NumberFormatException(new StringBuilder(21).append("Invalid sign nibble: ").append(signNibble).toString());
        }
        while (outputPos < ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.charArrayOps(outputData)) - 1) {
            int highNibble = (num[offset] & 0xFF) >>> 4;
            if (highNibble > 9) {
                throw new NumberFormatException(new StringBuilder(21).append("Invalid high nibble: ").append(highNibble).toString());
            }
            outputData[outputPos] = (char)(highNibble | 0x30);
            ++outputPos;
            int lowNibble = num[offset] & 0xF;
            if (lowNibble > 9) {
                throw new NumberFormatException(new StringBuilder(20).append("Invalid low nibble: ").append(lowNibble).toString());
            }
            outputData[outputPos] = (char)(lowNibble | 0x30);
            ++outputPos;
            ++offset;
        }
        int lastNibble = (num[offset] & 0xFF) >>> 4;
        if (lastNibble > 9) {
            throw new NumberFormatException(new StringBuilder(21).append("Invalid high nibble: ").append(lastNibble).toString());
        }
        outputData[outputPos] = (char)(lastNibble | 0x30);
        BigInteger jbi = new BigInteger(new String(outputData));
        if (negative) {
            return jbi.negate();
        }
        return jbi;
    }

    public BigDecimal packedToBigDecimal(byte[] num, int scale, PackedSignCodes signCodes) {
        return new BigDecimal(this.packedToBigInteger(num, signCodes), scale);
    }

    public Tuple2<Object, Object> packedFromBigIntegerLength(String absBigIntAsString, int minLengthInBits) {
        if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(absBigIntAsString), 0) == '-') {
            throw Assert$.MODULE$.abort("Invariant broken: scala.Predef.augmentString(absBigIntAsString).apply(0).!=('-')");
        }
        int numDigits = absBigIntAsString.length();
        int requiredBitLen = numDigits % 2 == 0 ? (numDigits + 2) * 4 : (numDigits + 1) * 4;
        int bitLen = package$.MODULE$.max(minLengthInBits, requiredBitLen);
        int numBytes = bitLen / 8;
        int leadingZeros = numDigits % 2 == 0 ? bitLen / 4 - numDigits - 1 : bitLen / 4 - numDigits;
        return new Tuple2.mcII.sp(numBytes, leadingZeros);
    }

    public byte[] packedFromBigInteger(BigInteger bigInt, int minLengthInBits, PackedSignCodes signCodes) {
        boolean negative = bigInt.signum() != 1;
        String inChars = bigInt.abs().toString();
        int numDigits = inChars.length();
        Tuple2<Object, Object> tuple2 = this.packedFromBigIntegerLength(inChars, minLengthInBits);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int numBytes = tuple2._1$mcI$sp();
        int leadingZeros = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(numBytes, leadingZeros);
        int numBytes2 = sp2._1$mcI$sp();
        int leadingZeros2 = sp2._2$mcI$sp();
        byte[] outArray = new byte[numBytes2];
        int offset = 0;
        int inPos = 0;
        while (offset * 2 < leadingZeros2 - 1) {
            outArray[offset] = (byte)0;
            ++offset;
        }
        if (numDigits % 2 == 0) {
            outArray[offset] = (byte)(0 + (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), inPos) & 0xF));
            ++inPos;
            ++offset;
        }
        while (inPos < numDigits - 1) {
            int firstNibble = (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), inPos) & 0xF) << 4;
            int secondNibble = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), ++inPos) & 0xF;
            ++inPos;
            outArray[offset] = (byte)(firstNibble + secondNibble);
            ++offset;
        }
        int lastNibble = (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), inPos) & 0xF) << 4;
        int signNibble = negative ? BoxesRunTime.unboxToInt((Object)signCodes.negative().apply(0)) & 0xF : BoxesRunTime.unboxToInt((Object)signCodes.positive().apply(0)) & 0xF;
        outArray[offset] = (byte)(lastNibble + signNibble);
        return outArray;
    }

    public BigInteger bcdToBigInteger(byte[] bcdNum) {
        int numDigits = ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(bcdNum)) * 2;
        char[] outputData = new char[numDigits];
        int outputPos = 0;
        for (int offset = 0; offset < ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(bcdNum)); ++offset) {
            int highNibble = (bcdNum[offset] & 0xFF) >>> 4;
            if (highNibble > 9) {
                throw new NumberFormatException(new StringBuilder(21).append("Invalid high nibble: ").append(highNibble).toString());
            }
            outputData[outputPos] = (char)(highNibble | 0x30);
            ++outputPos;
            int lowNibble = bcdNum[offset] & 0xF;
            if (lowNibble > 9) {
                throw new NumberFormatException(new StringBuilder(20).append("Invalid low nibble: ").append(lowNibble).toString());
            }
            outputData[outputPos] = (char)(lowNibble | 0x30);
            ++outputPos;
        }
        return new BigInteger(new String(outputData));
    }

    public BigDecimal bcdToBigDecimal(byte[] bcdNum, int scale) {
        return new BigDecimal(this.bcdToBigInteger(bcdNum), scale);
    }

    public Tuple2<Object, Object> bcdFromBigIntegerLength(String absBigIntAsString, int minLengthInBits) {
        int numDigits = absBigIntAsString.length();
        int requiredBitLen = numDigits % 2 == 0 ? numDigits * 4 : (numDigits + 1) * 4;
        int bitLen = package$.MODULE$.max(minLengthInBits, requiredBitLen);
        int numBytes = bitLen / 8;
        int leadingZeros = bitLen / 4 - numDigits;
        return new Tuple2.mcII.sp(numBytes, leadingZeros);
    }

    public byte[] bcdFromBigInteger(BigInteger bigInt, int minLengthInBits) {
        String inChars = bigInt.toString();
        int numDigits = inChars.length();
        Tuple2<Object, Object> tuple2 = this.bcdFromBigIntegerLength(inChars, minLengthInBits);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int numBytes = tuple2._1$mcI$sp();
        int leadingZeros = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(numBytes, leadingZeros);
        int numBytes2 = sp2._1$mcI$sp();
        int leadingZeros2 = sp2._2$mcI$sp();
        byte[] outArray = new byte[numBytes2];
        int offset = 0;
        int inPos = 0;
        while (offset * 2 < leadingZeros2 - 1) {
            outArray[offset] = (byte)0;
            ++offset;
        }
        if (inChars.length() % 2 != 0) {
            outArray[offset] = (byte)(0 + (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), inPos) & 0xF));
            ++offset;
            ++inPos;
        }
        while (inPos < inChars.length()) {
            int firstNibble = (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), inPos) & 0xF) << 4;
            int secondNibble = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), ++inPos) & 0xF;
            ++inPos;
            outArray[offset] = (byte)(firstNibble + secondNibble);
            ++offset;
        }
        return outArray;
    }

    public BigInteger ibm4690ToBigInteger(byte[] num) {
        int numDigits = ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(num)) * 2;
        char[] outputData = new char[numDigits];
        int outputPos = 0;
        boolean negative = false;
        boolean inDigits = false;
        for (int offset = 0; offset < ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(num)); ++offset) {
            int lowNibble;
            int highNibble = (num[offset] & 0xFF) >>> 4;
            if (highNibble > 9) {
                outputData[outputPos] = 48;
                if (highNibble == 13 && !inDigits) {
                    negative = true;
                    inDigits = true;
                } else if (highNibble != 15 || inDigits) {
                    throw new NumberFormatException(new StringBuilder(21).append("Invalid high nibble: ").append(highNibble).toString());
                }
                ++outputPos;
            }
            if (highNibble <= 9) {
                inDigits = true;
                outputData[outputPos] = (char)(highNibble | 0x30);
                ++outputPos;
            }
            if ((lowNibble = num[offset] & 0xF) > 9) {
                outputData[outputPos] = 48;
                ++outputPos;
                if (lowNibble == 13 && !inDigits) {
                    negative = true;
                    inDigits = true;
                } else if (lowNibble != 15 || inDigits) {
                    throw new NumberFormatException(new StringBuilder(20).append("Invalid low nibble: ").append(lowNibble).toString());
                }
            }
            if (lowNibble > 9) continue;
            inDigits = true;
            outputData[outputPos] = (char)(lowNibble | 0x30);
            ++outputPos;
        }
        BigInteger jbi = new BigInteger(new String(outputData));
        if (negative) {
            return jbi.negate();
        }
        return jbi;
    }

    public BigDecimal ibm4690ToBigDecimal(byte[] num, int scale) {
        return new BigDecimal(this.ibm4690ToBigInteger(num), scale);
    }

    public Tuple2<Object, Object> ibm4690FromBigIntegerLength(String absBigIntAsString, int minLengthInBits, boolean negative) {
        if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(absBigIntAsString), 0) == '-') {
            throw Assert$.MODULE$.abort("Invariant broken: scala.Predef.augmentString(absBigIntAsString).apply(0).!=('-')");
        }
        int numDigits = negative ? absBigIntAsString.length() + 1 : absBigIntAsString.length();
        int requiredBitLen = numDigits % 2 == 0 ? numDigits * 4 : (numDigits + 1) * 4;
        int bitLen = package$.MODULE$.max(minLengthInBits, requiredBitLen);
        int numBytes = bitLen / 8;
        int leadingZeros = numDigits % 2 == 0 ? bitLen / 4 - numDigits : bitLen / 4 - (numDigits + 1);
        return new Tuple2.mcII.sp(numBytes, leadingZeros);
    }

    public byte[] ibm4690FromBigInteger(BigInteger bigInt, int minLengthInBits) {
        boolean negative = bigInt.signum() != 1;
        String inChars = bigInt.abs().toString();
        int numDigits = negative ? inChars.length() + 1 : inChars.length();
        Tuple2<Object, Object> tuple2 = this.ibm4690FromBigIntegerLength(inChars, minLengthInBits, negative);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int numBytes = tuple2._1$mcI$sp();
        int leadingZeros = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(numBytes, leadingZeros);
        int numBytes2 = sp2._1$mcI$sp();
        int leadingZeros2 = sp2._2$mcI$sp();
        byte[] outArray = new byte[numBytes2];
        boolean wrote_negative = false;
        int offset = 0;
        int inPos = 0;
        while (offset * 2 < leadingZeros2 - 1) {
            outArray[offset] = (byte)255;
            ++offset;
        }
        if (numDigits % 2 != 0) {
            int n;
            int padNibble = 240;
            if (negative) {
                wrote_negative = true;
                n = 13;
            } else {
                n = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), ++inPos - 1) & 0xF;
            }
            int signNibble = n;
            outArray[offset] = (byte)(padNibble + signNibble);
            ++offset;
        }
        while (inPos < numDigits - 1) {
            int n;
            if (negative && !wrote_negative) {
                wrote_negative = true;
                n = 208;
            } else {
                n = (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), ++inPos - 1) & 0xF) << 4;
            }
            int firstNibble = n;
            int secondNibble = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inChars), inPos) & 0xF;
            ++inPos;
            outArray[offset] = (byte)(firstNibble + secondNibble);
            ++offset;
        }
        return outArray;
    }

    private String B0_to_B9_chars() {
        return B0_to_B9_chars;
    }

    public Tuple2<Object, Object> convertFromZonedEBCDIC(char digit) {
        if (digit >= '0' && digit <= '9') {
            return new Tuple2.mcIZ.sp(digit - 48, false);
        }
        if (digit == '{') {
            return new Tuple2.mcIZ.sp(0, false);
        }
        if (digit >= 'A' && digit <= 'I') {
            return new Tuple2.mcIZ.sp(digit - 65 + 1, false);
        }
        if (digit == '}') {
            return new Tuple2.mcIZ.sp(0, true);
        }
        if (digit >= 'J' && digit <= 'R') {
            return new Tuple2.mcIZ.sp(digit - 74 + 1, true);
        }
        int index = this.B0_to_B9_chars().indexOf(digit);
        if (index >= 0) {
            return new Tuple2.mcIZ.sp(index, true);
        }
        throw new NumberFormatException(new StringBuilder(21).append("Invalid zoned digit: ").append(digit).toString());
    }

    public Tuple2<Object, Object> convertFromAsciiStandard(char digit) {
        if (digit >= '0' && digit <= '9') {
            return new Tuple2.mcIZ.sp(digit - 48, false);
        }
        if (digit >= 'p' && digit <= 'y') {
            return new Tuple2.mcIZ.sp(digit - 112, true);
        }
        throw new NumberFormatException(new StringBuilder(21).append("Invalid zoned digit: ").append(digit).toString());
    }

    public char convertToAsciiStandard(char digit, boolean positive) {
        if (positive) {
            return digit;
        }
        return (char)(digit + 64);
    }

    public Tuple2<Object, Object> convertFromAsciiTranslatedEBCDIC(char digit) {
        if (digit == '{') {
            return new Tuple2.mcIZ.sp(0, false);
        }
        if (digit == '}') {
            return new Tuple2.mcIZ.sp(0, true);
        }
        if (digit >= 'A' && digit <= 'I') {
            return new Tuple2.mcIZ.sp(digit - 64, false);
        }
        if (digit >= 'J' && digit <= 'R') {
            return new Tuple2.mcIZ.sp(digit - 73, true);
        }
        if (digit >= '0' && digit <= '9') {
            return new Tuple2.mcIZ.sp(digit - 48, false);
        }
        throw new NumberFormatException(new StringBuilder(21).append("Invalid zoned digit: ").append(digit).toString());
    }

    public char convertToZonedEBCDIC(char digit, boolean positive) {
        int pos = digit - 48;
        if (pos > 9 || pos < 0) {
            throw new NumberFormatException(new StringBuilder(21).append("Invalid zoned digit: ").append(digit).toString());
        }
        if (positive) {
            return "{ABCDEFGHI".charAt(pos);
        }
        return "}JKLMNOPQR".charAt(pos);
    }

    public char convertToAsciiTranslatedEBCDIC(char digit, boolean positive) {
        if (positive) {
            if (digit == '0') {
                return '{';
            }
            return (char)(digit + 16);
        }
        if (digit == '0') {
            return '}';
        }
        return (char)(digit + 25);
    }

    public Tuple2<Object, Object> convertFromAsciiCARealiaModified(char digit) {
        if (digit >= '0' && digit <= '9') {
            return new Tuple2.mcIZ.sp(digit - 48, false);
        }
        if (digit >= ' ' && digit <= ')') {
            return new Tuple2.mcIZ.sp(digit - 32, true);
        }
        throw new NumberFormatException(new StringBuilder(21).append("Invalid zoned digit: ").append(digit).toString());
    }

    public char convertToAsciiCARealiaModified(char digit, boolean positive) {
        if (positive) {
            return digit;
        }
        return (char)(digit - 16);
    }

    public Tuple2<Object, Object> convertFromAsciiTandemModified(char digit) {
        if (digit >= '0' && digit <= '9') {
            return new Tuple2.mcIZ.sp(digit - 48, false);
        }
        if (digit >= '\u0080' && digit <= '\u0089') {
            return new Tuple2.mcIZ.sp(digit - 128, true);
        }
        throw new NumberFormatException(new StringBuilder(21).append("Invalid zoned digit: ").append(digit).toString());
    }

    public char convertToAsciiTandemModified(char digit, boolean positive) {
        if (positive) {
            return digit;
        }
        return (char)(digit + 80);
    }

    /*
     * Unable to fully structure code
     */
    public String zonedToNumber(String num, Option<TextZonedSignStyle> optZonedStyle, Enumeration.Value opl) {
        block16: {
            block18: {
                block17: {
                    block15: {
                        var9_4 = opl;
                        v0 = DecimalUtils$OverpunchLocation$.MODULE$.Start();
                        var10_5 = var9_4;
                        if (!(v0 != null ? v0.equals(var10_5) == false : var10_5 != null)) {
                            v1 = 0;
                        } else {
                            v2 = DecimalUtils$OverpunchLocation$.MODULE$.End();
                            var11_6 = var9_4;
                            v1 = !(v2 != null ? v2.equals(var11_6) == false : var11_6 != null) ? num.length() - 1 : -1;
                        }
                        opindex = v1;
                        v3 = opl;
                        var13_8 = DecimalUtils$OverpunchLocation$.MODULE$.None();
                        if (v3 != null ? v3.equals(var13_8) == false : var13_8 != null) break block15;
                        v4 = num;
                        break block16;
                    }
                    var16_9 = false;
                    var17_10 = null;
                    var18_11 = optZonedStyle;
                    if (!None$.MODULE$.equals(var18_11)) break block17;
                    v5 = this.convertFromZonedEBCDIC(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(num), opindex));
                    break block18;
                }
                if (!(var18_11 instanceof Some)) ** GOTO lbl-1000
                var16_9 = true;
                var17_10 = (Some)var18_11;
                var19_12 = (TextZonedSignStyle)var17_10.value();
                if (TextZonedSignStyle$AsciiStandard$.MODULE$.equals(var19_12)) {
                    v5 = this.convertFromAsciiStandard(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(num), opindex));
                } else if (var16_9 && TextZonedSignStyle$AsciiTranslatedEBCDIC$.MODULE$.equals(var20_13 = (TextZonedSignStyle)var17_10.value())) {
                    v5 = this.convertFromAsciiTranslatedEBCDIC(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(num), opindex));
                } else if (var16_9 && TextZonedSignStyle$AsciiCARealiaModified$.MODULE$.equals(var21_14 = (TextZonedSignStyle)var17_10.value())) {
                    v5 = this.convertFromAsciiCARealiaModified(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(num), opindex));
                } else if (var16_9 && TextZonedSignStyle$AsciiTandemModified$.MODULE$.equals(var22_15 = (TextZonedSignStyle)var17_10.value())) {
                    v5 = this.convertFromAsciiTandemModified(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(num), opindex));
                } else {
                    throw new MatchError(var18_11);
                }
            }
            var15_16 = v5;
            if (var15_16 == null) {
                throw new MatchError(var15_16);
            }
            digit = var15_16._1$mcI$sp();
            opneg = var15_16._2$mcZ$sp();
            var14_19 = new Tuple2.mcIZ.sp(digit, opneg);
            digit = var14_19._1$mcI$sp();
            opneg = var14_19._2$mcZ$sp();
            var28_22 = opl;
            v6 = DecimalUtils$OverpunchLocation$.MODULE$.Start();
            var29_23 = var28_22;
            if (!(v6 != null ? v6.equals(var29_23) == false : var29_23 != null)) {
                v7 = new StringBuilder(0).append(Integer.toString(digit)).append(num.substring(1)).toString();
            } else {
                v8 = DecimalUtils$OverpunchLocation$.MODULE$.End();
                var30_24 = var28_22;
                if (!(v8 != null ? v8.equals(var30_24) == false : var30_24 != null)) {
                    v7 = new StringBuilder(0).append(num.substring(0, opindex)).append(digit).toString();
                } else {
                    throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
                }
            }
            allDigits = v7;
            v4 = convertedNum = opneg != false ? new StringBuilder(1).append("-").append(allDigits).toString() : allDigits;
        }
        decodedValue = v4;
        return decodedValue;
    }

    /*
     * Unable to fully structure code
     */
    public String zonedFromNumber(String num, Option<TextZonedSignStyle> optZonedStyle, Enumeration.Value opl) {
        block20: {
            block22: {
                block21: {
                    block19: {
                        positive = num.charAt(0) != '-';
                        var10_5 = positive;
                        if (var10_5) {
                            v0 = num;
                        } else if (!var10_5) {
                            v0 = num.substring(1);
                        } else {
                            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)var10_5));
                        }
                        inStr = v0;
                        var12_7 = opl;
                        v1 = DecimalUtils$OverpunchLocation$.MODULE$.Start();
                        var13_8 = var12_7;
                        if (!(v1 != null ? v1.equals(var13_8) == false : var13_8 != null)) {
                            v2 = 0;
                        } else {
                            v3 = DecimalUtils$OverpunchLocation$.MODULE$.End();
                            var14_9 = var12_7;
                            v2 = !(v3 != null ? v3.equals(var14_9) == false : var14_9 != null) ? inStr.length() - 1 : -1;
                        }
                        opindex = v2;
                        v4 = opl;
                        var16_11 = DecimalUtils$OverpunchLocation$.MODULE$.None();
                        if (v4 != null ? v4.equals(var16_11) == false : var16_11 != null) break block19;
                        if (!positive) {
                            throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
                        }
                        v5 = inStr;
                        break block20;
                    }
                    var18_12 = false;
                    var19_13 = null;
                    var20_14 = optZonedStyle;
                    if (!None$.MODULE$.equals(var20_14)) break block21;
                    v6 = this.convertToZonedEBCDIC(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inStr), opindex), positive);
                    break block22;
                }
                if (!(var20_14 instanceof Some)) ** GOTO lbl-1000
                var18_12 = true;
                var19_13 = (Some)var20_14;
                var21_15 = (TextZonedSignStyle)var19_13.value();
                if (TextZonedSignStyle$AsciiStandard$.MODULE$.equals(var21_15)) {
                    v6 = this.convertToAsciiStandard(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inStr), opindex), positive);
                } else if (var18_12 && TextZonedSignStyle$AsciiTranslatedEBCDIC$.MODULE$.equals(var22_16 = (TextZonedSignStyle)var19_13.value())) {
                    v6 = this.convertToAsciiTranslatedEBCDIC(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inStr), opindex), positive);
                } else if (var18_12 && TextZonedSignStyle$AsciiCARealiaModified$.MODULE$.equals(var23_17 = (TextZonedSignStyle)var19_13.value())) {
                    v6 = this.convertToAsciiCARealiaModified(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inStr), opindex), positive);
                } else if (var18_12 && TextZonedSignStyle$AsciiTandemModified$.MODULE$.equals(var24_18 = (TextZonedSignStyle)var19_13.value())) {
                    v6 = this.convertToAsciiTandemModified(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(inStr), opindex), positive);
                } else {
                    throw new MatchError(var20_14);
                }
            }
            digit = v6;
            var26_20 = opl;
            v7 = DecimalUtils$OverpunchLocation$.MODULE$.Start();
            var27_21 = var26_20;
            if (!(v7 != null ? v7.equals(var27_21) == false : var27_21 != null)) {
                var28_22 = digit;
                v8 = StringOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.augmentString(inStr.substring(1)), var28_22);
            } else {
                v9 = DecimalUtils$OverpunchLocation$.MODULE$.End();
                var29_23 = var26_20;
                if (!(v9 != null ? v9.equals(var29_23) == false : var29_23 != null)) {
                    v8 = new StringBuilder(0).append(inStr.substring(0, opindex)).append(digit).toString();
                } else {
                    throw Assert$.MODULE$.impossible(Assert$.MODULE$.impossible$default$1());
                }
            }
            v5 = convertedNum = v8;
        }
        encodedValue = v5;
        return encodedValue;
    }

    private DecimalUtils$() {
    }
}

