/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe.metrics;

import cats.effect.unsafe.LocalQueue;
import cats.effect.unsafe.TimerHeap;
import cats.effect.unsafe.WorkStealingThreadPool;
import cats.effect.unsafe.WorkerThread;
import cats.effect.unsafe.metrics.LocalQueueMetrics;
import cats.effect.unsafe.metrics.PollerMetrics;
import cats.effect.unsafe.metrics.TimerHeapMetrics;
import cats.effect.unsafe.metrics.WorkStealingThreadPoolMetrics;
import cats.effect.unsafe.metrics.WorkerThreadMetrics;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.math.Integral;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;

public final class WorkStealingThreadPoolMetrics$
implements Serializable {
    public static final WorkStealingThreadPoolMetrics$ MODULE$ = new WorkStealingThreadPoolMetrics$();

    private WorkStealingThreadPoolMetrics$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(WorkStealingThreadPoolMetrics$.class);
    }

    public Option<WorkStealingThreadPoolMetrics> apply(ExecutionContext ec) {
        ExecutionContext executionContext = ec;
        if (executionContext instanceof WorkStealingThreadPool) {
            WorkStealingThreadPool wstp = (WorkStealingThreadPool)executionContext;
            return Some$.MODULE$.apply((Object)this.workStealingThreadPoolMetrics(wstp));
        }
        return None$.MODULE$;
    }

    private WorkStealingThreadPoolMetrics workStealingThreadPoolMetrics(WorkStealingThreadPool<? extends Object> wstp) {
        return new WorkStealingThreadPoolMetrics(wstp){
            private final WorkStealingThreadPool wstp$3;
            private final String identifier;
            private final List workerThreads;
            {
                this.wstp$3 = wstp$1;
                this.identifier = BoxesRunTime.boxToLong((long)wstp$1.id()).toString();
                this.workerThreads = ((List)package$.MODULE$.List().range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)this.workerThreadCount()), (Integral)Numeric.IntIsIntegral$.MODULE$)).map(arg_0 -> WorkStealingThreadPoolMetrics$.cats$effect$unsafe$metrics$WorkStealingThreadPoolMetrics$$anon$1$$_$$lessinit$greater$$anonfun$adapted$1(wstp$1, arg_0));
            }

            public String identifier() {
                return this.identifier;
            }

            public int workerThreadCount() {
                return this.wstp$3.getWorkerThreadCount();
            }

            public int activeThreadCount() {
                return this.wstp$3.getActiveThreadCount();
            }

            public int searchingThreadCount() {
                return this.wstp$3.getSearchingThreadCount();
            }

            public int blockedWorkerThreadCount() {
                return this.wstp$3.getBlockedWorkerThreadCount();
            }

            public long localQueueFiberCount() {
                return this.wstp$3.getLocalQueueFiberCount();
            }

            public long suspendedFiberCount() {
                return this.wstp$3.getSuspendedFiberCount();
            }

            public List workerThreads() {
                return this.workerThreads;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{cats$effect$unsafe$metrics$WorkStealingThreadPoolMetrics$$anon$1$$_$$lessinit$greater$$anonfun$adapted$1(cats.effect.unsafe.WorkStealingThreadPool java.lang.Object )}, serializedLambda);
            }
        };
    }

    private <P> WorkerThreadMetrics workerThreadMetrics(WorkStealingThreadPool<P> wstp, int idx) {
        return new WorkerThreadMetrics(idx, wstp){
            private final int index;
            private final WorkerThread.Metrics metrics;
            private final LocalQueueMetrics localQueue;
            private final TimerHeapMetrics timerHeap;
            private final PollerMetrics poller;
            {
                this.index = idx$1;
                this.metrics = wstp$4.metrices()[idx$1];
                this.localQueue = WorkStealingThreadPoolMetrics$.MODULE$.cats$effect$unsafe$metrics$WorkStealingThreadPoolMetrics$$$localQueueMetrics(wstp$4.localQueues()[this.index()]);
                this.timerHeap = WorkStealingThreadPoolMetrics$.MODULE$.cats$effect$unsafe$metrics$WorkStealingThreadPoolMetrics$$$timerHeapMetrics(wstp$4.sleepers()[this.index()]);
                this.poller = wstp$4.system().metrics(wstp$4.pollers()[this.index()]);
            }

            public int index() {
                return this.index;
            }

            public long idleTime() {
                return this.metrics.getIdleTime();
            }

            public long parkedCount() {
                return this.metrics.getParkedCount();
            }

            public long polledCount() {
                return this.metrics.getPolledCount();
            }

            public long blockingCount() {
                return this.metrics.getBlockingCount();
            }

            public long respawnCount() {
                return this.metrics.getRespawnCount();
            }

            public LocalQueueMetrics localQueue() {
                return this.localQueue;
            }

            public TimerHeapMetrics timerHeap() {
                return this.timerHeap;
            }

            public PollerMetrics poller() {
                return this.poller;
            }
        };
    }

    public LocalQueueMetrics cats$effect$unsafe$metrics$WorkStealingThreadPoolMetrics$$$localQueueMetrics(LocalQueue queue) {
        return new LocalQueueMetrics(queue){
            private final LocalQueue queue$1;
            {
                this.queue$1 = queue$2;
            }

            public int fiberCount() {
                return this.queue$1.getFiberCount();
            }

            public long totalFiberCount() {
                return this.queue$1.getTotalFiberCount();
            }

            public long totalSpilloverCount() {
                return this.queue$1.getTotalSpilloverCount();
            }

            public long successfulStealAttemptCount() {
                return this.queue$1.getSuccessfulStealAttemptCount();
            }

            public long stolenFiberCount() {
                return this.queue$1.getStolenFiberCount();
            }
        };
    }

    public TimerHeapMetrics cats$effect$unsafe$metrics$WorkStealingThreadPoolMetrics$$$timerHeapMetrics(TimerHeap timerHeap) {
        return new TimerHeapMetrics(timerHeap){
            private final TimerHeap timerHeap$1;
            {
                this.timerHeap$1 = timerHeap$2;
            }

            public Option nextTimerDue() {
                return this.timerHeap$1.nextTimerDue();
            }

            public int timersOutstandingCount() {
                return this.timerHeap$1.outstandingTimers();
            }

            public long totalTimersExecutedCount() {
                return this.timerHeap$1.totalTimersExecuted();
            }

            public long totalTimersScheduledCount() {
                return this.timerHeap$1.totalTimersScheduled();
            }

            public long totalTimersCanceledCount() {
                return this.timerHeap$1.totalTimersCanceled();
            }

            public long packCount() {
                return this.timerHeap$1.packCount();
            }
        };
    }

    public static /* bridge */ /* synthetic */ WorkerThreadMetrics cats$effect$unsafe$metrics$WorkStealingThreadPoolMetrics$$anon$1$$_$$lessinit$greater$$anonfun$adapted$1(WorkStealingThreadPool wstp$5, Object _$1) {
        return WorkStealingThreadPoolMetrics$.MODULE$.workerThreadMetrics(wstp$5, BoxesRunTime.unboxToInt((Object)_$1));
    }
}

