/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe.metrics;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.unsafe.metrics.CpuStarvationSampler$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.runtime.BoxedUnit;

public final class CpuStarvationSampler {
    private final AtomicLong counter;
    private final AtomicLong clockDriftCurrent;
    private final AtomicLong clockDriftMax;

    public static CpuStarvationSampler apply() {
        return CpuStarvationSampler$.MODULE$.apply();
    }

    public CpuStarvationSampler(AtomicLong counter, AtomicLong clockDriftCurrent, AtomicLong clockDriftMax) {
        this.counter = counter;
        this.clockDriftCurrent = clockDriftCurrent;
        this.clockDriftMax = clockDriftMax;
    }

    public long cpuStarvationCount() {
        return this.counter.get();
    }

    public long clockDriftCurrentMs() {
        return this.clockDriftCurrent.get();
    }

    public long clockDriftMaxMs() {
        return this.clockDriftMax.get();
    }

    public IO<BoxedUnit> incCpuStarvationCount() {
        return IO$.MODULE$.delay((Function0 & Serializable)() -> {
            this.incCpuStarvationCount$$anonfun$1();
            return BoxedUnit.UNIT;
        });
    }

    public IO<BoxedUnit> recordClockDrift(FiniteDuration drift) {
        long driftMs = drift.toMillis();
        IO<BoxedUnit> maxDrift = driftMs > 0L ? IO$.MODULE$.delay((Function0 & Serializable)() -> {
            this.$anonfun$1(driftMs);
            return BoxedUnit.UNIT;
        }) : IO$.MODULE$.unit();
        return IO$.MODULE$.delay((Function0 & Serializable)() -> {
            this.recordClockDrift$$anonfun$1(driftMs);
            return BoxedUnit.UNIT;
        }).$greater$greater(() -> CpuStarvationSampler.recordClockDrift$$anonfun$2(maxDrift));
    }

    private final void incCpuStarvationCount$$anonfun$1() {
        this.counter.incrementAndGet();
    }

    private final void $anonfun$1(long driftMs$1) {
        this.clockDriftMax.updateAndGet(_$1 -> package$.MODULE$.max(_$1, driftMs$1));
    }

    private final void recordClockDrift$$anonfun$1(long driftMs$3) {
        this.clockDriftCurrent.set(driftMs$3);
    }

    private static final IO recordClockDrift$$anonfun$2(IO maxDrift$1) {
        return maxDrift$1;
    }
}

