/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.Trace;
import cats.effect.tracing.Tracing;
import cats.effect.tracing.TracingConstants;
import cats.effect.unsafe.LocalQueue;
import cats.effect.unsafe.PollingSystem;
import cats.effect.unsafe.ScalQueue;
import cats.effect.unsafe.Scheduler;
import cats.effect.unsafe.TimerHeap;
import cats.effect.unsafe.UnsafeNonFatal;
import cats.effect.unsafe.UnsealedPollingContext;
import cats.effect.unsafe.WeakBag;
import cats.effect.unsafe.WorkStealingThreadPool$;
import cats.effect.unsafe.WorkStealingThreadPoolConstants;
import cats.effect.unsafe.WorkerThread;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Right;

public final class WorkStealingThreadPool<P>
implements ExecutionContextExecutor,
Scheduler,
UnsealedPollingContext<P> {
    private final int threadCount;
    private final String threadPrefix;
    private final String blockerThreadPrefix;
    private final Duration runtimeBlockingExpiration;
    private final boolean blockedThreadDetectionEnabled;
    private final Duration shutdownTimeout;
    private final PollingSystem system;
    private final Function1<Throwable, BoxedUnit> reportFailure0;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final long id;
    private final AtomicReferenceArray<WorkerThread<P>> workerThreads;
    private final LocalQueue[] localQueues;
    private final TimerHeap[] sleepers;
    private final AtomicBoolean[] parkedSignals;
    private final WeakBag[] fiberBags;
    private final Object[] pollers;
    private final WorkerThread.Metrics[] metrices;
    private final ScalQueue<Object> externalQueue;
    private final AtomicInteger state;
    private final LinkedTransferQueue cachedThreads;
    private final AtomicBoolean done;
    private final AtomicInteger blockedWorkerThreadCounter;
    private final AtomicInteger blockedWorkerThreadNamingIndex;

    public WorkStealingThreadPool(int threadCount, String threadPrefix, String blockerThreadPrefix, Duration runtimeBlockingExpiration, boolean blockedThreadDetectionEnabled, Duration shutdownTimeout, PollingSystem system, Function1<Throwable, BoxedUnit> reportFailure0, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        int i;
        this.threadCount = threadCount;
        this.threadPrefix = threadPrefix;
        this.blockerThreadPrefix = blockerThreadPrefix;
        this.runtimeBlockingExpiration = runtimeBlockingExpiration;
        this.blockedThreadDetectionEnabled = blockedThreadDetectionEnabled;
        this.shutdownTimeout = shutdownTimeout;
        this.system = system;
        this.reportFailure0 = reportFailure0;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        ExecutionContext.$init$((ExecutionContext)this);
        this.id = WorkStealingThreadPool$.cats$effect$unsafe$WorkStealingThreadPool$$$IdCounter.getAndIncrement();
        this.workerThreads = new AtomicReferenceArray(threadCount);
        this.localQueues = new LocalQueue[threadCount];
        this.sleepers = new TimerHeap[threadCount];
        this.parkedSignals = new AtomicBoolean[threadCount];
        this.fiberBags = new WeakBag[threadCount];
        this.pollers = new Object[threadCount];
        this.metrices = new WorkerThread.Metrics[threadCount];
        this.externalQueue = new ScalQueue(threadCount << 2);
        this.state = new AtomicInteger(threadCount << 16);
        this.cachedThreads = new LinkedTransferQueue();
        this.done = new AtomicBoolean(false);
        this.blockedWorkerThreadCounter = new AtomicInteger(0);
        this.blockedWorkerThreadNamingIndex = new AtomicInteger(0);
        for (i = 0; i < threadCount; ++i) {
            WorkerThread.Metrics metrics;
            AtomicBoolean parkedSignal;
            TimerHeap sleepersHeap;
            LocalQueue queue;
            this.localQueues()[i] = queue = new LocalQueue();
            this.sleepers()[i] = sleepersHeap = new TimerHeap();
            this.parkedSignals()[i] = parkedSignal = new AtomicBoolean(false);
            int index = i;
            WeakBag<Runnable> fiberBag = new WeakBag<Runnable>();
            this.fiberBags()[i] = fiberBag;
            Object poller = system.makePoller();
            this.pollers()[i] = poller;
            this.metrices()[i] = metrics = new WorkerThread.Metrics();
            WorkerThread<Object> thread = new WorkerThread<Object>(index, 0, queue, parkedSignal, this.externalQueue, fiberBag, sleepersHeap, system, poller, metrics, new WorkerThread.TransferState(), this);
            this.workerThreads.set(i, thread);
        }
        for (i = 0; i < threadCount; ++i) {
            ((Thread)this.workerThreads.get(i)).start();
        }
    }

    public String threadPrefix() {
        return this.threadPrefix;
    }

    public String blockerThreadPrefix() {
        return this.blockerThreadPrefix;
    }

    public Duration runtimeBlockingExpiration() {
        return this.runtimeBlockingExpiration;
    }

    public boolean blockedThreadDetectionEnabled() {
        return this.blockedThreadDetectionEnabled;
    }

    public PollingSystem system() {
        return this.system;
    }

    public Thread.UncaughtExceptionHandler uncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public long id() {
        return this.id;
    }

    public LocalQueue[] localQueues() {
        return this.localQueues;
    }

    public TimerHeap[] sleepers() {
        return this.sleepers;
    }

    public AtomicBoolean[] parkedSignals() {
        return this.parkedSignals;
    }

    public WeakBag<Runnable>[] fiberBags() {
        return this.fiberBags;
    }

    public P[] pollers() {
        return this.pollers;
    }

    public WorkerThread.Metrics[] metrices() {
        return this.metrices;
    }

    @Override
    public void accessPoller(Function1<P, BoxedUnit> cb) {
        Thread thread = Thread.currentThread();
        WorkStealingThreadPool pool = this;
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            if (worker.isOwnedBy(pool)) {
                cb.apply(worker.poller());
                return;
            }
            this.scheduleExternal(() -> this.accessPoller(cb));
            return;
        }
        this.scheduleExternal(() -> this.accessPoller(cb));
    }

    @Override
    public boolean ownPoller(P poller) {
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            return worker.ownsPoller(poller);
        }
        return false;
    }

    public LinkedTransferQueue<WorkerThread<P>> cachedThreads() {
        return this.cachedThreads;
    }

    public AtomicBoolean done() {
        return this.done;
    }

    public AtomicInteger blockedWorkerThreadCounter() {
        return this.blockedWorkerThreadCounter;
    }

    public AtomicInteger blockedWorkerThreadNamingIndex() {
        return this.blockedWorkerThreadNamingIndex;
    }

    public WorkerThread<P> getWorkerThread(int index) {
        return this.workerThreads.get(index);
    }

    public Runnable stealFromOtherWorkerThread(int dest, ThreadLocalRandom random, WorkerThread<P> destWorker) {
        LocalQueue destQueue = this.localQueues()[dest];
        int from = random.nextInt(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            Runnable res;
            int index = (from + i) % this.threadCount;
            if (index == dest || (res = this.localQueues()[index].stealInto(destQueue, destWorker)) == null) continue;
            return res;
        }
        Object element = this.externalQueue.poll(random);
        if (element instanceof Runnable[]) {
            Runnable[] batch = (Runnable[])element;
            return destQueue.enqueueBatch(batch, destWorker);
        }
        if (element instanceof Runnable) {
            Runnable fiber = (Runnable)element;
            if (TracingConstants.isStackTracing) {
                destWorker.active_$eq(fiber);
                this.parkedSignals()[dest].lazySet(false);
            }
            return fiber;
        }
        return null;
    }

    public boolean stealTimers(long now, ThreadLocalRandom random) {
        int from = random.nextInt(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            int index = (from + i) % this.threadCount;
            boolean invoked = this.sleepers()[index].steal(now);
            if (!invoked) continue;
            return true;
        }
        return false;
    }

    public boolean notifyParked(ThreadLocalRandom random) {
        if (!this.notifyShouldWakeup()) {
            return false;
        }
        int from = random.nextInt(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            int index = (from + i) % this.threadCount;
            AtomicBoolean signal = this.parkedSignals()[index];
            if (!signal.getAndSet(false)) continue;
            this.state.getAndAdd(WorkStealingThreadPoolConstants.DeltaSearching);
            WorkerThread<P> worker = this.workerThreads.get(index);
            this.system().interrupt(worker, this.pollers()[index]);
            return true;
        }
        return false;
    }

    private boolean notifyShouldWakeup() {
        int st = this.state.get();
        return (st & WorkStealingThreadPoolConstants.SearchMask) == 0 && (st & WorkStealingThreadPoolConstants.UnparkMask) >>> 16 < this.threadCount;
    }

    public void notifyIfWorkPending(ThreadLocalRandom random) {
        for (int i = 0; i < this.threadCount; ++i) {
            if (!this.localQueues()[i].nonEmpty()) continue;
            this.notifyParked(random);
            return;
        }
        if (this.externalQueue.nonEmpty()) {
            this.notifyParked(random);
            return;
        }
    }

    public boolean transitionWorkerToSearching() {
        int st = this.state.get();
        if (2 * (st & WorkStealingThreadPoolConstants.SearchMask) >= this.threadCount) {
            return false;
        }
        this.state.getAndIncrement();
        return true;
    }

    public void transitionWorkerFromSearching(ThreadLocalRandom random) {
        int prev = this.state.getAndDecrement();
        if (prev == 1) {
            this.notifyParked(random);
            return;
        }
    }

    public boolean transitionWorkerToParkedWhenSearching() {
        int prev = this.state.getAndAdd(-WorkStealingThreadPoolConstants.DeltaSearching);
        return (prev & WorkStealingThreadPoolConstants.SearchMask) == 1;
    }

    public void transitionWorkerToParked() {
        this.state.getAndAdd(-WorkStealingThreadPoolConstants.DeltaNotSearching);
    }

    public void doneSleeping() {
        this.state.getAndAdd(WorkStealingThreadPoolConstants.DeltaSearching);
    }

    public void replaceWorker(int index, WorkerThread<P> newWorker) {
        this.workerThreads.lazySet(index, newWorker);
    }

    public void reschedule(Runnable runnable) {
        WorkStealingThreadPool pool = this;
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            if (worker.isOwnedBy(pool)) {
                worker.reschedule(runnable);
                return;
            }
            this.scheduleExternal(runnable);
            return;
        }
        this.scheduleExternal(runnable);
    }

    public boolean canExecuteBlockingCode() {
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            return worker.canExecuteBlockingCodeOn(this);
        }
        return false;
    }

    public void prepareForBlocking() {
        Thread thread = Thread.currentThread();
        WorkerThread worker = (WorkerThread)thread;
        worker.prepareForBlocking();
    }

    private void scheduleExternal(Runnable fiber) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.externalQueue.offer(fiber, random);
        this.notifyParked(random);
    }

    public Tuple3<Map<Runnable, Trace>, Map<WorkerThread<P>, Tuple3<Thread.State, Option<Tuple2<Runnable, Trace>>, Map<Runnable, Trace>>>, Map<Runnable, Trace>> liveTraces() {
        Map externalFibers = this.externalQueue.snapshot().iterator().flatMap((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof Runnable[]) {
                Object[] batch = (Runnable[])object;
                Object object2 = Predef$.MODULE$.refArrayOps(batch);
                return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(object2, (Function1 & Serializable)r -> Tracing.captureTrace(r), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            if (object instanceof Runnable) {
                Runnable r2 = (Runnable)object;
                return Option$.MODULE$.option2Iterable(Tracing.captureTrace(r2)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            return Predef$.MODULE$.Map().empty();
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.mutable.Map map = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        scala.collection.mutable.Map suspended = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        for (int i = 0; i < this.threadCount; ++i) {
            Map localFibers = this.localQueues()[i].snapshot().iterator().flatMap((Function1 & Serializable)r -> Tracing.captureTrace(r)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            WorkerThread<P> worker = this.workerThreads.get(i);
            boolean bl = this.parkedSignals()[i].get();
            Option active = Option$.MODULE$.apply((Object)worker.active());
            WorkerThread workerThread = (WorkerThread)Predef$.MODULE$.ArrowAssoc(worker);
            map.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)workerThread, (Object)Tuple3$.MODULE$.apply((Object)worker.getState(), (Object)active.flatMap((Function1 & Serializable)a -> Tracing.captureTrace(a)), (Object)localFibers)));
            suspended.$plus$plus$eq(worker.suspendedTraces());
        }
        return Tuple3$.MODULE$.apply((Object)externalFibers, (Object)map.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)suspended.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public void execute(Runnable runnable) {
        WorkStealingThreadPool pool = this;
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            if (worker.isOwnedBy(pool)) {
                worker.schedule(runnable);
                return;
            }
            this.scheduleExternal(runnable);
            return;
        }
        this.scheduleExternal(runnable);
    }

    public void reportFailure(Throwable cause) {
        this.reportFailure0.apply((Object)cause);
    }

    @Override
    public long monotonicNanos() {
        long back = System.nanoTime();
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            ((WorkerThread)thread).now_$eq(back);
        }
        return back;
    }

    @Override
    public long nowMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long nowMicros() {
        Instant now = Instant.now();
        return now.getEpochSecond() * 1000000L + now.getLong(ChronoField.MICRO_OF_SECOND);
    }

    public Runnable sleepInternal(FiniteDuration delay, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback) {
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            if (worker.isOwnedBy(this)) {
                return worker.sleep(delay, callback);
            }
            return this.sleepExternal(delay, callback);
        }
        return this.sleepExternal(delay, callback);
    }

    private final Runnable sleepExternal(FiniteDuration delay, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback) {
        long scheduledAt = this.monotonicNanos();
        ExternalSleepCancel cancel = new ExternalSleepCancel();
        this.scheduleExternal(() -> {
            WorkerThread worker = (WorkerThread)Thread.currentThread();
            cancel.setCallback((Function0<BoxedUnit>)((Function0)worker.sleepLate(scheduledAt, delay, callback)));
        });
        return cancel;
    }

    @Override
    public Runnable sleep(FiniteDuration delay, Runnable task) {
        Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> cb = new Function1<Right<Nothing$, BoxedUnit>, BoxedUnit>(task, this){
            private final Runnable task$1;
            private final /* synthetic */ WorkStealingThreadPool $outer;
            {
                this.task$1 = task$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void apply(Right ru) {
                if (this.compareAndSet(false, true)) {
                    try {
                        this.task$1.run();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable ex = throwable2 = throwable;
                        if (UnsafeNonFatal.apply(ex)) {
                            this.$outer.reportFailure(ex);
                        }
                        throw throwable;
                    }
                    return;
                }
            }
        };
        Runnable cancel = this.sleepInternal(delay, (Function1<Right<Nothing$, BoxedUnit>, BoxedUnit>)((Function1)cb));
        return () -> WorkStealingThreadPool.sleep$$anonfun$1((AtomicBoolean)cb, cancel);
    }

    public void shutdown() {
        boolean interruptCalling = Thread.interrupted();
        Thread currentThread = Thread.currentThread();
        if (this.done().compareAndSet(false, true)) {
            long joinTimeout;
            long l;
            int i;
            for (i = 0; i < this.threadCount; ++i) {
                WorkerThread<P> workerThread = this.workerThreads.get(i);
                if (workerThread == currentThread) continue;
                this.system().interrupt(workerThread, this.pollers()[i]);
                workerThread.interrupt();
            }
            i = 0;
            Duration duration = this.shutdownTimeout;
            Duration.Infinite infinite = Duration$.MODULE$.Inf();
            Duration duration2 = duration;
            if (!(infinite != null ? !infinite.equals(duration2) : duration2 != null)) {
                l = Long.MAX_VALUE;
            } else {
                Duration d = duration;
                l = joinTimeout = d.toNanos();
            }
            while (i < this.threadCount && joinTimeout > 0L) {
                WorkerThread<P> workerThread = this.workerThreads.get(i);
                if (workerThread != currentThread) {
                    long now = System.nanoTime();
                    workerThread.join(joinTimeout / 1000000L, (int)(joinTimeout % 1000000L));
                    long elapsed = System.nanoTime() - now;
                    joinTimeout -= elapsed;
                }
                ++i;
            }
            boolean allClosed = true;
            for (i = 0; i < this.threadCount; ++i) {
                WorkerThread<P> workerThread = this.workerThreads.get(i);
                if (workerThread == currentThread || !workerThread.isAlive()) {
                    this.system().closePoller(this.pollers()[i]);
                    continue;
                }
                allClosed = false;
            }
            if (allClosed) {
                this.system().close();
            }
            WorkerThread<P> t = null;
            while ((t = this.cachedThreads().poll()) != null) {
                t.interrupt();
            }
            this.externalQueue.clear();
            if (interruptCalling) {
                currentThread.interrupt();
                return;
            }
            return;
        }
    }

    public int getWorkerThreadCount() {
        return this.threadCount;
    }

    public int getActiveThreadCount() {
        int st = this.state.get();
        return (st & WorkStealingThreadPoolConstants.UnparkMask) >>> 16;
    }

    public int getSearchingThreadCount() {
        int st = this.state.get();
        return st & WorkStealingThreadPoolConstants.SearchMask;
    }

    public int getBlockedWorkerThreadCount() {
        return this.blockedWorkerThreadCounter().get();
    }

    public long getLocalQueueFiberCount() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.localQueues());
        return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> _$1.size(), ClassTag$.MODULE$.apply(Long.TYPE))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long getSuspendedFiberCount() {
        long sum = 0L;
        for (int i = 0; i < this.threadCount; ++i) {
            sum += (long)this.workerThreads.get(i).getSuspendedFiberCount();
        }
        return sum;
    }

    private static final /* synthetic */ void sleep$$anonfun$1(AtomicBoolean cb$3, Runnable cancel$2) {
        if (cb$3.compareAndSet(false, true)) {
            cancel$2.run();
            return;
        }
    }

    public static final class ExternalSleepCancel
    extends AtomicReference<Function0<BoxedUnit>>
    implements Function0<BoxedUnit>,
    Runnable {
        public void setCallback(Function0<BoxedUnit> cb) {
            Function0<BoxedUnit> back = this.getAndSet(cb);
            if (back == WorkStealingThreadPool$.cats$effect$unsafe$WorkStealingThreadPool$$$CanceledSleepSentinel) {
                cb.apply$mcV$sp();
                return;
            }
        }

        public void apply() {
            this.apply$mcV$sp();
        }

        public void apply$mcV$sp() {
            Function0<BoxedUnit> back = this.getAndSet(WorkStealingThreadPool$.cats$effect$unsafe$WorkStealingThreadPool$$$CanceledSleepSentinel);
            if (back != null) {
                back.apply$mcV$sp();
                return;
            }
        }

        @Override
        public void run() {
            this.apply$mcV$sp();
        }
    }
}

