/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.unsafe.WorkerThread;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Right;

public final class TimerHeap
extends AtomicInteger {
    private int removedCanceledCounter = 0;
    private Node[] heap = new Node[8];
    private int size = 0;
    private final Right<Nothing$, BoxedUnit> RightUnit = package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    private long totalScheduled = 0L;
    private long totalExecuted = 0L;
    private long totalCanceled = 0L;
    private long totalPacks = 0L;

    public void cats$effect$unsafe$TimerHeap$$incrementTotalCanceled() {
        ++this.totalCanceled;
    }

    public long peekFirstTriggerTime() {
        while (this.size > 0) {
            Node root = this.heap[1];
            if (root.isDeleted()) {
                this.cats$effect$unsafe$TimerHeap$$removeAt(1);
                if (root.isCanceled()) {
                    ++this.removedCanceledCounter;
                    ++this.totalCanceled;
                    continue;
                }
                ++this.totalExecuted;
                continue;
            }
            long tt = root.triggerTime();
            if (tt != Long.MIN_VALUE) {
                return tt;
            }
            return Long.MAX_VALUE;
        }
        return Long.MIN_VALUE;
    }

    public Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> peekFirstQuiescent() {
        if (this.size > 0) {
            return this.heap[1].get();
        }
        return null;
    }

    public Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> pollFirstIfTriggered(long now) {
        Node[] heap = this.heap;
        return this.loop$1(heap, now);
    }

    public boolean steal(long now) {
        Node[] heap = this.heap;
        if (heap != null) {
            int size = Math.min(this.size, heap.length - 1);
            return this.go$1(now, heap, size, 1);
        }
        return false;
    }

    public Runnable insert(long now, long delay, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit>[] out) {
        Node node;
        ++this.totalScheduled;
        if (this.size > 0) {
            Node node2;
            boolean rootExpired;
            Node[] heap = this.heap;
            long triggerTime = this.computeTriggerTime(now, delay);
            Node root = heap[1];
            boolean rootDeleted = root.isDeleted();
            boolean bl = rootExpired = !rootDeleted && this.isExpired(root, now);
            if (rootDeleted || rootExpired) {
                Node node3;
                root.index_$eq(-1);
                if (root.isCanceled()) {
                    ++this.removedCanceledCounter;
                    ++this.totalCanceled;
                } else {
                    ++this.totalExecuted;
                    if (rootExpired) {
                        out[0] = root.getAndClear();
                    }
                }
                heap[1] = node3 = new Node(this, triggerTime, callback, 1);
                this.fixDown(1);
                return node3;
            }
            Node[] heap2 = this.growIfNeeded();
            ++this.size;
            heap2[this.size] = node2 = new Node(this, triggerTime, callback, this.size);
            this.fixUp(this.size);
            return node2;
        }
        this.heap[1] = node = new Node(this, now + delay, callback, 1);
        ++this.size;
        return node;
    }

    public void packIfNeeded() {
        int canceledCount;
        int back;
        do {
            if ((canceledCount = (back = this.get()) - this.removedCanceledCounter) < this.size / 2) continue;
            int removeCount = this.compareAndSet(back, 0) ? canceledCount : this.getAndSet(0) - this.removedCanceledCounter;
            this.removedCanceledCounter = 0;
            this.pack(removeCount);
            return;
        } while (!this.compareAndSet(back, canceledCount));
        this.removedCanceledCounter = 0;
    }

    public long totalTimersScheduled() {
        return this.totalScheduled;
    }

    public long totalTimersExecuted() {
        return this.totalExecuted;
    }

    public long totalTimersCanceled() {
        return this.totalCanceled;
    }

    public long packCount() {
        return this.totalPacks;
    }

    public int outstandingTimers() {
        return this.size;
    }

    public Option<Object> nextTimerDue() {
        Node root = this.heap[1];
        if (root != null) {
            long now = System.nanoTime();
            long when = root.triggerTime() - now;
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)when));
        }
        return None$.MODULE$;
    }

    private void pack(int removeCount) {
        ++this.totalPacks;
        Node[] heap = this.heap;
        int i = 1;
        int r = 0;
        while (r < removeCount && i <= this.size) {
            if (heap[i].isCanceled()) {
                this.cats$effect$unsafe$TimerHeap$$removeAt(i);
                ++r;
                ++this.totalCanceled;
                continue;
            }
            ++i;
        }
    }

    public void cats$effect$unsafe$TimerHeap$$removeAt(int i) {
        Node[] heap = this.heap;
        Node back = heap[i];
        back.getAndClear();
        back.index_$eq(-1);
        if (i == this.size) {
            heap[i] = null;
            --this.size;
            return;
        }
        Node last = heap[this.size];
        heap[this.size] = null;
        heap[i] = last;
        last.index_$eq(i);
        --this.size;
        this.fixUpOrDown(i);
    }

    private boolean isExpired(Node node, long now) {
        return this.cmp(node.triggerTime(), now) <= 0;
    }

    private Node[] growIfNeeded() {
        Node[] heap = this.heap;
        if (this.size >= heap.length - 1) {
            Node[] newHeap = (Node[])Arrays.copyOf(heap, heap.length * 2, Node[].class);
            this.heap = newHeap;
            return newHeap;
        }
        return heap;
    }

    private void fixUpOrDown(int m) {
        Node[] heap = this.heap;
        if (m > 1 && this.cmp(heap[m >> 1], heap[m]) > 0) {
            this.fixUp(m);
            return;
        }
        this.fixDown(m);
    }

    private void fixUp(int m) {
        Node[] heap = this.heap;
        Node heapAtM = heap[m];
        this.loop$2(heap, heapAtM, m);
    }

    private void fixDown(int m) {
        Node[] heap = this.heap;
        Node heapAtM = heap[m];
        this.loop$3(heap, heapAtM, m);
    }

    private int cmp(long xTriggerTime, long yTriggerTime) {
        long d = xTriggerTime - yTriggerTime;
        return Long.signum(d);
    }

    private int cmp(Node x, Node y) {
        return this.cmp(x.triggerTime(), y.triggerTime());
    }

    private long computeTriggerTime(long now, long delay) {
        long safeDelay = delay < 0x3FFFFFFFFFFFFFFFL ? delay : this.overflowFree(now, delay);
        return now + safeDelay;
    }

    private long overflowFree(long now, long delay) {
        Node root = this.heap[1];
        long rootDelay = root.triggerTime() - now;
        if (rootDelay < 0L && delay - rootDelay < 0L) {
            return Long.MAX_VALUE + rootDelay;
        }
        return delay;
    }

    @Override
    public String toString() {
        if (this.size > 0) {
            return "TimerHeap(...)";
        }
        return "TimerHeap()";
    }

    private final Function1 loop$1(Node[] heap$1, long now$1) {
        while (this.size > 0) {
            boolean rootExpired;
            Node root = heap$1[1];
            boolean rootDeleted = root.isDeleted();
            boolean bl = rootExpired = !rootDeleted && this.isExpired(root, now$1);
            if (rootDeleted || rootExpired) {
                root.index_$eq(-1);
                if (this.size > 1) {
                    heap$1[1] = heap$1[this.size];
                    this.fixDown(1);
                }
                heap$1[this.size] = null;
                --this.size;
                if (root.isCanceled()) {
                    ++this.removedCanceledCounter;
                    ++this.totalCanceled;
                } else {
                    ++this.totalExecuted;
                }
                Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> back = root.getAndClear();
                if (!rootExpired || back == null) continue;
                ++this.totalExecuted;
                return back;
            }
            return null;
        }
        return null;
    }

    private final boolean go$1(long now$2, Node[] heap, int size, int m) {
        if (m <= size) {
            Node node = heap[m];
            if (node != null && this.isExpired(node, now$2)) {
                boolean invoked;
                Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> cb = node.getAndClear();
                boolean bl = invoked = cb != null;
                if (invoked) {
                    cb.apply(this.RightUnit);
                }
                boolean leftInvoked = this.go$1(now$2, heap, size, 2 * m);
                boolean rightInvoked = this.go$1(now$2, heap, size, 2 * m + 1);
                return invoked || leftInvoked || rightInvoked;
            }
            return false;
        }
        return false;
    }

    private final void loop$2(Node[] heap$2, Node heapAtM$1, int m) {
        while (m > 1) {
            int parent = m >> 1;
            Node heapAtParent = heap$2[parent];
            if (this.cmp(heapAtParent, heapAtM$1) > 0) {
                heap$2[parent] = heapAtM$1;
                heap$2[m] = heapAtParent;
                heapAtParent.index_$eq(m);
                m = parent;
                continue;
            }
            heapAtM$1.index_$eq(m);
            return;
        }
        heapAtM$1.index_$eq(m);
    }

    private final void loop$3(Node[] heap$3, Node heapAtM$2, int m) {
        int j;
        while ((j = 2 * m) <= this.size) {
            Node heapAtJPlus1;
            Node heapAtJ = heap$3[j];
            if (j < this.size && this.cmp(heapAtJ, heapAtJPlus1 = heap$3[j + 1]) > 0) {
                ++j;
                heapAtJ = heapAtJPlus1;
            }
            if (this.cmp(heapAtM$2, heapAtJ) > 0) {
                heap$3[m] = heapAtJ;
                heapAtJ.index_$eq(m);
                heap$3[j] = heapAtM$2;
                m = j;
                continue;
            }
            heapAtM$2.index_$eq(m);
            return;
        }
        heapAtM$2.index_$eq(m);
    }

    public final class Node
    implements Function0<BoxedUnit>,
    Runnable {
        private final long triggerTime;
        private Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback;
        private int index;
        private boolean canceled;
        private final /* synthetic */ TimerHeap $outer;

        public Node(TimerHeap $outer, long triggerTime, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback, int index) {
            this.triggerTime = triggerTime;
            this.callback = callback;
            this.index = index;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.canceled = false;
        }

        public long triggerTime() {
            return this.triggerTime;
        }

        public int index() {
            return this.index;
        }

        public void index_$eq(int x$1) {
            this.index = x$1;
        }

        public Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> getAndClear() {
            Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> back = this.callback;
            if (back != null) {
                this.callback = null;
            }
            return back;
        }

        public Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> get() {
            return this.callback;
        }

        public void apply() {
            this.apply$mcV$sp();
        }

        public void apply$mcV$sp() {
            this.callback = null;
            this.canceled = true;
            Thread thread = Thread.currentThread();
            if (thread instanceof WorkerThread) {
                WorkerThread worker = (WorkerThread)thread;
                TimerHeap heap = this.$outer;
                if (worker.ownsTimers(heap)) {
                    if (this.index() >= 0) {
                        heap.cats$effect$unsafe$TimerHeap$$removeAt(this.index());
                    }
                    heap.cats$effect$unsafe$TimerHeap$$incrementTotalCanceled();
                    return;
                }
                this.$outer.getAndIncrement();
                return;
            }
            this.$outer.getAndIncrement();
        }

        @Override
        public void run() {
            this.apply$mcV$sp();
        }

        public boolean isDeleted() {
            return this.callback == null;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public String toString() {
            return new StringBuilder(9).append("Node(").append(this.triggerTime()).append(", ").append(this.callback).append("})").toString();
        }

        public final /* synthetic */ TimerHeap cats$effect$unsafe$TimerHeap$Node$$$outer() {
            return this.$outer;
        }
    }
}

