/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.tracing.TracingConstants;
import cats.effect.unsafe.Head;
import cats.effect.unsafe.LocalQueueConstants;
import cats.effect.unsafe.LocalQueuePadding;
import cats.effect.unsafe.ScalQueue;
import cats.effect.unsafe.Tail;
import cats.effect.unsafe.WorkerThread;
import java.util.concurrent.ThreadLocalRandom;
import scala.Predef$;
import scala.collection.immutable.Set;

public final class LocalQueue
extends LocalQueuePadding {
    private final Runnable[] buffer = new Runnable[256];
    private long totalFiberCount = 0L;
    private long totalSpilloverCount = 0L;
    private long successfulStealAttemptCount = 0L;
    private long stolenFiberCount = 0L;

    public void enqueue(Runnable fiber, ScalQueue<Object> external, ThreadLocalRandom random) {
        int tl = this.tail;
        while (true) {
            int hd = Head.updater.get(this);
            int steal = this.msb(hd);
            if (this.unsignedShortSubtraction(tl, steal) < 256) {
                int idx = this.index(tl);
                this.buffer[idx] = fiber;
                if (TracingConstants.isStackTracing) {
                    ++this.totalFiberCount;
                }
                int newTl = this.unsignedShortAddition(tl, 1);
                Tail.updater.lazySet(this, newTl);
                this.tail = newTl;
                return;
            }
            int real = this.lsb(hd);
            if (steal != real) {
                if (TracingConstants.isStackTracing) {
                    ++this.totalSpilloverCount;
                    Tail.updater.lazySet(this, tl);
                }
                external.offer(fiber, random);
                return;
            }
            int realPlusHalf = this.unsignedShortAddition(real, LocalQueueConstants.HalfLocalQueueCapacity);
            int newHd = this.pack(realPlusHalf, realPlusHalf);
            if (!Head.updater.compareAndSet(this, hd, newHd)) continue;
            Runnable[][] batches = new Runnable[LocalQueueConstants.BatchesInHalfQueueCapacity][];
            int offset = 0;
            for (int b = 0; b < LocalQueueConstants.BatchesInHalfQueueCapacity; ++b) {
                Runnable[] batch = new Runnable[32];
                int i = 0;
                while (i < 32) {
                    int idx = this.index(real + offset);
                    Runnable f = this.buffer[idx];
                    this.buffer[idx] = null;
                    batch[i] = f;
                    ++i;
                    ++offset;
                }
                if (TracingConstants.isStackTracing) {
                    this.totalSpilloverCount += 32L;
                }
                batches[b] = batch;
            }
            external.offerAll((Object[])batches, random);
        }
    }

    public Runnable enqueueBatch(Runnable[] batch, WorkerThread<?> worker) {
        int tl = this.tail;
        while (true) {
            int hd = Head.updater.get(this);
            int steal = this.msb(hd);
            int len = this.unsignedShortSubtraction(tl, steal);
            if (len > LocalQueueConstants.LocalQueueCapacityMinusBatch) continue;
            int startPos = tl - 1;
            for (int i = 1; i < 32; ++i) {
                int idx = this.index(startPos + i);
                this.buffer[idx] = batch[i];
            }
            Runnable fiber = batch[0];
            if (TracingConstants.isStackTracing) {
                this.totalFiberCount += 32L;
                worker.active_$eq(fiber);
            }
            int newTl = this.unsignedShortAddition(tl, 31);
            Tail.updater.lazySet(this, newTl);
            this.tail = newTl;
            return fiber;
        }
        return null;
    }

    public Runnable dequeue(WorkerThread<?> worker) {
        int tl = this.tail;
        while (true) {
            int hd = Head.updater.get(this);
            int real = this.lsb(hd);
            if (real == tl) {
                return null;
            }
            int newReal = this.unsignedShortAddition(real, 1);
            int steal = this.msb(hd);
            int newHd = steal == real ? this.pack(newReal, newReal) : this.pack(steal, newReal);
            int idx = this.index(real);
            Runnable fiber = this.buffer[idx];
            if (TracingConstants.isStackTracing) {
                worker.active_$eq(fiber);
            }
            if (!Head.updater.compareAndSet(this, hd, newHd)) continue;
            this.buffer[idx] = null;
            return fiber;
        }
        return null;
    }

    public Runnable stealInto(LocalQueue dst, WorkerThread<?> dstWorker) {
        int dstTl = dst.tail;
        int dstHd = Head.updater.get(dst);
        int dstSteal = this.msb(dstHd);
        if (this.unsignedShortSubtraction(dstTl, dstSteal) > LocalQueueConstants.HalfLocalQueueCapacity) {
            return null;
        }
        while (true) {
            int real;
            int hd = Head.updater.get(this);
            int steal = this.msb(hd);
            if (steal != (real = this.lsb(hd))) {
                return null;
            }
            int tl = Tail.updater.get(this);
            int n = this.unsignedShortSubtraction(tl, real);
            if ((n -= n / 2) == 0) {
                return null;
            }
            int newReal = this.unsignedShortAddition(real, n);
            int newHd = this.pack(steal, newReal);
            if (!Head.updater.compareAndSet(this, hd, newHd)) continue;
            Runnable[] dstBuffer = dst.bufferForwarder();
            int headFiberIdx = this.index(steal);
            Runnable headFiber = this.buffer[headFiberIdx];
            this.buffer[headFiberIdx] = null;
            if (TracingConstants.isStackTracing) {
                dstWorker.active_$eq(headFiber);
            }
            int sourcePos = steal + 1;
            int end = n - 1;
            for (int i = 0; i < end; ++i) {
                int srcIdx = this.index(sourcePos + i);
                int dstIdx = this.index(dstTl + i);
                Runnable fiber = this.buffer[srcIdx];
                this.buffer[srcIdx] = null;
                dstBuffer[dstIdx] = fiber;
            }
            if (TracingConstants.isStackTracing) {
                ++this.successfulStealAttemptCount;
                this.stolenFiberCount += (long)n;
            }
            hd = newHd;
            while (true) {
                newHd = this.pack(newReal, newReal);
                if (Head.updater.compareAndSet(this, hd, newHd)) {
                    if (n == 1) {
                        if (TracingConstants.isStackTracing) {
                            Tail.updater.lazySet(dst, dstTl);
                            dst.tail = dstTl;
                        }
                        return headFiber;
                    }
                    int newDstTl = this.unsignedShortAddition(dstTl, --n);
                    Tail.updater.lazySet(dst, newDstTl);
                    dst.tail = newDstTl;
                    return headFiber;
                }
                hd = Head.updater.get(this);
                newReal = this.lsb(hd);
            }
        }
        return null;
    }

    public void drainBatch(ScalQueue<Object> external, ThreadLocalRandom random) {
        int tl = this.tail;
        while (true) {
            int hd = Head.updater.get(this);
            int real = this.lsb(hd);
            if (this.unsignedShortSubtraction(tl, real) <= LocalQueueConstants.LocalQueueCapacityMinusBatch) {
                return;
            }
            int newReal = this.unsignedShortAddition(real, 32);
            int steal = this.msb(hd);
            int newHd = steal == real ? this.pack(newReal, newReal) : this.pack(steal, newReal);
            if (!Head.updater.compareAndSet(this, hd, newHd)) continue;
            Runnable[] batch = new Runnable[32];
            for (int i = 0; i < 32; ++i) {
                int idx = this.index(real + i);
                Runnable f = this.buffer[idx];
                this.buffer[idx] = null;
                batch[i] = f;
            }
            if (TracingConstants.isStackTracing) {
                this.totalSpilloverCount += 32L;
                Tail.updater.lazySet(this, tl);
            }
            external.offer(batch, random);
            return;
        }
    }

    public boolean isEmpty() {
        int hd = Head.updater.get(this);
        int tl = Tail.updater.get(this);
        return this.lsb(hd) == tl;
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public int size() {
        int hd = Head.updater.get(this);
        int tl = Tail.updater.get(this);
        return this.unsignedShortSubtraction(tl, this.lsb(hd));
    }

    public Runnable[] bufferForwarder() {
        return this.buffer;
    }

    private int index(int n) {
        return n & LocalQueueConstants.LocalQueueCapacityMask;
    }

    private int lsb(int n) {
        return n & LocalQueueConstants.UnsignedShortMask;
    }

    private int msb(int n) {
        return n >>> 16;
    }

    private int pack(int msb, int lsb) {
        return msb << 16 | lsb;
    }

    private int unsignedShortAddition(int x, int y) {
        return this.lsb(x + y);
    }

    private int unsignedShortSubtraction(int x, int y) {
        return this.lsb(x - y);
    }

    public Set<Runnable> snapshot() {
        int n = this.size();
        return (Set)Predef$.MODULE$.wrapRefArray((Object[])this.buffer).toSet().$minus(null);
    }

    public int getFiberCount() {
        return this.size();
    }

    public int getHeadIndex() {
        int hd = Head.updater.get(this);
        return this.index(this.lsb(hd));
    }

    public int getTailIndex() {
        int tl = Tail.updater.get(this);
        return this.index(tl);
    }

    public long getTotalFiberCount() {
        int n = Tail.updater.get(this);
        return this.totalFiberCount;
    }

    public long getTotalSpilloverCount() {
        int n = Tail.updater.get(this);
        return this.totalSpilloverCount;
    }

    public long getSuccessfulStealAttemptCount() {
        int n = Head.updater.get(this);
        return this.successfulStealAttemptCount;
    }

    public long getStolenFiberCount() {
        int n = Head.updater.get(this);
        return this.stolenFiberCount;
    }

    public int getRealHeadTag() {
        int hd = Head.updater.get(this);
        return this.lsb(hd);
    }

    public int getStealHeadTag() {
        int hd = Head.updater.get(this);
        return this.msb(hd);
    }

    public int getTailTag() {
        return Tail.updater.get(this);
    }
}

