/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.tracing.TracingConstants;
import cats.effect.unsafe.FiberMonitor;
import cats.effect.unsafe.IORuntime;
import cats.effect.unsafe.IORuntime$;
import cats.effect.unsafe.IORuntimeConfig$;
import cats.effect.unsafe.LocalQueue;
import cats.effect.unsafe.PollingSystem;
import cats.effect.unsafe.Scheduler;
import cats.effect.unsafe.Scheduler$;
import cats.effect.unsafe.SelectorSystem$;
import cats.effect.unsafe.SleepSystem$;
import cats.effect.unsafe.TimerHeap;
import cats.effect.unsafe.WorkStealingThreadPool;
import cats.effect.unsafe.WorkerThread;
import cats.effect.unsafe.metrics.ComputePoolSampler;
import cats.effect.unsafe.metrics.LiveFiberSnapshotTrigger;
import cats.effect.unsafe.metrics.LiveFiberSnapshotTrigger$;
import cats.effect.unsafe.metrics.LocalQueueSampler;
import cats.effect.unsafe.metrics.PollerSampler;
import cats.effect.unsafe.metrics.TimerHeapSampler;
import cats.effect.unsafe.metrics.WorkerThreadSampler;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public abstract class IORuntimeCompanionPlatform {
    private volatile IORuntime _global;

    public IORuntimeCompanionPlatform() {
        String DefaultBlockerPrefix = "io-compute-blocker";
        this._global = null;
    }

    public Tuple2<WorkStealingThreadPool<?>, Function0<BoxedUnit>> createWorkStealingComputeThreadPool(int threads, String threadPrefix, String blockerThreadPrefix, Duration runtimeBlockingExpiration, Function1<Throwable, BoxedUnit> reportFailure) {
        return this.createWorkStealingComputeThreadPool(threads, threadPrefix, blockerThreadPrefix, runtimeBlockingExpiration, reportFailure, false);
    }

    public Tuple2<WorkStealingThreadPool<?>, Function0<BoxedUnit>> createWorkStealingComputeThreadPool(int threads, String threadPrefix, String blockerThreadPrefix, Duration runtimeBlockingExpiration, Function1<Throwable, BoxedUnit> reportFailure, boolean blockedThreadDetectionEnabled) {
        Tuple3<WorkStealingThreadPool<?>, Object, Function0<BoxedUnit>> tuple3 = this.createWorkStealingComputeThreadPool(threads, threadPrefix, blockerThreadPrefix, runtimeBlockingExpiration, reportFailure, false, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).second(), SleepSystem$.MODULE$, this.createWorkStealingComputeThreadPool$default$9());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        WorkStealingThreadPool pool = (WorkStealingThreadPool)tuple3._1();
        Function0 shutdown = (Function0)tuple3._3();
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)pool, (Object)shutdown);
        WorkStealingThreadPool pool2 = (WorkStealingThreadPool)tuple2._1();
        Function0 shutdown2 = (Function0)tuple2._2();
        return Tuple2$.MODULE$.apply((Object)pool2, (Object)shutdown2);
    }

    public Tuple3<WorkStealingThreadPool<?>, Object, Function0<BoxedUnit>> createWorkStealingComputeThreadPool(int threads, String threadPrefix, String blockerThreadPrefix, Duration runtimeBlockingExpiration, Function1<Throwable, BoxedUnit> reportFailure, boolean blockedThreadDetectionEnabled, Duration shutdownTimeout, PollingSystem pollingSystem, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        JFunction0.mcV.sp & Serializable intersect;
        WorkStealingThreadPool<Object> threadPool = new WorkStealingThreadPool<Object>(threads, threadPrefix, blockerThreadPrefix, runtimeBlockingExpiration, blockedThreadDetectionEnabled && threads > 1, shutdownTimeout, pollingSystem, reportFailure, uncaughtExceptionHandler);
        if (TracingConstants.isStackTracing) {
            MBeanServer mBeanServer;
            MBeanServer mBeanServer2;
            try {
                mBeanServer2 = ManagementFactory.getPlatformMBeanServer();
            }
            catch (Throwable throwable) {
                mBeanServer2 = mBeanServer = null;
            }
            if (mBeanServer != null) {
                BoxedUnit boxedUnit;
                Set registeredMBeans = (Set)Set$.MODULE$.empty();
                long threadPoolId = threadPool.id();
                try {
                    ObjectName computePoolSamplerName = new ObjectName(new StringBuilder(51).append("cats.effect.unsafe.metrics:type=ComputePoolSampler-").append(threadPoolId).toString());
                    ComputePoolSampler computePoolSampler = new ComputePoolSampler(threadPool);
                    mBeanServer.registerMBean(computePoolSampler, computePoolSamplerName);
                    boxedUnit = registeredMBeans.$plus$eq((Object)computePoolSamplerName);
                }
                catch (Throwable throwable) {
                    boxedUnit = BoxedUnit.UNIT;
                }
                LocalQueue[] localQueues = threadPool.localQueues();
                int len = localQueues.length;
                for (int i = 0; i < len; ++i) {
                    BoxedUnit boxedUnit2;
                    LocalQueue localQueue = localQueues[i];
                    try {
                        ObjectName localQueueSamplerName = new ObjectName(new StringBuilder(51).append("cats.effect.unsafe.metrics:type=LocalQueueSampler-").append(threadPoolId).append("-").append(i).toString());
                        LocalQueueSampler localQueueSampler = new LocalQueueSampler(localQueue);
                        mBeanServer.registerMBean(localQueueSampler, localQueueSamplerName);
                        boxedUnit2 = registeredMBeans.$plus$eq((Object)localQueueSamplerName);
                        continue;
                    }
                    catch (Throwable throwable) {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                }
                Object object = Predef$.MODULE$.refArrayOps((Object[])threadPool.sleepers());
                Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
                ArrayOps$.MODULE$.foreach$extension(object2, (Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        TimerHeap timerHeap = (TimerHeap)tuple2._1();
                        int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        try {
                            ObjectName timerHeapSamplerName = new ObjectName(new StringBuilder(43).append("cats.effect.unsafe.metrics:type=TimerHeap-").append(threadPoolId).append("-").append(i).toString());
                            TimerHeapSampler timerHeapSampler = new TimerHeapSampler(timerHeap);
                            mBeanServer.registerMBean(timerHeapSampler, timerHeapSamplerName);
                            boxedUnit = registeredMBeans.$plus$eq((Object)timerHeapSamplerName);
                        }
                        catch (Throwable throwable) {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return boxedUnit;
                    }
                    throw new MatchError((Object)tuple2);
                });
                Object object3 = Predef$.MODULE$.refArrayOps(threadPool.pollers());
                Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object3));
                ArrayOps$.MODULE$.foreach$extension(object4, (Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        Object poller = tuple2._1();
                        int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        try {
                            ObjectName pollerSamplerName = new ObjectName(new StringBuilder(40).append("cats.effect.unsafe.metrics:type=Poller-").append(threadPoolId).append("-").append(i).toString());
                            PollerSampler pollerSampler = new PollerSampler(threadPool.system().metrics(poller));
                            mBeanServer.registerMBean(pollerSampler, pollerSamplerName);
                            boxedUnit = registeredMBeans.$plus$eq((Object)pollerSamplerName);
                        }
                        catch (Throwable throwable) {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return boxedUnit;
                    }
                    throw new MatchError((Object)tuple2);
                });
                Object object5 = Predef$.MODULE$.refArrayOps((Object[])threadPool.metrices());
                Object object6 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object5));
                ArrayOps$.MODULE$.foreach$extension(object6, (Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        WorkerThread.Metrics thread = (WorkerThread.Metrics)tuple2._1();
                        int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        try {
                            ObjectName workerThreadSamplerName = new ObjectName(new StringBuilder(46).append("cats.effect.unsafe.metrics:type=WorkerThread-").append(threadPoolId).append("-").append(i).toString());
                            WorkerThreadSampler workerThreadSampler = new WorkerThreadSampler(thread);
                            mBeanServer.registerMBean(workerThreadSampler, workerThreadSamplerName);
                            boxedUnit = registeredMBeans.$plus$eq((Object)workerThreadSamplerName);
                        }
                        catch (Throwable throwable) {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return boxedUnit;
                    }
                    throw new MatchError((Object)tuple2);
                });
                intersect = (JFunction0.mcV.sp & Serializable)() -> {
                    if (mBeanServer != null) {
                        registeredMBeans.foreach((Function1)(JProcedure1 & Serializable)mbean -> {
                            try {
                                mBeanServer.unregisterMBean((ObjectName)mbean);
                            }
                            catch (Throwable throwable) {}
                        });
                        return;
                    }
                };
            } else {
                intersect = (JFunction0.mcV.sp & Serializable)() -> {};
            }
        } else {
            intersect = (JFunction0.mcV.sp & Serializable)() -> {};
        }
        JFunction0.mcV.sp & Serializable unregisterMBeans = intersect;
        return Tuple3$.MODULE$.apply(threadPool, pollingSystem.makeApi(threadPool), () -> IORuntimeCompanionPlatform.createWorkStealingComputeThreadPool$$anonfun$1((Function0)unregisterMBeans, threadPool));
    }

    public int createWorkStealingComputeThreadPool$default$1() {
        return Math.max(2, Runtime.getRuntime().availableProcessors());
    }

    public String createWorkStealingComputeThreadPool$default$2() {
        return "io-compute";
    }

    public String createWorkStealingComputeThreadPool$default$3() {
        return "io-compute-blocker";
    }

    public Duration createWorkStealingComputeThreadPool$default$4() {
        return new package.DurationInt(package$.MODULE$.DurationInt(60)).seconds();
    }

    public Function1<Throwable, BoxedUnit> createWorkStealingComputeThreadPool$default$5() {
        return (JProcedure1 & Serializable)_$1 -> _$1.printStackTrace();
    }

    public boolean createWorkStealingComputeThreadPool$default$6() {
        return false;
    }

    public Duration createWorkStealingComputeThreadPool$default$7() {
        return new package.DurationInt(package$.MODULE$.DurationInt(1)).second();
    }

    public PollingSystem createWorkStealingComputeThreadPool$default$8() {
        return SelectorSystem$.MODULE$.apply();
    }

    public Thread.UncaughtExceptionHandler createWorkStealingComputeThreadPool$default$9() {
        return (_$2, ex) -> ex.printStackTrace();
    }

    public Tuple2<WorkStealingThreadPool<?>, Function0<BoxedUnit>> createDefaultComputeThreadPool(Function0<IORuntime> self, int threads, String threadPrefix, String blockerThreadPrefix) {
        return this.createWorkStealingComputeThreadPool(threads, threadPrefix, blockerThreadPrefix, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(60)).seconds(), (Function1<Throwable, BoxedUnit>)(JProcedure1 & Serializable)_$3 -> _$3.printStackTrace(), false);
    }

    public int createDefaultComputeThreadPool$default$2() {
        return Math.max(2, Runtime.getRuntime().availableProcessors());
    }

    public String createDefaultComputeThreadPool$default$3() {
        return "io-compute";
    }

    public String createDefaultComputeThreadPool$default$4() {
        return "io-compute-blocker";
    }

    public Tuple2<WorkStealingThreadPool<?>, Function0<BoxedUnit>> createDefaultComputeThreadPool(Function0<IORuntime> self, int threads, String threadPrefix) {
        return this.createDefaultComputeThreadPool(self, threads, threadPrefix, this.createDefaultComputeThreadPool$default$4());
    }

    public Tuple2<ExecutionContext, Function0<BoxedUnit>> createDefaultBlockingExecutionContext(String threadPrefix) {
        return this.createDefaultBlockingExecutionContext(threadPrefix, (Function1<Throwable, BoxedUnit>)(JProcedure1 & Serializable)_$4 -> _$4.printStackTrace());
    }

    public String createDefaultBlockingExecutionContext$default$1() {
        return "io-blocking";
    }

    public Tuple2<ExecutionContext, Function0<BoxedUnit>> createDefaultBlockingExecutionContext(String threadPrefix, Function1<Throwable, BoxedUnit> reportFailure) {
        AtomicInteger threadCount = new AtomicInteger(0);
        ExecutorService executor = Executors.newCachedThreadPool(r -> {
            Thread t = new Thread(r);
            t.setName(new StringBuilder(1).append(threadPrefix).append("-").append(threadCount.getAndIncrement()).toString());
            t.setDaemon(true);
            return t;
        });
        return Tuple2$.MODULE$.apply((Object)ExecutionContext$.MODULE$.fromExecutor((Executor)executor, reportFailure), (JFunction0.mcV.sp & Serializable)() -> executor.shutdown());
    }

    public Tuple2<Scheduler, Function0<BoxedUnit>> createDefaultScheduler(String threadPrefix) {
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r);
            t.setName(threadPrefix);
            t.setDaemon(true);
            t.setPriority(10);
            return t;
        });
        scheduler.setRemoveOnCancelPolicy(true);
        return Tuple2$.MODULE$.apply((Object)Scheduler$.MODULE$.fromScheduledExecutor(scheduler), (JFunction0.mcV.sp & Serializable)() -> scheduler.shutdown());
    }

    public String createDefaultScheduler$default$1() {
        return "io-scheduler";
    }

    public PollingSystem createDefaultPollingSystem() {
        return SelectorSystem$.MODULE$.apply();
    }

    public boolean installGlobal(Function0<IORuntime> global) {
        if (this._global == null) {
            this._global = (IORuntime)global.apply();
            return true;
        }
        return false;
    }

    public void resetGlobal() {
        this._global = null;
    }

    public IORuntime global() {
        if (this._global == null) {
            this.installGlobal((Function0<IORuntime>)((Function0 & Serializable)this::global$$anonfun$1));
        }
        return this._global;
    }

    public Function0<BoxedUnit> registerFiberMonitorMBean(FiberMonitor fiberMonitor) {
        if (TracingConstants.isStackTracing) {
            MBeanServer mBeanServer;
            MBeanServer mBeanServer2;
            try {
                mBeanServer2 = ManagementFactory.getPlatformMBeanServer();
            }
            catch (Throwable throwable) {
                mBeanServer2 = mBeanServer = null;
            }
            if (mBeanServer != null) {
                JFunction0.mcV.sp & Serializable intersect;
                try {
                    long mbeanId = LiveFiberSnapshotTrigger$.MODULE$.IdCounter().getAndIncrement();
                    ObjectName liveFiberSnapshotTriggerName = new ObjectName(new StringBuilder(57).append("cats.effect.unsafe.metrics:type=LiveFiberSnapshotTrigger-").append(mbeanId).toString());
                    LiveFiberSnapshotTrigger liveFiberSnapshotTrigger = new LiveFiberSnapshotTrigger(fiberMonitor);
                    mBeanServer.registerMBean(liveFiberSnapshotTrigger, liveFiberSnapshotTriggerName);
                    intersect = (JFunction0.mcV.sp & Serializable)() -> {
                        try {
                            mBeanServer.unregisterMBean(liveFiberSnapshotTriggerName);
                        }
                        catch (Throwable throwable) {}
                    };
                }
                catch (Throwable throwable) {
                    intersect = (JFunction0.mcV.sp & Serializable)() -> {};
                }
                return intersect;
            }
            return (JFunction0.mcV.sp & Serializable)() -> {};
        }
        return (JFunction0.mcV.sp & Serializable)() -> {};
    }

    private static final /* synthetic */ void createWorkStealingComputeThreadPool$$anonfun$1(Function0 unregisterMBeans$1, WorkStealingThreadPool threadPool$2) {
        unregisterMBeans$1.apply$mcV$sp();
        threadPool$2.shutdown();
    }

    private final IORuntime global$$anonfun$1() {
        Tuple3<WorkStealingThreadPool<?>, Object, Function0<BoxedUnit>> tuple3 = this.createWorkStealingComputeThreadPool(this.createWorkStealingComputeThreadPool$default$1(), this.createWorkStealingComputeThreadPool$default$2(), this.createWorkStealingComputeThreadPool$default$3(), this.createWorkStealingComputeThreadPool$default$4(), this.createWorkStealingComputeThreadPool$default$5(), this.createWorkStealingComputeThreadPool$default$6(), this.createWorkStealingComputeThreadPool$default$7(), this.createWorkStealingComputeThreadPool$default$8(), this.createWorkStealingComputeThreadPool$default$9());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        WorkStealingThreadPool compute = (WorkStealingThreadPool)tuple3._1();
        Object poller = tuple3._2();
        Function0 computeDown = (Function0)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)compute, poller, (Object)computeDown);
        WorkStealingThreadPool compute2 = (WorkStealingThreadPool)tuple32._1();
        Object poller2 = tuple32._2();
        Function0 computeDown2 = (Function0)tuple32._3();
        Tuple2<ExecutionContext, Function0<BoxedUnit>> tuple2 = this.createDefaultBlockingExecutionContext(this.createDefaultBlockingExecutionContext$default$1());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ExecutionContext blocking = (ExecutionContext)tuple2._1();
        Function0 blockingDown = (Function0)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)blocking, (Object)blockingDown);
        ExecutionContext blocking2 = (ExecutionContext)tuple22._1();
        Function0 blockingDown2 = (Function0)tuple22._2();
        JFunction0.mcV.sp & Serializable shutdown = (JFunction0.mcV.sp & Serializable)() -> {
            computeDown2.apply$mcV$sp();
            blockingDown2.apply$mcV$sp();
            this.resetGlobal();
        };
        return IORuntime$.MODULE$.apply((ExecutionContext)compute2, blocking2, (Scheduler)compute2, (List<Object>)((List)new .colon.colon(poller2, (List)Nil$.MODULE$)), (Function0<BoxedUnit>)shutdown, IORuntimeConfig$.MODULE$.apply());
    }
}

