/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.IOFiber;
import cats.effect.Trace;
import cats.effect.tracing.TracingConstants;
import cats.effect.unsafe.FiberMonitor$;
import cats.effect.unsafe.FiberMonitorShared;
import cats.effect.unsafe.WeakBag;
import cats.effect.unsafe.WeakList;
import cats.effect.unsafe.WorkStealingThreadPool;
import cats.effect.unsafe.WorkerThread;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;
import scala.concurrent.ExecutionContext;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;

public class FiberMonitor
extends FiberMonitorShared {
    private final WorkStealingThreadPool<?> compute;
    private final WeakList<WeakBag<Runnable>> BagReferences;
    private final ThreadLocal<WeakBag<Runnable>> Bags;
    private final PartialFunction<Tuple2<Runnable, Trace>, Tuple2<IOFiber<?>, Trace>> justFibers;

    public static FiberMonitor apply(ExecutionContext executionContext) {
        return FiberMonitor$.MODULE$.apply(executionContext);
    }

    public FiberMonitor(WorkStealingThreadPool<?> compute) {
        this.compute = compute;
        this.BagReferences = new WeakList();
        this.Bags = ThreadLocal.withInitial(() -> {
            WeakBag bag = new WeakBag();
            this.BagReferences.prepend(bag);
            return bag;
        });
        this.justFibers = new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Runnable runnable;
                Tuple2 tuple2 = x;
                if (tuple2 != null && (runnable = (Runnable)tuple2._1()) instanceof IOFiber) {
                    IOFiber fiber = (IOFiber)runnable;
                    Trace trace = (Trace)tuple2._2();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Runnable runnable;
                Tuple2 tuple2 = x;
                if (tuple2 != null && (runnable = (Runnable)tuple2._1()) instanceof IOFiber) {
                    IOFiber fiber = (IOFiber)runnable;
                    Trace trace = (Trace)tuple2._2();
                    IOFiber iOFiber = (IOFiber)Predef$.MODULE$.ArrowAssoc((Object)fiber);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)iOFiber, (Object)trace);
                }
                return function1.apply((Object)x);
            }
        };
    }

    public WeakBag.Handle monitorSuspended(IOFiber<?> fiber) {
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            if (worker.isOwnedBy(this.compute)) {
                return worker.monitor(fiber);
            }
            return this.monitorFallback(fiber);
        }
        return this.monitorFallback(fiber);
    }

    public void liveFiberSnapshot(Function1<String, BoxedUnit> print) {
        if (TracingConstants.isStackTracing) {
            Option$.MODULE$.apply(this.compute).fold((Function0 & Serializable)() -> {
                this.liveFiberSnapshot$$anonfun$1(print);
                return BoxedUnit.UNIT;
            }, (Function1)(JProcedure1 & Serializable)compute -> {
                Tuple3 tuple3 = compute.liveTraces();
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                Map external = (Map)tuple3._1();
                Map workers = (Map)tuple3._2();
                Map suspended = (Map)tuple3._3();
                Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)external, (Object)workers, (Object)suspended);
                Map external2 = (Map)tuple32._1();
                Map workers2 = (Map)tuple32._2();
                Map suspended2 = (Map)tuple32._3();
                Map externalFibers = (Map)external2.collect(this.justFibers);
                Map suspendedFibers = (Map)suspended2.collect(this.justFibers);
                Map workersMapping = ((Map)workers2.map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Tuple3 tuple3 = (Tuple3)tuple2._2();
                        WorkerThread thread = (WorkerThread)tuple2._1();
                        if (tuple3 != null) {
                            Thread.State state = (Thread.State)((Object)((Object)((Object)tuple3._1())));
                            Option opt = (Option)tuple3._2();
                            Map set = (Map)tuple3._3();
                            Option filteredOpt = opt.collect(this.justFibers);
                            Map filteredSet = (Map)set.collect(this.justFibers);
                            return Tuple2$.MODULE$.apply((Object)thread, (Object)Tuple3$.MODULE$.apply((Object)state, (Object)filteredOpt, (Object)filteredSet));
                        }
                    }
                    throw new MatchError((Object)tuple2);
                })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Tuple3 tuple33 = Tuple3$.MODULE$.apply((Object)externalFibers, (Object)workersMapping, (Object)suspendedFibers);
                Map rawExternal = (Map)tuple33._1();
                Map workersMap = (Map)tuple33._2();
                Map rawSuspended = (Map)tuple33._3();
                Map<IOFiber<?>, Trace> rawForeign = this.foreignFibers();
                Map localAndActive = (Map)workersMap.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        Tuple3 tuple3;
                        Tuple2 tuple22 = (Tuple2)tuple2._2();
                        Map acc = (Map)tuple2._1();
                        if (tuple22 != null && (tuple3 = (Tuple3)tuple22._2()) != null) {
                            Option active = (Option)tuple3._2();
                            Map local = (Map)tuple3._3();
                            return (Map)((MapOps)acc.$plus$plus((IterableOnce)local)).$plus$plus((IterableOnce)active.collect(this.justFibers));
                        }
                    }
                    throw new MatchError((Object)tuple2);
                });
                Map external3 = (Map)rawExternal.$minus$minus((IterableOnce)localAndActive.keys());
                Map suspended3 = (Map)rawSuspended.$minus$minus((IterableOnce)localAndActive.keys()).$minus$minus((IterableOnce)external3.keys());
                Map foreign = (Map)rawForeign.$minus$minus((IterableOnce)localAndActive.keys()).$minus$minus((IterableOnce)external3.keys()).$minus$minus((IterableOnce)suspended3.keys());
                Iterable workersStatuses = (Iterable)workersMap.map((Function1 & Serializable)x$12 -> {
                    Tuple2 tuple2 = x$12;
                    if (tuple2 != null) {
                        Tuple3 tuple3 = (Tuple3)tuple2._2();
                        WorkerThread worker = (WorkerThread)tuple2._1();
                        if (tuple3 != null) {
                            Map local;
                            Thread.State state = (Thread.State)((Object)((Object)((Object)tuple3._1())));
                            Option active = (Option)tuple3._2();
                            Map yielding = local = (Map)tuple3._3();
                            Thread.State state2 = state;
                            Thread.State state3 = Thread.State.RUNNABLE;
                            String status = !(state2 != null ? !((Object)((Object)state2)).equals((Object)state3) : state3 != null) ? "RUNNING" : "BLOCKED";
                            String workerString = new StringBuilder(15).append(worker).append(" (#").append(worker.index()).append("): ").append(yielding.size()).append(" enqueued").toString();
                            print.apply((Object)this.doubleNewline());
                            active.map((Function1 & Serializable)x$1 -> {
                                Tuple2 tuple2 = x$1;
                                if (tuple2 != null) {
                                    IOFiber fiber = (IOFiber)tuple2._1();
                                    Trace trace = (Trace)tuple2._2();
                                    return this.fiberString(fiber, trace, status);
                                }
                                throw new MatchError((Object)tuple2);
                            }).foreach((Function1)(JProcedure1 & Serializable)_$1 -> print.apply(_$1));
                            this.printFibers(yielding, "YIELDING", print);
                            return workerString;
                        }
                    }
                    throw new MatchError((Object)tuple2);
                });
                this.printFibers(external3, "YIELDING", print);
                this.printFibers(suspended3, "WAITING", print);
                this.printFibers(foreign, "ACTIVE", print);
                print.apply((Object)this.doubleNewline());
                print.apply((Object)workersStatuses.mkString(this.newline()));
                String globalStatus = new StringBuilder(37).append("Global: enqueued ").append(external3.size()).append(", foreign ").append(foreign.size()).append(", waiting ").append(suspended3.size()).toString();
                print.apply((Object)this.doubleNewline());
                print.apply((Object)globalStatus);
                print.apply((Object)this.newline());
            });
            return;
        }
    }

    private WeakBag.Handle monitorFallback(IOFiber<?> fiber) {
        WeakBag<Runnable> bag = this.Bags.get();
        WeakBag.Handle handle = bag.insert(fiber);
        bag.synchronizationPoint().lazySet(true);
        return handle;
    }

    private Map<IOFiber<?>, Trace> foreignFibers() {
        Builder foreign = Predef$.MODULE$.Map().newBuilder();
        this.BagReferences.foreach((Function1<WeakBag<Runnable>, BoxedUnit>)(JProcedure1 & Serializable)bag -> {
            boolean bl = bag.synchronizationPoint().get();
            bag.forEach((JProcedure1 & Serializable)x$1 -> {
                IOFiber fiber;
                Runnable runnable = x$1;
                if (runnable instanceof IOFiber && !(fiber = (IOFiber)runnable).isDone()) {
                    IOFiber iOFiber = (IOFiber)Predef$.MODULE$.ArrowAssoc((Object)fiber);
                    foreign.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)iOFiber, (Object)fiber.captureTrace()));
                    return;
                }
            });
        });
        return (Map)foreign.result();
    }

    private final void liveFiberSnapshot$$anonfun$1(Function1 print$1) {
        this.printFibers(this.foreignFibers(), "ACTIVE", (Function1<String, BoxedUnit>)print$1);
        print$1.apply((Object)this.newline());
    }
}

