/*
 * Decompiled with CFR 0.152.
 */
package cats.effect;

import cats.NotNull$;
import cats.effect.CpuStarvationCheck$;
import cats.effect.ExitCode;
import cats.effect.ExitCode$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.IOFiber;
import cats.effect.NonDaemonThreadLogger;
import cats.effect.Signal;
import cats.effect.metrics.CpuStarvationWarningMetrics;
import cats.effect.metrics.JvmCpuStarvationMetrics$;
import cats.effect.std.Console$;
import cats.effect.tracing.TracingConstants;
import cats.effect.unsafe.IORuntime;
import cats.effect.unsafe.IORuntime$;
import cats.effect.unsafe.IORuntimeConfig;
import cats.effect.unsafe.IORuntimeConfig$;
import cats.effect.unsafe.PollingSystem;
import cats.effect.unsafe.Scheduler;
import cats.effect.unsafe.UnsafeNonFatal;
import cats.effect.unsafe.WorkStealingThreadPool;
import cats.syntax.EitherObjectOps$;
import cats.syntax.EitherSyntax;
import cats.syntax.package;
import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public interface IOApp {
    public static void $init$(IOApp $this) {
        $this.cats$effect$IOApp$$_runtime_$eq(null);
    }

    public IORuntime cats$effect$IOApp$$_runtime();

    public void cats$effect$IOApp$$_runtime_$eq(IORuntime var1);

    public static IORuntime runtime$(IOApp $this) {
        return $this.runtime();
    }

    default public IORuntime runtime() {
        return this.cats$effect$IOApp$$_runtime();
    }

    public static IORuntimeConfig runtimeConfig$(IOApp $this) {
        return $this.runtimeConfig();
    }

    default public IORuntimeConfig runtimeConfig() {
        return IORuntimeConfig$.MODULE$.apply();
    }

    public static PollingSystem pollingSystem$(IOApp $this) {
        return $this.pollingSystem();
    }

    default public PollingSystem pollingSystem() {
        return IORuntime$.MODULE$.createDefaultPollingSystem();
    }

    public static int computeWorkerThreadCount$(IOApp $this) {
        return $this.computeWorkerThreadCount();
    }

    default public int computeWorkerThreadCount() {
        return Math.max(2, Runtime.getRuntime().availableProcessors());
    }

    public static ArrayBlockingQueue cats$effect$IOApp$$queue$(IOApp $this) {
        return $this.cats$effect$IOApp$$queue();
    }

    default public ArrayBlockingQueue<Object> cats$effect$IOApp$$queue() {
        return new ArrayBlockingQueue<Object>(32);
    }

    public static void cats$effect$IOApp$$handleTerminalFailure$(IOApp $this, Throwable t) {
        $this.cats$effect$IOApp$$handleTerminalFailure(t);
    }

    default public void cats$effect$IOApp$$handleTerminalFailure(Throwable t) {
        this.cats$effect$IOApp$$queue().clear();
        this.cats$effect$IOApp$$queue().put(t);
    }

    public static ExecutionContext MainThread$(IOApp $this) {
        return $this.MainThread();
    }

    default public ExecutionContext MainThread() {
        if (this.cats$effect$IOApp$$queue() == this.cats$effect$IOApp$$queue()) {
            return new ExecutionContext(this){
                private final /* synthetic */ IOApp $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    ExecutionContext.$init$((ExecutionContext)this);
                }

                public void reportFailure(Throwable t) {
                    Throwable throwable = t;
                    Throwable t2 = throwable;
                    if (UnsafeNonFatal.apply(t2)) {
                        this.$outer.reportFailure(t2).unsafeRunAndForgetWithoutCallback(this.$outer.runtime());
                        return;
                    }
                    Throwable t3 = throwable;
                    this.$outer.cats$effect$IOApp$$handleTerminalFailure(t3);
                }

                public void execute(Runnable r) {
                    if (!this.$outer.cats$effect$IOApp$$queue().offer(r)) {
                        this.$outer.runtime().blocking().execute(() -> this.$outer.cats$effect$IOApp$$queue().put(r));
                        return;
                    }
                }
            };
        }
        throw new UnsupportedOperationException("Your IOApp's super class has not been recompiled against Cats Effect 3.4.0+.");
    }

    public static IO reportFailure$(IOApp $this, Throwable err) {
        return $this.reportFailure(err);
    }

    default public IO<BoxedUnit> reportFailure(Throwable err) {
        return (IO)Console$.MODULE$.apply(IO$.MODULE$.consoleForIO()).printStackTrace(err);
    }

    public static boolean blockedThreadDetectionEnabled$(IOApp $this) {
        return $this.blockedThreadDetectionEnabled();
    }

    default public boolean blockedThreadDetectionEnabled() {
        return Boolean.getBoolean("cats.effect.detectBlockedThreads");
    }

    public static boolean logNonDaemonThreadsEnabled$(IOApp $this) {
        return $this.logNonDaemonThreadsEnabled();
    }

    default public boolean logNonDaemonThreadsEnabled() {
        Option option = Option$.MODULE$.apply((Object)System.getProperty("cats.effect.logNonDaemonThreadsOnExit")).map((Function1 & Serializable)_$1 -> _$1.toLowerCase());
        if (option instanceof Some) {
            String value = (String)((Some)option).value();
            return value.equalsIgnoreCase("true");
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError((Object)option);
    }

    public static FiniteDuration logNonDaemonThreadsInterval$(IOApp $this) {
        return $this.logNonDaemonThreadsInterval();
    }

    default public FiniteDuration logNonDaemonThreadsInterval() {
        return (FiniteDuration)Option$.MODULE$.apply((Object)System.getProperty("cats.effect.logNonDaemonThreads.sleepIntervalMillis")).flatMap((Function1 & Serializable)time -> {
            boolean bl = EitherObjectOps$.MODULE$.catchOnly$extension(package.all$.MODULE$.catsSyntaxEitherObject(package$.MODULE$.Either()));
            return EitherSyntax.CatchOnlyPartiallyApplied$.MODULE$.apply$extension(bl, () -> IOApp.logNonDaemonThreadsInterval$$anonfun$1$$anonfun$1(time), ClassTag$.MODULE$.apply(NumberFormatException.class), NotNull$.MODULE$.catsNotNullForA()).toOption();
        }).getOrElse(IOApp::logNonDaemonThreadsInterval$$anonfun$2);
    }

    public static IO onCpuStarvationWarn$(IOApp $this, CpuStarvationWarningMetrics metrics) {
        return $this.onCpuStarvationWarn(metrics);
    }

    default public IO<BoxedUnit> onCpuStarvationWarn(CpuStarvationWarningMetrics metrics) {
        return CpuStarvationCheck$.MODULE$.logWarning(metrics);
    }

    public static boolean warnOnNonMainThreadDetected$(IOApp $this) {
        return $this.warnOnNonMainThreadDetected();
    }

    default public boolean warnOnNonMainThreadDetected() {
        return BoxesRunTime.unboxToBoolean((Object)Option$.MODULE$.apply((Object)System.getProperty("cats.effect.warnOnNonMainThreadDetected")).map((Function1 & Serializable)_$2 -> _$2.equalsIgnoreCase("true")).getOrElse(IOApp::warnOnNonMainThreadDetected$$anonfun$2));
    }

    private void onNonMainThreadDetected() {
        if (this.warnOnNonMainThreadDetected()) {
            System.err.println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|[WARNING] IOApp `main` is running on a thread other than the main thread.\n             |This may prevent correct resource cleanup after `main` completes.\n             |This condition could be caused by executing `run` in an interactive sbt session with `fork := false`.\n             |To ensure proper cleanup, either\n             |  - set `Compile / run / fork := true` in this project\n             |  - use `fgRun` instead of `run`\n             |  - use 'bgStop` to terminate `run`\n             |  - update sbt to a version after 1.10.5\n             |\n             |To silence this warning set the system property:\n             |`-Dcats.effect.warnOnNonMainThreadDetected=false`.\n             |")));
            return;
        }
    }

    public IO<ExitCode> run(List<String> var1);

    public static void main$(IOApp $this, String[] args) {
        $this.main(args);
    }

    default public void main(String[] args) {
        boolean installed;
        boolean bl;
        boolean isForked;
        boolean bl2 = isForked = Thread.currentThread().getId() == 1L;
        if (!isForked) {
            this.onNonMainThreadDetected();
        }
        if (this.runtime() == null) {
            boolean installed2 = IORuntime$.MODULE$.installGlobal((Function0<IORuntime>)((Function0 & Serializable)this::$anonfun$1));
            this.cats$effect$IOApp$$_runtime_$eq(IORuntime$.MODULE$.global());
            bl = installed2;
        } else {
            bl = installed = IORuntime$.MODULE$.installGlobal((Function0<IORuntime>)((Function0 & Serializable)this::$anonfun$5));
        }
        if (!installed) {
            System.err.println("WARNING: Cats Effect global runtime already initialized; custom configurations will be ignored");
        }
        if (TracingConstants.isStackTracing) {
            List liveFiberSnapshotSignal = scala.sys.package$.MODULE$.props().get("os.name").toList().map((Function1 & Serializable)_$4 -> _$4.toLowerCase()).filterNot((Function1 & Serializable)_$5 -> _$5.contains("windows")).flatMap((Function1 & Serializable)_$6 -> (IterableOnce)new .colon.colon((Object)"USR1", (List)new .colon.colon((Object)"INFO", (List)Nil$.MODULE$)));
            liveFiberSnapshotSignal.foreach((Function1)(JProcedure1 & Serializable)name -> Signal.handle(name, _$7 -> this.runtime().fiberMonitor().liveFiberSnapshot((Function1<String, BoxedUnit>)(JProcedure1 & Serializable)_$8 -> System.err.print((String)_$8))));
        }
        Runtime rt = Runtime.getRuntime();
        AtomicInteger counter = new AtomicInteger(1);
        IO<ExitCode> ioa = this.run((List<String>)Predef$.MODULE$.wrapRefArray((Object[])args).toList());
        ArrayBlockingQueue<Object> queue = this.cats$effect$IOApp$$queue();
        IO iO = (IO)JvmCpuStarvationMetrics$.MODULE$.apply(this.runtime().metrics().cpuStarvationSampler()).flatMap((Function1 & Serializable)_$9 -> CpuStarvationCheck$.MODULE$.run(this.runtimeConfig(), this.runtime().metrics().cpuStarvationSampler(), (Function1<CpuStarvationWarningMetrics, IO<BoxedUnit>>)(Function1 & Serializable)metrics -> this.onCpuStarvationWarn((CpuStarvationWarningMetrics)metrics)).background()).surround(ioa, IO$.MODULE$.asyncForIO());
        IOFiber fiber = iO.unsafeRunFiber((Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            IOApp.$anonfun$10(counter, queue);
            return BoxedUnit.UNIT;
        }, (Function1<Throwable, BoxedUnit>)(JProcedure1 & Serializable)t -> {
            if (counter.decrementAndGet() == 0) {
                queue.clear();
            }
            queue.put(t);
        }, (JProcedure1 & Serializable)a -> {
            if (counter.decrementAndGet() == 0) {
                queue.clear();
            }
            queue.put(a);
        }, iO.unsafeRunFiber$default$4(), this.runtime());
        Object object = TracingConstants.isStackTracing ? this.runtime().fiberMonitor().monitorSuspended(fiber) : BoxedUnit.UNIT;
        Thread hook = new Thread(() -> this.handleShutdown$1(counter, fiber, isForked));
        hook.setName("io-cancel-hook");
        try {
            rt.addShutdownHook(hook);
        }
        catch (IllegalStateException illegalStateException) {
            this.handleShutdown$1(counter, fiber, isForked);
        }
        try {
            boolean done = false;
            while (!done) {
                Object result = scala.concurrent.package$.MODULE$.blocking(() -> IOApp.$anonfun$14(queue));
                Object object2 = result;
                if (object2 instanceof ExitCode) {
                    ExitCode ec = (ExitCode)object2;
                    if (!isForked) {
                        this.runtime().shutdown().apply$mcV$sp();
                    }
                    ExitCode exitCode = ec;
                    ExitCode exitCode2 = ExitCode$.MODULE$.Success();
                    if (!(exitCode != null ? !((Object)exitCode).equals(exitCode2) : exitCode2 != null)) {
                        if (isForked && this.logNonDaemonThreadsEnabled()) {
                            new NonDaemonThreadLogger(this.logNonDaemonThreadsInterval()).start();
                        }
                    } else if (isForked) {
                        System.exit(ec.code());
                    }
                    done = true;
                    continue;
                }
                if (object2 instanceof CancellationException) {
                    CancellationException e = (CancellationException)object2;
                    if (isForked) {
                        System.exit(1);
                        continue;
                    }
                    throw e;
                }
                if (object2 instanceof Throwable) {
                    Throwable t2 = (Throwable)object2;
                    if (UnsafeNonFatal.apply(t2)) {
                        if (isForked) {
                            t2.printStackTrace();
                            System.exit(1);
                            continue;
                        }
                        throw t2;
                    }
                    t2.printStackTrace();
                    rt.halt(1);
                    continue;
                }
                if (object2 instanceof Runnable) {
                    Runnable r = (Runnable)object2;
                    try {
                        r.run();
                        continue;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable t3 = throwable2 = throwable;
                        if (UnsafeNonFatal.apply(t3)) {
                            this.reportFailure(t3).unsafeRunAndForgetWithoutCallback(this.runtime());
                            continue;
                        }
                        if (throwable2 != null) {
                            Throwable t4 = throwable2;
                            t4.printStackTrace();
                            rt.halt(1);
                            continue;
                        }
                        throw throwable;
                    }
                }
                throw new IllegalStateException(new StringBuilder(20).append(result.getClass().getName()).append(" in MainThread queue").toString());
            }
        }
        catch (InterruptedException interruptedException) {
            hook.start();
            rt.removeShutdownHook(hook);
            Thread.currentThread().interrupt();
        }
    }

    private static FiniteDuration logNonDaemonThreadsInterval$$anonfun$1$$anonfun$1(String time$1) {
        return new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(time$1)))).millis();
    }

    private static FiniteDuration logNonDaemonThreadsInterval$$anonfun$2() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds();
    }

    private static boolean warnOnNonMainThreadDetected$$anonfun$2() {
        return true;
    }

    private IORuntime $anonfun$1() {
        Duration duration;
        Duration duration2;
        String string;
        int n = this.computeWorkerThreadCount();
        JProcedure1 & Serializable intersect = (JProcedure1 & Serializable)t -> this.reportFailure((Throwable)t).unsafeRunAndForgetWithoutCallback(this.runtime());
        boolean bl = this.blockedThreadDetectionEnabled();
        PollingSystem pollingSystem = this.pollingSystem();
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = (_$3, t) -> this.cats$effect$IOApp$$handleTerminalFailure(t);
        String string2 = IORuntime$.MODULE$.createWorkStealingComputeThreadPool$default$2();
        Tuple3<WorkStealingThreadPool<?>, Object, Function0<BoxedUnit>> tuple3 = IORuntime$.MODULE$.createWorkStealingComputeThreadPool(n, string2, string = IORuntime$.MODULE$.createWorkStealingComputeThreadPool$default$3(), duration2 = IORuntime$.MODULE$.createWorkStealingComputeThreadPool$default$4(), (Function1<Throwable, BoxedUnit>)intersect, bl, duration = IORuntime$.MODULE$.createWorkStealingComputeThreadPool$default$7(), pollingSystem, uncaughtExceptionHandler);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        WorkStealingThreadPool compute = (WorkStealingThreadPool)tuple3._1();
        Object poller = tuple3._2();
        Function0 compDown = (Function0)tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)compute, poller, (Object)compDown);
        WorkStealingThreadPool compute2 = (WorkStealingThreadPool)tuple32._1();
        Object poller2 = tuple32._2();
        Function0 compDown2 = (Function0)tuple32._3();
        Tuple2<ExecutionContext, Function0<BoxedUnit>> tuple2 = IORuntime$.MODULE$.createDefaultBlockingExecutionContext("io-blocking", (Function1<Throwable, BoxedUnit>)(JProcedure1 & Serializable)t -> this.reportFailure((Throwable)t).unsafeRunAndForgetWithoutCallback(this.runtime()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ExecutionContext blocking = (ExecutionContext)tuple2._1();
        Function0 blockDown = (Function0)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)blocking, (Object)blockDown);
        ExecutionContext blocking2 = (ExecutionContext)tuple22._1();
        Function0 blockDown2 = (Function0)tuple22._2();
        return IORuntime$.MODULE$.apply((ExecutionContext)compute2, blocking2, (Scheduler)compute2, (List<Object>)((List)new .colon.colon(poller2, (List)Nil$.MODULE$)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            compDown2.apply$mcV$sp();
            blockDown2.apply$mcV$sp();
            IORuntime$.MODULE$.resetGlobal();
        }, this.runtimeConfig());
    }

    private IORuntime $anonfun$5() {
        return this.runtime();
    }

    private static void $anonfun$10(AtomicInteger counter$1, ArrayBlockingQueue queue$1) {
        if (counter$1.decrementAndGet() == 0) {
            queue$1.clear();
        }
        queue$1.put(new CancellationException("IOApp main fiber was canceled"));
    }

    private static boolean handleShutdown$1$$anonfun$2(CountDownLatch cancelLatch$2, Duration timeout$1) {
        return cancelLatch$2.await(timeout$1.length(), timeout$1.unit());
    }

    private static void handleShutdown$1$$anonfun$3(CountDownLatch cancelLatch$3) {
        cancelLatch$3.await();
    }

    private void handleShutdown$1(AtomicInteger counter$4, IOFiber fiber$1, boolean isForked$1) {
        if (counter$4.compareAndSet(1, 0)) {
            CountDownLatch cancelLatch = new CountDownLatch(1);
            ((IO)fiber$1.cancel()).unsafeRunAsync((JProcedure1 & Serializable)_$10 -> cancelLatch.countDown(), this.runtime());
            Duration timeout = this.runtimeConfig().shutdownHookTimeout();
            if (timeout.isFinite()) {
                scala.concurrent.package$.MODULE$.blocking(() -> IOApp.handleShutdown$1$$anonfun$2(cancelLatch, timeout));
            } else {
                scala.concurrent.package$.MODULE$.blocking((Function0 & Serializable)() -> {
                    IOApp.handleShutdown$1$$anonfun$3(cancelLatch);
                    return BoxedUnit.UNIT;
                });
            }
        }
        if (!isForked$1) {
            this.runtime().shutdown().apply$mcV$sp();
            return;
        }
    }

    private static Object $anonfun$14(ArrayBlockingQueue queue$4) {
        return queue$4.take();
    }

    public static interface Simple
    extends IOApp {
        public IO<BoxedUnit> run();

        public static IO run$(Simple $this, List args) {
            return $this.run((List<String>)args);
        }

        @Override
        default public IO<ExitCode> run(List<String> args) {
            return this.run().as(ExitCode$.MODULE$.Success());
        }
    }
}

