/*
 * Decompiled with CFR 0.152.
 */
package cats.effect;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function1;
import scala.runtime.BoxedUnit;

public final class CallbackStack<A>
extends AtomicReference<Node<A>> {
    private Function1<A, BoxedUnit> callback;
    private final AtomicBoolean allowedToPack;

    public CallbackStack(Function1<A, BoxedUnit> callback) {
        this.callback = callback;
        this.allowedToPack = new AtomicBoolean(true);
    }

    public Handle<A> push(Function1<A, BoxedUnit> cb) {
        Node<A> newHead = new Node<A>(cb);
        return this.loop$1(newHead);
    }

    public void unsafeSetCallback(Function1<A, BoxedUnit> cb) {
        this.callback = cb;
    }

    public boolean apply(A a) {
        boolean bl;
        Node currentNode = (Node)this.get();
        try {
            boolean invoked;
            boolean bl2;
            Function1<A, BoxedUnit> cb = this.callback;
            if (cb != null) {
                cb.apply(a);
                bl2 = true;
            } else {
                bl2 = invoked = false;
            }
            while (currentNode != null) {
                Function1 cb2 = currentNode.getCallback();
                if (cb2 != null) {
                    cb2.apply(a);
                    currentNode.clear();
                    invoked = true;
                }
                Node nextNode = currentNode.getNext();
                currentNode.setNext(null);
                currentNode = nextNode;
            }
            this.lazySet(null);
            bl = invoked;
        }
        finally {
            while (currentNode != null) {
                Node nextNode = currentNode.getNext();
                currentNode.clear();
                currentNode.setNext(null);
                currentNode = nextNode;
            }
            this.lazySet(null);
        }
        return bl;
    }

    public boolean clearHandle(Handle<A> handle) {
        handle.clear();
        return false;
    }

    public int pack(int bound) {
        if (this.allowedToPack.compareAndSet(true, false)) {
            int n;
            try {
                Node got = (Node)this.get();
                n = got != null ? got.packHead(bound, 0, this) : 0;
            }
            finally {
                this.allowedToPack.set(true);
            }
            return n;
        }
        return 0;
    }

    @Override
    public String toString() {
        return new StringBuilder(17).append("CallbackStack(").append(this.callback).append(", ").append(this.get()).append(")").toString();
    }

    private final Handle loop$1(Node newHead$1) {
        Node currentHead;
        do {
            currentHead = (Node)this.get();
            newHead$1.setNext(currentHead);
        } while (!this.compareAndSet(currentHead, newHead$1));
        return newHead$1;
    }

    public static <A> CallbackStack<A> of(Function1<A, BoxedUnit> cb) {
        return new CallbackStack<A>(cb);
    }

    public static abstract class Handle<A> {
        public abstract void clear();
    }

    public static final class Node<A>
    extends Handle<A> {
        private Function1<A, BoxedUnit> callback;
        private Node<A> next;

        public Node(Function1<A, BoxedUnit> callback) {
            this.callback = callback;
        }

        public Function1<A, BoxedUnit> getCallback() {
            return this.callback;
        }

        public Node<A> getNext() {
            return this.next;
        }

        public void setNext(Node<A> next) {
            this.next = next;
        }

        @Override
        public void clear() {
            this.callback = null;
        }

        public int packHead(int bound, int removed, CallbackStack<A> root) {
            Node<A> next;
            block6: {
                while (true) {
                    next = this_.next;
                    if (this_.callback != null) break block6;
                    if (!root.compareAndSet(this_, next)) break;
                    if (next == null) {
                        return removed + 1;
                    }
                    Node<A> node = next;
                    int n = bound - 1;
                    int n2 = removed + 1;
                    Node<A> this_ = node;
                    bound = n;
                    removed = n2;
                }
                Node prev = (Node)root.get();
                if (prev != null && prev.getNext() == this_) {
                    return super.packTail(bound, removed, prev);
                }
                if (next != null) {
                    return super.packTail(bound - 1, removed, this_);
                }
                return removed;
            }
            if (next == null) {
                return removed;
            }
            if (bound > 0) {
                return super.packTail(bound - 1, removed, this_);
            }
            return removed;
        }

        private int packTail(int bound, int removed, Node<A> prev) {
            while (true) {
                Node<A> this_;
                Node<A> next = this_.next;
                if (this_.callback == null) {
                    prev.setNext(next);
                    if (next == null) {
                        return removed + 1;
                    }
                    Node<A> node = next;
                    int n = bound - 1;
                    int n2 = removed + 1;
                    this_ = node;
                    bound = n;
                    removed = n2;
                    continue;
                }
                if (next == null) {
                    return removed;
                }
                if (bound <= 0) break;
                Node<A> node = next;
                int n = bound - 1;
                Node<A> node2 = this_;
                this_ = node;
                bound = n;
                prev = node2;
            }
            return removed;
        }

        public String toString() {
            return new StringBuilder(8).append("Node(").append(this.callback).append(", ").append(this.next).append(")").toString();
        }
    }
}

