/*
 * Decompiled with CFR 0.152.
 */
package cats.effect;

import cats.effect.ByteStack$;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.RichInt$;

public final class ByteStack {
    public static Function1<Object, String> toDebugString$default$2() {
        return ByteStack$.MODULE$.toDebugString$default$2();
    }

    public static final String toDebugString(int[] stack, Function1<Object, String> translate) {
        int count = ByteStack.size(stack);
        return ((StringBuilder)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(count - 1), 0).by(-1).foldLeft((Object)new StringBuilder().append("Stack:").append(" capacity = ").append((stack.length - 1) * 8).append(',').append(" count = ").append(count).append(',').append(" content (top-first) = [ "), (arg_0, arg_1) -> ByteStack$.cats$effect$ByteStack$$_$toDebugString$$anonfun$adapted$1(translate, stack, arg_0, arg_1))).append(']').toString();
    }

    public static final int[] create(int initialMaxOps) {
        return new int[2 + (initialMaxOps - 1 >> 3)];
    }

    public static final int[] growIfNeeded(int[] stack, int count) {
        if (1 + (count + 1 >> 3) < stack.length) {
            return stack;
        }
        int[] bigger = new int[stack.length << 1];
        System.arraycopy(stack, 0, bigger, 0, stack.length);
        return bigger;
    }

    public static final int[] push(int[] stack, byte op) {
        int c = stack[0];
        int[] use = ByteStack.growIfNeeded(stack, c);
        int s = (c >> 3) + 1;
        int shift = (c & 7) << 2;
        use[s] = use[s] & ~(-1 << shift) | op << shift;
        use[0] = use[0] + 1;
        return use;
    }

    public static final int size(int[] stack) {
        return stack[0];
    }

    public static final boolean isEmpty(int[] stack) {
        return stack[0] < 1;
    }

    public static final byte read(int[] stack, int pos) {
        if (pos < 0 || pos >= stack[0]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (byte)(stack[(pos >> 3) + 1] >>> ((pos & 7) << 2) & 0xF);
    }

    public static final byte peek(int[] stack) {
        int c = stack[0] - 1;
        if (c < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return (byte)(stack[(c >> 3) + 1] >>> ((c & 7) << 2) & 0xF);
    }

    public static final byte pop(int[] stack) {
        byte op = ByteStack.peek(stack);
        stack[0] = stack[0] - 1;
        return op;
    }
}

