/*
 * Decompiled with CFR 0.152.
 */
package cats.effect;

public final class ArrayStack<A> {
    private Object[] buffer;
    private int index;

    public ArrayStack(Object[] buffer, int index) {
        this.buffer = buffer;
        this.index = index;
    }

    public ArrayStack(int initBound) {
        this(new Object[initBound], 0);
    }

    public ArrayStack() {
        this(null, 0);
    }

    public void init(int bound) {
        this.buffer = new Object[bound];
        this.index = 0;
    }

    public void push(A a) {
        this.checkAndGrow();
        this.buffer[this.index] = a;
        ++this.index;
    }

    public A pop() {
        --this.index;
        Object back = this.buffer[this.index];
        this.buffer[this.index] = null;
        return (A)back;
    }

    public A peek() {
        return (A)this.buffer[this.index - 1];
    }

    public boolean isEmpty() {
        return this.index <= 0;
    }

    public Object[] unsafeBuffer() {
        return this.buffer;
    }

    public int unsafeIndex() {
        return this.index;
    }

    public void unsafeSet(int newI) {
        for (int i = newI; i < this.index; ++i) {
            this.buffer[i] = null;
        }
        this.index = newI;
    }

    public void invalidate() {
        this.index = 0;
        this.buffer = null;
    }

    private void checkAndGrow() {
        if (this.index >= this.buffer.length) {
            int len = this.buffer.length;
            int targetLen = len * 2;
            if (targetLen < 0) {
                throw new Exception(new StringBuilder(47).append("Overflow while resizing array. Request length: ").append(targetLen).toString());
            }
            int resizeLen = len > 0x3FFFFFFB ? 0x7FFFFFF7 : targetLen;
            Object[] buffer2 = new Object[resizeLen];
            System.arraycopy(this.buffer, 0, buffer2, 0, len);
            this.buffer = buffer2;
            return;
        }
    }

    public static <A> ArrayStack<A> apply() {
        return new ArrayStack<A>();
    }

    public static <A> ArrayStack<A> apply(int size) {
        return new ArrayStack<A>(size);
    }
}

