/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.udf;

import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.daffodil.lib.util.Logger$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.runtime1.dpath.NodeInfo;
import org.apache.daffodil.runtime1.dpath.NodeInfo$;
import org.apache.daffodil.runtime1.udf.UserDefinedFunctionFatalErrorException;
import org.apache.daffodil.runtime1.udf.UserDefinedFunctionService;
import org.apache.daffodil.udf.UserDefinedFunction;
import org.apache.daffodil.udf.UserDefinedFunctionIdentification;
import org.apache.daffodil.udf.UserDefinedFunctionProvider;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Seq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class UserDefinedFunctionService$ {
    public static final UserDefinedFunctionService$ MODULE$ = new UserDefinedFunctionService$();
    private static String evaluateMethodName;
    private static Class<UserDefinedFunctionIdentification> classUserDefinedFunctionIdentification;
    private static Class<UserDefinedFunction> classUserDefinedFunction;
    private static String currentClassPath;
    private static final HashMap<String, UserDefinedFunctionService.UserDefinedFunctionInfo> udfInfoLookup;
    private static final HashMap<String, Option<UserDefinedFunctionService.UserDefinedFunctionCallingInfo>> initializedUserDefinedFunctionsCache;
    private static volatile byte bitmap$0;

    static {
        udfInfoLookup = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        initializedUserDefinedFunctionsCache = (HashMap)HashMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ServiceLoader<UserDefinedFunctionProvider> loader = ServiceLoader.load(UserDefinedFunctionProvider.class);
        Iterator<UserDefinedFunctionProvider> providerIter = loader.iterator();
        while (providerIter.hasNext()) {
            Option providerOpt = UserDefinedFunctionService$.liftedTree1$1(providerIter);
            Seq providerFunctionClasses = (Seq)providerOpt.map((Function1 & Serializable)provider -> {
                Seq seq;
                block7: {
                    try {
                        Class[] functionClasses = provider.getUserDefinedFunctionClasses();
                        if (functionClasses == null || ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])functionClasses))) {
                            BoxedUnit boxedUnit;
                            if (Logger$.MODULE$.log().underlying().isWarnEnabled()) {
                                Logger$.MODULE$.log().underlying().warn("User Defined Function Provider ignored: {}. No User Defined Functions found.", (Object)provider.getClass().getName());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            seq = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
                            break block7;
                        }
                        seq = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])functionClasses));
                    }
                    catch (Exception e) {
                        BoxedUnit boxedUnit;
                        if (Logger$.MODULE$.log().underlying().isWarnEnabled()) {
                            Logger$.MODULE$.log().underlying().warn("User Defined Function Provider ignored: {}. Error loading User Defined Functions: {}", new Object[]{provider.getClass().getName(), e});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        seq = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
                    }
                }
                return seq;
            }).getOrElse((Function0 & Serializable)() -> (scala.collection.mutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$));
            Seq goodFunctionClasses = (Seq)providerFunctionClasses.filter((Function1 & Serializable)udfc -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionService$.$anonfun$new$3(udfc)));
            goodFunctionClasses.foreach((Function1 & Serializable)fc -> {
                UserDefinedFunctionService$.$anonfun$new$4(providerOpt, fc);
                return BoxedUnit.UNIT;
            });
        }
    }

    private String evaluateMethodName$lzycompute() {
        UserDefinedFunctionService$ userDefinedFunctionService$ = this;
        synchronized (userDefinedFunctionService$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                evaluateMethodName = "evaluate";
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return evaluateMethodName;
    }

    public String evaluateMethodName() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.evaluateMethodName$lzycompute();
        }
        return evaluateMethodName;
    }

    private HashMap<String, UserDefinedFunctionService.UserDefinedFunctionInfo> udfInfoLookup() {
        return udfInfoLookup;
    }

    private HashMap<String, Option<UserDefinedFunctionService.UserDefinedFunctionCallingInfo>> initializedUserDefinedFunctionsCache() {
        return initializedUserDefinedFunctionsCache;
    }

    private Class<UserDefinedFunctionIdentification> classUserDefinedFunctionIdentification$lzycompute() {
        UserDefinedFunctionService$ userDefinedFunctionService$ = this;
        synchronized (userDefinedFunctionService$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                classUserDefinedFunctionIdentification = UserDefinedFunctionIdentification.class;
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return classUserDefinedFunctionIdentification;
    }

    public Class<UserDefinedFunctionIdentification> classUserDefinedFunctionIdentification() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.classUserDefinedFunctionIdentification$lzycompute();
        }
        return classUserDefinedFunctionIdentification;
    }

    private Class<UserDefinedFunction> classUserDefinedFunction$lzycompute() {
        UserDefinedFunctionService$ userDefinedFunctionService$ = this;
        synchronized (userDefinedFunctionService$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                classUserDefinedFunction = UserDefinedFunction.class;
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return classUserDefinedFunction;
    }

    public Class<UserDefinedFunction> classUserDefinedFunction() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.classUserDefinedFunction$lzycompute();
        }
        return classUserDefinedFunction;
    }

    private String currentClassPath$lzycompute() {
        UserDefinedFunctionService$ userDefinedFunctionService$ = this;
        synchronized (userDefinedFunctionService$) {
            if ((byte)(bitmap$0 & 8) == 0) {
                currentClassPath = ((IterableOnceOps)Misc$.MODULE$.classPath().map((Function1 & Serializable)x$1 -> x$1.toString())).mkString("\n");
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return currentClassPath;
    }

    public String currentClassPath() {
        if ((byte)(bitmap$0 & 8) == 0) {
            return this.currentClassPath$lzycompute();
        }
        return currentClassPath;
    }

    public Option<UserDefinedFunctionService.UserDefinedFunctionCallingInfo> lookupUserDefinedFunctionCallingInfo(String namespaceURI, String fname) {
        String udfid = new StringBuilder(2).append("{").append(namespaceURI).append("}").append(fname).toString();
        Option udfFunctionCallingInfo = (Option)this.initializedUserDefinedFunctionsCache().getOrElse((Object)udfid, (Function0 & Serializable)() -> {
            Option maybeUdfInfo = MODULE$.udfInfoLookup().get((Object)udfid);
            return maybeUdfInfo.flatMap((Function1 & Serializable)udfInfo -> {
                None$ none$;
                try {
                    UserDefinedFunction udf2 = udfInfo.provider().createUserDefinedFunction(namespaceURI, fname);
                    try {
                        new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(udf2);
                        none$ = Option$.MODULE$.apply((Object)udf2);
                    }
                    catch (NotSerializableException e) {
                        BoxedUnit boxedUnit;
                        if (Logger$.MODULE$.log().underlying().isWarnEnabled()) {
                            Logger$.MODULE$.log().underlying().warn("User Defined Function is not serializable: {}. Could not serialize member of class: {}", new Object[]{udf2.getClass().getName(), e.getMessage()});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        none$ = None$.MODULE$;
                    }
                }
                catch (Exception e) {
                    Exception exception = e;
                    Throwable actualCause = exception instanceof ReflectiveOperationException ? e.getCause() : exception;
                    throw new UserDefinedFunctionFatalErrorException(new StringBuilder(48).append("User Defined Function could not be initialized: ").append(udfid).toString(), actualCause, udfInfo.udfClass().getName(), udfInfo.provider().getClass().getName());
                }
                None$ maybeUdf = none$;
                return maybeUdf.flatMap((Function1 & Serializable)udf -> {
                    Class<?> actualUdfClass;
                    Class<?> expectedUdfClass = udfInfo.udfClass();
                    Class<?> clazz = actualUdfClass = udf.getClass();
                    Class<?> clazz2 = expectedUdfClass;
                    if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
                        BoxedUnit boxedUnit;
                        if (Logger$.MODULE$.log().underlying().isWarnEnabled()) {
                            Logger$.MODULE$.log().underlying().warn("User Defined Function class mismatch: {}. Expected: {} Actual: {}", new Object[]{udfid, expectedUdfClass, actualUdfClass});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return None$.MODULE$;
                    }
                    UserDefinedFunctionService.EvaluateMethodInfo udfInfoEval = udfInfo.evaluateMethodInfo();
                    udfInfoEval.evaluateMethod().method();
                    Some udfci = new Some((Object)new UserDefinedFunctionService.UserDefinedFunctionCallingInfo((UserDefinedFunction)udf, udfInfo.evaluateMethodInfo()));
                    MODULE$.initializedUserDefinedFunctionsCache().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)udfid), (Object)udfci));
                    return udfci;
                });
            });
        });
        return udfFunctionCallingInfo;
    }

    private static final /* synthetic */ Option liftedTree1$1(Iterator providerIter$1) {
        Some some;
        try {
            some = new Some(providerIter$1.next());
        }
        catch (ServiceConfigurationError e) {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            if (Logger$.MODULE$.log().underlying().isWarnEnabled()) {
                Logger$.MODULE$.log().underlying().warn("User Defined Function Provider failed to load: {}. Enable debug logging for more details", (Object)e.getMessage());
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (Logger$.MODULE$.log().underlying().isDebugEnabled()) {
                Logger logger = Logger$.MODULE$.log().underlying();
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.close();
                logger.debug(sw.toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            some = None$.MODULE$;
        }
        return some;
    }

    public static final /* synthetic */ boolean $anonfun$new$3(Class udfc) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        boolean nonUdf;
        boolean nonAnn = !udfc.isAnnotationPresent(MODULE$.classUserDefinedFunctionIdentification());
        boolean bl = nonUdf = !MODULE$.classUserDefinedFunction().isAssignableFrom(udfc);
        if (nonAnn) {
            if (Logger$.MODULE$.log().underlying().isWarnEnabled()) {
                Logger$.MODULE$.log().underlying().warn("User Defined Function ignored: {}. Missing {} annotation", new Object[]{udfc.getName(), MODULE$.classUserDefinedFunctionIdentification().getName()});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (nonUdf) {
            if (Logger$.MODULE$.log().underlying().isWarnEnabled()) {
                Logger$.MODULE$.log().underlying().warn("User Defined Function ignored: {}. Doesn't implement {}", new Object[]{udfc.getName(), MODULE$.classUserDefinedFunction().getName()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean ret = !nonAnn && !nonUdf;
        return ret;
    }

    public static final /* synthetic */ boolean $anonfun$new$5(Method x$2) {
        String string = x$2.getName();
        String string2 = MODULE$.evaluateMethodName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$4(Option providerOpt$1, Class fc) {
        BoxedUnit boxedUnit;
        Some some;
        NodeInfo.PrimType evaluateReturnType;
        String fcClassName = fc.getName();
        UserDefinedFunctionIdentification fInfo = fc.getDeclaredAnnotation(MODULE$.classUserDefinedFunctionIdentification());
        String fns = fInfo.namespaceURI();
        String fname = fInfo.name();
        Method[] evalMethods = (Method[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])fc.getMethods()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionService$.$anonfun$new$5(x$2)));
        if (Misc$.MODULE$.isNullOrBlank(fns)) {
            BoxedUnit boxedUnit2;
            if (Logger$.MODULE$.log().underlying().isWarnEnabled()) {
                Logger$.MODULE$.log().underlying().warn("User Defined Function ignored: {}. Annotation namespace field is empty or invalid.", (Object)fcClassName);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return;
        }
        if (Misc$.MODULE$.isNullOrBlank(fname)) {
            BoxedUnit boxedUnit3;
            if (Logger$.MODULE$.log().underlying().isWarnEnabled()) {
                Logger$.MODULE$.log().underlying().warn("User Defined Function ignored: {}. Annotation name field is empty or invalid.", (Object)fcClassName);
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            return;
        }
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])evalMethods))) {
            BoxedUnit boxedUnit4;
            if (Logger$.MODULE$.log().underlying().isWarnEnabled()) {
                Logger$.MODULE$.log().underlying().warn("User Defined Function ignored: {}. Missing evaluate method: {}:{}", new Object[]{fcClassName, fns, fname});
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            return;
        }
        if (evalMethods.length > 1) {
            BoxedUnit boxedUnit5;
            if (Logger$.MODULE$.log().underlying().isWarnEnabled()) {
                Logger$.MODULE$.log().underlying().warn("User Defined Function ignored: {}. Overloaded evaluate method: {}:{}", new Object[]{fcClassName, fns, fname});
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            return;
        }
        Method evaluateMethod = (Method)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])evalMethods));
        Class[] paramTypes = evaluateMethod.getParameterTypes();
        Class<?> returnType = evaluateMethod.getReturnType();
        Tuple2[] initParamTypeConv = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])paramTypes))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Class c = (Class)tuple2._1();
                int i = tuple2._2$mcI$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(NodeInfo$.MODULE$.fromClass(c)), (Object)BoxesRunTime.boxToInteger((int)i));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        Option<NodeInfo.PrimType> initRetTypeConv = NodeInfo$.MODULE$.fromClass(returnType);
        String[] badParams = (String[])ArrayOps$.MODULE$.collect$extension(Predef$.MODULE$.refArrayOps((Object[])initParamTypeConv), (PartialFunction)new Serializable(paramTypes){
            private static final long serialVersionUID = 0L;
            private final Class[] paramTypes$1;

            public final <A1 extends Tuple2<Option<NodeInfo.PrimType>, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    Option t = (Option)A1._1();
                    int i = A1._2$mcI$sp();
                    if (t.isEmpty()) {
                        Class cn = this.paramTypes$1[i];
                        return (B1)cn.getSimpleName();
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Option<NodeInfo.PrimType>, Object> x1) {
                Option t;
                Tuple2<Option<NodeInfo.PrimType>, Object> tuple2 = x1;
                return tuple2 != null && (t = (Option)tuple2._1()).isEmpty();
            }
            {
                this.paramTypes$1 = paramTypes$1;
            }
        }, ClassTag$.MODULE$.apply(String.class));
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])badParams))) {
            BoxedUnit boxedUnit6;
            if (Logger$.MODULE$.log().underlying().isWarnEnabled()) {
                Logger$.MODULE$.log().underlying().warn("User Defined Function ignored: {}. Unsupported parameter type(s): {}", new Object[]{fcClassName, Predef$.MODULE$.wrapRefArray((Object[])badParams).mkString(",")});
                boxedUnit6 = BoxedUnit.UNIT;
            } else {
                boxedUnit6 = BoxedUnit.UNIT;
            }
            return;
        }
        if (initRetTypeConv.isEmpty()) {
            BoxedUnit boxedUnit7;
            if (Logger$.MODULE$.log().underlying().isWarnEnabled()) {
                Logger$.MODULE$.log().underlying().warn("User Defined Function ignored: {}. Unsupported return type: {}", new Object[]{fcClassName, returnType.getSimpleName()});
                boxedUnit7 = BoxedUnit.UNIT;
            } else {
                boxedUnit7 = BoxedUnit.UNIT;
            }
            return;
        }
        List evaluateParamTypes = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])initParamTypeConv), (Function1 & Serializable)x$3 -> (Option)x$3._1(), ClassTag$.MODULE$.apply(NodeInfo.PrimType.class))).toList();
        Option<NodeInfo.PrimType> option = initRetTypeConv;
        if (!(option instanceof Some) || (evaluateReturnType = (NodeInfo.PrimType)(some = (Some)option).value()) == null) {
            throw new MatchError(option);
        }
        NodeInfo.PrimType primType = evaluateReturnType;
        NodeInfo.PrimType evaluateReturnType2 = primType;
        String key = new StringBuilder(2).append("{").append(fns).append("}").append(fname).toString();
        if (MODULE$.udfInfoLookup().contains((Object)key)) {
            BoxedUnit boxedUnit8;
            UserDefinedFunctionService.UserDefinedFunctionInfo udfInfo = (UserDefinedFunctionService.UserDefinedFunctionInfo)MODULE$.udfInfoLookup().apply((Object)key);
            if (Logger$.MODULE$.log().underlying().isWarnEnabled()) {
                Logger$.MODULE$.log().underlying().warn("User Defined Function ignored: {}. Duplicate {} from {} found.", new Object[]{fcClassName, key, udfInfo.udfClass().getName()});
                boxedUnit8 = BoxedUnit.UNIT;
            } else {
                boxedUnit8 = BoxedUnit.UNIT;
            }
            return;
        }
        UserDefinedFunctionService.UserDefinedFunctionMethod serializableEvaluate = new UserDefinedFunctionService.UserDefinedFunctionMethod(evaluateMethod.getDeclaringClass(), MODULE$.evaluateMethodName(), paramTypes);
        UserDefinedFunctionService.EvaluateMethodInfo emi = new UserDefinedFunctionService.EvaluateMethodInfo(serializableEvaluate, (List<NodeInfo.Kind>)evaluateParamTypes, evaluateReturnType2);
        MODULE$.udfInfoLookup().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new UserDefinedFunctionService.UserDefinedFunctionInfo(fc, (UserDefinedFunctionProvider)providerOpt$1.get(), emi)));
        if (Logger$.MODULE$.log().underlying().isDebugEnabled()) {
            Logger$.MODULE$.log().underlying().debug("User Defined Function loaded: {} => {}", new Object[]{fcClassName, key});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private UserDefinedFunctionService$() {
    }
}

