/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import org.apache.daffodil.lib.api.Diagnostic;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.schema.annotation.props.gen.LengthUnits;
import org.apache.daffodil.lib.util.MaybeInt$;
import org.apache.daffodil.lib.util.MaybeULong$;
import org.apache.daffodil.lib.util.Numbers$;
import org.apache.daffodil.lib.util.OKOrError$;
import org.apache.daffodil.runtime1.infoset.DIComplex;
import org.apache.daffodil.runtime1.infoset.DIElement;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import org.apache.daffodil.runtime1.infoset.Infoset$;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.ProcessingError;
import org.apache.daffodil.runtime1.processors.SimpleTypeRuntimeData;
import org.apache.daffodil.runtime1.processors.Success$;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.Parser;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u000553q\u0001C\u0005\u0011\u0002\u0007\u0005a\u0003C\u0003\u001e\u0001\u0011\u0005a\u0004C\u0003#\u0001\u0019\u00051\u0005C\u0003)\u0001\u0019\u0005\u0011\u0006C\u0003/\u0001\u0019\u0005q\u0006C\u0003?\u0001\u0019\u0005q\bC\u0003D\u0001\u0011\u0005A\tC\u0003K\u0001\u0011\u00051JA\rQe\u00164\u0017\u000e_3e\u0019\u0016tw\r\u001e5QCJ\u001cXM]'jq&t'B\u0001\u0006\f\u0003\u001d\u0001\u0018M]:feNT!\u0001D\u0007\u0002\u0015A\u0014xnY3tg>\u00148O\u0003\u0002\u000f\u001f\u0005A!/\u001e8uS6,\u0017G\u0003\u0002\u0011#\u0005AA-\u00194g_\u0012LGN\u0003\u0002\u0013'\u00051\u0011\r]1dQ\u0016T\u0011\u0001F\u0001\u0004_J<7\u0001A\n\u0003\u0001]\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0017A\u0002\u0013j]&$H\u0005F\u0001 !\tA\u0002%\u0003\u0002\"3\t!QK\\5u\u0003Q\u0001(/\u001a4jq\u0016$G*\u001a8hi\"\u0004\u0016M]:feV\tA\u0005\u0005\u0002&M5\t\u0011\"\u0003\u0002(\u0013\t1\u0001+\u0019:tKJ\f\u0011\u0003\u001d:fM&DX\r\u001a'f]\u001e$\b.\u0012*E+\u0005Q\u0003CA\u0016-\u001b\u0005Y\u0011BA\u0017\f\u0005I)E.Z7f]R\u0014VO\u001c;j[\u0016$\u0015\r^1\u0002\u00171,gn\u001a;i+:LGo]\u000b\u0002aA\u0011\u0011\u0007P\u0007\u0002e)\u00111\u0007N\u0001\u0004O\u0016t'BA\u001b7\u0003\u0015\u0001(o\u001c9t\u0015\t9\u0004(\u0001\u0006b]:|G/\u0019;j_:T!!\u000f\u001e\u0002\rM\u001c\u0007.Z7b\u0015\tYt\"A\u0002mS\nL!!\u0010\u001a\u0003\u00171+gn\u001a;i+:LGo]\u0001 aJ,g-\u001b=fI2+gn\u001a;i\u0003\u0012TWo\u001d;nK:$\u0018J\\+oSR\u001cX#\u0001!\u0011\u0005a\t\u0015B\u0001\"\u001a\u0005\u0011auN\\4\u00021\u001d,G\u000f\u0015:fM&DX\r\u001a'f]\u001e$\b.\u00138V]&$8\u000f\u0006\u0002A\u000b\")aI\u0002a\u0001\u000f\u0006)1\u000f^1uKB\u0011Q\u0005S\u0005\u0003\u0013&\u0011a\u0001U*uCR,\u0017aF4fiB\u0013XMZ5yK\u0012dUM\\4uQ&s')\u001b;t)\t\u0001E\nC\u0003G\u000f\u0001\u0007q\t")
public interface PrefixedLengthParserMixin {
    public Parser prefixedLengthParser();

    public ElementRuntimeData prefixedLengthERD();

    public LengthUnits lengthUnits();

    public long prefixedLengthAdjustmentInUnits();

    public static /* synthetic */ long getPrefixedLengthInUnits$(PrefixedLengthParserMixin $this, PState state) {
        return $this.getPrefixedLengthInUnits(state);
    }

    default public long getPrefixedLengthInUnits(PState state) {
        DIElement savedInfoset = state.infoset();
        DISimple plElement = (DISimple)Infoset$.MODULE$.newDetachedElement(state, this.prefixedLengthERD());
        state.infoset_$eq(plElement);
        try {
            this.prefixedLengthParser().parse1(state);
        }
        finally {
            state.infoset_$eq(savedInfoset);
        }
        if (state.processorStatus() == Success$.MODULE$) {
            SimpleTypeRuntimeData strd;
            String check;
            Long parsedLen = Numbers$.MODULE$.asLong(DataValue$.MODULE$.getAnyRef$extension(plElement.dataValue()));
            if (Predef$.MODULE$.Long2long(parsedLen) < 0L) {
                throw state.SDE("Prefixed length result must be non-negative, but was: %d", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{parsedLen}));
            }
            long adjustedLen = Predef$.MODULE$.Long2long(parsedLen) - this.prefixedLengthAdjustmentInUnits();
            if (adjustedLen < 0L) {
                throw state.SDE("Prefixed length result must be non-negative after dfdl:prefixIncludesPrefixLength adjustment , but was: %d", (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)adjustedLen)}));
            }
            Option<SimpleTypeRuntimeData> optSTRD = plElement.erd().optSimpleTypeRuntimeData();
            if (optSTRD.isDefined() && OKOrError$.MODULE$.isError$extension(check = (strd = (SimpleTypeRuntimeData)optSTRD.get()).executeCheck(plElement))) {
                ProcessingError pe = state.toProcessingError(new StringBuilder(51).append("The prefix length value of ").append(savedInfoset.namedQName()).append(" (").append(parsedLen).append(") failed check due to ").append(check).toString());
                state.setFailed((Diagnostic)pe);
            }
            return adjustedLen;
        }
        return 0L;
    }

    public static /* synthetic */ long getPrefixedLengthInBits$(PrefixedLengthParserMixin $this, PState state) {
        return $this.getPrefixedLengthInBits(state);
    }

    default public long getPrefixedLengthInBits(PState state) {
        long lenInUnits = this.getPrefixedLengthInUnits(state);
        if (state.processorStatus() == Success$.MODULE$) {
            long l;
            LengthUnits lengthUnits = this.lengthUnits();
            if (LengthUnits.Bits$.MODULE$.equals(lengthUnits)) {
                l = lenInUnits;
            } else if (LengthUnits.Bytes$.MODULE$.equals(lengthUnits)) {
                l = lenInUnits * 8L;
            } else if (LengthUnits.Characters$.MODULE$.equals(lengthUnits)) {
                long mfw = state.encoder().bitsCharset().maybeFixedWidth();
                if (!MaybeInt$.MODULE$.isDefined$extension(mfw)) {
                    throw Assert$.MODULE$.abort("Invariant broken. Prefixed length for text data in non-fixed width encoding.");
                }
                l = lenInUnits * (long)MaybeInt$.MODULE$.get$extension(mfw);
            } else {
                throw new MatchError((Object)lengthUnits);
            }
            long lenInBits = l;
            long mLenInBits = MaybeULong$.MODULE$.apply(lenInBits);
            DIElement dIElement = state.infoset();
            if (dIElement instanceof DIComplex) {
                DIComplex dIComplex = (DIComplex)dIElement;
                dIComplex.contentLength().maybeComputedLengthInBits_$eq(mLenInBits);
                dIComplex.valueLength().maybeComputedLengthInBits_$eq(mLenInBits);
            } else if (dIElement instanceof DISimple) {
                DISimple dISimple = (DISimple)dIElement;
                dISimple.contentLength().maybeComputedLengthInBits_$eq(mLenInBits);
            } else {
                throw new MatchError((Object)dIElement);
            }
            return lenInBits;
        }
        return 0L;
    }

    public static void $init$(PrefixedLengthParserMixin $this) {
    }
}

