/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import java.io.Serializable;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.runtime1.api.MetadataHandler;
import org.apache.daffodil.runtime1.api.SequenceMetadata;
import org.apache.daffodil.runtime1.processors.ChoiceRuntimeData;
import org.apache.daffodil.runtime1.processors.DataProcessor;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.ErrorERD;
import org.apache.daffodil.runtime1.processors.ModelGroupRuntimeData;
import org.apache.daffodil.runtime1.processors.SequenceRuntimeData;
import org.apache.daffodil.runtime1.processors.TermRuntimeData;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00054A\u0001D\u0007\u00011!Aq\u0004\u0001BC\u0002\u0013%\u0001\u0005\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003\"\u0011\u00151\u0003\u0001\"\u0001(\u0011!Q\u0003\u0001#b\u0001\n\u0013Y\u0003\"B\u0018\u0001\t\u0003\u0001\u0004\"\u0002\u001f\u0001\t\u0013i\u0004\"\u0002#\u0001\t\u0013)\u0005\"B%\u0001\t\u0013Q\u0005\"B'\u0001\t\u0013q\u0005\"B)\u0001\t\u0013\u0011\u0006\"B-\u0001\t\u0013Q&AD'fi\u0006$\u0017\r^1XC2\\WM\u001d\u0006\u0003\u001d=\t!\u0002\u001d:pG\u0016\u001c8o\u001c:t\u0015\t\u0001\u0012#\u0001\u0005sk:$\u0018.\\32\u0015\t\u00112#\u0001\u0005eC\u001a4w\u000eZ5m\u0015\t!R#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002-\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\u0007\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u0005\u0011\u0004X#A\u0011\u0011\u0005\t\u001aS\"A\u0007\n\u0005\u0011j!!\u0004#bi\u0006\u0004&o\\2fgN|'/A\u0002ea\u0002\na\u0001P5oSRtDC\u0001\u0015*!\t\u0011\u0003\u0001C\u0003 \u0007\u0001\u0007\u0011%A\u0004s_>$XI\u0015#\u0016\u00031\u0002\"AI\u0017\n\u00059j!AE#mK6,g\u000e\u001e*v]RLW.\u001a#bi\u0006\fAa^1mWR\u0011\u0011\u0007\u000e\t\u00035IJ!aM\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006k\u0015\u0001\rAN\u0001\bQ\u0006tG\r\\3s!\t9$(D\u00019\u0015\tIt\"A\u0002ba&L!a\u000f\u001d\u0003\u001f5+G/\u00193bi\u0006D\u0015M\u001c3mKJ\f\u0001b^1mWR+'/\u001c\u000b\u0004cyz\u0004\"B\u001b\u0007\u0001\u00041\u0004\"\u0002!\u0007\u0001\u0004\t\u0015a\u0001;sIB\u0011!EQ\u0005\u0003\u00076\u0011q\u0002V3s[J+h\u000e^5nK\u0012\u000bG/Y\u0001\fo\u0006d7.\u00127f[\u0016tG\u000fF\u00022\r\u001eCQ!N\u0004A\u0002YBQ\u0001S\u0004A\u00021\n1!\u001a:e\u0003I9\u0018\r\\6D_6\u0004H.\u001a=FY\u0016lWM\u001c;\u0015\u0007EZE\nC\u00036\u0011\u0001\u0007a\u0007C\u0003I\u0011\u0001\u0007A&A\txC2\\7+[7qY\u0016,E.Z7f]R$2!M(Q\u0011\u0015)\u0014\u00021\u00017\u0011\u0015A\u0015\u00021\u0001-\u000319\u0018\r\\6TKF,XM\\2f)\r\t4\u000b\u0016\u0005\u0006k)\u0001\rA\u000e\u0005\u0006+*\u0001\rAV\u0001\u0003g6\u0004\"aN,\n\u0005aC$\u0001E*fcV,gnY3NKR\fG-\u0019;b\u0003)9\u0018\r\\6DQ>L7-\u001a\u000b\u0004cmc\u0006\"B\u001b\f\u0001\u00041\u0004\"B/\f\u0001\u0004q\u0016aA2sIB\u0011!eX\u0005\u0003A6\u0011\u0011c\u00115pS\u000e,'+\u001e8uS6,G)\u0019;b\u0001")
public class MetadataWalker {
    private ElementRuntimeData rootERD;
    private DataProcessor dp;
    private volatile boolean bitmap$0;

    private DataProcessor dp() {
        return this.dp;
    }

    private ElementRuntimeData rootERD$lzycompute() {
        MetadataWalker metadataWalker = this;
        synchronized (metadataWalker) {
            if (!this.bitmap$0) {
                this.rootERD = this.dp().ssrd().elementRuntimeData();
                this.bitmap$0 = true;
            }
        }
        this.dp = null;
        return this.rootERD;
    }

    private ElementRuntimeData rootERD() {
        if (!this.bitmap$0) {
            return this.rootERD$lzycompute();
        }
        return this.rootERD;
    }

    public void walk(MetadataHandler handler) {
        this.walkTerm(handler, this.rootERD());
    }

    private void walkTerm(MetadataHandler handler, TermRuntimeData trd) {
        TermRuntimeData termRuntimeData = trd;
        if (termRuntimeData instanceof ErrorERD) {
            throw Assert$.MODULE$.invariantFailed("should not get ErrorERDs");
        }
        if (termRuntimeData instanceof ElementRuntimeData) {
            ElementRuntimeData elementRuntimeData = (ElementRuntimeData)termRuntimeData;
            this.walkElement(handler, elementRuntimeData);
            return;
        }
        if (termRuntimeData instanceof SequenceRuntimeData) {
            SequenceRuntimeData sequenceRuntimeData = (SequenceRuntimeData)termRuntimeData;
            this.walkSequence(handler, sequenceRuntimeData);
            return;
        }
        if (termRuntimeData instanceof ChoiceRuntimeData) {
            ChoiceRuntimeData choiceRuntimeData = (ChoiceRuntimeData)termRuntimeData;
            this.walkChoice(handler, choiceRuntimeData);
            return;
        }
        throw new MatchError((Object)termRuntimeData);
    }

    private void walkElement(MetadataHandler handler, ElementRuntimeData erd) {
        if (erd.optComplexTypeModelGroupRuntimeData().isDefined()) {
            this.walkComplexElement(handler, erd);
            return;
        }
        this.walkSimpleElement(handler, erd);
    }

    private void walkComplexElement(MetadataHandler handler, ElementRuntimeData erd) {
        ModelGroupRuntimeData mgrd = (ModelGroupRuntimeData)erd.optComplexTypeModelGroupRuntimeData().getOrElse((Function0 & Serializable)() -> Assert$.MODULE$.invariantFailed("not a complex type element"));
        handler.startComplexElementMetadata(erd);
        this.walkTerm(handler, mgrd);
        handler.endComplexElementMetadata(erd);
    }

    private void walkSimpleElement(MetadataHandler handler, ElementRuntimeData erd) {
        handler.simpleElementMetadata(erd);
    }

    private void walkSequence(MetadataHandler handler, SequenceMetadata sm) {
        SequenceRuntimeData srd = (SequenceRuntimeData)sm;
        if (!srd.isHidden()) {
            handler.startSequenceMetadata(srd);
            srd.groupMembers().map((Function1 & Serializable)trd -> {
                this.walkTerm(handler, trd);
                return BoxedUnit.UNIT;
            });
            handler.endSequenceMetadata(srd);
            return;
        }
    }

    private void walkChoice(MetadataHandler handler, ChoiceRuntimeData crd) {
        handler.startChoiceMetadata(crd);
        crd.groupMembers().map((Function1 & Serializable)trd -> {
            this.walkTerm(handler, trd);
            return BoxedUnit.UNIT;
        });
        handler.endChoiceMetadata(crd);
    }

    public MetadataWalker(DataProcessor dp) {
        this.dp = dp;
    }
}

