/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.externalvars;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import org.apache.daffodil.lib.api.DaffodilSchemaSource;
import org.apache.daffodil.lib.api.URISchemaSource$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.exceptions.ThrowsSDE;
import org.apache.daffodil.lib.externalvars.Binding;
import org.apache.daffodil.lib.externalvars.Binding$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.lib.xml.DaffodilXMLLoader;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.runtime1.processors.VariableMap;
import org.apache.daffodil.runtime1.processors.VariableUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.collection.immutable.Seq;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.xml.Node;

public final class ExternalVariablesLoader$ {
    public static final ExternalVariablesLoader$ MODULE$ = new ExternalVariablesLoader$();

    public VariableMap loadVariables(Seq<Binding> bindings, ThrowsSDE referringContext, VariableMap vmap) {
        if (referringContext == null) {
            throw Assert$.MODULE$.usageError2("loadVariables expects 'referringContext' to not be null!", "referringContext.!=(null)");
        }
        VariableUtils$.MODULE$.setExternalVariables(vmap, bindings, referringContext);
        return vmap;
    }

    public Queue<Binding> mapToBindings(Map<String, String> vars) {
        scala.collection.immutable.Iterable varsKVP = (scala.collection.immutable.Iterable)vars.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                String value = (String)tuple2._2();
                return Binding$.MODULE$.apply(name, value);
            }
            throw new MatchError((Object)tuple2);
        });
        return Queue$.MODULE$.empty().enqueueAll((Iterable)varsKVP);
    }

    public Queue<Binding> uriToBindings(URI uri) {
        if (uri == null) {
            throw Assert$.MODULE$.usageError("uri.ne(null)");
        }
        File file = new File(uri);
        return this.fileToBindings(file);
    }

    public Queue<Binding> fileToBindings(File file) {
        if (file == null) {
            throw Assert$.MODULE$.usageError("file.ne(null)");
        }
        String enc = Misc$.MODULE$.determineEncoding(file);
        BufferedSource input = Source$.MODULE$.fromURI(file.toURI(), Codec$.MODULE$.string2codec(enc));
        DaffodilXMLLoader ldr = new DaffodilXMLLoader();
        URI dafextURI = XMLUtils$.MODULE$.dafextURI();
        Node node = ldr.load((DaffodilSchemaSource)URISchemaSource$.MODULE$.apply(file, file.toURI()), (Option)new Some((Object)dafextURI), ldr.load$default$3());
        return this.nodeToBindings(node);
    }

    public Queue<Binding> nodeToBindings(Node node) {
        if (node == null) {
            throw Assert$.MODULE$.usageError("node.ne(null)");
        }
        Seq newBindings = Binding$.MODULE$.getBindings(node);
        ObjectRef res = ObjectRef.create((Object)Queue$.MODULE$.empty());
        newBindings.foreach((Function1 & Serializable)b -> {
            res.elem = ((Queue)res.elem).enqueue((Object)b);
            return BoxedUnit.UNIT;
        });
        return (Queue)res.elem;
    }

    private ExternalVariablesLoader$() {
    }
}

