/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.Trace;
import cats.effect.tracing.Tracing$;
import cats.effect.tracing.TracingConstants;
import cats.effect.unsafe.LocalQueue;
import cats.effect.unsafe.PollingSystem;
import cats.effect.unsafe.ScalQueue;
import cats.effect.unsafe.Scheduler;
import cats.effect.unsafe.TimerHeap;
import cats.effect.unsafe.UnsafeNonFatal$;
import cats.effect.unsafe.UnsealedPollingContext;
import cats.effect.unsafe.WeakBag;
import cats.effect.unsafe.WorkStealingThreadPool$;
import cats.effect.unsafe.WorkStealingThreadPoolConstants;
import cats.effect.unsafe.WorkerThread;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\rue!\u0002-Z\u0005m{\u0006\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011\u0002@\t\u0017\u0005\r\u0001A!b\u0001\n\u0003I\u0016Q\u0001\u0005\u000b\u0003;\u0001!\u0011!Q\u0001\n\u0005\u001d\u0001bCA\u0010\u0001\t\u0015\r\u0011\"\u0001Z\u0003\u000bA!\"!\t\u0001\u0005\u0003\u0005\u000b\u0011BA\u0004\u0011-\t\u0019\u0003\u0001BC\u0002\u0013\u0005\u0011,!\n\t\u0015\u0005M\u0002A!A!\u0002\u0013\t9\u0003C\u0006\u00026\u0001\u0011)\u0019!C\u00013\u0006]\u0002BCA \u0001\t\u0005\t\u0015!\u0003\u0002:!Q\u0011\u0011\t\u0001\u0003\u0002\u0003\u0006I!a\n\t\u0017\u0005\r\u0003A!b\u0001\n\u0003I\u0016Q\t\u0005\u000b\u0003+\u0002!\u0011!Q\u0001\n\u0005\u001d\u0003BCA,\u0001\t\u0005\t\u0015!\u0003\u0002Z!Y\u0011q\u000f\u0001\u0003\u0006\u0004%\t!WA=\u0011)\t\u0019\n\u0001B\u0001B\u0003%\u00111\u0010\u0005\b\u0003+\u0003A\u0011AAL\u0011)\ti\u000b\u0001b\u0001\n\u0003I\u0016q\u0016\u0005\t\u0003o\u0003\u0001\u0015!\u0003\u00022\"A\u0011\u0011\u0018\u0001!\u0002\u0013\tY\f\u0003\u0006\u0002T\u0002\u0011\r\u0011\"\u0001Z\u0003+D\u0001\"a9\u0001A\u0003%\u0011q\u001b\u0005\u000b\u0003K\u0004!\u0019!C\u00013\u0006\u001d\b\u0002CAy\u0001\u0001\u0006I!!;\t\u0015\u0005M\bA1A\u0005\u0002e\u000b)\u0010\u0003\u0005\u0002\u0000\u0002\u0001\u000b\u0011BA|\u0011)\u0011\t\u0001\u0001b\u0001\n\u0003I&1\u0001\u0005\t\u0005'\u0001\u0001\u0015!\u0003\u0003\u0006!Q!Q\u0003\u0001C\u0002\u0013\u0005\u0011La\u0006\t\u0011\tm\u0001\u0001)A\u0005\u00053A!B!\b\u0001\u0005\u0004%\t!\u0017B\u0010\u0011!\u0011\t\u0004\u0001Q\u0001\n\t\u0005\u0002b\u0002B\u001a\u0001\u0011\u0005!Q\u0007\u0005\b\u0005{\u0001A\u0011\u0001B \u0011!\u0011)\u0005\u0001Q\u0001\n\t\u001d\u0003\u0002\u0003B'\u0001\u0001\u0006IAa\u0014\t\u0015\tU\u0003A1A\u0005\u0002e\u00139\u0006\u0003\u0005\u0003b\u0001\u0001\u000b\u0011\u0002B-\u0011)\u0011\u0019\u0007\u0001b\u0001\n\u0003I&Q\r\u0005\t\u0005O\u0002\u0001\u0015!\u0003\u0002z\"Q!\u0011\u000e\u0001C\u0002\u0013\u0005\u0011La\u001b\t\u0011\t5\u0004\u0001)A\u0005\u0005\u001fB!Ba\u001c\u0001\u0005\u0004%\t!\u0017B6\u0011!\u0011\t\b\u0001Q\u0001\n\t=\u0003\u0002\u0003B:\u0001\u0011\u0005\u0011L!\u001e\t\u0011\tm\u0004\u0001\"\u0001Z\u0005{B\u0001B!%\u0001\t\u0003I&1\u0013\u0005\t\u00057\u0003A\u0011A-\u0003\u001e\"A!\u0011\u0015\u0001!\n\u0013\u0011\u0019\u000b\u0003\u0005\u0003&\u0002!\t!\u0017BT\u0011!\u0011Y\u000b\u0001C\u00013\n\r\u0006\u0002\u0003BW\u0001\u0011\u0005\u0011La,\t\u0011\tM\u0006\u0001\"\u0001Z\u0005GC\u0001B!.\u0001\t\u0003I&q\u0017\u0005\t\u0005s\u0003A\u0011A-\u00038\"A!1\u0018\u0001\u0005\u0002e\u0013i\f\u0003\u0005\u0003F\u0002!\ta\u0017Bd\u0011!\u0011i\r\u0001C\u00017\n\r\u0006\u0002\u0003Bh\u0001\u0011\u00051La.\t\u0011\tE\u0007\u0001)C\u0005\u0005'D\u0001B!7\u0001\t\u0003I&1\u001c\u0005\b\u0007\u000f\u0001A\u0011IB\u0005\u0011\u001d\u0019i\u0001\u0001C!\u0007\u001fAqa!\u0006\u0001\t\u0003\u001a9\u0002C\u0004\u0004\u001a\u0001!\tea\u0006\t\u000f\rm\u0001\u0001\"\u0011\u0004\u0018!91Q\u0004\u0001\u0005\u0002\r}\u0001\u0002CB\"\u0001\u0001&ia!\u0012\t\u000f\r=\u0003\u0001\"\u0011\u0004R!91\u0011\f\u0001\u0005\u0002\t]\u0006\u0002CB.\u0001\u0011\u0005\u0011l!\u0018\t\u0011\r}\u0003\u0001\"\u0001Z\u0007;B\u0001b!\u0019\u0001\t\u0003I6Q\f\u0005\t\u0007G\u0002A\u0011A-\u0004^!A1Q\r\u0001\u0005\u0002e\u001b9\u0002\u0003\u0005\u0004h\u0001!\t!WB\f\u000f\u001d\u0019I'\u0017E\u0005\u0007W2a\u0001W-\t\n\r5\u0004bBAK\u001b\u0012\u00051q\u000e\u0005\n\u0007cj%\u0019!C\u0005\u0007gB\u0001ba\u001fNA\u0003%1Q\u000f\u0004\u0007\u0007{jeaa \t\u000f\u0005U\u0015\u000b\"\u0001\u0004\b\"91QR)\u0005\u0002\r=\u0005bBBJ#\u0012\u0005!q\u0017\u0005\b\u0007+\u000bF\u0011\u0001B\\\u0011%\u00199*\u0014b\u0001\n\u0013\u0019I\n\u0003\u0005\u0004\u001c6\u0003\u000b\u0011BB\u0014\u0005Y9vN]6Ti\u0016\fG.\u001b8h)\"\u0014X-\u00193Q_>d'B\u0001.\\\u0003\u0019)hn]1gK*\u0011A,X\u0001\u0007K\u001a4Wm\u0019;\u000b\u0003y\u000bAaY1ugV\u0011\u0001M^\n\u0006\u0001\u0005<W.\u001d\t\u0003E\u0016l\u0011a\u0019\u0006\u0002I\u0006)1oY1mC&\u0011am\u0019\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!\\W\"A5\u000b\u0005)\u001c\u0017AC2p]\u000e,(O]3oi&\u0011A.\u001b\u0002\u0019\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u0014\bC\u00018p\u001b\u0005I\u0016B\u00019Z\u0005%\u00196\r[3ek2,'\u000fE\u0002oeRL!a]-\u0003-Us7/Z1mK\u0012\u0004v\u000e\u001c7j]\u001e\u001cuN\u001c;fqR\u0004\"!\u001e<\r\u0001\u0011)q\u000f\u0001b\u0001s\n\t\u0001k\u0001\u0001\u0012\u0005i\f\u0007C\u00012|\u0013\ta8MA\u0004O_RD\u0017N\\4\u0002\u0017QD'/Z1e\u0007>,h\u000e\u001e\t\u0003E~L1!!\u0001d\u0005\rIe\u000e^\u0001\ri\"\u0014X-\u00193Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00189!\u00111BA\n!\r\tiaY\u0007\u0003\u0003\u001fQ1!!\u0005y\u0003\u0019a$o\\8u}%\u0019\u0011QC2\u0002\rA\u0013X\rZ3g\u0013\u0011\tI\"a\u0007\u0003\rM#(/\u001b8h\u0015\r\t)bY\u0001\u000ei\"\u0014X-\u00193Qe\u00164\u0017\u000e\u001f\u0011\u0002'\tdwnY6feRC'/Z1e!J,g-\u001b=\u0002)\tdwnY6feRC'/Z1e!J,g-\u001b=!\u0003e\u0011XO\u001c;j[\u0016\u0014En\\2lS:<W\t\u001f9je\u0006$\u0018n\u001c8\u0016\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055\u0012.\u0001\u0005ekJ\fG/[8o\u0013\u0011\t\t$a\u000b\u0003\u0011\u0011+(/\u0019;j_:\f!D];oi&lWM\u00117pG.LgnZ#ya&\u0014\u0018\r^5p]\u0002\nQD\u00197pG.,G\r\u00165sK\u0006$G)\u001a;fGRLwN\\#oC\ndW\rZ\u000b\u0003\u0003s\u00012AYA\u001e\u0013\r\tid\u0019\u0002\b\u0005>|G.Z1o\u0003y\u0011Gn\\2lK\u0012$\u0006N]3bI\u0012+G/Z2uS>tWI\\1cY\u0016$\u0007%A\btQV$Hm\\<o)&lWm\\;u\u0003\u0019\u0019\u0018p\u001d;f[V\u0011\u0011q\t\t\u0006\u0003\u0013\ny\u0005\u001e\b\u0004]\u0006-\u0013bAA'3\u0006i\u0001k\u001c7mS:<7+_:uK6LA!!\u0015\u0002T\tQq+\u001b;i!>dG.\u001a:\u000b\u0007\u00055\u0013,A\u0004tsN$X-\u001c\u0011\u0002\u001dI,\u0007o\u001c:u\r\u0006LG.\u001e:faA9!-a\u0017\u0002`\u0005E\u0014bAA/G\nIa)\u001e8di&|g.\r\t\u0005\u0003C\nYG\u0004\u0003\u0002d\u0005\u001dd\u0002BA\u0007\u0003KJ\u0011\u0001Z\u0005\u0004\u0003S\u001a\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003[\nyGA\u0005UQJ|w/\u00192mK*\u0019\u0011\u0011N2\u0011\u0007\t\f\u0019(C\u0002\u0002v\r\u0014A!\u00168ji\u0006ARO\\2bk\u001eDG/\u0012=dKB$\u0018n\u001c8IC:$G.\u001a:\u0016\u0005\u0005m\u0004\u0003BA?\u0003\u001bsA!a \u0002\n6\u0011\u0011\u0011\u0011\u0006\u0005\u0003\u0007\u000b))\u0001\u0003mC:<'BAAD\u0003\u0011Q\u0017M^1\n\t\u0005-\u0015\u0011Q\u0001\u0007)\"\u0014X-\u00193\n\t\u0005=\u0015\u0011\u0013\u0002\u0019+:\u001c\u0017-^4ii\u0016C8-\u001a9uS>t\u0007*\u00198eY\u0016\u0014(\u0002BAF\u0003\u0003\u000b\u0011$\u001e8dCV<\u0007\u000e^#yG\u0016\u0004H/[8o\u0011\u0006tG\r\\3sA\u00051A(\u001b8jiz\"B#!'\u0002\u001c\u0006u\u0015qTAQ\u0003G\u000b)+a*\u0002*\u0006-\u0006c\u00018\u0001i\")Q\u0010\u0005a\u0001}\"9\u00111\u0001\tA\u0002\u0005\u001d\u0001bBA\u0010!\u0001\u0007\u0011q\u0001\u0005\b\u0003G\u0001\u0002\u0019AA\u0014\u0011\u001d\t)\u0004\u0005a\u0001\u0003sAq!!\u0011\u0011\u0001\u0004\t9\u0003C\u0004\u0002DA\u0001\r!a\u0012\t\u000f\u0005]\u0003\u00031\u0001\u0002Z!9\u0011q\u000f\tA\u0002\u0005m\u0014AA5e+\t\t\t\fE\u0002c\u0003gK1!!.d\u0005\u0011auN\\4\u0002\u0007%$\u0007%A\u0007x_J\\WM\u001d+ie\u0016\fGm\u001d\t\u0007\u0003{\u000bI-!4\u000e\u0005\u0005}&\u0002BAa\u0003\u0007\fa!\u0019;p[&\u001c'b\u00016\u0002F*!\u0011qYAC\u0003\u0011)H/\u001b7\n\t\u0005-\u0017q\u0018\u0002\u0015\u0003R|W.[2SK\u001a,'/\u001a8dK\u0006\u0013(/Y=\u0011\t9\fy\r^\u0005\u0004\u0003#L&\u0001D,pe.,'\u000f\u00165sK\u0006$\u0017a\u00037pG\u0006d\u0017+^3vKN,\"!a6\u0011\u000b\t\fI.!8\n\u0007\u0005m7MA\u0003BeJ\f\u0017\u0010E\u0002o\u0003?L1!!9Z\u0005)aunY1m#V,W/Z\u0001\rY>\u001c\u0017\r\\)vKV,7\u000fI\u0001\tg2,W\r]3sgV\u0011\u0011\u0011\u001e\t\u0006E\u0006e\u00171\u001e\t\u0004]\u00065\u0018bAAx3\nIA+[7fe\"+\u0017\r]\u0001\ng2,W\r]3sg\u0002\nQ\u0002]1sW\u0016$7+[4oC2\u001cXCAA|!\u0015\u0011\u0017\u0011\\A}!\u0011\ti,a?\n\t\u0005u\u0018q\u0018\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u001dA\f'o[3e'&<g.\u00197tA\u0005Ia-\u001b2fe\n\u000bwm]\u000b\u0003\u0005\u000b\u0001RAYAm\u0005\u000f\u0001RA\u001cB\u0005\u0005\u001bI1Aa\u0003Z\u0005\u001d9V-Y6CC\u001e\u0004B!a \u0003\u0010%!!\u0011CAA\u0005!\u0011VO\u001c8bE2,\u0017A\u00034jE\u0016\u0014()Y4tA\u00059\u0001o\u001c7mKJ\u001cXC\u0001B\r!\u0011\u0011\u0017\u0011\u001c;\u0002\u0011A|G\u000e\\3sg\u0002\n\u0001\"\\3ue&\u001cWm]\u000b\u0003\u0005C\u0001RAYAm\u0005G\u0001BA!\n\u0003,9\u0019aNa\n\n\u0007\t%\u0012,\u0001\u0007X_J\\WM\u001d+ie\u0016\fG-\u0003\u0003\u0003.\t=\"aB'fiJL7m\u001d\u0006\u0004\u0005SI\u0016!C7fiJL7-Z:!\u00031\t7mY3tgB{G\u000e\\3s)\u0011\t\tHa\u000e\t\u000f\te\u0002\u00051\u0001\u0003<\u0005\u00111M\u0019\t\u0007E\u0006mC/!\u001d\u0002\u0013=<h\u000eU8mY\u0016\u0014H\u0003BA\u001d\u0005\u0003BaAa\u0011\"\u0001\u0004!\u0018A\u00029pY2,'/A\u0007fqR,'O\\1m#V,W/\u001a\t\u0005]\n%\u0013-C\u0002\u0003Le\u0013\u0011bU2bYF+X-^3\u0002\u000bM$\u0018\r^3\u0011\t\u0005u&\u0011K\u0005\u0005\u0005'\nyLA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\u000eG\u0006\u001c\u0007.\u001a3UQJ,\u0017\rZ:\u0016\u0005\te\u0003C\u0002B.\u0005;\ni-\u0004\u0002\u0002D&!!qLAb\u0005Ma\u0015N\\6fIR\u0013\u0018M\\:gKJ\fV/Z;f\u00039\u0019\u0017m\u00195fIRC'/Z1eg\u0002\nA\u0001Z8oKV\u0011\u0011\u0011`\u0001\u0006I>tW\rI\u0001\u001bE2|7m[3e/>\u00148.\u001a:UQJ,\u0017\rZ\"pk:$XM]\u000b\u0003\u0005\u001f\n1D\u00197pG.,GmV8sW\u0016\u0014H\u000b\u001b:fC\u0012\u001cu.\u001e8uKJ\u0004\u0013A\b2m_\u000e\\W\rZ,pe.,'\u000f\u00165sK\u0006$g*Y7j]\u001eLe\u000eZ3y\u0003}\u0011Gn\\2lK\u0012<vN]6feRC'/Z1e\u001d\u0006l\u0017N\\4J]\u0012,\u0007\u0010I\u0001\u0010O\u0016$xk\u001c:lKJ$\u0006N]3bIR!\u0011Q\u001aB<\u0011\u0019\u0011I\b\fa\u0001}\u0006)\u0011N\u001c3fq\u0006Q2\u000f^3bY\u001a\u0013x.\\(uQ\u0016\u0014xk\u001c:lKJ$\u0006N]3bIRA!Q\u0002B@\u0005\u0007\u0013i\t\u0003\u0004\u0003\u00026\u0002\rA`\u0001\u0005I\u0016\u001cH\u000fC\u0004\u0003\u00066\u0002\rAa\"\u0002\rI\fg\u000eZ8n!\u0011\u0011YF!#\n\t\t-\u00151\u0019\u0002\u0012)\"\u0014X-\u00193M_\u000e\fGNU1oI>l\u0007b\u0002BH[\u0001\u0007\u0011QZ\u0001\u000bI\u0016\u001cHoV8sW\u0016\u0014\u0018aC:uK\u0006dG+[7feN$b!!\u000f\u0003\u0016\ne\u0005b\u0002BL]\u0001\u0007\u0011\u0011W\u0001\u0004]><\bb\u0002BC]\u0001\u0007!qQ\u0001\r]>$\u0018NZ=QCJ\\W\r\u001a\u000b\u0005\u0003s\u0011y\nC\u0004\u0003\u0006>\u0002\rAa\"\u0002%9|G/\u001b4z'\"|W\u000f\u001c3XC.,W\u000f\u001d\u000b\u0003\u0003s\t1C\\8uS\u001aL\u0018JZ,pe.\u0004VM\u001c3j]\u001e$B!!\u001d\u0003*\"9!QQ\u0019A\u0002\t\u001d\u0015a\u0007;sC:\u001c\u0018\u000e^5p]^{'o[3s)>\u001cV-\u0019:dQ&tw-A\u000fue\u0006t7/\u001b;j_:<vN]6fe\u001a\u0013x.\\*fCJ\u001c\u0007.\u001b8h)\u0011\t\tH!-\t\u000f\t\u00155\u00071\u0001\u0003\b\u0006)CO]1og&$\u0018n\u001c8X_J\\WM\u001d+p!\u0006\u00148.\u001a3XQ\u0016t7+Z1sG\"LgnZ\u0001\u0019iJ\fgn]5uS>twk\u001c:lKJ$v\u000eU1sW\u0016$GCAA9\u00031!wN\\3TY\u0016,\u0007/\u001b8h\u00035\u0011X\r\u001d7bG\u0016<vN]6feR1\u0011\u0011\u000fB`\u0005\u0003DaA!\u001f8\u0001\u0004q\bb\u0002Bbo\u0001\u0007\u0011QZ\u0001\n]\u0016<xk\u001c:lKJ\f!B]3tG\",G-\u001e7f)\u0011\t\tH!3\t\u000f\t-\u0007\b1\u0001\u0003\u000e\u0005A!/\u001e8oC\ndW-\u0001\fdC:,\u00050Z2vi\u0016\u0014En\\2lS:<7i\u001c3f\u0003I\u0001(/\u001a9be\u00164uN\u001d\"m_\u000e\\\u0017N\\4\u0002!M\u001c\u0007.\u001a3vY\u0016,\u0005\u0010^3s]\u0006dG\u0003BA9\u0005+DqAa6<\u0001\u0004\u0011i!A\u0003gS\n,'/\u0001\u0006mSZ,GK]1dKN$\"A!8\u0011\u0013\t\u0014yNa9\u0003r\n\r\u0018b\u0001BqG\n1A+\u001e9mKN\u0002\u0002\"!\u0003\u0003f\n5!\u0011^\u0005\u0005\u0005O\fYBA\u0002NCB\u0004BAa;\u0003n6\t1,C\u0002\u0003pn\u0013Q\u0001\u0016:bG\u0016\u0004\u0002\"!\u0003\u0003f\u00065'1\u001f\t\nE\n}'Q\u001fB~\u0005G\u0004B!! \u0003x&!!\u0011`AI\u0005\u0015\u0019F/\u0019;f!\u0015\u0011'Q`B\u0001\u0013\r\u0011yp\u0019\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f\t\u001c\u0019A!\u0004\u0003j&\u00191QA2\u0003\rQ+\b\u000f\\33\u0003\u001d)\u00070Z2vi\u0016$B!!\u001d\u0004\f!9!1Z\u001fA\u0002\t5\u0011!\u0004:fa>\u0014HOR1jYV\u0014X\r\u0006\u0003\u0002r\rE\u0001bBB\n}\u0001\u0007\u0011qL\u0001\u0006G\u0006,8/Z\u0001\u000f[>tw\u000e^8oS\u000et\u0015M\\8t)\t\t\t,A\u0005o_^l\u0015\u000e\u001c7jg\u0006Ian\\<NS\u000e\u0014xn]\u0001\u000eg2,W\r]%oi\u0016\u0014h.\u00197\u0015\r\r\u00052QFB\u001c%\u0019\u0019\u0019ca\n\u0003\u000e\u001911Q\u0005\u0001\u0001\u0007C\u0011A\u0002\u0010:fM&tW-\\3oiz\u0002RAYB\u0015\u0003cJ1aa\u000bd\u0005%1UO\\2uS>t\u0007\u0007C\u0004\u00040\t\u0003\ra!\r\u0002\u000b\u0011,G.Y=\u0011\t\u0005%21G\u0005\u0005\u0007k\tYC\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\t\u000f\re\"\t1\u0001\u0004<\u0005A1-\u00197mE\u0006\u001c7\u000eE\u0004c\u00037\u001ai$!\u001d\u0011\u000f\u0005\u00054q\b>\u0002r%!1\u0011IA8\u0005\u0015\u0011\u0016n\u001a5u\u00035\u0019H.Z3q\u000bb$XM\u001d8bYR11qIB&\u0007\u001b\u0012ba!\u0013\u0004(\t5aABB\u0013\u0001\u0001\u00199\u0005C\u0004\u00040\r\u0003\ra!\r\t\u000f\re2\t1\u0001\u0004<\u0005)1\u000f\\3faR1!QBB*\u0007+Bqaa\fE\u0001\u0004\u0019\t\u0004C\u0004\u0004X\u0011\u0003\rA!\u0004\u0002\tQ\f7o[\u0001\tg\",H\u000fZ8x]\u0006!r-\u001a;X_J\\WM\u001d+ie\u0016\fGmQ8v]R$\u0012A`\u0001\u0015O\u0016$\u0018i\u0019;jm\u0016$\u0006N]3bI\u000e{WO\u001c;\u0002/\u001d,GoU3be\u000eD\u0017N\\4UQJ,\u0017\rZ\"pk:$\u0018aG4fi\ncwnY6fI^{'o[3s)\"\u0014X-\u00193D_VtG/A\fhKRdunY1m#V,W/\u001a$jE\u0016\u00148i\\;oi\u00061r-\u001a;TkN\u0004XM\u001c3fI\u001aK'-\u001a:D_VtG/\u0001\fX_J\\7\u000b^3bY&tw\r\u00165sK\u0006$\u0007k\\8m!\tqWj\u0005\u0002NCR\u001111N\u0001\n\u0013\u0012\u001cu.\u001e8uKJ,\"a!\u001e\u0011\t\u0005u6qO\u0005\u0005\u0007s\nyL\u0001\u0006Bi>l\u0017n\u0019'p]\u001e\f!\"\u00133D_VtG/\u001a:!\u0005M)\u0005\u0010^3s]\u0006d7\u000b\\3fa\u000e\u000bgnY3m'\u001d\t6\u0011QB\u0014\u0005\u001b\u0001b!!0\u0004\u0004\u000e\u001d\u0012\u0002BBC\u0003\u007f\u0013q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\u000b\u0003\u0007\u0013\u00032aa#R\u001b\u0005i\u0015aC:fi\u000e\u000bG\u000e\u001c2bG.$B!!\u001d\u0004\u0012\"9!\u0011H*A\u0002\r\u001d\u0012!B1qa2L\u0018a\u0001:v]\u0006)2)\u00198dK2,Gm\u00157fKB\u001cVM\u001c;j]\u0016dWCAB\u0014\u0003Y\u0019\u0015M\\2fY\u0016$7\u000b\\3faN+g\u000e^5oK2\u0004\u0003")
public final class WorkStealingThreadPool<P>
implements ExecutionContextExecutor,
Scheduler,
UnsealedPollingContext<P> {
    private final int threadCount;
    private final String threadPrefix;
    private final String blockerThreadPrefix;
    private final Duration runtimeBlockingExpiration;
    private final boolean blockedThreadDetectionEnabled;
    private final Duration shutdownTimeout;
    private final PollingSystem system;
    private final Function1<Throwable, BoxedUnit> reportFailure0;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final long id;
    private final AtomicReferenceArray<WorkerThread<P>> workerThreads;
    private final LocalQueue[] localQueues;
    private final TimerHeap[] sleepers;
    private final AtomicBoolean[] parkedSignals;
    private final WeakBag<Runnable>[] fiberBags;
    private final P[] pollers;
    private final WorkerThread.Metrics[] metrices;
    private final ScalQueue<Object> externalQueue;
    private final AtomicInteger state;
    private final LinkedTransferQueue<WorkerThread<P>> cachedThreads;
    private final AtomicBoolean done;
    private final AtomicInteger blockedWorkerThreadCounter;
    private final AtomicInteger blockedWorkerThreadNamingIndex;

    public ExecutionContext prepare() {
        return ExecutionContext.prepare$((ExecutionContext)this);
    }

    public String threadPrefix() {
        return this.threadPrefix;
    }

    public String blockerThreadPrefix() {
        return this.blockerThreadPrefix;
    }

    public Duration runtimeBlockingExpiration() {
        return this.runtimeBlockingExpiration;
    }

    public boolean blockedThreadDetectionEnabled() {
        return this.blockedThreadDetectionEnabled;
    }

    public PollingSystem system() {
        return this.system;
    }

    public Thread.UncaughtExceptionHandler uncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public long id() {
        return this.id;
    }

    public LocalQueue[] localQueues() {
        return this.localQueues;
    }

    public TimerHeap[] sleepers() {
        return this.sleepers;
    }

    public AtomicBoolean[] parkedSignals() {
        return this.parkedSignals;
    }

    public WeakBag<Runnable>[] fiberBags() {
        return this.fiberBags;
    }

    public P[] pollers() {
        return this.pollers;
    }

    public WorkerThread.Metrics[] metrices() {
        return this.metrices;
    }

    @Override
    public void accessPoller(Function1<P, BoxedUnit> cb) {
        Thread thread = Thread.currentThread();
        WorkStealingThreadPool pool = this;
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            if (worker.isOwnedBy(pool)) {
                cb.apply(worker.poller());
                return;
            }
            this.scheduleExternal(() -> this.accessPoller(cb));
            return;
        }
        this.scheduleExternal(() -> this.accessPoller(cb));
    }

    @Override
    public boolean ownPoller(P poller) {
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            return worker.ownsPoller(poller);
        }
        return false;
    }

    public LinkedTransferQueue<WorkerThread<P>> cachedThreads() {
        return this.cachedThreads;
    }

    public AtomicBoolean done() {
        return this.done;
    }

    public AtomicInteger blockedWorkerThreadCounter() {
        return this.blockedWorkerThreadCounter;
    }

    public AtomicInteger blockedWorkerThreadNamingIndex() {
        return this.blockedWorkerThreadNamingIndex;
    }

    public WorkerThread<P> getWorkerThread(int index) {
        return this.workerThreads.get(index);
    }

    public Runnable stealFromOtherWorkerThread(int dest, ThreadLocalRandom random, WorkerThread<P> destWorker) {
        LocalQueue destQueue = this.localQueues()[dest];
        int from = random.nextInt(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            Runnable res;
            int index = (from + i) % this.threadCount;
            if (index == dest || (res = this.localQueues()[index].stealInto(destQueue, destWorker)) == null) continue;
            return res;
        }
        Object element = this.externalQueue.poll(random);
        if (element instanceof Runnable[]) {
            Runnable[] batch = (Runnable[])element;
            return destQueue.enqueueBatch(batch, destWorker);
        }
        if (element instanceof Runnable) {
            Runnable fiber = (Runnable)element;
            if (TracingConstants.isStackTracing) {
                destWorker.active_$eq(fiber);
                this.parkedSignals()[dest].lazySet(false);
            }
            return fiber;
        }
        return null;
    }

    public boolean stealTimers(long now, ThreadLocalRandom random) {
        int from = random.nextInt(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            int index = (from + i) % this.threadCount;
            boolean invoked = this.sleepers()[index].steal(now);
            if (!invoked) continue;
            return true;
        }
        return false;
    }

    public boolean notifyParked(ThreadLocalRandom random) {
        if (!this.notifyShouldWakeup()) {
            return false;
        }
        int from = random.nextInt(this.threadCount);
        for (int i = 0; i < this.threadCount; ++i) {
            int index = (from + i) % this.threadCount;
            AtomicBoolean signal = this.parkedSignals()[index];
            if (!signal.getAndSet(false)) continue;
            this.state.getAndAdd(WorkStealingThreadPoolConstants.DeltaSearching);
            WorkerThread<P> worker = this.workerThreads.get(index);
            this.system().interrupt(worker, this.pollers()[index]);
            return true;
        }
        return false;
    }

    private boolean notifyShouldWakeup() {
        int st = this.state.get();
        return (st & WorkStealingThreadPoolConstants.SearchMask) == 0 && (st & WorkStealingThreadPoolConstants.UnparkMask) >>> 16 < this.threadCount;
    }

    public void notifyIfWorkPending(ThreadLocalRandom random) {
        for (int i = 0; i < this.threadCount; ++i) {
            if (!this.localQueues()[i].nonEmpty()) continue;
            this.notifyParked(random);
            return;
        }
        if (this.externalQueue.nonEmpty()) {
            this.notifyParked(random);
            return;
        }
    }

    public boolean transitionWorkerToSearching() {
        int st = this.state.get();
        if (2 * (st & WorkStealingThreadPoolConstants.SearchMask) >= this.threadCount) {
            return false;
        }
        this.state.getAndIncrement();
        return true;
    }

    public void transitionWorkerFromSearching(ThreadLocalRandom random) {
        int prev = this.state.getAndDecrement();
        if (prev == 1) {
            this.notifyParked(random);
            return;
        }
    }

    public boolean transitionWorkerToParkedWhenSearching() {
        int prev = this.state.getAndAdd(-WorkStealingThreadPoolConstants.DeltaSearching);
        return (prev & WorkStealingThreadPoolConstants.SearchMask) == 1;
    }

    public void transitionWorkerToParked() {
        this.state.getAndAdd(-WorkStealingThreadPoolConstants.DeltaNotSearching);
    }

    public void doneSleeping() {
        this.state.getAndAdd(WorkStealingThreadPoolConstants.DeltaSearching);
    }

    public void replaceWorker(int index, WorkerThread<P> newWorker) {
        this.workerThreads.lazySet(index, newWorker);
    }

    public void reschedule(Runnable runnable) {
        WorkStealingThreadPool pool = this;
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            if (worker.isOwnedBy(pool)) {
                worker.reschedule(runnable);
                return;
            }
            this.scheduleExternal(runnable);
            return;
        }
        this.scheduleExternal(runnable);
    }

    public boolean canExecuteBlockingCode() {
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            return worker.canExecuteBlockingCodeOn(this);
        }
        return false;
    }

    public void prepareForBlocking() {
        Thread thread = Thread.currentThread();
        WorkerThread worker = (WorkerThread)thread;
        worker.prepareForBlocking();
    }

    private void scheduleExternal(Runnable fiber) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        this.externalQueue.offer(fiber, random);
        this.notifyParked(random);
    }

    public Tuple3<Map<Runnable, Trace>, Map<WorkerThread<P>, Tuple3<Thread.State, Option<Tuple2<Runnable, Trace>>, Map<Runnable, Trace>>>, Map<Runnable, Trace>> liveTraces() {
        Map externalFibers = this.externalQueue.snapshot().iterator().flatMap((Function1 & Serializable)x0$1 -> {
            Object object = x0$1;
            if (object instanceof Runnable[]) {
                Runnable[] runnableArray = (Runnable[])object;
                return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])runnableArray), (Function1 & Serializable)r -> Tracing$.MODULE$.captureTrace((Runnable)r), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            if (object instanceof Runnable) {
                Runnable runnable = (Runnable)object;
                return Option$.MODULE$.option2Iterable(Tracing$.MODULE$.captureTrace(runnable)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            return Predef$.MODULE$.Map().empty();
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.mutable.Map map = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        scala.collection.mutable.Map suspended = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        for (int i = 0; i < this.threadCount; ++i) {
            Map localFibers = this.localQueues()[i].snapshot().iterator().flatMap((Function1 & Serializable)r -> Tracing$.MODULE$.captureTrace((Runnable)r)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            WorkerThread<P> worker = this.workerThreads.get(i);
            boolean bl = this.parkedSignals()[i].get();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            Option active = Option$.MODULE$.apply((Object)worker.active());
            map.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(worker), (Object)new Tuple3((Object)worker.getState(), (Object)active.flatMap((Function1 & Serializable)a -> Tracing$.MODULE$.captureTrace((Runnable)a)), (Object)localFibers)));
            suspended.$plus$plus$eq(worker.suspendedTraces());
        }
        return new Tuple3((Object)externalFibers, (Object)map.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)suspended.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public void execute(Runnable runnable) {
        WorkStealingThreadPool pool = this;
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            if (worker.isOwnedBy(pool)) {
                worker.schedule(runnable);
                return;
            }
            this.scheduleExternal(runnable);
            return;
        }
        this.scheduleExternal(runnable);
    }

    public void reportFailure(Throwable cause) {
        this.reportFailure0.apply((Object)cause);
    }

    @Override
    public long monotonicNanos() {
        long back;
        block0: {
            back = System.nanoTime();
            Thread thread = Thread.currentThread();
            if (!(thread instanceof WorkerThread)) break block0;
            ((WorkerThread)thread).now_$eq(back);
        }
        return back;
    }

    @Override
    public long nowMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long nowMicros() {
        Instant now = Instant.now();
        return now.getEpochSecond() * 1000000L + now.getLong(ChronoField.MICRO_OF_SECOND);
    }

    public Function0<BoxedUnit> sleepInternal(FiniteDuration delay, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback) {
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            WorkerThread worker = (WorkerThread)thread;
            if (worker.isOwnedBy(this)) {
                return worker.sleep(delay, callback);
            }
            return this.sleepExternal(delay, callback);
        }
        return this.sleepExternal(delay, callback);
    }

    private final Function0<BoxedUnit> sleepExternal(FiniteDuration delay, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback) {
        long scheduledAt = this.monotonicNanos();
        ExternalSleepCancel cancel = new ExternalSleepCancel();
        this.scheduleExternal(() -> {
            WorkerThread worker = (WorkerThread)Thread.currentThread();
            cancel.setCallback(worker.sleepLate(scheduledAt, delay, callback));
        });
        return cancel;
    }

    @Override
    public Runnable sleep(FiniteDuration delay, Runnable task) {
        Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> cb = new Function1<Right<Nothing$, BoxedUnit>, BoxedUnit>(this, task){
            private final /* synthetic */ WorkStealingThreadPool $outer;
            private final Runnable task$1;

            public boolean apply$mcZD$sp(double v1) {
                return Function1.apply$mcZD$sp$((Function1)this, (double)v1);
            }

            public double apply$mcDD$sp(double v1) {
                return Function1.apply$mcDD$sp$((Function1)this, (double)v1);
            }

            public float apply$mcFD$sp(double v1) {
                return Function1.apply$mcFD$sp$((Function1)this, (double)v1);
            }

            public int apply$mcID$sp(double v1) {
                return Function1.apply$mcID$sp$((Function1)this, (double)v1);
            }

            public long apply$mcJD$sp(double v1) {
                return Function1.apply$mcJD$sp$((Function1)this, (double)v1);
            }

            public void apply$mcVD$sp(double v1) {
                Function1.apply$mcVD$sp$((Function1)this, (double)v1);
            }

            public boolean apply$mcZF$sp(float v1) {
                return Function1.apply$mcZF$sp$((Function1)this, (float)v1);
            }

            public double apply$mcDF$sp(float v1) {
                return Function1.apply$mcDF$sp$((Function1)this, (float)v1);
            }

            public float apply$mcFF$sp(float v1) {
                return Function1.apply$mcFF$sp$((Function1)this, (float)v1);
            }

            public int apply$mcIF$sp(float v1) {
                return Function1.apply$mcIF$sp$((Function1)this, (float)v1);
            }

            public long apply$mcJF$sp(float v1) {
                return Function1.apply$mcJF$sp$((Function1)this, (float)v1);
            }

            public void apply$mcVF$sp(float v1) {
                Function1.apply$mcVF$sp$((Function1)this, (float)v1);
            }

            public boolean apply$mcZI$sp(int v1) {
                return Function1.apply$mcZI$sp$((Function1)this, (int)v1);
            }

            public double apply$mcDI$sp(int v1) {
                return Function1.apply$mcDI$sp$((Function1)this, (int)v1);
            }

            public float apply$mcFI$sp(int v1) {
                return Function1.apply$mcFI$sp$((Function1)this, (int)v1);
            }

            public int apply$mcII$sp(int v1) {
                return Function1.apply$mcII$sp$((Function1)this, (int)v1);
            }

            public long apply$mcJI$sp(int v1) {
                return Function1.apply$mcJI$sp$((Function1)this, (int)v1);
            }

            public void apply$mcVI$sp(int v1) {
                Function1.apply$mcVI$sp$((Function1)this, (int)v1);
            }

            public boolean apply$mcZJ$sp(long v1) {
                return Function1.apply$mcZJ$sp$((Function1)this, (long)v1);
            }

            public double apply$mcDJ$sp(long v1) {
                return Function1.apply$mcDJ$sp$((Function1)this, (long)v1);
            }

            public float apply$mcFJ$sp(long v1) {
                return Function1.apply$mcFJ$sp$((Function1)this, (long)v1);
            }

            public int apply$mcIJ$sp(long v1) {
                return Function1.apply$mcIJ$sp$((Function1)this, (long)v1);
            }

            public long apply$mcJJ$sp(long v1) {
                return Function1.apply$mcJJ$sp$((Function1)this, (long)v1);
            }

            public void apply$mcVJ$sp(long v1) {
                Function1.apply$mcVJ$sp$((Function1)this, (long)v1);
            }

            public <A> Function1<A, BoxedUnit> compose(Function1<A, Right<Nothing$, BoxedUnit>> g) {
                return Function1.compose$((Function1)this, g);
            }

            public <A> Function1<Right<Nothing$, BoxedUnit>, A> andThen(Function1<BoxedUnit, A> g) {
                return Function1.andThen$((Function1)this, g);
            }

            public String toString() {
                return Function1.toString$((Function1)this);
            }

            public void apply(Right<Nothing$, BoxedUnit> ru) {
                if (this.compareAndSet(false, true)) {
                    try {
                        this.task$1.run();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (UnsafeNonFatal$.MODULE$.apply(throwable2)) {
                            this.$outer.reportFailure(throwable2);
                        }
                        throw throwable;
                    }
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.task$1 = task$1;
                Function1.$init$((Function1)this);
            }
        };
        Function0<BoxedUnit> cancel = this.sleepInternal(delay, (Function1<Right<Nothing$, BoxedUnit>, BoxedUnit>)((Function1)cb));
        return () -> WorkStealingThreadPool.$anonfun$sleep$1((AtomicBoolean)cb, cancel);
    }

    public void shutdown() {
        boolean interruptCalling = Thread.interrupted();
        Thread currentThread = Thread.currentThread();
        if (this.done().compareAndSet(false, true)) {
            long joinTimeout;
            int i;
            for (i = 0; i < this.threadCount; ++i) {
                WorkerThread<P> workerThread = this.workerThreads.get(i);
                if (workerThread == currentThread) continue;
                this.system().interrupt(workerThread, this.pollers()[i]);
                workerThread.interrupt();
            }
            Duration duration = this.shutdownTimeout;
            Duration.Infinite infinite = Duration$.MODULE$.Inf();
            Duration duration2 = duration;
            long l = !(infinite != null ? !infinite.equals(duration2) : duration2 != null) ? Long.MAX_VALUE : (joinTimeout = duration.toNanos());
            for (i = 0; i < this.threadCount && joinTimeout > 0L; ++i) {
                WorkerThread<P> workerThread = this.workerThreads.get(i);
                if (workerThread == currentThread) continue;
                long now = System.nanoTime();
                workerThread.join(joinTimeout / 1000000L, (int)(joinTimeout % 1000000L));
                long elapsed = System.nanoTime() - now;
                joinTimeout -= elapsed;
            }
            boolean allClosed = true;
            for (i = 0; i < this.threadCount; ++i) {
                WorkerThread<P> workerThread = this.workerThreads.get(i);
                if (workerThread == currentThread || !workerThread.isAlive()) {
                    this.system().closePoller(this.pollers()[i]);
                    continue;
                }
                allClosed = false;
            }
            if (allClosed) {
                this.system().close();
            }
            WorkerThread<P> t = null;
            while ((t = this.cachedThreads().poll()) != null) {
                t.interrupt();
            }
            this.externalQueue.clear();
            if (interruptCalling) {
                currentThread.interrupt();
                return;
            }
            return;
        }
    }

    public int getWorkerThreadCount() {
        return this.threadCount;
    }

    public int getActiveThreadCount() {
        int st = this.state.get();
        return (st & WorkStealingThreadPoolConstants.UnparkMask) >>> 16;
    }

    public int getSearchingThreadCount() {
        int st = this.state.get();
        return st & WorkStealingThreadPoolConstants.SearchMask;
    }

    public int getBlockedWorkerThreadCount() {
        return this.blockedWorkerThreadCounter().get();
    }

    public long getLocalQueueFiberCount() {
        return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.localQueues()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.size()), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long getSuspendedFiberCount() {
        long sum = 0L;
        for (int i = 0; i < this.threadCount; ++i) {
            sum += (long)this.workerThreads.get(i).getSuspendedFiberCount();
        }
        return sum;
    }

    public static final /* synthetic */ void $anonfun$sleep$1(AtomicBoolean cb$2, Function0 cancel$2) {
        if (cb$2.compareAndSet(false, true)) {
            ((Runnable)cancel$2).run();
            return;
        }
    }

    public WorkStealingThreadPool(int threadCount, String threadPrefix, String blockerThreadPrefix, Duration runtimeBlockingExpiration, boolean blockedThreadDetectionEnabled, Duration shutdownTimeout, PollingSystem system, Function1<Throwable, BoxedUnit> reportFailure0, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        int i;
        this.threadCount = threadCount;
        this.threadPrefix = threadPrefix;
        this.blockerThreadPrefix = blockerThreadPrefix;
        this.runtimeBlockingExpiration = runtimeBlockingExpiration;
        this.blockedThreadDetectionEnabled = blockedThreadDetectionEnabled;
        this.shutdownTimeout = shutdownTimeout;
        this.system = system;
        this.reportFailure0 = reportFailure0;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        ExecutionContext.$init$((ExecutionContext)this);
        Scheduler.$init$(this);
        this.id = WorkStealingThreadPool$.MODULE$.cats$effect$unsafe$WorkStealingThreadPool$$IdCounter().getAndIncrement();
        this.workerThreads = new AtomicReferenceArray(threadCount);
        this.localQueues = new LocalQueue[threadCount];
        this.sleepers = new TimerHeap[threadCount];
        this.parkedSignals = new AtomicBoolean[threadCount];
        this.fiberBags = new WeakBag[threadCount];
        this.pollers = new Object[threadCount];
        this.metrices = new WorkerThread.Metrics[threadCount];
        this.externalQueue = new ScalQueue(threadCount << 2);
        this.state = new AtomicInteger(threadCount << 16);
        this.cachedThreads = new LinkedTransferQueue();
        this.done = new AtomicBoolean(false);
        this.blockedWorkerThreadCounter = new AtomicInteger(0);
        this.blockedWorkerThreadNamingIndex = new AtomicInteger(0);
        for (i = 0; i < threadCount; ++i) {
            WorkerThread.Metrics metrics;
            AtomicBoolean parkedSignal;
            TimerHeap sleepersHeap;
            LocalQueue queue;
            this.localQueues()[i] = queue = new LocalQueue();
            this.sleepers()[i] = sleepersHeap = new TimerHeap();
            this.parkedSignals()[i] = parkedSignal = new AtomicBoolean(false);
            int index = i;
            WeakBag<Runnable> fiberBag = new WeakBag<Runnable>();
            this.fiberBags()[i] = fiberBag;
            Object poller = system.makePoller();
            this.pollers()[i] = poller;
            this.metrices()[i] = metrics = new WorkerThread.Metrics();
            WorkerThread<Object> thread = new WorkerThread<Object>(index, 0, queue, parkedSignal, this.externalQueue, fiberBag, sleepersHeap, system, poller, metrics, new WorkerThread.TransferState(), this);
            this.workerThreads.set(i, thread);
        }
        for (i = 0; i < threadCount; ++i) {
            ((Thread)this.workerThreads.get(i)).start();
        }
    }

    private static final class ExternalSleepCancel
    extends AtomicReference<Function0<BoxedUnit>>
    implements Function0.mcV.sp,
    Runnable {
        public boolean apply$mcZ$sp() {
            return Function0.apply$mcZ$sp$((Function0)this);
        }

        public byte apply$mcB$sp() {
            return Function0.apply$mcB$sp$((Function0)this);
        }

        public char apply$mcC$sp() {
            return Function0.apply$mcC$sp$((Function0)this);
        }

        public double apply$mcD$sp() {
            return Function0.apply$mcD$sp$((Function0)this);
        }

        public float apply$mcF$sp() {
            return Function0.apply$mcF$sp$((Function0)this);
        }

        public int apply$mcI$sp() {
            return Function0.apply$mcI$sp$((Function0)this);
        }

        public long apply$mcJ$sp() {
            return Function0.apply$mcJ$sp$((Function0)this);
        }

        public short apply$mcS$sp() {
            return Function0.apply$mcS$sp$((Function0)this);
        }

        @Override
        public String toString() {
            return Function0.toString$((Function0)this);
        }

        public void setCallback(Function0<BoxedUnit> cb) {
            Function0<BoxedUnit> back = this.getAndSet(cb);
            if (back == WorkStealingThreadPool$.MODULE$.cats$effect$unsafe$WorkStealingThreadPool$$CanceledSleepSentinel()) {
                cb.apply$mcV$sp();
                return;
            }
        }

        public void apply() {
            this.apply$mcV$sp();
        }

        @Override
        public void run() {
            this.apply$mcV$sp();
        }

        public void apply$mcV$sp() {
            Function0<BoxedUnit> back = this.getAndSet(WorkStealingThreadPool$.MODULE$.cats$effect$unsafe$WorkStealingThreadPool$$CanceledSleepSentinel());
            if (back != null) {
                back.apply$mcV$sp();
                return;
            }
        }

        public ExternalSleepCancel() {
            Function0.$init$((Function0)this);
        }
    }
}

