/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.unsafe.WorkerThread;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001B\u001a5\rmBQ\u0001\u0013\u0001\u0005\u0002%Ca\u0001\u0014\u0001!B\u0013i\u0005BB*\u0001A\u0003&A\u000bC\u0004\u0002B\u0001\u0001\u000b\u0015B'\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003\u000bBq!!\u0014\u0001A\u0003&A\u000eC\u0004\u0002P\u0001\u0001\u000b\u0015\u00027\t\u000f\u0005E\u0003\u0001)Q\u0005Y\"9\u00111\u000b\u0001!B\u0013a\u0007bBA+\u0001\u0011%\u0011Q\u0006\u0005\b\u0003/\u0002A\u0011AA-\u0011\u001d\tI\u0007\u0001C\u0001\u0003OAq!a\u001b\u0001\t\u0003\ti\u0007C\u0004\u0002t\u0001!\t!!\u001e\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|!9\u0011\u0011\u0013\u0001\u0005\u0002\u00055\u0002bBAK\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0003/\u0003A\u0011AA-\u0011\u001d\tI\n\u0001C\u0001\u00033Bq!a'\u0001\t\u0003\tI\u0006C\u0004\u0002\u001e\u0002!\t!a(\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002$\"A\u00111\u0016\u0001!\n\u0013\ti\u000bC\u0004\u00024\u0002!I!!.\t\u0011\u0005m\u0006\u0001)C\u0005\u0003{C\u0001\"!2\u0001A\u0013%\u0011q\u0019\u0005\t\u0003\u0013\u0004\u0001\u0015\"\u0003\u0002L\"A\u0011\u0011\u001b\u0001!\n\u0013\t\u0019\u000e\u0003\u0005\u0002X\u0002\u0001K\u0011BAm\u0011!\ti\u000e\u0001Q\u0005\n\u0005}\u0007\u0002CAo\u0001\u0001&I!!;\t\u0011\u0005M\b\u0001)C\u0005\u0003kD\u0001\"a?\u0001A\u0013%\u0011Q \u0005\b\u0003o\u0001A\u0011IA\u001d\r\u0011I\u0006A\u0002.\t\u0011)\u001c#Q1A\u0005\u0002-D\u0001b\\\u0012\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\ta\u000e\u0012\t\u0011)Q\u0005c\"Q\u0011qA\u0012\u0003\u0002\u0004%\t!!\u0003\t\u0015\u0005-1E!a\u0001\n\u0003\ti\u0001C\u0005\u0002\u0014\r\u0012\t\u0011)Q\u0005\u001b\"1\u0001j\tC\u0001\u0003+A\u0001\"!\b$A\u0003&\u0011q\u0004\u0005\b\u0003K\u0019C\u0011AA\u0014\u0011\u001d\tIc\tC\u0001\u0003OAq!a\u000b$\t\u0003\ti\u0003C\u0004\u00020\r\"\t!!\f\t\u000f\u0005E2\u0005\"\u0001\u00024!9\u0011QG\u0012\u0005\u0002\u0005M\u0002bBA\u001cG\u0011\u0005\u0013\u0011\b\u0002\n)&lWM\u001d%fCBT!!\u000e\u001c\u0002\rUt7/\u00194f\u0015\t9\u0004(\u0001\u0004fM\u001a,7\r\u001e\u0006\u0002s\u0005!1-\u0019;t\u0007\u0001\u0019\"\u0001\u0001\u001f\u0011\u0005u2U\"\u0001 \u000b\u0005}\u0002\u0015AB1u_6L7M\u0003\u0002B\u0005\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\r#\u0015\u0001B;uS2T\u0011!R\u0001\u0005U\u00064\u0018-\u0003\u0002H}\ti\u0011\t^8nS\u000eLe\u000e^3hKJ\fa\u0001P5oSRtD#\u0001&\u0011\u0005-\u0003Q\"\u0001\u001b\u0002-I,Wn\u001c<fI\u000e\u000bgnY3mK\u0012\u001cu.\u001e8uKJ\u0004\"AT)\u000e\u0003=S\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%>\u00131!\u00138u\u0003\u0011AW-\u00199\u0011\u00079+v+\u0003\u0002W\u001f\n)\u0011I\u001d:bsB\u0011\u0001lI\u0007\u0002\u0001\t!aj\u001c3f'\u0011\u00193L\u00183\u0011\u00059c\u0016BA/P\u0005\u0019\te.\u001f*fMB\u0019ajX1\n\u0005\u0001|%!\u0003$v]\u000e$\u0018n\u001c81!\tq%-\u0003\u0002d\u001f\n!QK\\5u!\t)\u0007.D\u0001g\u0015\t9G)\u0001\u0003mC:<\u0017BA5g\u0005!\u0011VO\u001c8bE2,\u0017a\u0003;sS\u001e<WM\u001d+j[\u0016,\u0012\u0001\u001c\t\u0003\u001d6L!A\\(\u0003\t1{gnZ\u0001\riJLwmZ3s)&lW\rI\u0001\tG\u0006dGNY1dWB!aJ\u001d;b\u0013\t\u0019xJA\u0005Gk:\u001cG/[8ocA)Q/`A\u0001C:\u0011ao\u001f\b\u0003ojl\u0011\u0001\u001f\u0006\u0003sj\na\u0001\u0010:p_Rt\u0014\"\u0001)\n\u0005q|\u0015a\u00029bG.\fw-Z\u0005\u0003}~\u0014QAU5hQRT!\u0001`(\u0011\u00079\u000b\u0019!C\u0002\u0002\u0006=\u0013qAT8uQ&tw-A\u0003j]\u0012,\u00070F\u0001N\u0003%Ig\u000eZ3y?\u0012*\u0017\u000fF\u0002b\u0003\u001fA\u0001\"!\u0005)\u0003\u0003\u0005\r!T\u0001\u0004q\u0012\n\u0014AB5oI\u0016D\b\u0005F\u0004X\u0003/\tI\"a\u0007\t\u000b)T\u0003\u0019\u00017\t\u000bAT\u0003\u0019A9\t\r\u0005\u001d!\u00061\u0001N\u0003!\u0019\u0017M\\2fY\u0016$\u0007c\u0001(\u0002\"%\u0019\u00111E(\u0003\u000f\t{w\u000e\\3b]\u0006Yq-\u001a;B]\u0012\u001cE.Z1s)\u0005\t\u0018aA4fi\u0006)\u0011\r\u001d9msR\t\u0011-A\u0002sk:\f\u0011\"[:EK2,G/\u001a3\u0015\u0005\u0005}\u0011AC5t\u0007\u0006t7-\u001a7fI\u0006AAo\\*ue&tw\r\u0006\u0002\u0002<A\u0019Q-!\u0010\n\u0007\u0005}bM\u0001\u0004TiJLgnZ\u0001\u0005g&TX-A\u0005SS\u001eDG/\u00168jiB9\u0011qIA&\u0003\u0003\tWBAA%\u0015\t\u0019u*C\u0002\u007f\u0003\u0013\na\u0002^8uC2\u001c6\r[3ek2,G-A\u0007u_R\fG.\u0012=fGV$X\rZ\u0001\u000ei>$\u0018\r\\\"b]\u000e,G.\u001a3\u0002\u0015Q|G/\u00197QC\u000e\\7/\u0001\fj]\u000e\u0014X-\\3oiR{G/\u00197DC:\u001cW\r\\3e\u0003Q\u0001X-Z6GSJ\u001cH\u000f\u0016:jO\u001e,'\u000fV5nKR\tA\u000eK\u0002\f\u0003;\u0002B!a\u0018\u0002f5\u0011\u0011\u0011\r\u0006\u0004\u0003Gz\u0015AC1o]>$\u0018\r^5p]&!\u0011qMA1\u0005\u001d!\u0018-\u001b7sK\u000e\f!\u0003]3fW\u001aK'o\u001d;Rk&,7oY3oi\u0006!\u0002o\u001c7m\r&\u00148\u000f^%g)JLwmZ3sK\u0012$2!]A8\u0011\u0019\t\t(\u0004a\u0001Y\u0006\u0019an\\<\u0002\u000bM$X-\u00197\u0015\t\u0005}\u0011q\u000f\u0005\u0007\u0003cr\u0001\u0019\u00017\u0002\r%t7/\u001a:u))\ti(a!\u0002\u0006\u0006%\u00151\u0012\n\u0005\u0003\u007frFM\u0002\u0004\u0002\u0002\u0002\u0001\u0011Q\u0010\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\u0005\u0007\u0003cz\u0001\u0019\u00017\t\r\u0005\u001du\u00021\u0001m\u0003\u0015!W\r\\1z\u0011\u0015\u0001x\u00021\u0001r\u0011\u001d\tii\u0004a\u0001\u0003\u001f\u000b1a\\;u!\rqU+]\u0001\ra\u0006\u001c7.\u00134OK\u0016$W\r\u001a\u0015\u0004!\u0005u\u0013\u0001\u0006;pi\u0006dG+[7feN\u001c6\r[3ek2,G-A\nu_R\fG\u000eV5nKJ\u001cX\t_3dkR,G-A\nu_R\fG\u000eV5nKJ\u001c8)\u00198dK2,G-A\u0005qC\u000e\\7i\\;oi\u0006\tr.\u001e;ti\u0006tG-\u001b8h)&lWM]:\u0015\u00035\u000bAB\\3yiRKW.\u001a:Ek\u0016$\"!!*\u0011\t9\u000b9\u000b\\\u0005\u0004\u0003S{%AB(qi&|g.\u0001\u0003qC\u000e\\GcA1\u00020\"1\u0011\u0011W\fA\u00025\u000b1B]3n_Z,7i\\;oi\u0006A!/Z7pm\u0016\fE\u000fF\u0002b\u0003oCa!!/\u0019\u0001\u0004i\u0015!A5\u0002\u0013%\u001cX\t\u001f9je\u0016$GCBA\u0010\u0003\u007f\u000b\u0019\r\u0003\u0004\u0002Bf\u0001\raV\u0001\u0005]>$W\r\u0003\u0004\u0002re\u0001\r\u0001\\\u0001\rOJ|w/\u00134OK\u0016$W\r\u001a\u000b\u0002)\u0006Ya-\u001b=Va>\u0013Hi\\<o)\r\t\u0017Q\u001a\u0005\u0007\u0003\u001f\\\u0002\u0019A'\u0002\u00035\fQAZ5y+B$2!YAk\u0011\u0019\ty\r\ba\u0001\u001b\u00069a-\u001b=E_^tGcA1\u0002\\\"1\u0011qZ\u000fA\u00025\u000b1aY7q)\u0015i\u0015\u0011]As\u0011\u0019\t\u0019O\ba\u0001Y\u0006a\u0001\u0010\u0016:jO\u001e,'\u000fV5nK\"1\u0011q\u001d\u0010A\u00021\fA\"\u001f+sS\u001e<WM\u001d+j[\u0016$R!TAv\u0003_Da!!< \u0001\u00049\u0016!\u0001=\t\r\u0005Ex\u00041\u0001X\u0003\u0005I\u0018AE2p[B,H/\u001a+sS\u001e<WM\u001d+j[\u0016$R\u0001\\A|\u0003sDa!!\u001d!\u0001\u0004a\u0007BBADA\u0001\u0007A.\u0001\u0007pm\u0016\u0014h\r\\8x\rJ,W\rF\u0003m\u0003\u007f\u0014\t\u0001\u0003\u0004\u0002r\u0005\u0002\r\u0001\u001c\u0005\u0007\u0003\u000f\u000b\u0003\u0019\u00017")
public final class TimerHeap
extends AtomicInteger {
    private int removedCanceledCounter = 0;
    private Node[] heap = new Node[8];
    private int size = 0;
    private final Right<Nothing$, BoxedUnit> RightUnit = new Right((Object)BoxedUnit.UNIT);
    private long totalScheduled = 0L;
    private long totalExecuted = 0L;
    private long totalCanceled = 0L;
    private long totalPacks = 0L;

    public void cats$effect$unsafe$TimerHeap$$incrementTotalCanceled() {
        ++this.totalCanceled;
    }

    public long peekFirstTriggerTime() {
        while (this.size > 0) {
            Node root = this.heap[1];
            if (root.isDeleted()) {
                this.cats$effect$unsafe$TimerHeap$$removeAt(1);
                if (root.isCanceled()) {
                    ++this.removedCanceledCounter;
                    ++this.totalCanceled;
                    continue;
                }
                ++this.totalExecuted;
                continue;
            }
            long tt = root.triggerTime();
            if (tt != Long.MIN_VALUE) {
                return tt;
            }
            return Long.MAX_VALUE;
        }
        return Long.MIN_VALUE;
    }

    public Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> peekFirstQuiescent() {
        if (this.size > 0) {
            return this.heap[1].get();
        }
        return null;
    }

    public Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> pollFirstIfTriggered(long now) {
        Node[] heap = this.heap;
        return this.loop$1(heap, now);
    }

    public boolean steal(long now) {
        Node[] heap = this.heap;
        if (heap != null) {
            int size = Math.min(this.size, heap.length - 1);
            return this.go$1(heap, size, 1, now);
        }
        return false;
    }

    public Function0<BoxedUnit> insert(long now, long delay, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit>[] out) {
        Node node;
        ++this.totalScheduled;
        if (this.size > 0) {
            Node node2;
            boolean rootExpired;
            Node[] heap = this.heap;
            long triggerTime = this.computeTriggerTime(now, delay);
            Node root = heap[1];
            boolean rootDeleted = root.isDeleted();
            boolean bl = rootExpired = !rootDeleted && this.isExpired(root, now);
            if (rootDeleted || rootExpired) {
                Node node3;
                root.index_$eq(-1);
                if (root.isCanceled()) {
                    ++this.removedCanceledCounter;
                    ++this.totalCanceled;
                } else {
                    ++this.totalExecuted;
                    if (rootExpired) {
                        out[0] = root.getAndClear();
                    }
                }
                heap[1] = node3 = new Node(this, triggerTime, callback, 1);
                this.fixDown(1);
                return node3;
            }
            Node[] heap2 = this.growIfNeeded();
            ++this.size;
            heap2[this.size] = node2 = new Node(this, triggerTime, callback, this.size);
            this.fixUp(this.size);
            return node2;
        }
        this.heap[1] = node = new Node(this, now + delay, callback, 1);
        ++this.size;
        return node;
    }

    public void packIfNeeded() {
        block1: {
            BoxedUnit boxedUnit;
            int canceledCount;
            int back;
            do {
                if ((canceledCount = (back = this.get()) - this.removedCanceledCounter) < this.size / 2) continue;
                int removeCount = this.compareAndSet(back, 0) ? canceledCount : this.getAndSet(0) - this.removedCanceledCounter;
                this.removedCanceledCounter = 0;
                this.pack(removeCount);
                boxedUnit = BoxedUnit.UNIT;
                break block1;
            } while (!this.compareAndSet(back, canceledCount));
            this.removedCanceledCounter = 0;
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public long totalTimersScheduled() {
        return this.totalScheduled;
    }

    public long totalTimersExecuted() {
        return this.totalExecuted;
    }

    public long totalTimersCanceled() {
        return this.totalCanceled;
    }

    public long packCount() {
        return this.totalPacks;
    }

    public int outstandingTimers() {
        return this.size;
    }

    public Option<Object> nextTimerDue() {
        Node root = this.heap[1];
        if (root != null) {
            long now = System.nanoTime();
            long when = root.triggerTime() - now;
            return new Some((Object)BoxesRunTime.boxToLong((long)when));
        }
        return None$.MODULE$;
    }

    private void pack(int removeCount) {
        ++this.totalPacks;
        Node[] heap = this.heap;
        int i = 1;
        int r = 0;
        while (r < removeCount && i <= this.size) {
            if (heap[i].isCanceled()) {
                this.cats$effect$unsafe$TimerHeap$$removeAt(i);
                ++r;
                ++this.totalCanceled;
                continue;
            }
            ++i;
        }
    }

    public void cats$effect$unsafe$TimerHeap$$removeAt(int i) {
        Node[] heap = this.heap;
        Node back = heap[i];
        back.getAndClear();
        back.index_$eq(-1);
        if (i == this.size) {
            heap[i] = null;
            --this.size;
            return;
        }
        Node last = heap[this.size];
        heap[this.size] = null;
        heap[i] = last;
        last.index_$eq(i);
        --this.size;
        this.fixUpOrDown(i);
    }

    private boolean isExpired(Node node, long now) {
        return this.cmp(node.triggerTime(), now) <= 0;
    }

    private Node[] growIfNeeded() {
        Node[] heap = this.heap;
        if (this.size >= heap.length - 1) {
            Node[] newHeap = (Node[])Arrays.copyOf((Object[])heap, heap.length * 2, Node[].class);
            this.heap = newHeap;
            return newHeap;
        }
        return heap;
    }

    private void fixUpOrDown(int m) {
        Node[] heap = this.heap;
        if (m > 1 && this.cmp(heap[m >> 1], heap[m]) > 0) {
            this.fixUp(m);
            return;
        }
        this.fixDown(m);
    }

    private void fixUp(int m) {
        Node[] heap = this.heap;
        Node heapAtM = heap[m];
        this.loop$2(m, heap, heapAtM);
    }

    private void fixDown(int m) {
        Node[] heap = this.heap;
        Node heapAtM = heap[m];
        this.loop$3(m, heap, heapAtM);
    }

    private int cmp(long xTriggerTime, long yTriggerTime) {
        long d = xTriggerTime - yTriggerTime;
        return Long.signum(d);
    }

    private int cmp(Node x, Node y) {
        return this.cmp(x.triggerTime(), y.triggerTime());
    }

    private long computeTriggerTime(long now, long delay) {
        long safeDelay = delay < 0x3FFFFFFFFFFFFFFFL ? delay : this.overflowFree(now, delay);
        return now + safeDelay;
    }

    private long overflowFree(long now, long delay) {
        Node root = this.heap[1];
        long rootDelay = root.triggerTime() - now;
        if (rootDelay < 0L && delay - rootDelay < 0L) {
            return Long.MAX_VALUE + rootDelay;
        }
        return delay;
    }

    @Override
    public String toString() {
        if (this.size > 0) {
            return "TimerHeap(...)";
        }
        return "TimerHeap()";
    }

    private final Function1 loop$1(Node[] heap$1, long now$1) {
        while (this.size > 0) {
            boolean rootExpired;
            Node root = heap$1[1];
            boolean rootDeleted = root.isDeleted();
            boolean bl = rootExpired = !rootDeleted && this.isExpired(root, now$1);
            if (rootDeleted || rootExpired) {
                root.index_$eq(-1);
                if (this.size > 1) {
                    heap$1[1] = heap$1[this.size];
                    this.fixDown(1);
                }
                heap$1[this.size] = null;
                --this.size;
                if (root.isCanceled()) {
                    ++this.removedCanceledCounter;
                    ++this.totalCanceled;
                } else {
                    ++this.totalExecuted;
                }
                Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> back = root.getAndClear();
                if (!rootExpired || back == null) continue;
                ++this.totalExecuted;
                return back;
            }
            return null;
        }
        return null;
    }

    private final boolean go$1(Node[] heap, int size, int m, long now$2) {
        if (m <= size) {
            Node node = heap[m];
            if (node != null && this.isExpired(node, now$2)) {
                Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> cb = node.getAndClear();
                boolean invoked = cb != null;
                Object object = invoked ? cb.apply(this.RightUnit) : BoxedUnit.UNIT;
                boolean leftInvoked = this.go$1(heap, size, 2 * m, now$2);
                boolean rightInvoked = this.go$1(heap, size, 2 * m + 1, now$2);
                return invoked || leftInvoked || rightInvoked;
            }
            return false;
        }
        return false;
    }

    private final void loop$2(int m, Node[] heap$2, Node heapAtM$1) {
        block2: {
            BoxedUnit boxedUnit;
            while (m > 1) {
                int parent = m >> 1;
                Node heapAtParent = heap$2[parent];
                if (this.cmp(heapAtParent, heapAtM$1) > 0) {
                    heap$2[parent] = heapAtM$1;
                    heap$2[m] = heapAtParent;
                    heapAtParent.index_$eq(m);
                    m = parent;
                    continue;
                }
                heapAtM$1.index_$eq(m);
                boxedUnit = BoxedUnit.UNIT;
                break block2;
            }
            heapAtM$1.index_$eq(m);
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final void loop$3(int m, Node[] heap$3, Node heapAtM$2) {
        block3: {
            BoxedUnit boxedUnit;
            int j;
            while ((j = 2 * m) <= this.size) {
                Node heapAtJPlus1;
                Node heapAtJ = heap$3[j];
                if (j < this.size && this.cmp(heapAtJ, heapAtJPlus1 = heap$3[j + 1]) > 0) {
                    ++j;
                    heapAtJ = heapAtJPlus1;
                }
                if (this.cmp(heapAtM$2, heapAtJ) > 0) {
                    heap$3[m] = heapAtJ;
                    heapAtJ.index_$eq(m);
                    heap$3[j] = heapAtM$2;
                    m = j;
                    continue;
                }
                heapAtM$2.index_$eq(m);
                boxedUnit = BoxedUnit.UNIT;
                break block3;
            }
            heapAtM$2.index_$eq(m);
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final class Node
    implements Function0.mcV.sp,
    Runnable {
        private final long triggerTime;
        public Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> cats$effect$unsafe$TimerHeap$Node$$callback;
        private int index;
        public boolean cats$effect$unsafe$TimerHeap$Node$$canceled;
        private final /* synthetic */ TimerHeap $outer;

        public boolean apply$mcZ$sp() {
            return Function0.apply$mcZ$sp$((Function0)this);
        }

        public byte apply$mcB$sp() {
            return Function0.apply$mcB$sp$((Function0)this);
        }

        public char apply$mcC$sp() {
            return Function0.apply$mcC$sp$((Function0)this);
        }

        public double apply$mcD$sp() {
            return Function0.apply$mcD$sp$((Function0)this);
        }

        public float apply$mcF$sp() {
            return Function0.apply$mcF$sp$((Function0)this);
        }

        public int apply$mcI$sp() {
            return Function0.apply$mcI$sp$((Function0)this);
        }

        public long apply$mcJ$sp() {
            return Function0.apply$mcJ$sp$((Function0)this);
        }

        public short apply$mcS$sp() {
            return Function0.apply$mcS$sp$((Function0)this);
        }

        public long triggerTime() {
            return this.triggerTime;
        }

        public int index() {
            return this.index;
        }

        public void index_$eq(int x$1) {
            this.index = x$1;
        }

        public Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> getAndClear() {
            Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> back;
            block0: {
                back = this.cats$effect$unsafe$TimerHeap$Node$$callback;
                if (back == null) break block0;
                this.cats$effect$unsafe$TimerHeap$Node$$callback = null;
            }
            return back;
        }

        public Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> get() {
            return this.cats$effect$unsafe$TimerHeap$Node$$callback;
        }

        public void apply() {
            this.apply$mcV$sp();
        }

        @Override
        public void run() {
            this.apply$mcV$sp();
        }

        public boolean isDeleted() {
            return this.cats$effect$unsafe$TimerHeap$Node$$callback == null;
        }

        public boolean isCanceled() {
            return this.cats$effect$unsafe$TimerHeap$Node$$canceled;
        }

        public String toString() {
            return new StringBuilder(9).append("Node(").append(this.triggerTime()).append(", ").append(this.cats$effect$unsafe$TimerHeap$Node$$callback).append("})").toString();
        }

        public void apply$mcV$sp() {
            this.cats$effect$unsafe$TimerHeap$Node$$callback = null;
            this.cats$effect$unsafe$TimerHeap$Node$$canceled = true;
            Thread thread = Thread.currentThread();
            if (thread instanceof WorkerThread) {
                WorkerThread worker = (WorkerThread)thread;
                TimerHeap heap = this.$outer;
                if (worker.ownsTimers(heap)) {
                    if (this.index() >= 0) {
                        heap.cats$effect$unsafe$TimerHeap$$removeAt(this.index());
                    }
                    heap.cats$effect$unsafe$TimerHeap$$incrementTotalCanceled();
                    return;
                }
                this.$outer.getAndIncrement();
                return;
            }
            this.$outer.getAndIncrement();
        }

        public Node(TimerHeap $outer, long triggerTime, Function1<Right<Nothing$, BoxedUnit>, BoxedUnit> callback, int index) {
            this.triggerTime = triggerTime;
            this.cats$effect$unsafe$TimerHeap$Node$$callback = callback;
            this.index = index;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Function0.$init$((Function0)this);
            this.cats$effect$unsafe$TimerHeap$Node$$canceled = false;
        }
    }
}

