/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005E4QAD\b\u0003#UA\u0001\"\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\u0006E\u0001!\ta\t\u0005\u0007_\u0001\u0001\u000b\u0011B\u0010\t\rA\u0002\u0001\u0015!\u0003 \u0011\u0019\t\u0004\u0001)A\u0005e!)q\b\u0001C\u0001\u0001\")1\n\u0001C\u0001\u0019\")a\u000b\u0001C\u0001/\")\u0011\f\u0001C\u00015\")A\f\u0001C\u0001;\")\u0011\u000e\u0001C\u0001U\")a\u000e\u0001C\u0001U\")q\u000e\u0001C\u0001a\nI1kY1m#V,W/\u001a\u0006\u0003!E\ta!\u001e8tC\u001a,'B\u0001\n\u0014\u0003\u0019)gMZ3di*\tA#\u0001\u0003dCR\u001cXC\u0001\f)'\t\u0001q\u0003\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VMZ\u0001\fi\"\u0014X-\u00193D_VtGo\u0001\u0001\u0011\u0005a\u0001\u0013BA\u0011\u001a\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0011r\u0003cA\u0013\u0001M5\tq\u0002\u0005\u0002(Q1\u0001A!B\u0015\u0001\u0005\u0004Q#!A!\u0012\u0005-:\u0002C\u0001\r-\u0013\ti\u0013DA\u0004O_RD\u0017N\\4\t\u000bu\u0011\u0001\u0019A\u0010\u0002\t5\f7o[\u0001\n]Vl\u0017+^3vKN\fa!];fk\u0016\u001c\bc\u0001\r4k%\u0011A'\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004mu2S\"A\u001c\u000b\u0005aJ\u0014AC2p]\u000e,(O]3oi*\u0011!hO\u0001\u0005kRLGNC\u0001=\u0003\u0011Q\u0017M^1\n\u0005y:$!F\"p]\u000e,(O]3oi2Kgn[3e#V,W/Z\u0001\u0006_\u001a4WM\u001d\u000b\u0004\u0003\u00123\u0005C\u0001\rC\u0013\t\u0019\u0015D\u0001\u0003V]&$\b\"B#\u0007\u0001\u00041\u0013!A1\t\u000b\u001d3\u0001\u0019\u0001%\u0002\rI\fg\u000eZ8n!\t1\u0014*\u0003\u0002Ko\t\tB\u000b\u001b:fC\u0012dunY1m%\u0006tGm\\7\u0002\u0011=4g-\u001a:BY2$2!Q'V\u0011\u0015qu\u00011\u0001P\u0003\t\t7\u000f\r\u0002Q%B\u0019\u0001dM)\u0011\u0005\u001d\u0012F!C*N\u0003\u0003\u0005\tQ!\u0001U\u0005!!\u0013/\\1sW\u0012\n\u0014CA\u0016'\u0011\u00159u\u00011\u0001I\u0003\u0011\u0001x\u000e\u001c7\u0015\u0005\u0019B\u0006\"B$\t\u0001\u0004A\u0015A\u0002:f[>4X\r\u0006\u0002B7\")Q)\u0003a\u0001M\u0005A1O\\1qg\"|G\u000fF\u0001_!\ryfm\u0006\b\u0003A\u0012\u0004\"!Y\r\u000e\u0003\tT!a\u0019\u0010\u0002\rq\u0012xn\u001c;?\u0013\t)\u0017$\u0001\u0004Qe\u0016$WMZ\u0005\u0003O\"\u00141aU3u\u0015\t)\u0017$A\u0004jg\u0016k\u0007\u000f^=\u0015\u0003-\u0004\"\u0001\u00077\n\u00055L\"a\u0002\"p_2,\u0017M\\\u0001\t]>tW)\u001c9us\u0006)1\r\\3beR\t\u0011\t")
public final class ScalQueue<A> {
    private final int mask;
    private final int numQueues;
    private final ConcurrentLinkedQueue<A>[] queues;

    public void offer(A a, ThreadLocalRandom random) {
        int idx = random.nextInt(this.numQueues);
        this.queues[idx].offer(a);
    }

    public void offerAll(Object[] as, ThreadLocalRandom random) {
        int nq = this.numQueues;
        for (Object fiber : as) {
            int idx = random.nextInt(nq);
            this.queues[idx].offer(fiber);
        }
    }

    public A poll(ThreadLocalRandom random) {
        int nq = this.numQueues;
        int from = random.nextInt(nq);
        A a = null;
        for (int i = 0; a == null && i < nq; ++i) {
            int idx = from + i & this.mask;
            a = this.queues[idx].poll();
        }
        return a;
    }

    public void remove(A a) {
        int nq = this.numQueues;
        boolean done = false;
        for (int i = 0; !done && i < nq; ++i) {
            done = this.queues[i].remove(a);
        }
    }

    public Set<Object> snapshot() {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])this.queues), (Function1 & Serializable)x$1 -> x$1.toArray(), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray(xs), ClassTag$.MODULE$.apply(Object.class))).toSet();
    }

    public boolean isEmpty() {
        int nq = this.numQueues;
        boolean empty = true;
        for (int i = 0; empty && i < nq; ++i) {
            empty = this.queues[i].isEmpty();
        }
        return empty;
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public void clear() {
        int nq = this.numQueues;
        for (int i = 0; i < nq; ++i) {
            this.queues[i].clear();
        }
    }

    public ScalQueue(int threadCount) {
        int value = threadCount - 1;
        value |= value >> 1;
        value |= value >> 2;
        value |= value >> 4;
        value |= value >> 8;
        this.mask = value | value >> 16;
        int nq = this.numQueues = this.mask + 1;
        ConcurrentLinkedQueue[] queues = new ConcurrentLinkedQueue[nq];
        for (int i = 0; i < nq; ++i) {
            queues[i] = new ConcurrentLinkedQueue();
        }
        this.queues = queues;
    }
}

