/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.tracing.TracingConstants;
import cats.effect.unsafe.Head;
import cats.effect.unsafe.LocalQueueConstants;
import cats.effect.unsafe.LocalQueuePadding;
import cats.effect.unsafe.ScalQueue;
import cats.effect.unsafe.Tail;
import cats.effect.unsafe.WorkerThread;
import java.util.concurrent.ThreadLocalRandom;
import scala.Predef$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001B\u0011#\r%BQA\f\u0001\u0005\u0002=Ba!\r\u0001!\u0002\u0013\u0011\u0004B\u0002!\u0001A\u0003&\u0011\t\u0003\u0004E\u0001\u0001\u0006K!\u0011\u0005\u0007\u000b\u0002\u0001\u000b\u0015B!\t\r\u0019\u0003\u0001\u0015)\u0003B\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u0015)\b\u0001\"\u0001w\u0011\u0015i\b\u0001\"\u0001\u007f\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'Aq!!\u0007\u0001\t\u0003\tY\u0002C\u0004\u0002$\u0001!\t!a\u0007\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0002\u0002CA\u001a\u0001\u0001&I!!\u000e\t\u0011\u0005m\u0002\u0001)C\u0005\u0003{A\u0001\"!\u0011\u0001A\u0013%\u00111\t\u0005\t\u0003\u000f\u0002\u0001\u0015\"\u0003\u0002J!A\u0011q\n\u0001!\n\u0013\t\t\u0006\u0003\u0005\u0002\\\u0001\u0001K\u0011BA/\u0011\u001d\t\u0019\u0007\u0001C\u0001\u0003KBq!! \u0001\t\u0003\t9\u0003C\u0004\u0002\u0000\u0001!\t!a\n\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002(!9\u00111\u0011\u0001\u0005\u0002\u0005\u0015\u0005bBAD\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0003\u0013\u0003A\u0011AAC\u0011\u001d\tY\t\u0001C\u0001\u0003\u000bCq!!$\u0001\t\u0003\t9\u0003C\u0004\u0002\u0010\u0002!\t!a\n\t\u000f\u0005E\u0005\u0001\"\u0001\u0002(\tQAj\\2bYF+X-^3\u000b\u0005\r\"\u0013AB;og\u00064WM\u0003\u0002&M\u00051QM\u001a4fGRT\u0011aJ\u0001\u0005G\u0006$8o\u0001\u0001\u0014\u0005\u0001Q\u0003CA\u0016-\u001b\u0005\u0011\u0013BA\u0017#\u0005EaunY1m#V,W/\u001a)bI\u0012LgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\u0002\"a\u000b\u0001\u0002\r\t,hMZ3s!\r\u0019d\u0007O\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t)\u0011I\u001d:bsB\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0005Y\u0006twMC\u0001>\u0003\u0011Q\u0017M^1\n\u0005}R$\u0001\u0003*v]:\f'\r\\3\u0002\u001fQ|G/\u00197GS\n,'oQ8v]R\u0004\"a\r\"\n\u0005\r#$\u0001\u0002'p]\u001e\f1\u0003^8uC2\u001c\u0006/\u001b7m_Z,'oQ8v]R\f1d];dG\u0016\u001c8OZ;m'R,\u0017\r\\!ui\u0016l\u0007\u000f^\"pk:$\u0018\u0001E:u_2,gNR5cKJ\u001cu.\u001e8u\u0003\u001d)g.];fk\u0016$B!\u0013'O-B\u00111GS\u0005\u0003\u0017R\u0012A!\u00168ji\")Qj\u0002a\u0001q\u0005)a-\u001b2fe\")qj\u0002a\u0001!\u0006AQ\r\u001f;fe:\fG\u000eE\u0002,#NK!A\u0015\u0012\u0003\u0013M\u001b\u0017\r\\)vKV,\u0007CA\u001aU\u0013\t)FG\u0001\u0004B]f\u0014VM\u001a\u0005\u0006/\u001e\u0001\r\u0001W\u0001\u0007e\u0006tGm\\7\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016AC2p]\u000e,(O]3oi*\u0011Q\fP\u0001\u0005kRLG.\u0003\u0002`5\n\tB\u000b\u001b:fC\u0012dunY1m%\u0006tGm\\7\u0002\u0019\u0015t\u0017/^3vK\n\u000bGo\u00195\u0015\u0007a\u0012G\rC\u0003d\u0011\u0001\u0007!'A\u0003cCR\u001c\u0007\u000eC\u0003f\u0011\u0001\u0007a-\u0001\u0004x_J\\WM\u001d\u0019\u0003O2\u00042a\u000b5k\u0013\tI'E\u0001\u0007X_J\\WM\u001d+ie\u0016\fG\r\u0005\u0002lY2\u0001A!C7e\u0003\u0003\u0005\tQ!\u0001o\u0005!!\u0013/\\1sW\u0012\n\u0014CA8s!\t\u0019\u0004/\u0003\u0002ri\t9aj\u001c;iS:<\u0007CA\u001at\u0013\t!HGA\u0002B]f\fq\u0001Z3rk\u0016,X\r\u0006\u00029o\")Q-\u0003a\u0001qB\u0012\u0011p\u001f\t\u0004W!T\bCA6|\t%ax/!A\u0001\u0002\u000b\u0005aN\u0001\u0005%c6\f'o\u001b\u00133\u0003%\u0019H/Z1m\u0013:$x\u000e\u0006\u00039\u007f\u0006\r\u0001BBA\u0001\u0015\u0001\u0007\u0001'A\u0002egRDq!!\u0002\u000b\u0001\u0004\t9!A\u0005egR<vN]6feB\"\u0011\u0011BA\u0007!\u0011Y\u0003.a\u0003\u0011\u0007-\fi\u0001B\u0006\u0002\u0010\u0005\r\u0011\u0011!A\u0001\u0006\u0003q'\u0001\u0003\u0013r[\u0006\u00148\u000eJ\u001a\u0002\u0015\u0011\u0014\u0018-\u001b8CCR\u001c\u0007\u000eF\u0003J\u0003+\t9\u0002C\u0003P\u0017\u0001\u0007\u0001\u000bC\u0003X\u0017\u0001\u0007\u0001,A\u0004jg\u0016k\u0007\u000f^=\u0015\u0005\u0005u\u0001cA\u001a\u0002 %\u0019\u0011\u0011\u0005\u001b\u0003\u000f\t{w\u000e\\3b]\u0006Aan\u001c8F[B$\u00180\u0001\u0003tSj,GCAA\u0015!\r\u0019\u00141F\u0005\u0004\u0003[!$aA%oi\u0006y!-\u001e4gKJ4uN]<be\u0012,'/F\u00013\u0003\u0015Ig\u000eZ3y)\u0011\tI#a\u000e\t\u000f\u0005e\u0002\u00031\u0001\u0002*\u0005\ta.A\u0002mg\n$B!!\u000b\u0002@!9\u0011\u0011H\tA\u0002\u0005%\u0012aA7tER!\u0011\u0011FA#\u0011\u001d\tID\u0005a\u0001\u0003S\tA\u0001]1dWR1\u0011\u0011FA&\u0003\u001bBq!!\u0011\u0014\u0001\u0004\tI\u0003C\u0004\u0002<M\u0001\r!!\u000b\u0002+Ut7/[4oK\u0012\u001c\u0006n\u001c:u\u0003\u0012$\u0017\u000e^5p]R1\u0011\u0011FA*\u0003/Bq!!\u0016\u0015\u0001\u0004\tI#A\u0001y\u0011\u001d\tI\u0006\u0006a\u0001\u0003S\t\u0011!_\u0001\u0019k:\u001c\u0018n\u001a8fINCwN\u001d;Tk\n$(/Y2uS>tGCBA\u0015\u0003?\n\t\u0007C\u0004\u0002VU\u0001\r!!\u000b\t\u000f\u0005eS\u00031\u0001\u0002*\u0005A1O\\1qg\"|G\u000f\u0006\u0002\u0002hA)\u0011\u0011NA<q9!\u00111NA:!\r\ti\u0007N\u0007\u0003\u0003_R1!!\u001d)\u0003\u0019a$o\\8u}%\u0019\u0011Q\u000f\u001b\u0002\rA\u0013X\rZ3g\u0013\u0011\tI(a\u001f\u0003\u0007M+GOC\u0002\u0002vQ\nQbZ3u\r&\u0014WM]\"pk:$\u0018\u0001D4fi\"+\u0017\rZ%oI\u0016D\u0018\u0001D4fiR\u000b\u0017\u000e\\%oI\u0016D\u0018AE4fiR{G/\u00197GS\n,'oQ8v]R$\u0012!Q\u0001\u0017O\u0016$Hk\u001c;bYN\u0003\u0018\u000e\u001c7pm\u0016\u00148i\\;oi\u0006qr-\u001a;Tk\u000e\u001cWm]:gk2\u001cF/Z1m\u0003R$X-\u001c9u\u0007>,h\u000e^\u0001\u0014O\u0016$8\u000b^8mK:4\u0015NY3s\u0007>,h\u000e^\u0001\u000fO\u0016$(+Z1m\u0011\u0016\fG\rV1h\u0003=9W\r^*uK\u0006d\u0007*Z1e)\u0006<\u0017AC4fiR\u000b\u0017\u000e\u001c+bO\u0002")
public final class LocalQueue
extends LocalQueuePadding {
    private final Runnable[] buffer = new Runnable[256];
    private long totalFiberCount = 0L;
    private long totalSpilloverCount = 0L;
    private long successfulStealAttemptCount = 0L;
    private long stolenFiberCount = 0L;

    public void enqueue(Runnable fiber, ScalQueue<Object> external, ThreadLocalRandom random) {
        int tl = this.tail;
        while (true) {
            int hd;
            int steal;
            if (this.unsignedShortSubtraction(tl, steal = this.msb(hd = Head.updater.get(this))) < 256) {
                int idx = this.index(tl);
                this.buffer[idx] = fiber;
                if (TracingConstants.isStackTracing) {
                    ++this.totalFiberCount;
                }
                int newTl = this.unsignedShortAddition(tl, 1);
                Tail.updater.lazySet(this, newTl);
                this.tail = newTl;
                return;
            }
            int real = this.lsb(hd);
            if (steal != real) {
                if (TracingConstants.isStackTracing) {
                    ++this.totalSpilloverCount;
                    Tail.updater.lazySet(this, tl);
                }
                external.offer(fiber, random);
                return;
            }
            int realPlusHalf = this.unsignedShortAddition(real, LocalQueueConstants.HalfLocalQueueCapacity);
            int newHd = this.pack(realPlusHalf, realPlusHalf);
            if (!Head.updater.compareAndSet(this, hd, newHd)) continue;
            Runnable[][] batches = new Runnable[LocalQueueConstants.BatchesInHalfQueueCapacity][];
            int offset = 0;
            for (int b = 0; b < LocalQueueConstants.BatchesInHalfQueueCapacity; ++b) {
                Runnable[] batch = new Runnable[32];
                int i = 0;
                while (i < 32) {
                    int idx = this.index(real + offset);
                    Runnable f = this.buffer[idx];
                    this.buffer[idx] = null;
                    batch[i] = f;
                    ++i;
                    ++offset;
                }
                if (TracingConstants.isStackTracing) {
                    this.totalSpilloverCount += 32L;
                }
                batches[b] = batch;
            }
            external.offerAll((Object[])batches, random);
        }
    }

    public Runnable enqueueBatch(Runnable[] batch, WorkerThread<?> worker) {
        int hd;
        int steal;
        int len;
        int tl = this.tail;
        while ((len = this.unsignedShortSubtraction(tl, steal = this.msb(hd = Head.updater.get(this)))) > LocalQueueConstants.LocalQueueCapacityMinusBatch) {
        }
        int startPos = tl - 1;
        for (int i = 1; i < 32; ++i) {
            int idx = this.index(startPos + i);
            this.buffer[idx] = batch[i];
        }
        Runnable fiber = batch[0];
        if (TracingConstants.isStackTracing) {
            this.totalFiberCount += 32L;
            worker.active_$eq(fiber);
        }
        int newTl = this.unsignedShortAddition(tl, 31);
        Tail.updater.lazySet(this, newTl);
        this.tail = newTl;
        return fiber;
    }

    public Runnable dequeue(WorkerThread<?> worker) {
        Runnable fiber;
        int newHd;
        int hd;
        int tl = this.tail;
        do {
            int real;
            if ((real = this.lsb(hd = Head.updater.get(this))) == tl) {
                return null;
            }
            int newReal = this.unsignedShortAddition(real, 1);
            int steal = this.msb(hd);
            newHd = steal == real ? this.pack(newReal, newReal) : this.pack(steal, newReal);
            int idx = this.index(real);
            fiber = this.buffer[idx];
            if (!TracingConstants.isStackTracing) continue;
            worker.active_$eq(fiber);
        } while (!Head.updater.compareAndSet(this, hd, newHd));
        this.buffer[idx] = null;
        return fiber;
    }

    public Runnable stealInto(LocalQueue dst, WorkerThread<?> dstWorker) {
        int n;
        int real;
        int newReal;
        int steal;
        int newHd;
        int hd;
        int dstTl = dst.tail;
        int dstHd = Head.updater.get(dst);
        int dstSteal = this.msb(dstHd);
        if (this.unsignedShortSubtraction(dstTl, dstSteal) > LocalQueueConstants.HalfLocalQueueCapacity) {
            return null;
        }
        do {
            if ((steal = this.msb(hd = Head.updater.get(this))) != (real = this.lsb(hd))) {
                return null;
            }
            int tl = Tail.updater.get(this);
            n = this.unsignedShortSubtraction(tl, real);
            if ((n -= n / 2) != 0) continue;
            return null;
        } while (!Head.updater.compareAndSet(this, hd, newHd = this.pack(steal, newReal = this.unsignedShortAddition(real, n))));
        Runnable[] dstBuffer = dst.bufferForwarder();
        int headFiberIdx = this.index(steal);
        Runnable headFiber = this.buffer[headFiberIdx];
        this.buffer[headFiberIdx] = null;
        if (TracingConstants.isStackTracing) {
            dstWorker.active_$eq(headFiber);
        }
        int sourcePos = steal + 1;
        int end = n - 1;
        for (int i = 0; i < end; ++i) {
            int srcIdx = this.index(sourcePos + i);
            int dstIdx = this.index(dstTl + i);
            Runnable fiber = this.buffer[srcIdx];
            this.buffer[srcIdx] = null;
            dstBuffer[dstIdx] = fiber;
        }
        if (TracingConstants.isStackTracing) {
            ++this.successfulStealAttemptCount;
            this.stolenFiberCount += (long)n;
        }
        hd = newHd;
        while (true) {
            if (Head.updater.compareAndSet(this, hd, newHd = this.pack(newReal, newReal))) {
                if (n == 1) {
                    if (TracingConstants.isStackTracing) {
                        Tail.updater.lazySet(dst, dstTl);
                        dst.tail = dstTl;
                    }
                    return headFiber;
                }
                int newDstTl = this.unsignedShortAddition(dstTl, --n);
                Tail.updater.lazySet(dst, newDstTl);
                dst.tail = newDstTl;
                return headFiber;
            }
            hd = Head.updater.get(this);
            newReal = this.lsb(hd);
        }
    }

    public void drainBatch(ScalQueue<Object> external, ThreadLocalRandom random) {
        int newReal;
        int real;
        int steal;
        int newHd;
        int hd;
        int tl = this.tail;
        do {
            if (this.unsignedShortSubtraction(tl, real = this.lsb(hd = Head.updater.get(this))) <= LocalQueueConstants.LocalQueueCapacityMinusBatch) {
                return;
            }
            newReal = this.unsignedShortAddition(real, 32);
        } while (!Head.updater.compareAndSet(this, hd, newHd = (steal = this.msb(hd)) == real ? this.pack(newReal, newReal) : this.pack(steal, newReal)));
        Runnable[] batch = new Runnable[32];
        for (int i = 0; i < 32; ++i) {
            int idx = this.index(real + i);
            Runnable f = this.buffer[idx];
            this.buffer[idx] = null;
            batch[i] = f;
        }
        if (TracingConstants.isStackTracing) {
            this.totalSpilloverCount += 32L;
            Tail.updater.lazySet(this, tl);
        }
        external.offer(batch, random);
    }

    public boolean isEmpty() {
        int hd = Head.updater.get(this);
        int tl = Tail.updater.get(this);
        return this.lsb(hd) == tl;
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public int size() {
        int hd = Head.updater.get(this);
        int tl = Tail.updater.get(this);
        return this.unsignedShortSubtraction(tl, this.lsb(hd));
    }

    public Runnable[] bufferForwarder() {
        return this.buffer;
    }

    private int index(int n) {
        return n & LocalQueueConstants.LocalQueueCapacityMask;
    }

    private int lsb(int n) {
        return n & LocalQueueConstants.UnsignedShortMask;
    }

    private int msb(int n) {
        return n >>> 16;
    }

    private int pack(int msb, int lsb) {
        return msb << 16 | lsb;
    }

    private int unsignedShortAddition(int x, int y) {
        return this.lsb(x + y);
    }

    private int unsignedShortSubtraction(int x, int y) {
        return this.lsb(x - y);
    }

    public Set<Runnable> snapshot() {
        int n = this.size();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return (Set)Predef$.MODULE$.wrapRefArray((Object[])this.buffer).toSet().$minus(null);
    }

    public int getFiberCount() {
        return this.size();
    }

    public int getHeadIndex() {
        int hd = Head.updater.get(this);
        return this.index(this.lsb(hd));
    }

    public int getTailIndex() {
        int tl = Tail.updater.get(this);
        return this.index(tl);
    }

    public long getTotalFiberCount() {
        int n = Tail.updater.get(this);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return this.totalFiberCount;
    }

    public long getTotalSpilloverCount() {
        int n = Tail.updater.get(this);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return this.totalSpilloverCount;
    }

    public long getSuccessfulStealAttemptCount() {
        int n = Head.updater.get(this);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return this.successfulStealAttemptCount;
    }

    public long getStolenFiberCount() {
        int n = Head.updater.get(this);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return this.stolenFiberCount;
    }

    public int getRealHeadTag() {
        int hd = Head.updater.get(this);
        return this.lsb(hd);
    }

    public int getStealHeadTag() {
        int hd = Head.updater.get(this);
        return this.msb(hd);
    }

    public int getTailTag() {
        return Tail.updater.get(this);
    }
}

