/*
 * Decompiled with CFR 0.152.
 */
package cats.effect;

import cats.Show$;
import cats.effect.CpuStarvationCheckPlatform;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.metrics.CpuStarvationWarningMetrics;
import cats.effect.std.Console$;
import cats.effect.unsafe.IORuntimeConfig;
import cats.effect.unsafe.metrics.CpuStarvationSampler;
import cats.syntax.ApplicativeByNameOps$;
import cats.syntax.package;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

public final class CpuStarvationCheck$
extends CpuStarvationCheckPlatform {
    public static final CpuStarvationCheck$ MODULE$ = new CpuStarvationCheck$();

    public IO<Nothing$> run(IORuntimeConfig runtimeConfig, CpuStarvationSampler sampler, Function1<CpuStarvationWarningMetrics, IO<BoxedUnit>> onCpuStarvationWarn) {
        Duration threshold = runtimeConfig.cpuStarvationCheckInterval().$times(1.0 + runtimeConfig.cpuStarvationCheckThreshold());
        return IO$.MODULE$.monotonic().flatMap((Function1 & Serializable)x$1 -> CpuStarvationCheck$.go$1(x$1, runtimeConfig, sampler, onCpuStarvationWarn, threshold)).delayBy(runtimeConfig.cpuStarvationCheckInitialDelay());
    }

    public IO<BoxedUnit> logWarning(CpuStarvationWarningMetrics cpuStarvationWarningMetrics) {
        return (IO)Console$.MODULE$.make(IO$.MODULE$.asyncForIO()).errorln((Object)this.mkWarning(cpuStarvationWarningMetrics.starvationInterval().$times(cpuStarvationWarningMetrics.starvationThreshold()), cpuStarvationWarningMetrics.occurrenceTime()), Show$.MODULE$.catsShowForString());
    }

    private String mkWarning(Duration threshold, FiniteDuration when) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(447).append("|").append(this.format(when)).append(" [WARNING] Your app's responsiveness to a new asynchronous\n        | event (such as a new connection, an upstream response, or a timer) was in excess\n        | of ").append(threshold).append(". Your CPU is probably starving. Consider increasing the\n        | granularity of your delays or adding more cedes. This may also be a sign that you\n        | are unintentionally running blocking I/O operations (such as File or InetAddress)\n        | without the blocking combinator.").toString())).replaceAll("\n", "");
    }

    private static final IO go$1(FiniteDuration initial, IORuntimeConfig runtimeConfig$1, CpuStarvationSampler sampler$1, Function1 onCpuStarvationWarn$1, Duration threshold$1) {
        return IO$.MODULE$.sleep(runtimeConfig$1.cpuStarvationCheckInterval()).$greater$greater((Function0 & Serializable)() -> IO$.MODULE$.monotonic().flatMap((Function1 & Serializable)now -> {
            FiniteDuration delta = now.$minus(initial);
            return sampler$1.recordClockDrift(delta.$minus(runtimeConfig$1.cpuStarvationCheckInterval())).$greater$greater((Function0 & Serializable)() -> IO$.MODULE$.realTime().flatMap((Function1 & Serializable)fd -> (IO)ApplicativeByNameOps$.MODULE$.whenA$extension(package.all$.MODULE$.catsSyntaxApplicativeByName((Function0 & Serializable)() -> ((IO)onCpuStarvationWarn$1.apply((Object)new CpuStarvationWarningMetrics((FiniteDuration)fd, delta.$minus(runtimeConfig$1.cpuStarvationCheckInterval()), runtimeConfig$1.cpuStarvationCheckThreshold(), runtimeConfig$1.cpuStarvationCheckInterval()))).$times$greater(sampler$1.incCpuStarvationCount())), delta.$greater$eq((Object)threshold$1), IO$.MODULE$.asyncForIO()))).$greater$greater((Function0 & Serializable)() -> CpuStarvationCheck$.go$1(now, runtimeConfig$1, sampler$1, onCpuStarvationWarn$1, threshold$1));
        }));
    }

    private CpuStarvationCheck$() {
    }
}

