/*
 * Decompiled with CFR 0.152.
 */
package cats.effect;

import cats.effect.ArrayStack$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000514Q!\u0006\f\u0003-iA\u0001B\t\u0001\u0003\u0002\u0003\u0006K\u0001\n\u0005\tO\u0001\u0011\t\u0011)Q\u0005Q!)1\u0006\u0001C\u0001Y!)1\u0006\u0001C\u0001s!)1\u0006\u0001C\u0001y!)Q\b\u0001C\u0001}!)A\t\u0001C\u0001\u000b\")\u0001\n\u0001C\u0001\u0013\")!\n\u0001C\u0001\u0013\")1\n\u0001C\u0001\u0019\")\u0001\u000b\u0001C\u0001#\")!\u000b\u0001C\u0001'\")A\u000b\u0001C\u0001+\")\u0001\f\u0001C\u00013\"1!\f\u0001Q\u0005\ne;Qa\u0017\f\t\nq3Q!\u0006\f\t\nuCQaK\t\u0005\u0002yCQaX\t\u0005\u0002\u0001DQaX\t\u0005\u0002\u0015\u0014!\"\u0011:sCf\u001cF/Y2l\u0015\t9\u0002$\u0001\u0004fM\u001a,7\r\u001e\u0006\u00023\u0005!1-\u0019;t+\tY\u0012g\u0005\u0002\u00019A\u0011Q\u0004I\u0007\u0002=)\tq$A\u0003tG\u0006d\u0017-\u0003\u0002\"=\t1\u0011I\\=SK\u001a\faAY;gM\u0016\u00148\u0001\u0001\t\u0004;\u0015b\u0012B\u0001\u0014\u001f\u0005\u0015\t%O]1z\u0003\u0015Ig\u000eZ3y!\ti\u0012&\u0003\u0002+=\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\ris\u0007\u000f\t\u0004]\u0001yS\"\u0001\f\u0011\u0005A\nD\u0002\u0001\u0003\u0006e\u0001\u0011\ra\r\u0002\u0002\u0003F\u0011A\u0007\b\t\u0003;UJ!A\u000e\u0010\u0003\u000f9{G\u000f[5oO\")!e\u0001a\u0001I!)qe\u0001a\u0001QQ\u0011QF\u000f\u0005\u0006w\u0011\u0001\r\u0001K\u0001\nS:LGOQ8v]\u0012$\u0012!L\u0001\u0005S:LG\u000f\u0006\u0002@\u0005B\u0011Q\u0004Q\u0005\u0003\u0003z\u0011A!\u00168ji\")1I\u0002a\u0001Q\u0005)!m\\;oI\u0006!\u0001/^:i)\tyd\tC\u0003H\u000f\u0001\u0007q&A\u0001b\u0003\r\u0001x\u000e\u001d\u000b\u0002_\u0005!\u0001/Z3l\u0003\u001dI7/R7qif$\u0012!\u0014\t\u0003;9K!a\u0014\u0010\u0003\u000f\t{w\u000e\\3b]\u0006aQO\\:bM\u0016\u0014UO\u001a4feR\tA%A\u0006v]N\fg-Z%oI\u0016DH#\u0001\u0015\u0002\u0013Ut7/\u00194f'\u0016$HCA W\u0011\u00159V\u00021\u0001)\u0003\u0011qWm^%\u0002\u0015%tg/\u00197jI\u0006$X\rF\u0001@\u00031\u0019\u0007.Z2l\u0003:$wI]8x\u0003)\t%O]1z'R\f7m\u001b\t\u0003]E\u0019\"!\u0005\u000f\u0015\u0003q\u000bQ!\u00199qYf,\"!\u00193\u0015\u0003\t\u00042A\f\u0001d!\t\u0001D\rB\u00033'\t\u00071'\u0006\u0002gSR\u0011qM\u001b\t\u0004]\u0001A\u0007C\u0001\u0019j\t\u0015\u0011DC1\u00014\u0011\u0015YG\u00031\u0001)\u0003\u0011\u0019\u0018N_3")
public final class ArrayStack<A> {
    private Object[] buffer;
    private int index;

    public static <A> ArrayStack<A> apply(int size) {
        return ArrayStack$.MODULE$.apply(size);
    }

    public static <A> ArrayStack<A> apply() {
        return ArrayStack$.MODULE$.apply();
    }

    public void init(int bound) {
        this.buffer = new Object[bound];
        this.index = 0;
    }

    public void push(A a) {
        this.checkAndGrow();
        this.buffer[this.index] = a;
        ++this.index;
    }

    public A pop() {
        --this.index;
        Object back = this.buffer[this.index];
        this.buffer[this.index] = null;
        return (A)back;
    }

    public A peek() {
        return (A)this.buffer[this.index - 1];
    }

    public boolean isEmpty() {
        return this.index <= 0;
    }

    public Object[] unsafeBuffer() {
        return this.buffer;
    }

    public int unsafeIndex() {
        return this.index;
    }

    public void unsafeSet(int newI) {
        for (int i = newI; i < this.index; ++i) {
            this.buffer[i] = null;
        }
        this.index = newI;
    }

    public void invalidate() {
        this.index = 0;
        this.buffer = null;
    }

    private void checkAndGrow() {
        if (this.index >= this.buffer.length) {
            int len = this.buffer.length;
            int targetLen = len * 2;
            if (targetLen < 0) {
                throw new Exception(new StringBuilder(47).append("Overflow while resizing array. Request length: ").append(targetLen).toString());
            }
            int resizeLen = len > 0x3FFFFFFB ? 0x7FFFFFF7 : targetLen;
            Object[] buffer2 = new Object[resizeLen];
            System.arraycopy(this.buffer, 0, buffer2, 0, len);
            this.buffer = buffer2;
            return;
        }
    }

    public ArrayStack(Object[] buffer, int index) {
        this.buffer = buffer;
        this.index = index;
    }

    public ArrayStack(int initBound) {
        this(new Object[initBound], 0);
    }

    public ArrayStack() {
        this(null, 0);
    }
}

