/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.file;

import cats.ApplicativeError;
import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.package;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.CollectionCompat$;
import fs2.io.CollectionCompat$JIteratorOps$;
import fs2.io.CollectionCompat$SetOps$;
import fs2.io.file.BasicFileAttributes;
import fs2.io.file.CopyFlag;
import fs2.io.file.CopyFlags;
import fs2.io.file.FileHandle;
import fs2.io.file.FileHandle$;
import fs2.io.file.FileKey;
import fs2.io.file.Files;
import fs2.io.file.FilesCompanionPlatform$AsyncFiles$WalkEntry$;
import fs2.io.file.FilesCompanionPlatform$NioFileKey$;
import fs2.io.file.Flag;
import fs2.io.file.Flags;
import fs2.io.file.Path;
import fs2.io.file.Path$;
import fs2.io.file.PathInfo;
import fs2.io.file.PathInfo$;
import fs2.io.file.Permissions;
import fs2.io.file.PosixFileAttributes;
import fs2.io.file.PosixPermissions;
import fs2.io.file.PosixPermissions$;
import fs2.io.file.WalkOptions;
import fs2.io.file.Watcher;
import fs2.io.file.Watcher$;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.Principal;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;
import scala.util.control.NonFatal$;

public interface FilesCompanionPlatform {
    public static Files forAsync$(FilesCompanionPlatform $this, Async evidence$1) {
        return $this.forAsync(evidence$1);
    }

    default public <F> Files<F> forAsync(Async<F> evidence$1) {
        return new AsyncFiles<F>(this, evidence$1);
    }

    public static FilesCompanionPlatform$NioFileKey$ fs2$io$file$FilesCompanionPlatform$$NioFileKey$(FilesCompanionPlatform $this) {
        return $this.fs2$io$file$FilesCompanionPlatform$$NioFileKey();
    }

    default public FilesCompanionPlatform$NioFileKey$ fs2$io$file$FilesCompanionPlatform$$NioFileKey() {
        return new FilesCompanionPlatform$NioFileKey$(this);
    }

    private static void copy$$anonfun$1(Path source$1, Path target$1, CopyFlags flags$1) {
        java.nio.file.Files.copy(source$1.toNioPath(), target$1.toNioPath(), (CopyOption[])Arrays$.MODULE$.seqToArray((Seq)flags$1.value().map((Function1 & Serializable)_$4 -> _$4 == null ? null : ((CopyFlag)_$4).option()), CopyOption.class));
    }

    public static /* bridge */ /* synthetic */ Object fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$copy$$anonfun$adapted$1(Path source$3, Path target$4, CopyFlags flags$5) {
        FilesCompanionPlatform.copy$$anonfun$1(source$3, target$4, flags$5);
        return BoxedUnit.UNIT;
    }

    private static void createDirectory$$anonfun$1(Path path$1, Option permissions$1) {
        java.nio.file.Files.createDirectory(path$1.toNioPath(), (FileAttribute[])Arrays$.MODULE$.seqToArray(Option$.MODULE$.option2Iterable(permissions$1.map((Function1 & Serializable)_$5 -> _$5.toNioFileAttribute())).toSeq(), FileAttribute.class));
    }

    public static /* bridge */ /* synthetic */ Object fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createDirectory$$anonfun$adapted$1(Path path$29, Option permissions$10) {
        FilesCompanionPlatform.createDirectory$$anonfun$1(path$29, permissions$10);
        return BoxedUnit.UNIT;
    }

    private static void createDirectories$$anonfun$1(Path path$2, Option permissions$2) {
        java.nio.file.Files.createDirectories(path$2.toNioPath(), (FileAttribute[])Arrays$.MODULE$.seqToArray(Option$.MODULE$.option2Iterable(permissions$2.map((Function1 & Serializable)_$6 -> _$6.toNioFileAttribute())).toSeq(), FileAttribute.class));
    }

    public static /* bridge */ /* synthetic */ Object fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createDirectories$$anonfun$adapted$1(Path path$30, Option permissions$11) {
        FilesCompanionPlatform.createDirectories$$anonfun$1(path$30, permissions$11);
        return BoxedUnit.UNIT;
    }

    private static void createFile$$anonfun$1(Path path$3, Option permissions$3) {
        java.nio.file.Files.createFile(path$3.toNioPath(), (FileAttribute[])Arrays$.MODULE$.seqToArray(Option$.MODULE$.option2Iterable(permissions$3.map((Function1 & Serializable)_$7 -> _$7.toNioFileAttribute())).toSeq(), FileAttribute.class));
    }

    public static /* bridge */ /* synthetic */ Object fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createFile$$anonfun$adapted$1(Path path$31, Option permissions$12) {
        FilesCompanionPlatform.createFile$$anonfun$1(path$31, permissions$12);
        return BoxedUnit.UNIT;
    }

    private static void createSymbolicLink$$anonfun$1(Path link$1, Path target$2, Option permissions$4) {
        java.nio.file.Files.createSymbolicLink(link$1.toNioPath(), target$2.toNioPath(), (FileAttribute[])Arrays$.MODULE$.seqToArray(Option$.MODULE$.option2Iterable(permissions$4.map((Function1 & Serializable)_$8 -> _$8.toNioFileAttribute())).toSeq(), FileAttribute.class));
    }

    public static /* bridge */ /* synthetic */ Object fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createSymbolicLink$$anonfun$adapted$1(Path link$3, Path target$5, Option permissions$13) {
        FilesCompanionPlatform.createSymbolicLink$$anonfun$1(link$3, target$5, permissions$13);
        return BoxedUnit.UNIT;
    }

    private static void createLink$$anonfun$1(Path link$2, Path existing$1) {
        java.nio.file.Files.createLink(link$2.toNioPath(), existing$1.toNioPath());
    }

    public static /* bridge */ /* synthetic */ Object fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createLink$$anonfun$adapted$1(Path link$4, Path existing$2) {
        FilesCompanionPlatform.createLink$$anonfun$1(link$4, existing$2);
        return BoxedUnit.UNIT;
    }

    public static java.nio.file.Path fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createTempFile$$anonfun$1(Path dir$1, String prefix$1, String suffix$1, Option permissions$5) {
        return java.nio.file.Files.createTempFile(dir$1.toNioPath(), prefix$1, suffix$1, (FileAttribute[])Arrays$.MODULE$.seqToArray(Option$.MODULE$.option2Iterable(permissions$5.map((Function1 & Serializable)_$9 -> _$9.toNioFileAttribute())).toSeq(), FileAttribute.class));
    }

    public static java.nio.file.Path fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createTempFile$$anonfun$2(String prefix$2, String suffix$2, Option permissions$6) {
        return java.nio.file.Files.createTempFile(prefix$2, suffix$2, (FileAttribute[])Arrays$.MODULE$.seqToArray(Option$.MODULE$.option2Iterable(permissions$6.map((Function1 & Serializable)_$10 -> _$10.toNioFileAttribute())).toSeq(), FileAttribute.class));
    }

    public static /* synthetic */ Path fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createTempFile$$anonfun$3(java.nio.file.Path path) {
        return Path$.MODULE$.fromNioPath(path);
    }

    public static java.nio.file.Path fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createTempDirectory$$anonfun$1(Path dir$2, String prefix$3, Option permissions$7) {
        return java.nio.file.Files.createTempDirectory(dir$2.toNioPath(), prefix$3, (FileAttribute[])Arrays$.MODULE$.seqToArray(Option$.MODULE$.option2Iterable(permissions$7.map((Function1 & Serializable)_$11 -> _$11.toNioFileAttribute())).toSeq(), FileAttribute.class));
    }

    public static java.nio.file.Path fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createTempDirectory$$anonfun$2(String prefix$4, Option permissions$8) {
        return java.nio.file.Files.createTempDirectory(prefix$4, (FileAttribute[])Arrays$.MODULE$.seqToArray(Option$.MODULE$.option2Iterable(permissions$8.map((Function1 & Serializable)_$12 -> _$12.toNioFileAttribute())).toSeq(), FileAttribute.class));
    }

    public static /* synthetic */ Path fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createTempDirectory$$anonfun$3(java.nio.file.Path path) {
        return Path$.MODULE$.fromNioPath(path);
    }

    public static Path fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$currentWorkingDirectory$$anonfun$1() {
        return Path$.MODULE$.apply((String)Option$.MODULE$.apply((Object)System.getProperty("user.dir")).get());
    }

    public static Path fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$userHome$$anonfun$1() {
        return Path$.MODULE$.apply((String)Option$.MODULE$.apply((Object)System.getProperty("user.home")).get());
    }

    private static void delete$$anonfun$1(Path path$4) {
        java.nio.file.Files.delete(path$4.toNioPath());
    }

    public static /* bridge */ /* synthetic */ Object fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$delete$$anonfun$adapted$1(Path path$32) {
        FilesCompanionPlatform.delete$$anonfun$1(path$32);
        return BoxedUnit.UNIT;
    }

    public static boolean fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$deleteIfExists$$anonfun$1(Path path$5) {
        return java.nio.file.Files.deleteIfExists(path$5.toNioPath());
    }

    private static void deleteRecursively$$anonfun$1(Path path$6, boolean followLinks$1) {
        Set set = CollectionCompat$.MODULE$.SetOps(followLinks$1 ? (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FileVisitOption[]{FileVisitOption.FOLLOW_LINKS})) : Predef$.MODULE$.Set().empty());
        java.nio.file.Files.walkFileTree(path$6.toNioPath(), CollectionCompat$SetOps$.MODULE$.asJava$extension(set), Integer.MAX_VALUE, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

            public FileVisitResult visitFile(java.nio.file.Path path, java.nio.file.attribute.BasicFileAttributes attrs) {
                java.nio.file.Files.deleteIfExists(path);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(java.nio.file.Path path, IOException e) {
                java.nio.file.Files.deleteIfExists(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static /* bridge */ /* synthetic */ Object fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$deleteRecursively$$anonfun$adapted$1(Path path$33, boolean followLinks$9) {
        FilesCompanionPlatform.deleteRecursively$$anonfun$1(path$33, followLinks$9);
        return BoxedUnit.UNIT;
    }

    public static boolean fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$exists$$anonfun$1(Path path$7, boolean followLinks$2) {
        return java.nio.file.Files.exists(path$7.toNioPath(), (LinkOption[])Arrays$.MODULE$.seqToArray((Seq)(followLinks$2 ? scala.package$.MODULE$.Nil() : (Seq)((SeqOps)new .colon.colon((Object)LinkOption.NOFOLLOW_LINKS, (List)Nil$.MODULE$))), LinkOption.class));
    }

    public static FiniteDuration fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$getLastModifiedTime$$anonfun$1(Path path$10) {
        return new package.DurationLong(package$.MODULE$.DurationLong(java.nio.file.Files.getLastModifiedTime(path$10.toNioPath(), new LinkOption[0]).toMillis())).millis();
    }

    public static PosixPermissions fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$getPosixPermissions$$anonfun$1(Path path$11, boolean followLinks$5) {
        return (PosixPermissions)PosixPermissions$.MODULE$.fromString(PosixFilePermissions.toString(java.nio.file.Files.getPosixFilePermissions(path$11.toNioPath(), (LinkOption[])Arrays$.MODULE$.seqToArray((Seq)(followLinks$5 ? scala.package$.MODULE$.Nil() : (Seq)((SeqOps)new .colon.colon((Object)LinkOption.NOFOLLOW_LINKS, (List)Nil$.MODULE$))), LinkOption.class)))).get();
    }

    public static boolean fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$isDirectory$$anonfun$1(Path path$12, boolean followLinks$6) {
        return java.nio.file.Files.isDirectory(path$12.toNioPath(), (LinkOption[])Arrays$.MODULE$.seqToArray((Seq)(followLinks$6 ? scala.package$.MODULE$.Nil() : (Seq)((SeqOps)new .colon.colon((Object)LinkOption.NOFOLLOW_LINKS, (List)Nil$.MODULE$))), LinkOption.class));
    }

    public static boolean fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$isExecutable$$anonfun$1(Path path$13) {
        return java.nio.file.Files.isExecutable(path$13.toNioPath());
    }

    public static boolean fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$isHidden$$anonfun$1(Path path$14) {
        return java.nio.file.Files.isHidden(path$14.toNioPath());
    }

    public static boolean fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$isReadable$$anonfun$1(Path path$15) {
        return java.nio.file.Files.isReadable(path$15.toNioPath());
    }

    public static boolean fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$isRegularFile$$anonfun$1(Path path$16, boolean followLinks$7) {
        return java.nio.file.Files.isRegularFile(path$16.toNioPath(), (LinkOption[])Arrays$.MODULE$.seqToArray((Seq)(followLinks$7 ? scala.package$.MODULE$.Nil() : (Seq)((SeqOps)new .colon.colon((Object)LinkOption.NOFOLLOW_LINKS, (List)Nil$.MODULE$))), LinkOption.class));
    }

    public static boolean fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$isSymbolicLink$$anonfun$1(Path path$17) {
        return java.nio.file.Files.isSymbolicLink(path$17.toNioPath());
    }

    public static boolean fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$isWritable$$anonfun$1(Path path$18) {
        return java.nio.file.Files.isWritable(path$18.toNioPath());
    }

    public static boolean fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$isSameFile$$anonfun$1(Path path1$1, Path path2$1) {
        return java.nio.file.Files.isSameFile(path1$1.toNioPath(), path2$1.toNioPath());
    }

    public static java.util.stream.Stream fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$list$$anonfun$1(Path path$19) {
        return java.nio.file.Files.list(path$19.toNioPath());
    }

    public static /* synthetic */ Iterator fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$list$$anonfun$2(java.util.stream.Stream _$13) {
        java.util.Iterator iterator = CollectionCompat$.MODULE$.JIteratorOps(_$13.iterator());
        return CollectionCompat$JIteratorOps$.MODULE$.asScala$extension(iterator);
    }

    public static /* synthetic */ Path fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$list$$anonfun$3(java.nio.file.Path path) {
        return Path$.MODULE$.fromNioPath(path);
    }

    public static DirectoryStream fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$list$$anonfun$4(Path path$20, String glob$1) {
        return java.nio.file.Files.newDirectoryStream(path$20.toNioPath(), glob$1);
    }

    public static /* synthetic */ Iterator fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$list$$anonfun$5(DirectoryStream _$14) {
        java.util.Iterator iterator = CollectionCompat$.MODULE$.JIteratorOps(_$14.iterator());
        return CollectionCompat$JIteratorOps$.MODULE$.asScala$extension(iterator);
    }

    public static /* synthetic */ Path fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$list$$anonfun$6(java.nio.file.Path path) {
        return Path$.MODULE$.fromNioPath(path);
    }

    private static void move$$anonfun$1(Path source$2, Path target$3, CopyFlags flags$2) {
        java.nio.file.Files.move(source$2.toNioPath(), target$3.toNioPath(), (CopyOption[])Arrays$.MODULE$.seqToArray((Seq)flags$2.value().map((Function1 & Serializable)_$15 -> _$15 == null ? null : ((CopyFlag)_$15).option()), CopyOption.class));
    }

    public static /* bridge */ /* synthetic */ Object fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$move$$anonfun$adapted$1(Path source$4, Path target$6, CopyFlags flags$6) {
        FilesCompanionPlatform.move$$anonfun$1(source$4, target$6, flags$6);
        return BoxedUnit.UNIT;
    }

    public static FileChannel fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$open$$anonfun$1(Path path$21, Flags flags$3) {
        return FileChannel.open(path$21.toNioPath(), (OpenOption[])Arrays$.MODULE$.seqToArray((Seq)flags$3.value().map((Function1 & Serializable)_$16 -> _$16 == null ? null : ((Flag)_$16).option()), OpenOption.class));
    }

    public static /* bridge */ /* synthetic */ OpenOption fs2$io$file$FilesCompanionPlatform$$anon$2$$_$applyOrElse$$anonfun$1$$anonfun$adapted$1(Object _$17) {
        return _$17 == null ? null : ((Flag)_$17).option();
    }

    public static Throwable fs2$io$file$FilesCompanionPlatform$$anon$2$$_$applyOrElse$$anonfun$2(UnsupportedOperationException unsupportedOperationException$1) {
        return unsupportedOperationException$1;
    }

    private static void openFileChannel$$anonfun$1$$anonfun$1(FileChannel ch$1) {
        ch$1.close();
    }

    public static /* bridge */ /* synthetic */ Object fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$openFileChannel$$anonfun$1$$anonfun$adapted$1(FileChannel ch$3) {
        FilesCompanionPlatform.openFileChannel$$anonfun$1$$anonfun$1(ch$3);
        return BoxedUnit.UNIT;
    }

    private static void openSeekableByteChannel$$anonfun$1$$anonfun$1(SeekableByteChannel ch$2) {
        ch$2.close();
    }

    public static /* bridge */ /* synthetic */ Object fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$openSeekableByteChannel$$anonfun$1$$anonfun$adapted$1(SeekableByteChannel ch$4) {
        FilesCompanionPlatform.openSeekableByteChannel$$anonfun$1$$anonfun$1(ch$4);
        return BoxedUnit.UNIT;
    }

    public static Path fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$realPath$$anonfun$1(Path path$23) {
        return Path$.MODULE$.fromNioPath(path$23.toNioPath().toRealPath(new LinkOption[0]));
    }

    private static FileTime toFileTime$1(Option opt) {
        return (FileTime)opt.map((Function1 & Serializable)d -> FileTime.fromMillis(d.toMillis())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private static void setFileTimes$$anonfun$1(Path path$24, boolean followLinks$8, Option lastModified$1, Option lastAccess$1, Option create$1) {
        BasicFileAttributeView view = java.nio.file.Files.getFileAttributeView(path$24.toNioPath(), BasicFileAttributeView.class, (LinkOption[])Arrays$.MODULE$.seqToArray((Seq)(followLinks$8 ? scala.package$.MODULE$.Nil() : (Seq)((SeqOps)new .colon.colon((Object)LinkOption.NOFOLLOW_LINKS, (List)Nil$.MODULE$))), LinkOption.class));
        view.setTimes(FilesCompanionPlatform.toFileTime$1(lastModified$1), FilesCompanionPlatform.toFileTime$1(lastAccess$1), FilesCompanionPlatform.toFileTime$1(create$1));
    }

    public static /* bridge */ /* synthetic */ Object fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$setFileTimes$$anonfun$adapted$1(Path path$35, boolean followLinks$10, Option lastModified$2, Option lastAccess$2, Option create$2) {
        FilesCompanionPlatform.setFileTimes$$anonfun$1(path$35, followLinks$10, lastModified$2, lastAccess$2, create$2);
        return BoxedUnit.UNIT;
    }

    public static java.nio.file.Path fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$setLastModifiedTime$$anonfun$1(Path path$25, FiniteDuration timestamp$1) {
        return java.nio.file.Files.setLastModifiedTime(path$25.toNioPath(), FileTime.fromMillis(timestamp$1.toMillis()));
    }

    public static java.nio.file.Path fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$setPosixPermissions$$anonfun$1(Path path$26, PosixPermissions permissions$9) {
        return java.nio.file.Files.setPosixFilePermissions(path$26.toNioPath(), PosixFilePermissions.fromString(permissions$9.toString()));
    }

    public static long fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$size$$anonfun$1(Path path$27) {
        return java.nio.file.Files.size(path$27.toNioPath());
    }

    public static /* synthetic */ boolean fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$_$_$$anonfun$3(Option fileKey$1, AsyncFiles.WalkEntry entry$1, Either x$1) {
        Either either = x$1;
        if (either instanceof Right) {
            NioFileKey ancestorKey = (NioFileKey)((Right)either).value();
            return fileKey$1.contains((Object)ancestorKey);
        }
        if (either instanceof Left) {
            Path ancestorPath = (Path)((Left)either).value();
            return java.nio.file.Files.isSameFile(entry$1.path().toNioPath(), ancestorPath.toNioPath());
        }
        throw new MatchError((Object)either);
    }

    public static Path fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$_$$anonfun$6(AsyncFiles.WalkEntry entry$3) {
        return entry$3.path();
    }

    public static /* synthetic */ Object fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$watch$$anonfun$1(Path path$28, Seq types$1, Seq modifiers$1, Watcher _$20) {
        return _$20.watch(path$28, (Seq<Watcher.EventType>)types$1, (Seq<WatchEvent.Modifier>)modifiers$1);
    }

    public static /* synthetic */ Stream fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$watch$$anonfun$2(FiniteDuration pollTimeout$1, Watcher _$21) {
        return _$21.events(pollTimeout$1);
    }

    public final class AsyncFiles<F>
    extends Files.UnsealedFiles<F> {
        private final Async F;
        public final FilesCompanionPlatform$AsyncFiles$WalkEntry$ WalkEntry$lzy1;
        private final /* synthetic */ FilesCompanionPlatform $outer;

        public AsyncFiles(FilesCompanionPlatform $outer, Async<F> F) {
            this.F = F;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(F);
            this.WalkEntry$lzy1 = new FilesCompanionPlatform$AsyncFiles$WalkEntry$(this);
            int pathStreamChunkSize = 16;
        }

        @Override
        public Async<F> F() {
            return this.F;
        }

        @Override
        public F copy(Path source, Path target, CopyFlags flags) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$copy$$anonfun$adapted$1(source, target, flags));
        }

        @Override
        public F createDirectory(Path path, Option<Permissions> permissions) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createDirectory$$anonfun$adapted$1(path, permissions));
        }

        @Override
        public F createDirectories(Path path, Option<Permissions> permissions) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createDirectories$$anonfun$adapted$1(path, permissions));
        }

        @Override
        public F createFile(Path path, Option<Permissions> permissions) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createFile$$anonfun$adapted$1(path, permissions));
        }

        @Override
        public F createSymbolicLink(Path link, Path target, Option<Permissions> permissions) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createSymbolicLink$$anonfun$adapted$1(link, target, permissions));
        }

        @Override
        public F createLink(Path link, Path existing) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createLink$$anonfun$adapted$1(link, existing));
        }

        @Override
        public F createTempFile(Option<Path> dir, String prefix, String suffix, Option<Permissions> permissions) {
            Object object;
            Option<Path> option = dir;
            if (option instanceof Some) {
                Path dir2 = (Path)((Some)option).value();
                object = Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createTempFile$$anonfun$1(dir2, prefix, suffix, permissions));
            } else if (None$.MODULE$.equals(option)) {
                object = Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createTempFile$$anonfun$2(prefix, suffix, permissions));
            } else {
                throw new MatchError(option);
            }
            return (F)package.all$.MODULE$.toFunctorOps(object, this.F()).map(FilesCompanionPlatform::fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createTempFile$$anonfun$3);
        }

        @Override
        public F createTempDirectory(Option<Path> dir, String prefix, Option<Permissions> permissions) {
            Object object;
            Option<Path> option = dir;
            if (option instanceof Some) {
                Path dir2 = (Path)((Some)option).value();
                object = Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createTempDirectory$$anonfun$1(dir2, prefix, permissions));
            } else if (None$.MODULE$.equals(option)) {
                object = Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createTempDirectory$$anonfun$2(prefix, permissions));
            } else {
                throw new MatchError(option);
            }
            return (F)package.all$.MODULE$.toFunctorOps(object, this.F()).map(FilesCompanionPlatform::fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$createTempDirectory$$anonfun$3);
        }

        @Override
        public F currentWorkingDirectory() {
            return (F)Sync$.MODULE$.apply(this.F()).delay(FilesCompanionPlatform::fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$currentWorkingDirectory$$anonfun$1);
        }

        @Override
        public F userHome() {
            return (F)Sync$.MODULE$.apply(this.F()).delay(FilesCompanionPlatform::fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$userHome$$anonfun$1);
        }

        @Override
        public F delete(Path path) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$delete$$anonfun$adapted$1(path));
        }

        @Override
        public F deleteIfExists(Path path) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$deleteIfExists$$anonfun$1(path));
        }

        @Override
        public F deleteRecursively(Path path, boolean followLinks) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$deleteRecursively$$anonfun$adapted$1(path, followLinks));
        }

        public boolean deleteRecursively$default$2() {
            return false;
        }

        @Override
        public F exists(Path path, boolean followLinks) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$exists$$anonfun$1(path, followLinks));
        }

        @Override
        public F getBasicFileAttributes(Path path, boolean followLinks) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> this.getBasicFileAttributes$$anonfun$1(path, followLinks));
        }

        @Override
        public F getPosixFileAttributes(Path path, boolean followLinks) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> this.getPosixFileAttributes$$anonfun$1(path, followLinks));
        }

        @Override
        public F getLastModifiedTime(Path path, boolean followLinks) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$getLastModifiedTime$$anonfun$1(path));
        }

        @Override
        public F getPosixPermissions(Path path, boolean followLinks) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$getPosixPermissions$$anonfun$1(path, followLinks));
        }

        @Override
        public F isDirectory(Path path, boolean followLinks) {
            return (F)Sync$.MODULE$.apply(this.F()).delay(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$isDirectory$$anonfun$1(path, followLinks));
        }

        @Override
        public F isExecutable(Path path) {
            return (F)Sync$.MODULE$.apply(this.F()).delay(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$isExecutable$$anonfun$1(path));
        }

        @Override
        public F isHidden(Path path) {
            return (F)Sync$.MODULE$.apply(this.F()).delay(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$isHidden$$anonfun$1(path));
        }

        @Override
        public F isReadable(Path path) {
            return (F)Sync$.MODULE$.apply(this.F()).delay(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$isReadable$$anonfun$1(path));
        }

        @Override
        public F isRegularFile(Path path, boolean followLinks) {
            return (F)Sync$.MODULE$.apply(this.F()).delay(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$isRegularFile$$anonfun$1(path, followLinks));
        }

        @Override
        public F isSymbolicLink(Path path) {
            return (F)Sync$.MODULE$.apply(this.F()).delay(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$isSymbolicLink$$anonfun$1(path));
        }

        @Override
        public F isWritable(Path path) {
            return (F)Sync$.MODULE$.apply(this.F()).delay(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$isWritable$$anonfun$1(path));
        }

        @Override
        public F isSameFile(Path path1, Path path2) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$isSameFile$$anonfun$1(path1, path2));
        }

        @Override
        public String lineSeparator() {
            return System.lineSeparator();
        }

        @Override
        public Stream<F, Path> list(Path path) {
            return this._runJavaCollectionResource(Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$list$$anonfun$1(path)), FilesCompanionPlatform::fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$list$$anonfun$2).map(FilesCompanionPlatform::fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$list$$anonfun$3);
        }

        @Override
        public Stream<F, Path> list(Path path, String glob) {
            return this._runJavaCollectionResource(Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$list$$anonfun$4(path, glob)), FilesCompanionPlatform::fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$list$$anonfun$5).map(FilesCompanionPlatform::fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$list$$anonfun$6);
        }

        @Override
        public F move(Path source, Path target, CopyFlags flags) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$move$$anonfun$adapted$1(source, target, flags));
        }

        @Override
        public Resource<F, FileHandle<F>> open(Path path, Flags flags) {
            Resource resource = (Resource)package.all$.MODULE$.catsSyntaxApplicativeError(this.openFileChannel(Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$open$$anonfun$1(path, flags))), (ApplicativeError)Resource$.MODULE$.catsEffectAsyncForResource(this.F()));
            return (Resource)ApplicativeErrorOps$.MODULE$.recoverWith$extension((Object)resource, (PartialFunction)new Serializable(path, flags, this){
                private final Path path$22;
                private final Flags flags$4;
                private final /* synthetic */ AsyncFiles $outer;
                {
                    this.path$22 = path$34;
                    this.flags$4 = flags$7;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    if (throwable instanceof UnsupportedOperationException) {
                        UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable instanceof UnsupportedOperationException) {
                        UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)throwable;
                        return this.$outer.openSeekableByteChannel(Sync$.MODULE$.apply(this.$outer.F()).blocking(this::applyOrElse$$anonfun$1), (Function0<Throwable>)((Function0 & Serializable)() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$$anon$2$$_$applyOrElse$$anonfun$2(unsupportedOperationException)));
                    }
                    return function1.apply((Object)x);
                }

                private final SeekableByteChannel applyOrElse$$anonfun$1() {
                    return java.nio.file.Files.newByteChannel(this.path$22.toNioPath(), (OpenOption[])Arrays$.MODULE$.seqToArray((Seq)this.flags$4.value().map(FilesCompanionPlatform::fs2$io$file$FilesCompanionPlatform$$anon$2$$_$applyOrElse$$anonfun$1$$anonfun$adapted$1), OpenOption.class));
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(), fs2$io$file$FilesCompanionPlatform$$anon$2$$_$applyOrElse$$anonfun$2(java.lang.UnsupportedOperationException ), fs2$io$file$FilesCompanionPlatform$$anon$2$$_$applyOrElse$$anonfun$1$$anonfun$adapted$1(java.lang.Object )}, serializedLambda);
                }
            }, (ApplicativeError)Resource$.MODULE$.catsEffectAsyncForResource(this.F()));
        }

        @Override
        public Resource<F, FileHandle<F>> openFileChannel(F channel) {
            return Resource$.MODULE$.make(channel, (Function1 & Serializable)ch -> Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$openFileChannel$$anonfun$1$$anonfun$adapted$1(ch)), this.F()).map((Function1 & Serializable)ch -> FileHandle$.MODULE$.make((FileChannel)ch, (Sync)this.F()));
        }

        @Override
        public Resource<F, FileHandle<F>> openSeekableByteChannel(F channel, Function0<Throwable> unsupportedOperationException) {
            return Resource$.MODULE$.make(channel, (Function1 & Serializable)ch -> Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$openSeekableByteChannel$$anonfun$1$$anonfun$adapted$1(ch)), this.F()).map((Function1 & Serializable)ch -> FileHandle$.MODULE$.makeFromSeekableByteChannel((SeekableByteChannel)ch, (Function0)unsupportedOperationException, (Sync)this.F()));
        }

        @Override
        public F realPath(Path path) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$realPath$$anonfun$1(path));
        }

        @Override
        public F setFileTimes(Path path, Option<FiniteDuration> lastModified, Option<FiniteDuration> lastAccess, Option<FiniteDuration> create, boolean followLinks) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$setFileTimes$$anonfun$adapted$1(path, followLinks, lastModified, lastAccess, create));
        }

        public F setLastModifiedTime(Path path, FiniteDuration timestamp) {
            return (F)package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$setLastModifiedTime$$anonfun$1(path, timestamp)), this.F()).void();
        }

        @Override
        public F setPosixPermissions(Path path, PosixPermissions permissions) {
            return (F)package.all$.MODULE$.toFunctorOps(Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$setPosixPermissions$$anonfun$1(path, permissions)), this.F()).void();
        }

        @Override
        public F size(Path path) {
            return (F)Sync$.MODULE$.apply(this.F()).blocking(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$size$$anonfun$1(path));
        }

        @Override
        public <C extends AutoCloseable> Stream<F, java.nio.file.Path> _runJavaCollectionResource(F javaCollection, Function1<C, Iterator<java.nio.file.Path>> collectionIterator) {
            return Stream$.MODULE$.resource(Resource$.MODULE$.fromAutoCloseable(javaCollection, this.F()), this.F()).flatMap((Function1 & Serializable)ds -> {
                boolean bl = Stream$.MODULE$.fromBlockingIterator();
                return Stream.PartiallyAppliedFromBlockingIterator$.MODULE$.apply$extension(bl, (Iterator)collectionIterator.apply(ds), 16, this.F());
            }, NotGiven$.MODULE$.value());
        }

        private final FilesCompanionPlatform$AsyncFiles$WalkEntry$ WalkEntry() {
            return this.WalkEntry$lzy1;
        }

        @Override
        public Stream<F, PathInfo> walkWithAttributes(Path start, WalkOptions options) {
            return Stream$.MODULE$.eval(Sync$.MODULE$.apply(this.F()).interruptible(() -> this.walkWithAttributes$$anonfun$1(start))).mask().flatMap((Function1 & Serializable)w -> this.loop$1(options, Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new WalkEntry[]{w}))), NotGiven$.MODULE$.value());
        }

        public Resource<F, Watcher<F>> createWatcher() {
            return Watcher$.MODULE$.default(this, this.F());
        }

        @Override
        public Stream<F, Watcher.Event> watch(Path path, Seq<Watcher.EventType> types, Seq<WatchEvent.Modifier> modifiers, FiniteDuration pollTimeout) {
            return Stream$.MODULE$.resource(this.createWatcher(), this.F()).evalTap(arg_0 -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$watch$$anonfun$1(path, types, modifiers, arg_0)).flatMap(arg_0 -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$watch$$anonfun$2(pollTimeout, arg_0), NotGiven$.MODULE$.value());
        }

        public final /* synthetic */ FilesCompanionPlatform fs2$io$file$FilesCompanionPlatform$AsyncFiles$$$outer() {
            return this.$outer;
        }

        private final BasicFileAttributes getBasicFileAttributes$$anonfun$1(Path path$8, boolean followLinks$3) {
            return new DelegatingBasicFileAttributes(this.$outer, java.nio.file.Files.readAttributes(path$8.toNioPath(), java.nio.file.attribute.BasicFileAttributes.class, (LinkOption[])Arrays$.MODULE$.seqToArray((Seq)(followLinks$3 ? scala.package$.MODULE$.Nil() : (Seq)((SeqOps)new .colon.colon((Object)LinkOption.NOFOLLOW_LINKS, (List)Nil$.MODULE$))), LinkOption.class)));
        }

        private final PosixFileAttributes getPosixFileAttributes$$anonfun$1(Path path$9, boolean followLinks$4) {
            return new DelegatingPosixFileAttributes(this.$outer, java.nio.file.Files.readAttributes(path$9.toNioPath(), java.nio.file.attribute.PosixFileAttributes.class, (LinkOption[])Arrays$.MODULE$.seqToArray((Seq)(followLinks$4 ? scala.package$.MODULE$.Nil() : (Seq)((SeqOps)new .colon.colon((Object)LinkOption.NOFOLLOW_LINKS, (List)Nil$.MODULE$))), LinkOption.class)));
        }

        private final Stream $anonfun$1$$anonfun$1(ObjectRef toWalk$1, WalkOptions options$3) {
            if (((Queue)toWalk$1.elem).isEmpty()) {
                return Stream$.MODULE$.empty();
            }
            return this.loop$1(options$3, (Queue)toWalk$1.elem);
        }

        private final Stream $anonfun$1(Queue toWalk0$1, WalkOptions options$1) {
            Vector acc = scala.package$.MODULE$.Vector().empty();
            ObjectRef toWalk = ObjectRef.create((Object)toWalk0$1);
            while (acc.size() < options$1.chunkSize() && ((Queue)toWalk.elem).nonEmpty() && !Thread.interrupted()) {
                Path dir;
                Path path;
                WalkEntry entry = (WalkEntry)((Queue)toWalk.elem).head();
                toWalk.elem = (Queue)((Queue)toWalk.elem).drop(1);
                acc = (Vector)acc.$colon$plus((Object)PathInfo$.MODULE$.apply(entry.path(), new DelegatingBasicFileAttributes(this.$outer, entry.attr())));
                if (entry.depth() >= options$1.maxDepth()) continue;
                if (entry.attr().isDirectory()) {
                    path = entry.path();
                } else if (options$1.followLinks() && entry.attr().isSymbolicLink()) {
                    try {
                        java.nio.file.attribute.BasicFileAttributes targetAttr = java.nio.file.Files.readAttributes(entry.path().toNioPath(), java.nio.file.attribute.BasicFileAttributes.class, new LinkOption[0]);
                        Option fileKey = Option$.MODULE$.apply(targetAttr.fileKey()).map((Function1 & Serializable)_$18 -> this.$outer.fs2$io$file$FilesCompanionPlatform$$NioFileKey().apply(_$18));
                        boolean isCycle = entry.ancestry().exists(arg_0 -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$_$_$$anonfun$3(fileKey, entry, arg_0));
                        if (isCycle) {
                            if (options$1.allowCycles()) {
                                path = null;
                            }
                            throw new FileSystemLoopException(entry.path().toString());
                        }
                        path = entry.path();
                    }
                    catch (FileSystemLoopException t) {
                        throw t;
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            throw throwable;
                        }
                        Throwable throwable3 = (Throwable)option.get();
                        path = null;
                    }
                } else {
                    path = null;
                }
                if ((dir = path) == null) continue;
                try (java.util.stream.Stream<java.nio.file.Path> listing = java.nio.file.Files.list(dir.toNioPath());){
                    java.util.Iterator iterator = CollectionCompat$.MODULE$.JIteratorOps(listing.iterator());
                    Iterator descendants = CollectionCompat$JIteratorOps$.MODULE$.asScala$extension(iterator).flatMap((Function1 & Serializable)p -> {
                        None$ none$;
                        try {
                            Either either = Option$.MODULE$.apply(entry.attr().fileKey()).map((Function1 & Serializable)_$19 -> this.$outer.fs2$io$file$FilesCompanionPlatform$$NioFileKey().apply(_$19)).toRight(() -> FilesCompanionPlatform.fs2$io$file$FilesCompanionPlatform$AsyncFiles$$_$_$$anonfun$6(entry));
                            none$ = Some$.MODULE$.apply((Object)this.WalkEntry().apply(Path$.MODULE$.fromNioPath((java.nio.file.Path)p), java.nio.file.Files.readAttributes(p, java.nio.file.attribute.BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS), entry.depth() + 1, (List<Either<Path, NioFileKey>>)entry.ancestry().$colon$colon((Object)either)));
                        }
                        catch (Throwable throwable) {
                            Option option;
                            Throwable throwable2 = throwable;
                            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                Throwable throwable3 = (Throwable)option.get();
                                none$ = None$.MODULE$;
                            }
                            throw throwable;
                        }
                        return none$;
                    });
                    toWalk.elem = (Queue)((IterableOps)Queue$.MODULE$.empty().$plus$plus((IterableOnce)descendants)).$plus$plus((IterableOnce)((Queue)toWalk.elem));
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable4 = throwable;
                    if (throwable4 != null && !(option = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                        Throwable throwable5 = (Throwable)option.get();
                        continue;
                    }
                    throw throwable;
                }
            }
            return Stream$.MODULE$.chunk(Chunk$.MODULE$.from((Iterable)acc)).$plus$plus(() -> this.$anonfun$1$$anonfun$1(toWalk, options$1));
        }

        private final Stream loop$1(WalkOptions options$2, Queue toWalk0) {
            Object partialWalk = Sync$.MODULE$.apply(this.F()).interruptible(() -> this.$anonfun$1(toWalk0, options$2));
            return Stream$.MODULE$.eval(partialWalk).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        private final WalkEntry walkWithAttributes$$anonfun$1(Path start$1) {
            return this.WalkEntry().apply(start$1, java.nio.file.Files.readAttributes(start$1.toNioPath(), java.nio.file.attribute.BasicFileAttributes.class, new LinkOption[0]), 0, (List<Either<Path, NioFileKey>>)scala.package$.MODULE$.Nil());
        }

        public class WalkEntry
        implements Product,
        Serializable {
            private final Path path;
            private final java.nio.file.attribute.BasicFileAttributes attr;
            private final int depth;
            private final List ancestry;
            private final /* synthetic */ AsyncFiles $outer;

            public WalkEntry(AsyncFiles $outer, Path path, java.nio.file.attribute.BasicFileAttributes attr, int depth, List<Either<Path, NioFileKey>> ancestry) {
                this.path = path;
                this.attr = attr;
                this.depth = depth;
                this.ancestry = ancestry;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.attr()));
                n = Statics.mix((int)n, (int)this.depth());
                n = Statics.mix((int)n, (int)Statics.anyHash(this.ancestry()));
                return Statics.finalizeHash((int)n, (int)4);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof WalkEntry)) return false;
                if (((WalkEntry)object).fs2$io$file$FilesCompanionPlatform$AsyncFiles$WalkEntry$$$outer() != this.$outer) return false;
                WalkEntry walkEntry = (WalkEntry)object;
                if (this.depth() != walkEntry.depth()) return false;
                Path path = this.path();
                Path path2 = walkEntry.path();
                if (path == null) {
                    if (path2 != null) {
                        return false;
                    }
                } else if (!((Object)path).equals(path2)) return false;
                java.nio.file.attribute.BasicFileAttributes basicFileAttributes = this.attr();
                java.nio.file.attribute.BasicFileAttributes basicFileAttributes2 = walkEntry.attr();
                if (basicFileAttributes == null) {
                    if (basicFileAttributes2 != null) {
                        return false;
                    }
                } else if (!basicFileAttributes.equals(basicFileAttributes2)) return false;
                List<Either<Path, NioFileKey>> list = this.ancestry();
                List<Either<Path, NioFileKey>> list2 = walkEntry.ancestry();
                if (list == null) {
                    if (list2 != null) {
                        return false;
                    }
                } else if (!list.equals(list2)) return false;
                if (!walkEntry.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof WalkEntry;
            }

            public int productArity() {
                return 4;
            }

            public String productPrefix() {
                return "WalkEntry";
            }

            public Object productElement(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return this._1();
                    }
                    case 1: {
                        return this._2();
                    }
                    case 2: {
                        return BoxesRunTime.boxToInteger((int)this._3());
                    }
                    case 3: {
                        return this._4();
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                switch (n2) {
                    case 0: {
                        return "path";
                    }
                    case 1: {
                        return "attr";
                    }
                    case 2: {
                        return "depth";
                    }
                    case 3: {
                        return "ancestry";
                    }
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Path path() {
                return this.path;
            }

            public java.nio.file.attribute.BasicFileAttributes attr() {
                return this.attr;
            }

            public int depth() {
                return this.depth;
            }

            public List<Either<Path, NioFileKey>> ancestry() {
                return this.ancestry;
            }

            public WalkEntry copy(Path path, java.nio.file.attribute.BasicFileAttributes attr, int depth, List<Either<Path, NioFileKey>> ancestry) {
                return new WalkEntry(this.$outer, path, attr, depth, ancestry);
            }

            public Path copy$default$1() {
                return this.path();
            }

            public java.nio.file.attribute.BasicFileAttributes copy$default$2() {
                return this.attr();
            }

            public int copy$default$3() {
                return this.depth();
            }

            public List<Either<Path, NioFileKey>> copy$default$4() {
                return this.ancestry();
            }

            public Path _1() {
                return this.path();
            }

            public java.nio.file.attribute.BasicFileAttributes _2() {
                return this.attr();
            }

            public int _3() {
                return this.depth();
            }

            public List<Either<Path, NioFileKey>> _4() {
                return this.ancestry();
            }

            public final /* synthetic */ AsyncFiles fs2$io$file$FilesCompanionPlatform$AsyncFiles$WalkEntry$$$outer() {
                return this.$outer;
            }
        }
    }

    public class DelegatingBasicFileAttributes
    implements BasicFileAttributes,
    BasicFileAttributes.UnsealedBasicFileAttributes {
        private final java.nio.file.attribute.BasicFileAttributes attr;
        private final /* synthetic */ FilesCompanionPlatform $outer;

        public DelegatingBasicFileAttributes(FilesCompanionPlatform $outer, java.nio.file.attribute.BasicFileAttributes attr) {
            this.attr = attr;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public FiniteDuration creationTime() {
            return new package.DurationLong(package$.MODULE$.DurationLong(this.attr.creationTime().toMillis())).millis();
        }

        @Override
        public Option<FileKey> fileKey() {
            return Option$.MODULE$.apply(this.attr.fileKey()).map((Function1 & Serializable)_$22 -> this.$outer.fs2$io$file$FilesCompanionPlatform$$NioFileKey().apply(_$22));
        }

        @Override
        public boolean isDirectory() {
            return this.attr.isDirectory();
        }

        @Override
        public boolean isOther() {
            return this.attr.isOther();
        }

        @Override
        public boolean isRegularFile() {
            return this.attr.isRegularFile();
        }

        @Override
        public boolean isSymbolicLink() {
            return this.attr.isSymbolicLink();
        }

        @Override
        public FiniteDuration lastAccessTime() {
            return new package.DurationLong(package$.MODULE$.DurationLong(this.attr.lastAccessTime().toMillis())).millis();
        }

        @Override
        public FiniteDuration lastModifiedTime() {
            return new package.DurationLong(package$.MODULE$.DurationLong(this.attr.lastModifiedTime().toMillis())).millis();
        }

        @Override
        public long size() {
            return this.attr.size();
        }

        public final /* synthetic */ FilesCompanionPlatform fs2$io$file$FilesCompanionPlatform$DelegatingBasicFileAttributes$$$outer() {
            return this.$outer;
        }
    }

    public class DelegatingPosixFileAttributes
    extends DelegatingBasicFileAttributes
    implements PosixFileAttributes,
    PosixFileAttributes.UnsealedPosixFileAttributes,
    BasicFileAttributes {
        private final java.nio.file.attribute.PosixFileAttributes attr;
        private final /* synthetic */ FilesCompanionPlatform $outer;

        public DelegatingPosixFileAttributes(FilesCompanionPlatform $outer, java.nio.file.attribute.PosixFileAttributes attr) {
            this.attr = attr;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super($outer, attr);
        }

        @Override
        public /* synthetic */ boolean fs2$io$file$PosixFileAttributes$$super$equals(Object that) {
            return BasicFileAttributes.equals$(this, that);
        }

        @Override
        public /* synthetic */ int fs2$io$file$PosixFileAttributes$$super$hashCode() {
            return BasicFileAttributes.hashCode$(this);
        }

        public Principal owner() {
            return this.attr.owner();
        }

        public Principal group() {
            return this.attr.group();
        }

        @Override
        public PosixPermissions permissions() {
            return (PosixPermissions)PosixPermissions$.MODULE$.fromString(PosixFilePermissions.toString(this.attr.permissions())).get();
        }

        public final /* synthetic */ FilesCompanionPlatform fs2$io$file$FilesCompanionPlatform$DelegatingPosixFileAttributes$$$outer() {
            return this.$outer;
        }
    }

    public class NioFileKey
    implements FileKey,
    Product,
    Serializable {
        private final Object value;
        private final /* synthetic */ FilesCompanionPlatform $outer;

        public NioFileKey(FilesCompanionPlatform $outer, Object value) {
            this.value = value;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NioFileKey)) return false;
            if (((NioFileKey)object).fs2$io$file$FilesCompanionPlatform$NioFileKey$$$outer() != this.$outer) return false;
            NioFileKey nioFileKey = (NioFileKey)object;
            if (!BoxesRunTime.equals((Object)this.value(), (Object)nioFileKey.value())) return false;
            if (!nioFileKey.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NioFileKey;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "NioFileKey";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Object value() {
            return this.value;
        }

        public NioFileKey copy(Object value) {
            return new NioFileKey(this.$outer, value);
        }

        public Object copy$default$1() {
            return this.value();
        }

        public Object _1() {
            return this.value();
        }

        public final /* synthetic */ FilesCompanionPlatform fs2$io$file$FilesCompanionPlatform$NioFileKey$$$outer() {
            return this.$outer;
        }
    }
}

