/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.net;

import com.comcast.ip4s.IpAddress;
import com.comcast.ip4s.SocketAddress;
import com.comcast.ip4s.SocketAddress$;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.io.net.AsynchronousDatagramSocketGroup;
import fs2.io.net.AsynchronousDatagramSocketGroup$;
import fs2.io.net.AsynchronousDatagramSocketGroup$$anon$1$Attachment$;
import fs2.io.net.Datagram;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class AsynchronousDatagramSocketGroup$ {
    public static final AsynchronousDatagramSocketGroup$ MODULE$ = new AsynchronousDatagramSocketGroup$();

    public AsynchronousDatagramSocketGroup unsafe(ThreadFactory threadFactory) {
        return new AsynchronousDatagramSocketGroup(threadFactory){
            private volatile AsynchronousDatagramSocketGroup$$anon$1$Attachment$ Attachment$module;
            private final AtomicLong ids;
            private final Selector fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$selector;
            private final Object closeLock;
            private volatile boolean fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$closed;
            private final ConcurrentLinkedQueue<Function0<BoxedUnit>> pendingThunks;
            private final ByteBuffer readBuffer;
            private final Thread selectorThread;

            private AsynchronousDatagramSocketGroup$$anon$1$Attachment$ Attachment() {
                if (this.Attachment$module == null) {
                    this.Attachment$lzycompute$1();
                }
                return this.Attachment$module;
            }

            private AtomicLong ids() {
                return this.ids;
            }

            public Selector fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$selector() {
                return this.fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$selector;
            }

            private Object closeLock() {
                return this.closeLock;
            }

            public boolean fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$closed() {
                return this.fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$closed;
            }

            private void closed_$eq(boolean x$1) {
                this.fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$closed = x$1;
            }

            private ConcurrentLinkedQueue<Function0<BoxedUnit>> pendingThunks() {
                return this.pendingThunks;
            }

            private ByteBuffer readBuffer() {
                return this.readBuffer;
            }

            public SelectionKey register(DatagramChannel channel) {
                ObjectRef key = ObjectRef.create(null);
                CountDownLatch latch = new CountDownLatch(1);
                this.onSelectorThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    channel.configureBlocking(false);
                    anon.Attachment attachment = new anon.Attachment(this, this.Attachment().$lessinit$greater$default$1(), this.Attachment().$lessinit$greater$default$2());
                    key$1.elem = channel.register(this.fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$selector(), 0, attachment);
                    latch.countDown();
                }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> latch.countDown());
                latch.await();
                if ((SelectionKey)key.elem == null) {
                    throw new ClosedChannelException();
                }
                return (SelectionKey)key.elem;
            }

            public Function0<BoxedUnit> read(SelectionKey key, Function1<Either<Throwable, Datagram>, BoxedUnit> cb) {
                long readerId = this.ids().getAndIncrement();
                anon.Attachment attachment = (anon.Attachment)key.attachment();
                this.onSelectorThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    DatagramChannel channel = (DatagramChannel)key.channel();
                    Function0<BoxedUnit> cancelReader = null;
                    if (attachment.hasReaders()) {
                        cancelReader = attachment.queueReader(readerId, cb);
                        return;
                    }
                    if (!this.fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$read1(channel, cb)) {
                        cancelReader = attachment.queueReader(readerId, cb);
                        try {
                            key.interestOps(key.interestOps() | 1);
                        }
                        catch (CancelledKeyException cancelledKeyException) {}
                        return;
                    }
                }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> cb.apply((Object)new Left((Object)new ClosedChannelException())));
                return (JFunction0.mcV.sp & Serializable)() -> this.onSelectorThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> attachment.cancelReader(readerId), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {});
            }

            public boolean fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$read1(DatagramChannel channel, Function1<Either<Throwable, Datagram>, BoxedUnit> reader) {
                boolean bl;
                block3: {
                    try {
                        InetSocketAddress src = (InetSocketAddress)channel.receive(this.readBuffer());
                        if (src == null) {
                            bl = false;
                            break block3;
                        }
                        SocketAddress srcAddr = SocketAddress$.MODULE$.fromInetSocketAddress(src);
                        ((Buffer)this.readBuffer()).flip();
                        byte[] bytes = new byte[this.readBuffer().remaining()];
                        this.readBuffer().get(bytes);
                        ((Buffer)this.readBuffer()).clear();
                        reader.apply((Object)new Right((Object)new Datagram((SocketAddress<IpAddress>)srcAddr, (Chunk<Object>)Chunk$.MODULE$.array((Object)bytes, (ClassTag)ClassTag$.MODULE$.Byte()))));
                        bl = true;
                    }
                    catch (IOException t) {
                        reader.apply((Object)new Left((Object)t));
                        bl = true;
                    }
                }
                return bl;
            }

            public Function0<BoxedUnit> write(SelectionKey key, Datagram datagram, Function1<Option<Throwable>, BoxedUnit> cb) {
                byte[] byArray;
                long writerId = this.ids().getAndIncrement();
                Chunk.ArraySlice srcBytes = datagram.bytes().toArraySlice((ClassTag)ClassTag$.MODULE$.Byte());
                if (srcBytes.size() == ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps((byte[])srcBytes.values()))) {
                    byArray = (byte[])srcBytes.values();
                } else {
                    byte[] destBytes = new byte[srcBytes.size()];
                    Array$.MODULE$.copy(srcBytes.values(), srcBytes.offset(), (Object)destBytes, 0, srcBytes.size());
                    byArray = destBytes;
                }
                byte[] bytes = byArray;
                AsynchronousDatagramSocketGroup.WriterDatagram writerDatagram = new AsynchronousDatagramSocketGroup.WriterDatagram(datagram.remote().toInetSocketAddress((.less.colon.less)$less$colon$less$.MODULE$.refl()), ByteBuffer.wrap(bytes));
                anon.Attachment attachment = (anon.Attachment)key.attachment();
                this.onSelectorThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    DatagramChannel channel = (DatagramChannel)key.channel();
                    Function0<BoxedUnit> cancelWriter = null;
                    if (attachment.hasWriters()) {
                        cancelWriter = attachment.queueWriter(writerId, (Tuple2<AsynchronousDatagramSocketGroup.WriterDatagram, Function1<Option<Throwable>, BoxedUnit>>)new Tuple2((Object)writerDatagram, (Object)cb));
                        return;
                    }
                    if (!this.fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$write1(channel, writerDatagram, cb)) {
                        cancelWriter = attachment.queueWriter(writerId, (Tuple2<AsynchronousDatagramSocketGroup.WriterDatagram, Function1<Option<Throwable>, BoxedUnit>>)new Tuple2((Object)writerDatagram, (Object)cb));
                        try {
                            key.interestOps(key.interestOps() | 4);
                        }
                        catch (CancelledKeyException cancelledKeyException) {}
                        return;
                    }
                }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> cb.apply((Object)new Some((Object)new ClosedChannelException())));
                return (JFunction0.mcV.sp & Serializable)() -> this.onSelectorThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> attachment.cancelWriter(writerId), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {});
            }

            public boolean fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$write1(DatagramChannel channel, AsynchronousDatagramSocketGroup.WriterDatagram datagram, Function1<Option<Throwable>, BoxedUnit> cb) {
                boolean bl;
                block3: {
                    try {
                        int sent = channel.send(datagram.bytes(), datagram.remote());
                        if (sent > 0) {
                            cb.apply((Object)None$.MODULE$);
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                    catch (IOException e) {
                        cb.apply((Object)new Some((Object)e));
                        bl = true;
                    }
                }
                return bl;
            }

            public void close(SelectionKey key) {
                this.onSelectorThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    DatagramChannel channel = (DatagramChannel)key.channel();
                    anon.Attachment attachment = (anon.Attachment)key.attachment();
                    key.cancel();
                    channel.close();
                    attachment.close();
                }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {});
            }

            public void close() {
                Object object = this.closeLock();
                synchronized (object) {
                    this.closed_$eq(true);
                }
            }

            private void onSelectorThread(Function0<BoxedUnit> f, Function0<BoxedUnit> ifClosed) {
                Object object = this.closeLock();
                synchronized (object) {
                    if (this.fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$closed()) {
                        ifClosed.apply$mcV$sp();
                    } else {
                        this.pendingThunks().add(f);
                        this.fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$selector().wakeup();
                    }
                }
            }

            public void fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$runPendingThunks() {
                Function0<BoxedUnit> next = this.pendingThunks().poll();
                while (next != null) {
                    next.apply$mcV$sp();
                    next = this.pendingThunks().poll();
                }
            }

            private Thread selectorThread() {
                return this.selectorThread;
            }

            public String toString() {
                return "AsynchronousDatagramSocketGroup";
            }

            private final void Attachment$lzycompute$1() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.Attachment$module == null) {
                        this.Attachment$module = new AsynchronousDatagramSocketGroup$$anon$1$Attachment$(this);
                    }
                }
            }
            {
                this.ids = new AtomicLong(Long.MIN_VALUE);
                this.fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$selector = Selector.open();
                this.closeLock = new Object();
                this.fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$closed = false;
                this.pendingThunks = new ConcurrentLinkedQueue<E>();
                this.readBuffer = ByteBuffer.allocate(65536);
                this.selectorThread = threadFactory$1.newThread(new Runnable(this){
                    private final /* synthetic */ anon.1 $outer;

                    public void run() {
                        while (!this.$outer.fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$closed() && !Thread.currentThread().isInterrupted()) {
                            this.$outer.fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$runPendingThunks();
                            this.$outer.fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$selector().select(0L);
                            Iterator<SelectionKey> selectedKeys = this.$outer.fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$selector().selectedKeys().iterator();
                            while (selectedKeys.hasNext()) {
                                SelectionKey key = selectedKeys.next();
                                selectedKeys.remove();
                                DatagramChannel channel = (DatagramChannel)key.channel();
                                anon.Attachment attachment = (anon.Attachment)key.attachment();
                                try {
                                    if (!key.isValid()) continue;
                                    if (key.isReadable()) {
                                        boolean success = true;
                                        while (success && attachment.hasReaders()) {
                                            Function1 reader = (Function1)attachment.peekReader().get();
                                            success = this.$outer.fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$read1(channel, (Function1<Either<Throwable, Datagram>, BoxedUnit>)reader);
                                            if (!success) continue;
                                            attachment.dequeueReader();
                                        }
                                    }
                                    if (key.isWritable()) {
                                        boolean success = true;
                                        while (success && attachment.hasWriters()) {
                                            Function1 writer;
                                            Tuple2 tuple2 = (Tuple2)attachment.peekWriter().get();
                                            if (tuple2 == null) {
                                                throw new MatchError((Object)tuple2);
                                            }
                                            AsynchronousDatagramSocketGroup.WriterDatagram p = (AsynchronousDatagramSocketGroup.WriterDatagram)tuple2._1();
                                            Function1 writer2 = (Function1)tuple2._2();
                                            Tuple2 tuple22 = new Tuple2((Object)p, (Object)writer2);
                                            AsynchronousDatagramSocketGroup.WriterDatagram p2 = (AsynchronousDatagramSocketGroup.WriterDatagram)tuple22._1();
                                            success = this.$outer.fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$write1(channel, p2, (Function1<Option<Throwable>, BoxedUnit>)(writer = (Function1)tuple22._2()));
                                            if (!success) continue;
                                            attachment.dequeueWriter();
                                        }
                                    }
                                    key.interestOps((attachment.hasReaders() ? 1 : 0) | (attachment.hasWriters() ? 4 : 0));
                                }
                                catch (CancelledKeyException cancelledKeyException) {}
                            }
                        }
                        this.$outer.close();
                        this.$outer.fs2$io$net$AsynchronousDatagramSocketGroup$$anon$$runPendingThunks();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.selectorThread().start();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$close$3(java.nio.channels.SelectionKey ), $anonfun$close$4(), $anonfun$read$1(fs2.io.net.AsynchronousDatagramSocketGroup$$anon$1 java.nio.channels.SelectionKey fs2.io.net.AsynchronousDatagramSocketGroup$$anon$1$Attachment long scala.Function1 ), $anonfun$read$2(scala.Function1 ), $anonfun$read$3(fs2.io.net.AsynchronousDatagramSocketGroup$$anon$1 fs2.io.net.AsynchronousDatagramSocketGroup$$anon$1$Attachment long ), $anonfun$read$4(fs2.io.net.AsynchronousDatagramSocketGroup$$anon$1$Attachment long ), $anonfun$read$5(), $anonfun$register$1(fs2.io.net.AsynchronousDatagramSocketGroup$$anon$1 java.nio.channels.DatagramChannel scala.runtime.ObjectRef java.util.concurrent.CountDownLatch ), $anonfun$register$2(java.util.concurrent.CountDownLatch ), $anonfun$write$1(fs2.io.net.AsynchronousDatagramSocketGroup$$anon$1 java.nio.channels.SelectionKey fs2.io.net.AsynchronousDatagramSocketGroup$$anon$1$Attachment long fs2.io.net.AsynchronousDatagramSocketGroup$WriterDatagram scala.Function1 ), $anonfun$write$2(scala.Function1 ), $anonfun$write$3(fs2.io.net.AsynchronousDatagramSocketGroup$$anon$1 fs2.io.net.AsynchronousDatagramSocketGroup$$anon$1$Attachment long ), $anonfun$write$4(fs2.io.net.AsynchronousDatagramSocketGroup$$anon$1$Attachment long ), $anonfun$write$5()}, serializedLambda);
            }
        };
    }

    private AsynchronousDatagramSocketGroup$() {
    }
}

