/*
 * Decompiled with CFR 0.152.
 */
package org.typelevel.log4cats;

import cats.Applicative$;
import cats.Foldable;
import cats.Monad;
import cats.Show;
import cats.Show$;
import cats.UnorderedFoldable$;
import cats.effect.std.UUIDGen;
import cats.syntax.IfMOps$;
import cats.syntax.package;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import org.typelevel.log4cats.PagingSelfAwareStructuredLogger$;
import org.typelevel.log4cats.SelfAwareStructuredLogger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class PagingSelfAwareStructuredLogger {
    public static <F> SelfAwareStructuredLogger<F> paged(int n, int n2, SelfAwareStructuredLogger<F> selfAwareStructuredLogger, Monad<F> monad, UUIDGen<F> uUIDGen) {
        return PagingSelfAwareStructuredLogger$.MODULE$.paged(n, n2, selfAwareStructuredLogger, monad, uUIDGen);
    }

    public static <F> SelfAwareStructuredLogger<F> withPaging(int n, int n2, SelfAwareStructuredLogger<F> selfAwareStructuredLogger, Monad<F> monad) {
        return PagingSelfAwareStructuredLogger$.MODULE$.withPaging(n, n2, selfAwareStructuredLogger, monad);
    }

    public static <F> int paged$default$1() {
        return PagingSelfAwareStructuredLogger$.MODULE$.paged$default$1();
    }

    public static <F> int withPaging$default$1() {
        return PagingSelfAwareStructuredLogger$.MODULE$.withPaging$default$1();
    }

    public static <F> int paged$default$2() {
        return PagingSelfAwareStructuredLogger$.MODULE$.paged$default$2();
    }

    public static <F> int withPaging$default$2() {
        return PagingSelfAwareStructuredLogger$.MODULE$.withPaging$default$2();
    }

    public static class PagingSelfAwareStructuredLogger<F>
    implements SelfAwareStructuredLogger<F> {
        private final int pageSizeK;
        private final int maxPageNeeded;
        private final F randomUUID;
        private final SelfAwareStructuredLogger<F> sl;
        private final Monad<F> evidence$1;
        private final List<Object> pageIndices;
        private final String logSplitIdN;
        private final int pageSize;

        public PagingSelfAwareStructuredLogger(int pageSizeK, int maxPageNeeded, Object randomUUID, SelfAwareStructuredLogger<F> sl, Monad<F> evidence$1) {
            this.pageSizeK = pageSizeK;
            this.maxPageNeeded = maxPageNeeded;
            this.randomUUID = randomUUID;
            this.sl = sl;
            this.evidence$1 = evidence$1;
            if (pageSizeK <= 0 || maxPageNeeded <= 0) {
                throw new IllegalArgumentException(new StringBuilder(59).append("pageSizeK(=").append(pageSizeK).append(") and maxPageNeeded(=").append(maxPageNeeded).append(") must be positive numbers.").toString());
            }
            this.pageIndices = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), maxPageNeeded).toList();
            this.logSplitIdN = "log_split_id";
            this.pageSize = pageSizeK * 1024;
        }

        public PagingSelfAwareStructuredLogger(int pageSizeK, int maxPageNeeded, SelfAwareStructuredLogger<F> sl, Monad<F> evidence$1) {
            this(pageSizeK, maxPageNeeded, PagingSelfAwareStructuredLogger$.MODULE$.org$typelevel$log4cats$PagingSelfAwareStructuredLogger$$$PagingSelfAwareStructuredLogger$superArg$1(pageSizeK, maxPageNeeded, sl, evidence$1), sl, evidence$1);
        }

        private F pagedLogging(Function1<Map<String, String>, Function1<String, F>> logOpWithCtx, Map<String, String> ctx, String logSplitId, String msg) {
            int numOfPagesRaw = (msg.length() - 1) / this.pageSize + 1;
            int numOfPages = Math.min(numOfPagesRaw, this.maxPageNeeded);
            if (numOfPages <= 1) {
                return (F)((Function1)logOpWithCtx.apply(this.addPageCtx(msg, 1, 1, ctx))).apply(() -> PagingSelfAwareStructuredLogger$.org$typelevel$log4cats$PagingSelfAwareStructuredLogger$PagingSelfAwareStructuredLogger$$_$pagedLogging$$anonfun$1(msg));
            }
            Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(logSplitId), '-'));
            String logSplitIdPart1 = (String)ArrayOps$.MODULE$.head$extension(object);
            String pageHeaderTail = new StringBuilder(1).append(numOfPages).append(" ").append(logSplitIdPart1).toString();
            String pageFooterTail = new StringBuilder(17).append(numOfPages).append(" ").append(this.logSplitIdN).append("=").append(logSplitId).append(" page_size=").append(this.pageSizeK).append(" Kib").toString();
            return (F)package.all$.MODULE$.toFoldableOps((Object)this.pageIndices.take(numOfPages), (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForList()).traverse_((Function1 & Serializable)pi -> this.pagedLogging$$anonfun$2(msg, pageHeaderTail, pageFooterTail, logOpWithCtx, numOfPages, ctx, BoxesRunTime.unboxToInt((Object)pi)), this.evidence$1);
        }

        private F addMsgCtx(String msg, Map<String, String> ctx) {
            return (F)package.all$.MODULE$.toFunctorOps(this.randomUUID, this.evidence$1).map((Function1 & Serializable)uuid -> {
                String logSplitId = package.all$.MODULE$.toShow(uuid, Show$.MODULE$.catsShowForUUID()).show();
                int msgLength = msg.length();
                return Tuple2$.MODULE$.apply((Object)logSplitId, (Object)ctx.updated((Object)this.logSplitIdN, (Object)logSplitId).updated((Object)"page_size", (Object)new StringBuilder(4).append(this.pageSizeK).append(" Kib").toString()).updated((Object)"whole_message_size_bytes", (Object)String.valueOf(BoxesRunTime.boxToInteger((int)msgLength))).updated((Object)"log_size", (Object)new StringBuilder(5).append(msgLength).append(" Byte").toString()));
            });
        }

        private Map<String, String> addPageCtx(String page, int pageNum, int totalPages, Map<String, String> ctx) {
            return (Map)ctx.updated((Object)"total_pages", (Object)String.valueOf(BoxesRunTime.boxToInteger((int)totalPages))).updated((Object)"page_num", (Object)String.valueOf(BoxesRunTime.boxToInteger((int)pageNum))).updated((Object)"log_size_bytes", (Object)String.valueOf(BoxesRunTime.boxToInteger((int)page.length())));
        }

        private F doLogging(Function0<F> loggingLevelChk, Function1<Map<String, String>, Function1<String, F>> logOpWithCtx, Function0<String> msg, Map<String, String> ctx) {
            Object object = package.all$.MODULE$.catsSyntaxIfM(loggingLevelChk.apply(), this.evidence$1);
            return (F)IfMOps$.MODULE$.ifM$extension(object, () -> this.doLogging$$anonfun$1(msg, ctx, logOpWithCtx), this::doLogging$$anonfun$2, this.evidence$1);
        }

        private Map<String, String> doLogging$default$4() {
            return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }

        private F doLoggingThrowable(Function0<F> loggingLevelChk, Function1<Map<String, String>, Function1<String, F>> logOpWithCtx, Throwable t, Function0<String> msg, Map<String, String> ctx) {
            Object object = package.all$.MODULE$.catsSyntaxIfM(loggingLevelChk.apply(), this.evidence$1);
            return (F)IfMOps$.MODULE$.ifM$extension(object, () -> this.doLoggingThrowable$$anonfun$1(loggingLevelChk, logOpWithCtx, msg, t, ctx), this::doLoggingThrowable$$anonfun$2, this.evidence$1);
        }

        private Map<String, String> doLoggingThrowable$default$5() {
            return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        }

        public String getStackTrace(Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            t.printStackTrace(pw);
            return sw.getBuffer().toString();
        }

        @Override
        public F isTraceEnabled() {
            return this.sl.isTraceEnabled();
        }

        @Override
        public F isDebugEnabled() {
            return this.sl.isDebugEnabled();
        }

        @Override
        public F isInfoEnabled() {
            return this.sl.isInfoEnabled();
        }

        @Override
        public F isWarnEnabled() {
            return this.sl.isWarnEnabled();
        }

        @Override
        public F isErrorEnabled() {
            return this.sl.isErrorEnabled();
        }

        @Override
        public F trace(Function0<String> msg) {
            return this.doLogging(this::trace$$anonfun$1, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.trace((Map<String, String>)ctx, (Function0<String>)msg), msg, this.doLogging$default$4());
        }

        @Override
        public F debug(Function0<String> msg) {
            return this.doLogging(this::debug$$anonfun$1, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.debug((Map<String, String>)ctx, (Function0<String>)msg), msg, this.doLogging$default$4());
        }

        @Override
        public F info(Function0<String> msg) {
            return this.doLogging(this::info$$anonfun$1, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.info((Map<String, String>)ctx, (Function0<String>)msg), msg, this.doLogging$default$4());
        }

        @Override
        public F warn(Function0<String> msg) {
            return this.doLogging(this::warn$$anonfun$1, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.warn((Map<String, String>)ctx, (Function0<String>)msg), msg, this.doLogging$default$4());
        }

        @Override
        public F error(Function0<String> msg) {
            return this.doLogging(this::error$$anonfun$1, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.error((Map<String, String>)ctx, (Function0<String>)msg), msg, this.doLogging$default$4());
        }

        @Override
        public F trace(Throwable t, Function0<String> msg) {
            return this.doLoggingThrowable(this::trace$$anonfun$3, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.trace((Map<String, String>)ctx, (Function0<String>)msg), t, msg, this.doLoggingThrowable$default$5());
        }

        @Override
        public F debug(Throwable t, Function0<String> msg) {
            return this.doLoggingThrowable(this::debug$$anonfun$3, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.debug((Map<String, String>)ctx, (Function0<String>)msg), t, msg, this.doLoggingThrowable$default$5());
        }

        @Override
        public F info(Throwable t, Function0<String> msg) {
            return this.doLoggingThrowable(this::info$$anonfun$3, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.info((Map<String, String>)ctx, (Function0<String>)msg), t, msg, this.doLoggingThrowable$default$5());
        }

        @Override
        public F warn(Throwable t, Function0<String> msg) {
            return this.doLoggingThrowable(this::warn$$anonfun$3, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.warn((Map<String, String>)ctx, (Function0<String>)msg), t, msg, this.doLoggingThrowable$default$5());
        }

        @Override
        public F error(Throwable t, Function0<String> msg) {
            return this.doLoggingThrowable(this::error$$anonfun$3, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.error((Map<String, String>)ctx, (Function0<String>)msg), t, msg, this.doLoggingThrowable$default$5());
        }

        @Override
        public F trace(Map<String, String> ctx2, Function0<String> msg) {
            return this.doLogging(this::trace$$anonfun$5, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.trace((Map<String, String>)ctx, (Function0<String>)msg), msg, ctx2);
        }

        @Override
        public F debug(Map<String, String> ctx2, Function0<String> msg) {
            return this.doLogging(this::debug$$anonfun$5, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.debug((Map<String, String>)ctx, (Function0<String>)msg), msg, ctx2);
        }

        @Override
        public F info(Map<String, String> ctx2, Function0<String> msg) {
            return this.doLogging(this::info$$anonfun$5, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.info((Map<String, String>)ctx, (Function0<String>)msg), msg, ctx2);
        }

        @Override
        public F warn(Map<String, String> ctx2, Function0<String> msg) {
            return this.doLogging(this::warn$$anonfun$5, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.warn((Map<String, String>)ctx, (Function0<String>)msg), msg, ctx2);
        }

        @Override
        public F error(Map<String, String> ctx2, Function0<String> msg) {
            return this.doLogging(this::error$$anonfun$5, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.error((Map<String, String>)ctx, (Function0<String>)msg), msg, ctx2);
        }

        @Override
        public F trace(Map<String, String> ctx2, Throwable t, Function0<String> msg) {
            return this.doLoggingThrowable(this::trace$$anonfun$7, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.trace((Map<String, String>)ctx, (Function0<String>)msg), t, msg, ctx2);
        }

        @Override
        public F debug(Map<String, String> ctx2, Throwable t, Function0<String> msg) {
            return this.doLoggingThrowable(this::debug$$anonfun$7, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.debug((Map<String, String>)ctx, (Function0<String>)msg), t, msg, ctx2);
        }

        @Override
        public F info(Map<String, String> ctx2, Throwable t, Function0<String> msg) {
            return this.doLoggingThrowable(this::info$$anonfun$7, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.info((Map<String, String>)ctx, (Function0<String>)msg), t, msg, ctx2);
        }

        @Override
        public F warn(Map<String, String> ctx2, Throwable t, Function0<String> msg) {
            return this.doLoggingThrowable(this::warn$$anonfun$7, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.warn((Map<String, String>)ctx, (Function0<String>)msg), t, msg, ctx2);
        }

        @Override
        public F error(Map<String, String> ctx2, Throwable t, Function0<String> msg) {
            return this.doLoggingThrowable(this::error$$anonfun$7, (Function1 & Serializable)ctx -> (Function1 & Serializable)msg -> this.sl.error((Map<String, String>)ctx, (Function0<String>)msg), t, msg, ctx2);
        }

        private final /* synthetic */ Object pagedLogging$$anonfun$2(String msg$2, String pageHeaderTail$1, String pageFooterTail$1, Function1 logOpWithCtx$1, int numOfPages$1, Map ctx$1, int pi) {
            int beginIndex = (pi - 1) * this.pageSize;
            String pageContent = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(msg$2), beginIndex, beginIndex + this.pageSize);
            String page = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(Show.ShowInterpolator$.MODULE$.show$extension(package.all$.MODULE$.showInterpolator(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Page ", "/", "\n                            |\n                            |", "\n                            |\n                            |Page ", "/", ""}))), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Show.Shown[]{new Show.Shown(Show.Shown$.MODULE$.mat((Object)BoxesRunTime.boxToInteger((int)pi), (Show.ContravariantShow)Show$.MODULE$.catsShowForInt())), new Show.Shown(Show.Shown$.MODULE$.mat((Object)pageHeaderTail$1, (Show.ContravariantShow)Show$.MODULE$.catsShowForString())), new Show.Shown(Show.Shown$.MODULE$.mat((Object)pageContent, (Show.ContravariantShow)Show$.MODULE$.catsShowForString())), new Show.Shown(Show.Shown$.MODULE$.mat((Object)BoxesRunTime.boxToInteger((int)pi), (Show.ContravariantShow)Show$.MODULE$.catsShowForInt())), new Show.Shown(Show.Shown$.MODULE$.mat((Object)pageFooterTail$1, (Show.ContravariantShow)Show$.MODULE$.catsShowForString()))}))));
            return ((Function1)logOpWithCtx$1.apply(this.addPageCtx(page, pi, numOfPages$1, (Map<String, String>)ctx$1))).apply(() -> PagingSelfAwareStructuredLogger$.org$typelevel$log4cats$PagingSelfAwareStructuredLogger$PagingSelfAwareStructuredLogger$$_$pagedLogging$$anonfun$2$$anonfun$1(page));
        }

        private final Object doLogging$$anonfun$1(Function0 msg$4, Map ctx$3, Function1 logOpWithCtx$2) {
            String materializedMsg = (String)msg$4.apply();
            return package.all$.MODULE$.toFlatMapOps(this.addMsgCtx(materializedMsg, (Map<String, String>)ctx$3), this.evidence$1).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String logSplitId = (String)tuple2._1();
                    Map newCtx = (Map)tuple2._2();
                    return this.pagedLogging(logOpWithCtx$2, (Map<String, String>)newCtx, logSplitId, materializedMsg);
                }
                throw new MatchError((Object)tuple2);
            });
        }

        private final Object doLogging$$anonfun$2() {
            return Applicative$.MODULE$.apply(this.evidence$1).unit();
        }

        private final String doLoggingThrowable$$anonfun$1$$anonfun$1(Function0 msg$6, Throwable t$2) {
            return new StringBuilder(1).append(msg$6.apply()).append("\n").append(this.getStackTrace(t$2)).toString();
        }

        private final Object doLoggingThrowable$$anonfun$1(Function0 loggingLevelChk$1, Function1 logOpWithCtx$4, Function0 msg$5, Throwable t$1, Map ctx$4) {
            return this.doLogging(loggingLevelChk$1, logOpWithCtx$4, (Function0<String>)((Function0 & Serializable)() -> this.doLoggingThrowable$$anonfun$1$$anonfun$1(msg$5, t$1)), (Map<String, String>)ctx$4);
        }

        private final Object doLoggingThrowable$$anonfun$2() {
            return Applicative$.MODULE$.apply(this.evidence$1).unit();
        }

        private final Object trace$$anonfun$1() {
            return this.isTraceEnabled();
        }

        private final Object debug$$anonfun$1() {
            return this.isDebugEnabled();
        }

        private final Object info$$anonfun$1() {
            return this.isInfoEnabled();
        }

        private final Object warn$$anonfun$1() {
            return this.isWarnEnabled();
        }

        private final Object error$$anonfun$1() {
            return this.isErrorEnabled();
        }

        private final Object trace$$anonfun$3() {
            return this.isTraceEnabled();
        }

        private final Object debug$$anonfun$3() {
            return this.isDebugEnabled();
        }

        private final Object info$$anonfun$3() {
            return this.isInfoEnabled();
        }

        private final Object warn$$anonfun$3() {
            return this.isWarnEnabled();
        }

        private final Object error$$anonfun$3() {
            return this.isErrorEnabled();
        }

        private final Object trace$$anonfun$5() {
            return this.isTraceEnabled();
        }

        private final Object debug$$anonfun$5() {
            return this.isDebugEnabled();
        }

        private final Object info$$anonfun$5() {
            return this.isInfoEnabled();
        }

        private final Object warn$$anonfun$5() {
            return this.isWarnEnabled();
        }

        private final Object error$$anonfun$5() {
            return this.isErrorEnabled();
        }

        private final Object trace$$anonfun$7() {
            return this.isTraceEnabled();
        }

        private final Object debug$$anonfun$7() {
            return this.isDebugEnabled();
        }

        private final Object info$$anonfun$7() {
            return this.isInfoEnabled();
        }

        private final Object warn$$anonfun$7() {
            return this.isWarnEnabled();
        }

        private final Object error$$anonfun$7() {
            return this.isErrorEnabled();
        }
    }
}

