/*
 * Decompiled with CFR 0.152.
 */
package fs2.internal;

import fs2.internal.AsyncByteArrayInputStream$AsyncError$;
import java.io.InputStream;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.math.package$;
import scala.runtime.BoxedUnit;

public final class AsyncByteArrayInputStream
extends InputStream {
    private final int bound;
    private final ListBuffer<byte[]> bytes;
    private int headOffset;
    private int _available;
    private List<byte[]> cbytes;
    private int cheadOffset;
    private int cavailable;

    public AsyncByteArrayInputStream(int bound) {
        this.bound = bound;
        this.bytes = new ListBuffer();
        this.headOffset = 0;
        this._available = 0;
    }

    public int bound() {
        return this.bound;
    }

    public void checkpoint() {
        this.cbytes = this.bytes.toList();
        this.cheadOffset = this.headOffset;
        this.cavailable = this._available;
    }

    public void restore() {
        this.bytes.clear();
        ListBuffer listBuffer = (ListBuffer)this.bytes.$plus$plus$eq(this.cbytes);
        this.headOffset = this.cheadOffset;
        this._available = this.cavailable;
    }

    public void release() {
        this.cbytes = null;
    }

    public boolean push(byte[] chunk) {
        if (this.available() < this.bound()) {
            ListBuffer listBuffer = (ListBuffer)this.bytes.$plus$eq((Object)chunk);
            this._available += chunk.length;
            return true;
        }
        return false;
    }

    @Override
    public int available() {
        return this._available;
    }

    @Override
    public int read() {
        byte[] buf = new byte[1];
        int n = this.read(buf);
        return buf[0] & 0xFF;
    }

    @Override
    public int read(byte[] target, int off, int len) {
        int copied;
        block1: {
            if (this.bytes.isEmpty()) {
                throw AsyncByteArrayInputStream$AsyncError$.MODULE$;
            }
            byte[] head = (byte[])this.bytes.head();
            copied = package$.MODULE$.min(len, head.length - this.headOffset);
            System.arraycopy(head, this.headOffset, target, off, copied);
            this._available -= copied;
            this.headOffset += copied;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            if (this.headOffset < head.length) break block1;
            this.headOffset = 0;
            byte[] byArray = (byte[])this.bytes.remove(0);
        }
        return copied;
    }
}

