/*
 * Decompiled with CFR 0.152.
 */
package fs2.hashing;

import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import fs2.Chunk;
import fs2.Pull;
import fs2.Pull$;
import fs2.Pull$StreamPullOps$;
import fs2.Stream;
import fs2.Stream$;
import fs2.hashing.Hash;
import fs2.hashing.HashAlgorithm;
import fs2.hashing.HashVerificationException$;
import fs2.hashing.Hasher$;
import java.io.Serializable;
import java.security.MessageDigest;
import javax.crypto.Mac;
import scala.Function1;
import scala.runtime.Nothing$;
import scala.util.NotGiven$;

public interface Hasher<F> {
    public static <F> Resource<F, Hasher<F>> apply(HashAlgorithm hashAlgorithm, Sync<F> sync) {
        return Hasher$.MODULE$.apply(hashAlgorithm, (Sync)sync);
    }

    public static <F> Resource<F, Hasher<F>> hmac(HashAlgorithm hashAlgorithm, Chunk<Object> chunk, Sync<F> sync) {
        return Hasher$.MODULE$.hmac(hashAlgorithm, (Chunk)chunk, (Sync)sync);
    }

    public static String toAlgorithmString(HashAlgorithm hashAlgorithm) {
        return Hasher$.MODULE$.toAlgorithmString(hashAlgorithm);
    }

    public static String toMacAlgorithmString(HashAlgorithm hashAlgorithm) {
        return Hasher$.MODULE$.toMacAlgorithmString(hashAlgorithm);
    }

    public static <F> Hasher<F> unsafe(HashAlgorithm hashAlgorithm, Sync<F> sync) {
        return Hasher$.MODULE$.unsafe(hashAlgorithm, (Sync)sync);
    }

    public static <F> Hasher<F> unsafeFromMac(Mac mac, Sync<F> sync) {
        return Hasher$.MODULE$.unsafeFromMac(mac, (Sync)sync);
    }

    public static <F> Hasher<F> unsafeFromMessageDigest(MessageDigest messageDigest, Sync<F> sync) {
        return Hasher$.MODULE$.unsafeFromMessageDigest(messageDigest, (Sync)sync);
    }

    public static <F> Hasher<F> unsafeHmac(HashAlgorithm hashAlgorithm, Chunk<Object> chunk, Sync<F> sync) {
        return Hasher$.MODULE$.unsafeHmac(hashAlgorithm, (Chunk)chunk, (Sync)sync);
    }

    public F update(Chunk<Object> var1);

    public F hash();

    public void unsafeUpdate(Chunk<Object> var1);

    public Hash unsafeHash();

    public static Function1 update$(Hasher $this) {
        return $this.update();
    }

    default public Function1<Stream<F, Object>, Stream<F, Object>> update() {
        return (Function1 & Serializable)_$2 -> _$2.mapChunks((Function1 & Serializable)c -> {
            this.unsafeUpdate((Chunk<Object>)c);
            return c;
        });
    }

    public static Function1 observe$(Hasher $this, Function1 sink) {
        return $this.observe(sink);
    }

    default public Function1<Stream<F, Object>, Stream<F, Hash>> observe(Function1<Stream<F, Object>, Stream<F, Nothing$>> sink) {
        return (Function1 & Serializable)source -> ((Stream)sink.apply(this.update().apply(source))).$plus$plus(this::observe$$anonfun$1$$anonfun$1);
    }

    public static Function1 drain$(Hasher $this) {
        return $this.drain();
    }

    default public Function1<Stream<F, Object>, Stream<F, Hash>> drain() {
        return this.observe((Function1 & Serializable)_$3 -> _$3.drain());
    }

    public static Function1 verify$(Hasher $this, Hash expected) {
        return $this.verify(expected);
    }

    default public Function1<Stream<F, Object>, Stream<F, Object>> verify(Hash expected) {
        return (Function1 & Serializable)source -> ((Stream)this.update().apply(source)).onComplete(() -> this.verify$$anonfun$1$$anonfun$1(expected));
    }

    private Stream observe$$anonfun$1$$anonfun$1() {
        return Stream$.MODULE$.eval(this.hash());
    }

    private Stream verify$$anonfun$1$$anonfun$1(Hash expected$2) {
        return Stream$.MODULE$.eval(this.hash()).flatMap((Function1 & Serializable)actual -> {
            Hash hash2 = actual;
            Hash hash3 = expected$2;
            if (!(hash2 != null ? !((Object)hash2).equals(hash3) : hash3 != null)) {
                return Stream$.MODULE$.empty();
            }
            Pull pull = Pull$.MODULE$.StreamPullOps(Pull$.MODULE$.fail(HashVerificationException$.MODULE$.apply(expected$2, (Hash)actual)));
            return Pull$StreamPullOps$.MODULE$.streamNoScope$extension(pull);
        }, NotGiven$.MODULE$.value());
    }
}

