/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.debugger.dap;

import cats.Applicative;
import cats.ApplicativeError;
import cats.MonadError;
import cats.data.NonEmptyList;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.LiftIO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import cats.kernel.Semigroup$;
import cats.syntax.MonadErrorOps$;
import cats.syntax.package;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.Stream$;
import fs2.concurrent.Channel;
import fs2.concurrent.Channel$;
import fs2.concurrent.Signal;
import fs2.io.file.Files$;
import fs2.io.file.Path$;
import fs2.text;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.daffodil.debugger.dap.DAPCompiler$;
import org.apache.daffodil.debugger.dap.DAPodil;
import org.apache.daffodil.debugger.dap.DAPodil$Data$;
import org.apache.daffodil.debugger.dap.DAPodil$Debugee$State$Stopped$;
import org.apache.daffodil.debugger.dap.DataLeftOverUtils$;
import org.apache.daffodil.debugger.dap.Parse;
import org.apache.daffodil.debugger.dap.Parse$;
import org.apache.daffodil.debugger.dap.Parse$Breakpoints$;
import org.apache.daffodil.debugger.dap.Parse$ConfigEvent$;
import org.apache.daffodil.debugger.dap.Parse$Control$;
import org.apache.daffodil.debugger.dap.Parse$DaffodilDebugger$;
import org.apache.daffodil.debugger.dap.Parse$Debugee$LaunchArgs$;
import org.apache.daffodil.debugger.dap.Parse$Debugee$LaunchArgs$InfosetOutput$Console$;
import org.apache.daffodil.debugger.dap.Parse$Debugee$LaunchArgs$InfosetOutput$None$;
import org.apache.daffodil.debugger.dap.Parse$Delivery$;
import org.apache.daffodil.debugger.dap.Support$;
import org.apache.daffodil.runtime1.debugger.Debugger;
import org.apache.daffodil.sapi.DataLocation;
import org.apache.daffodil.sapi.DataProcessor;
import org.apache.daffodil.sapi.Diagnostic;
import org.apache.daffodil.sapi.ParseResult;
import org.apache.daffodil.tdml.TDML$;
import org.typelevel.log4cats.Logger;
import org.typelevel.log4cats.Logger$;
import org.typelevel.log4cats.slf4j.Slf4jLogger$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

public final class Parse$ {
    public static final Parse$ MODULE$ = new Parse$();
    private static final Logger<IO> logger = Slf4jLogger$.MODULE$.getLogger((Sync)IO$.MODULE$.asyncForIO(), "org.apache.daffodil.debugger.dap.Parse");
    private static final DAPodil.Source infosetSource = new DAPodil.Source(Paths.get("infoset", new String[0]), (Option<DAPodil.Source.Ref>)new Some((Object)new DAPodil.Source.Ref(1)));
    private static final DAPodil.Source dataDumpSource = new DAPodil.Source(Paths.get("data", new String[0]), (Option<DAPodil.Source.Ref>)new Some((Object)new DAPodil.Source.Ref(2)));

    public Logger<IO> logger() {
        return logger;
    }

    public IO<Parse> apply(Path schema, InputStream data, Path dataFilePath, Debugger debugger, String infosetFormat, Option<String> rootName, Option<String> rootNamespace, Map<String, String> variables, Map<String, String> tunables, Channel<IO, Events.DebugEvent> dapEvents) {
        return DAPCompiler$.MODULE$.apply().compile(schema, rootName, rootNamespace, tunables).map((Function1 & Serializable)p -> Support$.MODULE$.dataProcessorWithDebugger((DataProcessor)p, debugger, variables)).flatMap((Function1 & Serializable)dp -> ((IO)Ref.ApplyBuilders$.MODULE$.of$extension(package$.MODULE$.Ref().apply(Ref.Make$.MODULE$.concurrentInstance((GenConcurrent)IO$.MODULE$.asyncForIO())), (Object)BoxesRunTime.boxToBoolean((boolean)false))).flatMap((Function1 & Serializable)done -> ((IO)package$.MODULE$.Deferred().apply((GenConcurrent)IO$.MODULE$.asyncForIO())).map((Function1 & Serializable)pleaseStop -> new Parse((Deferred)pleaseStop, data, (DataProcessor)dp, infosetFormat, (Channel)dapEvents, dataFilePath, (Ref)done){
            private final Deferred pleaseStop$1;
            private final InputStream data$1;
            private final DataProcessor dp$1;
            private final String infosetFormat$1;
            private final Channel dapEvents$1;
            private final Path dataFilePath$1;
            private final Ref done$1;

            public Stream<IO, Object> run() {
                return fs2.io.package$.MODULE$.readOutputStream(4096, (Function1 & Serializable)os -> {
                    IO stopper = ((IO)$this.pleaseStop$1.get()).$times$greater(IO$.MODULE$.canceled());
                    int dataSize = $this.data$1.available();
                    IO parse = ((IO)MonadErrorOps$.MODULE$.ensureOr$extension(package.all$.MODULE$.catsSyntaxMonadError((Object)IO$.MODULE$.interruptibleMany((Function0 & Serializable)() -> $this.dp$1.parse(Support$.MODULE$.getInputSourceDataInputStream($this.data$1), Support$.MODULE$.getInfosetOutputter($this.infosetFormat$1, (OutputStream)os))).flatTap((Function1 & Serializable)res -> {
                        if (res.isError()) {
                            return ((IO)$this.dapEvents$1.send((Object)new Parse.Event.Error(Support$.MODULE$.parseDiagnosticList((Seq<Diagnostic>)res.getDiagnostics()).toList().map((Function1 & Serializable)d -> d.toString()).mkString("\n")))).void();
                        }
                        return IO$.MODULE$.unit();
                    }), (MonadError)IO$.MODULE$.asyncForIO()), (Function1 & Serializable)res -> new Parse.Exception((List<Diagnostic>)Support$.MODULE$.parseDiagnosticList((Seq<Diagnostic>)res.getDiagnostics()).toList()), (Function1 & Serializable)res -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$run$6(res)), (MonadError)IO$.MODULE$.asyncForIO())).flatMap((Function1 & Serializable)parseResult -> {
                        DataLocation loc = parseResult.location();
                        long leftOverBits = ((long)dataSize - (loc.bytePos1b() - 1L)) * 8L;
                        if (leftOverBits > 0L) {
                            String message = DataLeftOverUtils$.MODULE$.getMessage($this.dataFilePath$1, loc.bitPos1b(), loc.bytePos1b(), leftOverBits);
                            return ((IO)Logger$.MODULE$.apply(Parse$.MODULE$.logger()).error((Function0 & Serializable)() -> message)).$times$greater((IO)$this.dapEvents$1.send((Object)new Parse.DataLeftOverEvent(loc.bitPos1b(), loc.bytePos1b(), leftOverBits, message))).$times$greater(IO$.MODULE$.unit());
                        }
                        return IO$.MODULE$.unit();
                    }).void().guarantee(IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> os.close()).$times$greater((IO)$this.done$1.set((Object)BoxesRunTime.boxToBoolean((boolean)true))));
                    return stopper.$amp$greater(parse);
                }, IO$.MODULE$.asyncForIO());
            }

            public IO<BoxedUnit> close() {
                return ((IO)this.done$1.get()).flatMap((Function1 & Serializable)x0$1 -> anon.1.$anonfun$close$1(this, BoxesRunTime.unboxToBoolean((Object)x0$1)));
            }

            public static final /* synthetic */ boolean $anonfun$run$6(ParseResult res) {
                return !res.isError();
            }

            public static final /* synthetic */ IO $anonfun$close$1(anon.1 $this, boolean x0$1) {
                boolean bl = x0$1;
                if (!bl) {
                    return ((IO)Logger$.MODULE$.apply(Parse$.MODULE$.logger()).debug((Function0 & Serializable)() -> "interrupting parse")).$times$greater(((IO)$this.pleaseStop$1.complete((Object)BoxedUnit.UNIT)).void());
                }
                if (bl) {
                    return ((IO)Logger$.MODULE$.apply(Parse$.MODULE$.logger()).debug((Function0 & Serializable)() -> "parse done, no interruption")).$times$greater(IO$.MODULE$.unit());
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
            {
                this.pleaseStop$1 = pleaseStop$1;
                this.data$1 = data$1;
                this.dp$1 = dp$1;
                this.infosetFormat$1 = infosetFormat$1;
                this.dapEvents$1 = dapEvents$1;
                this.dataFilePath$1 = dataFilePath$1;
                this.done$1 = done$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$close$1$adapted(org.apache.daffodil.debugger.dap.Parse$$anon$1 java.lang.Object ), $anonfun$close$2(), $anonfun$close$3(), $anonfun$run$1(org.apache.daffodil.debugger.dap.Parse$$anon$1 java.io.OutputStream ), $anonfun$run$2(org.apache.daffodil.debugger.dap.Parse$$anon$1 java.io.OutputStream ), $anonfun$run$3(org.apache.daffodil.debugger.dap.Parse$$anon$1 org.apache.daffodil.sapi.ParseResult ), $anonfun$run$4(org.apache.daffodil.sapi.Diagnostic ), $anonfun$run$5(org.apache.daffodil.sapi.ParseResult ), $anonfun$run$6$adapted(org.apache.daffodil.sapi.ParseResult ), $anonfun$run$7(org.apache.daffodil.debugger.dap.Parse$$anon$1 int org.apache.daffodil.sapi.ParseResult ), $anonfun$run$8(java.lang.String ), $anonfun$run$9(java.io.OutputStream )}, serializedLambda);
            }
        })));
    }

    public DAPodil.Source infosetSource() {
        return infosetSource;
    }

    public DAPodil.Source dataDumpSource() {
        return dataDumpSource;
    }

    public Either<NonEmptyList<String>, Resource<IO, DAPodil.Debugee>> debugee(Messages.Request request) {
        return Parse$Debugee$LaunchArgs$.MODULE$.parse(request.arguments).map((Function1 & Serializable)x0$1 -> {
            Parse.Debugee.LaunchArgs launchArgs = x0$1;
            if (launchArgs instanceof Parse.Debugee.LaunchArgs.Manual) {
                Parse.Debugee.LaunchArgs.Manual manual = (Parse.Debugee.LaunchArgs.Manual)launchArgs;
                return MODULE$.debugee(manual);
            }
            if (launchArgs instanceof Parse.Debugee.LaunchArgs.TDMLConfig.Generate) {
                IO iO;
                Parse.Debugee.LaunchArgs.TDMLConfig.Generate generate = (Parse.Debugee.LaunchArgs.TDMLConfig.Generate)launchArgs;
                Path schemaPath = generate.schemaPath();
                Path dataPath = generate.dataPath();
                boolean stopOnEntry = generate.stopOnEntry();
                String infosetFormat = generate.infosetFormat();
                Parse.Debugee.LaunchArgs.InfosetOutput infosetOutput = generate.infosetOutput();
                String name = generate.name();
                String tdmlPath = generate.path();
                Option<String> rootName = generate.rootName();
                Option<String> rootNamespace = generate.rootNamespace();
                Map<String, String> variables = generate.variables();
                Map<String, String> tunables = generate.tunables();
                Resource<IO, DAPodil.Debugee> resource2 = MODULE$.debugee(new Parse.Debugee.LaunchArgs.Manual(schemaPath, dataPath, stopOnEntry, infosetFormat, infosetOutput, rootName, rootNamespace, variables, tunables));
                Parse.Debugee.LaunchArgs.InfosetOutput infosetOutput2 = infosetOutput;
                if (infosetOutput2 instanceof Parse.Debugee.LaunchArgs.InfosetOutput.File) {
                    Parse.Debugee.LaunchArgs.InfosetOutput.File file = (Parse.Debugee.LaunchArgs.InfosetOutput.File)infosetOutput2;
                    Path path = file.path();
                    iO = IO$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> TDML$.MODULE$.generate(path, schemaPath, dataPath, name, tdmlPath));
                } else {
                    iO = IO$.MODULE$.unit();
                }
                return resource2.onFinalize((Object)iO, (Applicative)IO$.MODULE$.asyncForIO());
            }
            if (launchArgs instanceof Parse.Debugee.LaunchArgs.TDMLConfig.Execute) {
                Parse.Debugee.LaunchArgs.TDMLConfig.Execute execute2 = (Parse.Debugee.LaunchArgs.TDMLConfig.Execute)launchArgs;
                boolean stopOnEntry = execute2.stopOnEntry();
                String infosetFormat = execute2.infosetFormat();
                Parse.Debugee.LaunchArgs.InfosetOutput infosetOutput = execute2.infosetOutput();
                String name = execute2.name();
                String tdmlPath = execute2.path();
                Option<String> rootName = execute2.rootName();
                Option<String> rootNamespace = execute2.rootNamespace();
                Map<String, String> variables = execute2.variables();
                Map<String, String> tunables = execute2.tunables();
                return package$.MODULE$.Resource().eval((Object)IO$.MODULE$.apply((Function0 & Serializable)() -> TDML$.MODULE$.execute(name, tdmlPath))).flatMap((Function1 & Serializable)x0$2 -> {
                    Some some;
                    Tuple2 tuple2;
                    Option option = x0$2;
                    if (None$.MODULE$.equals(option)) {
                        return package$.MODULE$.Resource().raiseError((Object)new RuntimeException(new StringBuilder(39).append("couldn't execute TDML with name ").append(name).append(", path ").append(tdmlPath).toString()), (ApplicativeError)IO$.MODULE$.asyncForIO());
                    }
                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                        Path schemaPath = (Path)tuple2._1();
                        Path dataPath = (Path)tuple2._2();
                        return MODULE$.debugee(new Parse.Debugee.LaunchArgs.Manual(schemaPath, dataPath, stopOnEntry, infosetFormat, infosetOutput, rootName, rootNamespace, variables, tunables));
                    }
                    throw new MatchError((Object)option);
                });
            }
            throw new MatchError((Object)launchArgs);
        });
    }

    public Resource<IO, DAPodil.Debugee> debugee(Parse.Debugee.LaunchArgs.Manual args) {
        return ((IO)Channel$.MODULE$.bounded(10, (GenConcurrent)IO$.MODULE$.asyncForIO())).toResource().flatMap((Function1 & Serializable)data -> ((IO)Channel$.MODULE$.bounded(10, (GenConcurrent)IO$.MODULE$.asyncForIO())).toResource().flatMap((Function1 & Serializable)dapEvents -> Parse$Breakpoints$.MODULE$.apply().toResource().flatMap((Function1 & Serializable)breakpoints -> Parse$Control$.MODULE$.stopped().toResource().flatMap((Function1 & Serializable)control -> ((IO)Channel$.MODULE$.bounded(10, (GenConcurrent)IO$.MODULE$.asyncForIO())).toResource().flatMap((Function1 & Serializable)events -> Parse$DaffodilDebugger$.MODULE$.resource((Channel<IO, Parse.Event>)events, (Parse.Breakpoints)breakpoints, (Parse.Control)control, args.infosetFormat()).flatMap((Function1 & Serializable)debugger -> args.data().flatMap((Function1 & Serializable)in -> MODULE$.apply(args.schemaPath(), (InputStream)in, args.dataPath(), (Debugger)debugger, args.infosetFormat(), args.rootName(), args.rootNamespace(), args.variables(), args.tunables(), (Channel<IO, Events.DebugEvent>)dapEvents)).toResource().map((Function1 & Serializable)parse -> {
            Stream stream;
            Parse.Debugee.LaunchArgs.InfosetOutput infosetOutput = args.infosetOutput();
            if (Parse$Debugee$LaunchArgs$InfosetOutput$None$.MODULE$.equals(infosetOutput)) {
                stream = parse.run().drain();
            } else if (Parse$Debugee$LaunchArgs$InfosetOutput$Console$.MODULE$.equals(infosetOutput)) {
                stream = parse.run().through(text.utf8$.MODULE$.decode()).foldMonoid(Semigroup$.MODULE$.catsKernelMonoidForString()).evalTap((Function1 & Serializable)xml -> ((IO)Logger$.MODULE$.apply(MODULE$.logger()).debug((Function0 & Serializable)() -> "done collecting infoset XML output")).$times$greater((IO)dapEvents.send((Object)Events.OutputEvent.createConsoleOutput((String)xml))));
            } else if (infosetOutput instanceof Parse.Debugee.LaunchArgs.InfosetOutput.File) {
                Parse.Debugee.LaunchArgs.InfosetOutput.File file = (Parse.Debugee.LaunchArgs.InfosetOutput.File)infosetOutput;
                Path path = file.path();
                stream = parse.run().through(Files$.MODULE$.apply(Files$.MODULE$.forLiftIO(IO$.MODULE$.asyncForIO(), LiftIO$.MODULE$.ioLiftIO())).writeAll(Path$.MODULE$.fromNioPath(path)));
            } else {
                throw new MatchError((Object)infosetOutput);
            }
            Stream parsing = stream.onFinalizeCase((Function1 & Serializable)x0$1 -> {
                Resource.ExitCase.Errored errored;
                Throwable e;
                Resource.ExitCase exitCase = x0$1;
                if (exitCase instanceof Resource.ExitCase.Errored && (e = (errored = (Resource.ExitCase.Errored)exitCase).e()) instanceof Parse.Exception) {
                    Parse.Exception exception = (Parse.Exception)e;
                    return ((IO)dapEvents.send((Object)Events.OutputEvent.createConsoleOutput((String)exception.getMessage()))).$times$greater(((IO)dapEvents.close()).void());
                }
                return ((IO)dapEvents.close()).void();
            }, (Applicative)IO$.MODULE$.asyncForIO()).onFinalizeCase((Function1 & Serializable)ec -> (IO)Logger$.MODULE$.apply(MODULE$.logger()).debug((Function0 & Serializable)() -> new StringBuilder(9).append("parsing: ").append(ec).toString()), (Applicative)IO$.MODULE$.asyncForIO());
            return new Tuple2(parse, (Object)parsing);
        }).flatMap((Function1 & Serializable)x$15 -> {
            Tuple2 tuple2 = x$15;
            if (tuple2 != null) {
                Parse parse = (Parse)tuple2._1();
                Stream parsing = (Stream)tuple2._2();
                return data.stream().holdResource((Object)DAPodil$Data$.MODULE$.empty(), (GenConcurrent)IO$.MODULE$.asyncForIO()).map((Function1 & Serializable)latestData -> {
                    Parse.Debugee debugee = new Parse.Debugee(new DAPodil.Source(args.schemaPath(), (Option<DAPodil.Source.Ref>)None$.MODULE$), new DAPodil.Source(args.dataPath(), (Option<DAPodil.Source.Ref>)None$.MODULE$), (Signal<IO, DAPodil.Data>)latestData, (Stream<IO, Events.DebugEvent>)dapEvents.stream(), (Parse.Breakpoints)breakpoints, (Parse.Control)control, (Channel<IO, Parse.Event>)events);
                    IO startup = ((IO)dapEvents.send((Object)Parse$ConfigEvent$.MODULE$.apply(args))).$times$greater(args.stopOnEntry() ? control.stepIn().$times$greater((IO)events.send((Object)new Parse.Event.Control(DAPodil$Debugee$State$Stopped$.MODULE$.entry()))) : debugee.continue());
                    return new Tuple3(latestData, (Object)debugee, (Object)startup);
                }).flatMap((Function1 & Serializable)x$14 -> {
                    Tuple3 tuple3 = x$14;
                    if (tuple3 != null) {
                        Parse.Debugee debugee = (Parse.Debugee)tuple3._2();
                        IO startup = (IO)tuple3._3();
                        return Parse$Delivery$.MODULE$.to((Channel<IO, DAPodil.Data>)data, (Channel<IO, Events.DebugEvent>)dapEvents).toResource().map((Function1 & Serializable)delivery -> {
                            Stream deliverParseData = events.stream().through((Function1 & Serializable)events -> delivery.deliver((Stream<IO, Parse.Event>)events)).onFinalize((Object)((IO)data.close()).void(), (Applicative)IO$.MODULE$.asyncForIO()).onFinalizeCase((Function1 & Serializable)x0$2 -> {
                                Resource.ExitCase exitCase = x0$2;
                                if (exitCase instanceof Resource.ExitCase.Errored) {
                                    Resource.ExitCase.Errored errored = (Resource.ExitCase.Errored)exitCase;
                                    Throwable e = errored.e();
                                    return (IO)Logger$.MODULE$.apply(MODULE$.logger()).warn(e, (Function0 & Serializable)() -> new StringBuilder(18).append("deliverParseData: ").append(errored).toString());
                                }
                                return (IO)Logger$.MODULE$.apply(MODULE$.logger()).debug((Function0 & Serializable)() -> new StringBuilder(18).append("deliverParseData: ").append(exitCase).toString());
                            }, (Applicative)IO$.MODULE$.asyncForIO());
                            return new Tuple2(delivery, (Object)deliverParseData);
                        }).flatMap((Function1 & Serializable)x$13 -> {
                            Tuple2 tuple2 = x$13;
                            if (tuple2 != null) {
                                Stream deliverParseData = (Stream)tuple2._2();
                                return ((Resource)Stream$.MODULE$.emit((Object)debugee).concurrently(Stream.NestedStreamOps$.MODULE$.parJoinUnbounded$extension(Stream$.MODULE$.NestedStreamOps(Stream$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Stream[]{Stream$.MODULE$.eval((Object)startup), parsing, deliverParseData}))), (GenConcurrent)IO$.MODULE$.asyncForIO()), (GenConcurrent)IO$.MODULE$.asyncForIO()).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).resource(Compiler$.MODULE$.resource(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).lastOrError((MonadError)Resource$.MODULE$.catsEffectAsyncForResource(IO$.MODULE$.asyncForIO()))).flatMap((Function1 & Serializable)x$12 -> {
                                    Parse.Debugee debugee = x$12;
                                    return package$.MODULE$.Resource().onFinalize((Object)((IO)Logger$.MODULE$.apply(MODULE$.logger()).debug((Function0 & Serializable)() -> "signalling a stop")).$times$greater(parse.close()), (Applicative)IO$.MODULE$.asyncForIO()).map((Function1 & Serializable)x$11 -> {
                                        BoxedUnit boxedUnit = x$11;
                                        return debugee;
                                    });
                                });
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    }
                    throw new MatchError((Object)tuple3);
                });
            }
            throw new MatchError((Object)tuple2);
        })))))));
    }

    private Parse$() {
    }
}

