/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.debugger.dap;

import cats.Applicative;
import cats.Functor;
import cats.MonadError;
import cats.Semigroupal;
import cats.data.NonEmptyList;
import cats.effect.ExitCode;
import cats.effect.ExitCode$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.IOApp;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import cats.effect.metrics.CpuStarvationWarningMetrics;
import cats.effect.package$;
import cats.effect.std.Hotswap;
import cats.effect.std.Hotswap$;
import cats.effect.unsafe.IORuntime;
import cats.effect.unsafe.IORuntimeConfig;
import cats.effect.unsafe.PollingSystem;
import cats.syntax.package;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.monovore.decline.Argument$;
import com.monovore.decline.Opts;
import com.monovore.decline.Opts$;
import com.monovore.decline.effect.CommandIOApp$;
import fs2.Compiler;
import fs2.Compiler$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.daffodil.debugger.dap.BuildInfo$;
import org.apache.daffodil.debugger.dap.DAPSession;
import org.apache.daffodil.debugger.dap.DAPSession$;
import org.apache.daffodil.debugger.dap.DAPodil;
import org.apache.daffodil.debugger.dap.DAPodil$State$Uninitialized$;
import org.apache.daffodil.debugger.dap.Parse$;
import org.apache.daffodil.lib.util.Misc$;
import org.typelevel.log4cats.Logger;
import org.typelevel.log4cats.Logger$;
import org.typelevel.log4cats.slf4j.Slf4jLogger$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Either;

public final class DAPodil$
implements IOApp {
    public static final DAPodil$ MODULE$ = new DAPodil$();
    private static final Opts<DAPodil.Options> opts;
    private static final Logger<IO> logger;
    private static final String header;
    private static IORuntime cats$effect$IOApp$$_runtime;
    private static ArrayBlockingQueue<Object> cats$effect$IOApp$$queue;
    private static volatile boolean bitmap$0;

    static {
        IOApp.$init$((IOApp)MODULE$);
        opts = (Opts)package.all$.MODULE$.catsSyntaxTuple2Semigroupal(new Tuple2((Object)Opts$.MODULE$.option("listenPort", "port to listen on for DAP client connection (default: 4711)", Opts$.MODULE$.option$default$3(), Opts$.MODULE$.option$default$4(), Opts$.MODULE$.option$default$5(), Argument$.MODULE$.readInt()).withDefault((Object)BoxesRunTime.boxToInteger((int)4711)), (Object)Opts$.MODULE$.option("listenTimeout", "duration to wait for a DAP client connection (default: 10s)", Opts$.MODULE$.option$default$3(), Opts$.MODULE$.option$default$4(), Opts$.MODULE$.option$default$5(), Argument$.MODULE$.readDuration()).withDefault((Object)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds()))).mapN((Function2 & Serializable)(listenPort, listenTimeout) -> DAPodil$.$anonfun$opts$1(BoxesRunTime.unboxToInt((Object)listenPort), listenTimeout), (Functor)Opts$.MODULE$.alternative(), (Semigroupal)Opts$.MODULE$.alternative());
        logger = Slf4jLogger$.MODULE$.getLogger((Sync)IO$.MODULE$.asyncForIO(), "org.apache.daffodil.debugger.dap.DAPodil");
        header = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(376).append("|\n        |******************************************************\n        |A DAP server for debugging Daffodil schema processors.\n        |\n        |Build info:\n        |  version: ").append(BuildInfo$.MODULE$.version()).append("\n        |  scalaVersion: ").append(BuildInfo$.MODULE$.scalaVersion()).append("\n        |  sbtVersion: ").append(BuildInfo$.MODULE$.sbtVersion()).append("\n        |Runtime info:\n        |  JVM version: ").append(System.getProperty("java.version")).append(" (").append(System.getProperty("java.home")).append(")\n        |  Daffodil Version: ").append(Misc$.MODULE$.getDaffodilVersion()).append("\n        |******************************************************").toString()));
    }

    public IORuntime runtime() {
        return IOApp.runtime$((IOApp)this);
    }

    public IORuntimeConfig runtimeConfig() {
        return IOApp.runtimeConfig$((IOApp)this);
    }

    public PollingSystem pollingSystem() {
        return IOApp.pollingSystem$((IOApp)this);
    }

    public int computeWorkerThreadCount() {
        return IOApp.computeWorkerThreadCount$((IOApp)this);
    }

    public ExecutionContext MainThread() {
        return IOApp.MainThread$((IOApp)this);
    }

    public IO<BoxedUnit> reportFailure(Throwable err) {
        return IOApp.reportFailure$((IOApp)this, (Throwable)err);
    }

    public boolean blockedThreadDetectionEnabled() {
        return IOApp.blockedThreadDetectionEnabled$((IOApp)this);
    }

    public boolean logNonDaemonThreadsEnabled() {
        return IOApp.logNonDaemonThreadsEnabled$((IOApp)this);
    }

    public FiniteDuration logNonDaemonThreadsInterval() {
        return IOApp.logNonDaemonThreadsInterval$((IOApp)this);
    }

    public IO<BoxedUnit> onCpuStarvationWarn(CpuStarvationWarningMetrics metrics) {
        return IOApp.onCpuStarvationWarn$((IOApp)this, (CpuStarvationWarningMetrics)metrics);
    }

    public boolean warnOnNonMainThreadDetected() {
        return IOApp.warnOnNonMainThreadDetected$((IOApp)this);
    }

    public final void main(String[] args) {
        IOApp.main$((IOApp)this, (String[])args);
    }

    public IORuntime cats$effect$IOApp$$_runtime() {
        return cats$effect$IOApp$$_runtime;
    }

    public void cats$effect$IOApp$$_runtime_$eq(IORuntime x$1) {
        cats$effect$IOApp$$_runtime = x$1;
    }

    private ArrayBlockingQueue<Object> cats$effect$IOApp$$queue$lzycompute() {
        DAPodil$ dAPodil$ = this;
        synchronized (dAPodil$) {
            if (!bitmap$0) {
                cats$effect$IOApp$$queue = IOApp.cats$effect$IOApp$$queue$((IOApp)this);
                bitmap$0 = true;
            }
        }
        return cats$effect$IOApp$$queue;
    }

    public ArrayBlockingQueue<Object> cats$effect$IOApp$$queue() {
        if (!bitmap$0) {
            return this.cats$effect$IOApp$$queue$lzycompute();
        }
        return cats$effect$IOApp$$queue;
    }

    public Opts<DAPodil.Options> opts() {
        return opts;
    }

    public Logger<IO> logger() {
        return logger;
    }

    public String header() {
        return header;
    }

    public IO<ExitCode> run(List<String> args) {
        String x$1 = "DAPodil";
        String x$2 = this.header();
        Some x$3 = new Some((Object)BuildInfo$.MODULE$.version());
        boolean x$4 = CommandIOApp$.MODULE$.run$default$3();
        Opts x$5 = this.opts().map((Function1 & Serializable)options -> MODULE$.run((DAPodil.Options)options));
        List<String> x$6 = args;
        return (IO)CommandIOApp$.MODULE$.run("DAPodil", x$2, x$4, (Option)x$3, x$5, x$6, (Sync)IO$.MODULE$.asyncForIO(), IO$.MODULE$.consoleForIO());
    }

    public IO<ExitCode> run(DAPodil.Options options) {
        return ((IO)Logger$.MODULE$.apply(this.logger()).info((Function0 & Serializable)() -> MODULE$.header())).flatMap((Function1 & Serializable)x$31 -> {
            BoxedUnit boxedUnit = x$31;
            DAPodil.Options options = options;
            if (options == null) {
                throw new MatchError((Object)options);
            }
            int listenPort = options.listenPort();
            Duration listenTimeout = options.listenTimeout();
            return ((IO)Logger$.MODULE$.apply(MODULE$.logger()).info((Function0 & Serializable)() -> new StringBuilder(51).append("launched with options listenPort: ").append(listenPort).append(", listenTimeout: ").append(listenTimeout).toString())).flatMap((Function1 & Serializable)x$30 -> {
                BoxedUnit boxedUnit = x$30;
                return ((IO)Ref.ApplyBuilders$.MODULE$.of$extension(package$.MODULE$.Ref().apply(Ref.Make$.MODULE$.concurrentInstance((GenConcurrent)IO$.MODULE$.asyncForIO())), (Object)DAPodil$State$Uninitialized$.MODULE$)).map((Function1 & Serializable)x$28 -> {
                    InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), options.listenPort());
                    ServerSocket ss = new ServerSocket(address.getPort(), 1, address.getAddress());
                    ss.setSoTimeout((int)options.listenTimeout().toMillis());
                    ServerSocket serverSocket = ss;
                    URI uri = URI.create(new StringBuilder(7).append("tcp://").append(address.getHostString()).append(":").append(serverSocket.getLocalPort()).toString());
                    return new Tuple4(x$28, (Object)address, (Object)serverSocket, (Object)uri);
                }).flatMap((Function1 & Serializable)x$29 -> {
                    Tuple4 tuple4 = x$29;
                    if (tuple4 != null) {
                        ServerSocket serverSocket = (ServerSocket)tuple4._3();
                        URI uri = (URI)tuple4._4();
                        return MODULE$.listen(serverSocket, uri).iterateWhile((Function1 & Serializable)x$27 -> BoxesRunTime.boxToBoolean((boolean)x$27.restart())).as((Object)ExitCode$.MODULE$.Success()).recoverWith((PartialFunction)new Serializable(uri){
                            private static final long serialVersionUID = 0L;
                            private final URI uri$1;

                            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                if (A1 instanceof SocketTimeoutException) {
                                    return (B1)((IO)Logger$.MODULE$.apply(DAPodil$.MODULE$.logger()).error((Function0 & Serializable)() -> new StringBuilder(47).append("timed out listening for connection on ").append($this.uri$1).append(", exiting").toString())).as((Object)ExitCode$.MODULE$.Error());
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(Throwable x1) {
                                Throwable throwable = x1;
                                return throwable instanceof SocketTimeoutException;
                            }
                            {
                                this.uri$1 = uri$1;
                            }

                            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.apache.daffodil.debugger.dap.DAPodil$$anonfun$$nestedInanonfun$run$7$1 )}, serializedLambda);
                            }
                        }).map((Function1 & Serializable)code -> code);
                    }
                    throw new MatchError((Object)tuple4);
                });
            });
        });
    }

    public IO<DAPodil.Done> listen(ServerSocket socket, URI uri) {
        return ((IO)Logger$.MODULE$.apply(this.logger()).info((Function0 & Serializable)() -> new StringBuilder(11).append("waiting at ").append(uri).toString())).flatMap((Function1 & Serializable)x$34 -> {
            BoxedUnit boxedUnit = x$34;
            return IO$.MODULE$.blocking((Function0 & Serializable)() -> socket.accept()).flatMap((Function1 & Serializable)socket -> ((IO)Logger$.MODULE$.apply(MODULE$.logger()).info((Function0 & Serializable)() -> new StringBuilder(13).append("connected at ").append(uri).toString())).flatMap((Function1 & Serializable)x$33 -> {
                BoxedUnit boxedUnit = x$33;
                return ((IO)DAPSession$.MODULE$.resource((Socket)socket).flatMap((Function1 & Serializable)session -> MODULE$.resource((DAPSession<Messages.Request, Messages.Response, Events.DebugEvent>)session, (Function1<Messages.Request, Either<NonEmptyList<String>, Resource<IO, DAPodil.Debugee>>>)(Function1 & Serializable)request -> Parse$.MODULE$.debugee((Messages.Request)request))).use((Function1 & Serializable)whenDone -> whenDone.$less$times((IO)Logger$.MODULE$.apply(MODULE$.logger()).debug((Function0 & Serializable)() -> "whenDone: completed")), (MonadCancel)IO$.MODULE$.asyncForIO())).flatMap((Function1 & Serializable)done -> ((IO)Logger$.MODULE$.apply(MODULE$.logger()).info((Function0 & Serializable)() -> new StringBuilder(16).append("disconnected at ").append(uri).toString())).map((Function1 & Serializable)x$32 -> {
                    BoxedUnit boxedUnit = x$32;
                    return done;
                }));
            }));
        });
    }

    public Resource<IO, IO<DAPodil.Done>> resource(DAPSession<Messages.Request, Messages.Response, Events.DebugEvent> session, Function1<Messages.Request, Either<NonEmptyList<String>, Resource<IO, DAPodil.Debugee>>> debugee) {
        return ((IO)Ref.ApplyBuilders$.MODULE$.of$extension(package$.MODULE$.Ref().apply(Ref.Make$.MODULE$.concurrentInstance((GenConcurrent)IO$.MODULE$.asyncForIO())), (Object)DAPodil$State$Uninitialized$.MODULE$)).toResource().flatMap((Function1 & Serializable)state -> Hotswap$.MODULE$.create((GenConcurrent)IO$.MODULE$.asyncForIO()).onFinalizeCase((Function1 & Serializable)ec -> (IO)Logger$.MODULE$.apply(MODULE$.logger()).debug((Function0 & Serializable)() -> new StringBuilder(9).append("hotswap: ").append(ec).toString()), (Applicative)IO$.MODULE$.asyncForIO()).flatMap((Function1 & Serializable)hotswap -> ((IO)package$.MODULE$.Deferred().apply((GenConcurrent)IO$.MODULE$.asyncForIO())).toResource().map((Function1 & Serializable)whenDone -> {
            DAPodil dapodil = new DAPodil(session, (Ref<IO, DAPodil.State>)state, (Hotswap<IO, DAPodil.State>)hotswap, debugee, (Deferred<IO, DAPodil.Done>)whenDone);
            return new Tuple2(whenDone, (Object)dapodil);
        }).flatMap((Function1 & Serializable)x$36 -> {
            Tuple2 tuple2 = x$36;
            if (tuple2 != null) {
                Deferred whenDone = (Deferred)tuple2._1();
                DAPodil dapodil = (DAPodil)tuple2._2();
                return ((IO)dapodil.handleRequests().compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).lastOrError((MonadError)IO$.MODULE$.asyncForIO())).onError((PartialFunction)new Serializable(whenDone){
                    private static final long serialVersionUID = 0L;
                    private final Deferred whenDone$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        return (B1)((IO)Logger$.MODULE$.apply(DAPodil$.MODULE$.logger()).error(A1, (Function0 & Serializable)() -> "unhandled error")).$times$greater(((IO)this.whenDone$1.complete((Object)new DAPodil.Done(false))).void());
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        return true;
                    }
                    {
                        this.whenDone$1 = whenDone$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3()}, serializedLambda);
                    }
                }).background().map((Function1 & Serializable)x$35 -> {
                    IO iO = x$35;
                    return (IO)whenDone.get();
                });
            }
            throw new MatchError((Object)tuple2);
        })));
    }

    public static final /* synthetic */ DAPodil.Options $anonfun$opts$1(int listenPort, Duration listenTimeout) {
        return new DAPodil.Options(listenPort, listenTimeout);
    }

    private DAPodil$() {
    }
}

