/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.model;

import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.dbsync.merge.context.MergerContext;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.model.AbstractToModelToken;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;

public class CreateTableToModel
extends AbstractToModelToken.Entity {
    private String objEntityClassName;

    public CreateTableToModel(DbEntity entity) {
        super("Create Table", 45, entity);
    }

    public void setObjEntityClassName(String n) {
        this.objEntityClassName = n;
    }

    @Override
    public void execute(MergerContext context) {
        DbEntity dbEntity = this.getEntity();
        DataMap map = context.getDataMap();
        map.addDbEntity(dbEntity);
        ObjEntity objEntity = new ObjEntity();
        objEntity.setName(NameBuilder.builder((ConfigurationNode)objEntity, (ConfigurationNode)dbEntity.getDataMap()).baseName(context.getNameGenerator().objEntityName(dbEntity)).name());
        objEntity.setDbEntity(this.getEntity());
        String className = this.objEntityClassName;
        if (className == null) {
            className = map.getNameWithDefaultPackage(objEntity.getName());
        }
        objEntity.setClassName(className);
        objEntity.setSuperClassName(map.getDefaultSuperclass());
        if (map.isClientSupported()) {
            objEntity.setClientClassName(map.getNameWithDefaultClientPackage(objEntity.getName()));
            objEntity.setClientSuperClassName(map.getDefaultClientSuperclass());
        }
        map.addObjEntity(objEntity);
        context.getEntityMergeSupport().synchronizeWithDbEntity(objEntity);
        context.getDelegate().dbEntityAdded(this.getEntity());
        context.getDelegate().objEntityAdded(objEntity);
    }

    @Override
    public MergerToken createReverse(MergerTokenFactory factory) {
        return factory.createDropTableToDb(this.getEntity());
    }
}

