/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.resource.Resource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DBCPDataSourceFactory
implements DataSourceFactory {
    private static final String DBCP2_PROPERTIES = "dbcp2.properties";
    private static final Logger logger = LoggerFactory.getLogger(DBCPDataSourceFactory.class);

    public DataSource getDataSource(DataNodeDescriptor nodeDescriptor) throws Exception {
        Resource baseConfiguration;
        String location = nodeDescriptor.getParameters();
        if (location == null) {
            logger.debug("No explicit DBCP2 config location, will use default location: dbcp2.properties");
            location = DBCP2_PROPERTIES;
        }
        if ((baseConfiguration = nodeDescriptor.getConfigurationSource()) == null) {
            throw new CayenneRuntimeException("Null 'configurationSource' for nodeDescriptor '%s'", new Object[]{nodeDescriptor.getName()});
        }
        Resource dbcp2Configuration = baseConfiguration.getRelativeResource(location);
        if (dbcp2Configuration == null) {
            throw new CayenneRuntimeException("Missing DBCP2 configuration '%s' for nodeDescriptor '%s'", new Object[]{location, nodeDescriptor.getName()});
        }
        Properties properties = this.getProperties(dbcp2Configuration);
        if (logger.isDebugEnabled()) {
            logger.debug("DBCP2 Properties: " + properties);
        }
        return BasicDataSourceFactory.createDataSource((Properties)properties);
    }

    private Properties getProperties(Resource dbcp2Configuration) throws IOException {
        Properties properties = new Properties();
        try (InputStream in = dbcp2Configuration.getURL().openStream();){
            properties.load(in);
        }
        return properties;
    }
}

