/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.action.LinkDataMapAction;

public class TreeDropTarget
implements DropTargetListener,
Transferable {
    private DropTarget target;
    private JTree targetTree;
    private ProjectController eventController;
    private TreePath parentPath;
    private TreePath targetPath;

    public TreeDropTarget(JTree tree, ProjectController eventController, TreePath parentPath) {
        this.targetTree = tree;
        this.eventController = eventController;
        this.parentPath = parentPath;
        this.target = new DropTarget(this.targetTree, this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Point p = dtde.getLocation();
        this.targetPath = this.targetTree.getPathForLocation(p.x, p.y);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (this.targetPath != null) {
            try {
                dtde.acceptDrop(dtde.getDropAction());
                DefaultMutableTreeNode target = (DefaultMutableTreeNode)this.targetPath.getLastPathComponent();
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.parentPath.getLastPathComponent();
                if (target.getUserObject() instanceof DataNodeDescriptor && parent.getUserObject() instanceof DataMap) {
                    DataNodeDescriptor currentDataNode = (DataNodeDescriptor)target.getUserObject();
                    DataMap currentDataMap = (DataMap)parent.getUserObject();
                    LinkDataMapAction action = this.eventController.getApplication().getActionManager().getAction(LinkDataMapAction.class);
                    action.linkDataMap(currentDataMap, currentDataNode);
                    this.targetTree.makeVisible(this.targetPath.pathByAddingChild(target));
                    dtde.dropComplete(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                dtde.rejectDrop();
            }
        }
    }

    public TreePath getPath() {
        return this.targetPath;
    }

    @Override
    public Object getTransferData(DataFlavor arg0) throws UnsupportedFlavorException, IOException {
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return null;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor arg0) {
        return false;
    }
}

