/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.property;

import java.util.Collection;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.BaseProperty;
import org.apache.cayenne.exp.property.EntityProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.RelationshipProperty;

public abstract class CollectionProperty<V extends Persistent, E extends Collection<V>>
extends BaseProperty<E>
implements RelationshipProperty<E> {
    protected Class<V> entityType;

    protected CollectionProperty(String name, Expression expression, Class<? super E> collectionType, Class<V> entityType) {
        super(name, expression, collectionType);
        this.entityType = entityType;
    }

    public EntityProperty<V> flat() {
        return PropertyFactory.createEntity(ExpressionFactory.fullObjectExp(this.getExpression()), this.getEntityType());
    }

    public Expression contains(V value) {
        return ExpressionFactory.matchExp(this.getExpression(), value);
    }

    public Expression notContains(V value) {
        return ExpressionFactory.noMatchExp(this.getExpression(), value);
    }

    @SafeVarargs
    public final Expression contains(V firstValue, V ... moreValues) {
        int moreValuesLength = moreValues != null ? moreValues.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstValue;
        if (moreValuesLength > 0) {
            System.arraycopy(moreValues, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.inExp(this.getExpression(), values);
    }

    public Expression contains(Collection<V> values) {
        return ExpressionFactory.inExp(this.getExpression(), values);
    }

    public Expression containsId(Object id) {
        return ExpressionFactory.matchExp(this.getExpression(), id);
    }

    public Expression containsId(Object firstId, Object ... moreId) {
        int moreValuesLength = moreId != null ? moreId.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstId;
        if (moreValuesLength > 0) {
            System.arraycopy(moreId, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.inExp(this.getExpression(), values);
    }

    public Expression containsId(Collection<Object> ids) {
        return ExpressionFactory.inExp(this.getExpression(), ids);
    }

    public Expression notContainsId(Object id) {
        return ExpressionFactory.noMatchExp(this.getExpression(), id);
    }

    public Expression notContainsId(Object firstId, Object ... moreId) {
        int moreValuesLength = moreId != null ? moreId.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstId;
        if (moreValuesLength > 0) {
            System.arraycopy(moreId, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.notInExp(this.getExpression(), values);
    }

    public Expression notContainsId(Collection<Object> ids) {
        return ExpressionFactory.notInExp(this.getExpression(), ids);
    }

    public Expression notContains(Collection<V> values) {
        return ExpressionFactory.notInExp(this.getExpression(), values);
    }

    @SafeVarargs
    public final Expression notContains(V firstValue, V ... moreValues) {
        int moreValuesLength = moreValues != null ? moreValues.length : 0;
        Object[] values = new Object[moreValuesLength + 1];
        values[0] = firstValue;
        if (moreValuesLength > 0) {
            System.arraycopy(moreValues, 0, values, 1, moreValuesLength);
        }
        return ExpressionFactory.notInExp(this.getExpression(), values);
    }

    protected Class<V> getEntityType() {
        return this.entityType;
    }
}

