/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.ParentAttachmentStrategy;
import org.apache.cayenne.access.PrefetchProcessorJointNode;
import org.apache.cayenne.access.PrefetchProcessorNode;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjRelationship;

class ResultScanParentAttachmentStrategy
implements ParentAttachmentStrategy {
    private final PrefetchProcessorNode parentNode;
    private final DbJoin[] joins;
    private final PrefetchProcessorNode node;
    private Map<Object, List<Persistent>> partitionByChild;

    ResultScanParentAttachmentStrategy(PrefetchProcessorNode node) {
        if (node.getParent() == null) {
            throw new IllegalArgumentException("ResultScanParentAttachmentStrategy works only for non-root nodes");
        }
        this.node = node;
        this.parentNode = (PrefetchProcessorNode)node.getParent();
        ObjRelationship relationship = node.getIncoming().getRelationship();
        List<DbRelationship> dbRelationships = relationship.getDbRelationships();
        if (dbRelationships.size() > 1) {
            throw new IllegalArgumentException("ResultScanParentAttachmentStrategy does not work for flattened relationships");
        }
        this.joins = dbRelationships.get(0).getJoins().toArray(new DbJoin[0]);
    }

    @Override
    public void linkToParent(DataRow row, Persistent object) {
        Object key;
        if (this.partitionByChild == null) {
            this.indexParents();
        }
        if (this.joins.length > 1) {
            ArrayList values = new ArrayList(this.joins.length);
            for (DbJoin join : this.joins) {
                values.add(row.get(join.getTargetName()));
            }
            key = values;
        } else {
            key = row.get(this.joins[0].getTargetName());
        }
        List<Persistent> parents = this.partitionByChild.get(key);
        if (parents != null) {
            for (Persistent parent : parents) {
                this.node.linkToParent(object, parent);
            }
        }
    }

    private void indexParents() {
        this.partitionByChild = new HashMap<Object, List<Persistent>>();
        List<Persistent> objects = this.parentNode.getObjects();
        if (objects == null) {
            return;
        }
        List<DataRow> rows = this.parentNode.getDataRows();
        if (rows == null) {
            if (this.parentNode instanceof PrefetchProcessorJointNode) {
                rows = ((PrefetchProcessorJointNode)this.parentNode).getResolvedRows();
            }
            if (rows == null) {
                return;
            }
        }
        int size = objects.size();
        for (int i = 0; i < size; ++i) {
            Object key;
            DataRow row = rows.get(i);
            if (this.joins.length > 1) {
                ArrayList values = new ArrayList(this.joins.length);
                for (DbJoin join : this.joins) {
                    values.add(row.get(join.getSourceName()));
                }
                key = values;
            } else {
                key = row.get(this.joins[0].getSourceName());
            }
            List parents = this.partitionByChild.computeIfAbsent(key, k -> new ArrayList());
            parents.add(objects.get(i));
        }
    }
}

