/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.ResultIterator;

public class ResultBatchIterator<T>
implements Iterable<List<T>>,
Iterator<List<T>>,
AutoCloseable {
    private final ResultIterator<T> delegate;
    private final int size;

    public ResultBatchIterator(ResultIterator<T> delegate, int size) {
        this.delegate = delegate;
        this.size = size;
    }

    @Override
    public Iterator<List<T>> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNextRow();
    }

    @Override
    public List<T> next() {
        ArrayList<T> objects = new ArrayList<T>(this.size);
        for (int i = 0; i < this.size && this.hasNext(); ++i) {
            objects.add(this.delegate.nextRow());
        }
        return objects;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported.");
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    public int getBatchSize() {
        return this.size;
    }
}

